/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoopLockLoadIntegrationTest {
    private static GoogleCloudStorageOptions gcsOptions;
    private static RetryHttpInitializer httpRequestInitializer;
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsfsIHelper;

    @BeforeClass
    public static void before() throws Throwable {
        Credential credential = (Credential)Preconditions.checkNotNull((Object)GoogleCloudStorageTestHelper.getCredential(), (Object)"credential must not be null");
        gcsOptions = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
        httpRequestInitializer = new RetryHttpInitializer(credential, gcsOptions.toRetryHttpInitializerOptions());
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(credential, GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).build());
        gcsfsIHelper = new GoogleCloudStorageFileSystemIntegrationHelper(gcsfs);
        gcsfsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() throws Throwable {
        gcsfsIHelper.afterAllTests();
        GoogleCloudStorageFileSystem gcsFs = CoopLockLoadIntegrationTest.gcsfsIHelper.gcsfs;
        Truth.assertThat((Boolean)gcsFs.exists(new URI("gs://" + CoopLockLoadIntegrationTest.gcsfsIHelper.sharedBucketName1))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(new URI("gs://" + CoopLockLoadIntegrationTest.gcsfsIHelper.sharedBucketName2))).isFalse();
    }

    @Test
    public void moveDirectory_loadTest() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockLoadIntegrationTest.newGcsFsOptions().toBuilder().setCloudStorageOptions(gcsOptions.toBuilder().setMaxHttpRequestRetries(0).build()).build();
        GoogleCloudStorageFileSystem gcsFs = CoopLockLoadIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-load");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirName = "rename_" + UUID.randomUUID();
        String fileNamePrefix = "file_";
        URI srcFileUri = bucketUri.resolve(dirName + "_src");
        URI dstFileUri = bucketUri.resolve(dirName + "_dst");
        URI srcDirUri = bucketUri.resolve(dirName + "_src/");
        URI dstDirUri = bucketUri.resolve(dirName + "_dst/");
        int iterations = 10;
        for (int i = 0; i < iterations; ++i) {
            gcsfsIHelper.writeTextFile(bucketName, srcDirUri.resolve(fileNamePrefix + i).getPath(), "file_content_" + i);
        }
        ExecutorService moveExecutor = Executors.newFixedThreadPool(iterations * 2);
        ArrayList futures = new ArrayList(iterations * 2);
        for (int i = 0; i < iterations; ++i) {
            URI uRI = i % 4 == 0 ? srcFileUri : srcDirUri;
            URI dstUri1 = i % 4 == 1 ? dstFileUri : dstDirUri;
            futures.add(moveExecutor.submit(() -> CoopLockLoadIntegrationTest.renameUnchecked(gcsFs, srcUri1, dstUri1)));
            URI srcUri2 = i % 4 == 3 ? srcFileUri : srcDirUri;
            URI dstUri2 = i % 4 == 2 ? dstFileUri : dstDirUri;
            futures.add(moveExecutor.submit(() -> CoopLockLoadIntegrationTest.renameUnchecked(gcsFs, dstUri2, srcUri2)));
        }
        moveExecutor.shutdown();
        moveExecutor.awaitTermination(6L, TimeUnit.MINUTES);
        Truth.assertWithMessage((String)"Cooperative locking load test timed out").that(Boolean.valueOf(moveExecutor.isTerminated())).isTrue();
        for (Future future : futures) {
            future.get();
        }
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri)).isFalse();
        Truth.assertThat((Iterable)gcsFs.listFileInfo(srcDirUri)).hasSize(iterations);
        for (int i = 0; i < iterations; ++i) {
            Truth.assertThat((Boolean)gcsFs.exists(srcDirUri.resolve(fileNamePrefix + i))).isTrue();
        }
        List lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(iterations * 4);
    }

    private static void renameUnchecked(GoogleCloudStorageFileSystem gcsFs, URI src, URI dst) {
        while (true) {
            try {
                gcsFs.rename(src, dst);
            }
            catch (FileNotFoundException e) {
                Truth.assertThat((Throwable)e).hasMessageThat().matches("^Item not found: " + src + "/?$");
                continue;
            }
            catch (IOException e) {
                Truth.assertThat((Throwable)e).hasMessageThat().matches("^Cannot rename because path does not exist: " + src + "/?$");
                continue;
            }
            break;
        }
    }

    private static GoogleCloudStorageFileSystemOptions newGcsFsOptions() {
        return CoopLockLoadIntegrationTest.newGcsFsOptions(gcsOptions);
    }

    private static GoogleCloudStorageFileSystemOptions newGcsFsOptions(GoogleCloudStorageOptions gcsOptions) {
        return GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(gcsOptions).setCooperativeLockingEnabled(true).build();
    }

    private static GoogleCloudStorageFileSystem newGcsFs(GoogleCloudStorageFileSystemOptions gcsFsOptions, HttpRequestInitializer requestInitializer) throws IOException {
        return new GoogleCloudStorageFileSystem(o -> new GoogleCloudStorageImpl(o, requestInitializer), gcsFsOptions);
    }
}

