/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.DeletionBehavior;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.MethodOutcome;
import com.google.cloud.hadoop.gcsio.MkdirsBehavior;
import com.google.cloud.hadoop.gcsio.RenameBehavior;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.base.Throwables;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Iterables;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.flogger.GoogleLogger;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageFileSystemIntegrationTest {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    protected static GoogleCloudStorageFileSystem gcsfs;
    protected static GoogleCloudStorage gcs;
    protected static GoogleCloudStorageFileSystemIntegrationHelper gcsiHelper;
    protected static Instant testStartTime;
    protected static String sharedBucketName1;
    protected static String sharedBucketName2;
    protected static String objectName;
    protected static final int UPLOAD_CHUNK_SIZE_DEFAULT = 0x4000000;
    @ClassRule
    public static NotInheritableExternalResource storageResource;

    public static void postCreateInit() throws IOException {
        GoogleCloudStorageFileSystemIntegrationTest.postCreateInit(new GoogleCloudStorageFileSystemIntegrationHelper(gcsfs));
    }

    public static void postCreateInit(GoogleCloudStorageFileSystemIntegrationHelper helper) throws IOException {
        testStartTime = Instant.now();
        gcsiHelper = helper;
        gcsiHelper.beforeAllTests();
        sharedBucketName1 = GoogleCloudStorageFileSystemIntegrationTest.gcsiHelper.sharedBucketName1;
        sharedBucketName2 = GoogleCloudStorageFileSystemIntegrationTest.gcsiHelper.sharedBucketName2;
    }

    private void validateFileInfoInternal(String bucketName, String objectName, boolean expectedToExist, FileInfo fileInfo) throws IOException {
        Truth.assertWithMessage((String)"exists for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(Boolean.valueOf(fileInfo.exists())).isEqualTo((Object)expectedToExist);
        long expectedSize = gcsiHelper.getExpectedObjectSize(objectName, expectedToExist);
        if (expectedSize != Long.MIN_VALUE) {
            Truth.assertWithMessage((String)"getSize for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(Long.valueOf(fileInfo.getSize())).isEqualTo((Object)expectedSize);
        }
        boolean expectedDirectory = objectName == null || StringPaths.isDirectoryPath((String)objectName);
        Truth.assertWithMessage((String)"isDirectory for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(Boolean.valueOf(fileInfo.isDirectory())).isEqualTo((Object)expectedDirectory);
        if (expectedToExist) {
            Instant currentTime = Instant.now();
            Instant fileModificationTime = Instant.ofEpochMilli(fileInfo.getModificationTime());
            Truth.assertWithMessage((String)"getModificationTime for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that((Comparable)fileModificationTime).isAtLeast((Comparable)testStartTime);
            Truth.assertWithMessage((String)"getModificationTime for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that((Comparable)fileModificationTime).isAtMost((Comparable)currentTime);
        } else {
            Truth.assertWithMessage((String)"getCreationTime for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(Long.valueOf(fileInfo.getCreationTime())).isEqualTo((Object)0);
            Truth.assertWithMessage((String)"getModificationTime for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(Long.valueOf(fileInfo.getModificationTime())).isEqualTo((Object)0);
        }
        Truth.assertWithMessage((String)"toString for bucketName '%s' objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(fileInfo.toString()).isNotEmpty();
    }

    protected void validateGetFileInfo(String bucketName, String objectName, boolean expectedToExist) throws IOException {
        URI path = gcsiHelper.getPath(bucketName, objectName);
        FileInfo fileInfo = gcsfs.getFileInfo(path);
        Truth.assertThat((Comparable)fileInfo.getPath()).isEqualTo((Object)path);
        this.validateFileInfoInternal(bucketName, objectName, expectedToExist, fileInfo);
    }

    protected void validateListFileInfo(String bucketName, String objectNamePrefix, boolean expectedToExist, String ... expectedListedNames) throws IOException {
        ArrayList fileInfos;
        boolean childPathsExpectedToExist = expectedToExist && expectedListedNames != null;
        boolean listRoot = bucketName == null;
        ArrayList<URI> expectedPaths = new ArrayList<URI>();
        HashMap<URI, String[]> pathToComponents = new HashMap<URI, String[]>();
        if (childPathsExpectedToExist) {
            for (String expectedListedName : expectedListedNames) {
                String[] pathComponents = new String[2];
                if (listRoot) {
                    pathComponents[0] = expectedListedName;
                    pathComponents[1] = null;
                } else {
                    pathComponents[0] = bucketName;
                    pathComponents[1] = expectedListedName;
                }
                URI expectedPath = gcsiHelper.getPath(pathComponents[0], pathComponents[1]);
                expectedPaths.add(expectedPath);
                pathToComponents.put(expectedPath, pathComponents);
            }
        }
        URI path = gcsiHelper.getPath(bucketName, objectNamePrefix);
        if (expectedToExist) {
            fileInfos = gcsfs.listFileInfo(path);
        } else {
            Assert.assertThrows(FileNotFoundException.class, () -> gcsfs.listFileInfo(path));
            fileInfos = new ArrayList();
        }
        ArrayList<URI> actualPaths = new ArrayList<URI>();
        for (FileInfo fileInfo : fileInfos) {
            Truth.assertWithMessage((String)("File exists? : " + fileInfo.getPath())).that(Boolean.valueOf(fileInfo.exists())).isEqualTo((Object)childPathsExpectedToExist);
            if (!fileInfo.exists()) continue;
            actualPaths.add(fileInfo.getPath());
            String[] uriComponents = (String[])pathToComponents.get(fileInfo.getPath());
            if (uriComponents == null) continue;
            this.validateFileInfoInternal(uriComponents[0], uriComponents[1], true, fileInfo);
        }
        if (listRoot) {
            Truth.assertThat(actualPaths).containsAtLeastElementsIn(expectedPaths);
        } else {
            Truth.assertThat(actualPaths).containsExactlyElementsIn(expectedPaths);
        }
    }

    @Test
    public void testDelete() throws Exception {
        this.deleteHelper(new DeletionBehavior(){

            @Override
            public MethodOutcome nonEmptyDeleteOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IOException.class);
            }

            @Override
            public MethodOutcome nonExistentDeleteOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, FileNotFoundException.class);
            }
        });
    }

    @Test
    public void testGetAndListFileInfo() throws Exception {
        String[] objectNames = new String[]{"o1", "o2", "d0/", "d1/o11", "d1/o12", "d1/d10/", "d1/d11/o111", "d2/o21", "d2/o22"};
        String dirDoesNotExist = "does-not-exist/";
        String objDoesNotExist = "does-not-exist";
        String testBucket = gcsiHelper.createUniqueBucket("list");
        gcsiHelper.createObjectsWithSubdirs(testBucket, objectNames);
        for (String objectName : objectNames) {
            this.validateGetFileInfo(testBucket, objectName, true);
        }
        this.validateGetFileInfo(testBucket, null, true);
        this.validateGetFileInfo(testBucket, dirDoesNotExist, false);
        this.validateGetFileInfo(testBucket, objDoesNotExist, false);
        this.validateListFileInfo(testBucket, null, true, "o1", "o2", "d0/", "d1/", "d2/");
        this.validateListFileInfo(testBucket, "", true, "o1", "o2", "d0/", "d1/", "d2/");
        this.validateListFileInfo(testBucket, "d0/", true, new String[0]);
        this.validateListFileInfo(testBucket, "d0", true, new String[0]);
        this.validateListFileInfo(testBucket, "o1", true, "o1");
        if (this.getClass().equals(GoogleCloudStorageFileSystemIntegrationTest.class) || this.getClass().equals(GoogleCloudStorageFileSystemTest.class)) {
            this.validateListFileInfo(testBucket, "o1/", false, new String[0]);
        } else {
            this.validateListFileInfo(testBucket, "o1/", true, "o1");
        }
        this.validateListFileInfo(testBucket, "d1/", true, "d1/o11", "d1/o12", "d1/d10/", "d1/d11/");
        this.validateListFileInfo(testBucket, "d1", true, "d1/o11", "d1/o12", "d1/d10/", "d1/d11/");
        this.validateListFileInfo(testBucket, "d1/o12", true, "d1/o12");
        if (this.getClass().equals(GoogleCloudStorageFileSystemIntegrationTest.class) || this.getClass().equals(GoogleCloudStorageFileSystemTest.class)) {
            this.validateListFileInfo(testBucket, "d1/o12/", false, new String[0]);
        } else {
            this.validateListFileInfo(testBucket, "d1/o12/", true, "d1/o12");
        }
        this.validateListFileInfo(testBucket, "d1/d11/", true, "d1/d11/o111");
        this.validateListFileInfo(testBucket, "d1/d11", true, "d1/d11/o111");
        this.validateListFileInfo(testBucket, "d2/", true, "d2/o21", "d2/o22");
        this.validateListFileInfo(testBucket, "d2", true, "d2/o21", "d2/o22");
        this.validateListFileInfo(testBucket, dirDoesNotExist, false, new String[0]);
        this.validateListFileInfo(testBucket, objDoesNotExist, false, new String[0]);
        this.validateListFileInfo("gcsio-test-bucket-" + objDoesNotExist, objDoesNotExist, false, new String[0]);
        this.validateListFileInfo(null, null, true, sharedBucketName1, sharedBucketName2, testBucket);
    }

    @Test
    public void testGoogleCloudStorageItemInfoNegativeEquality() {
        Truth.assertThat((Boolean)GoogleCloudStorageItemInfo.ROOT_INFO.equals((Object)"non-item-info")).isFalse();
    }

    @Test
    public void testWriteAndReadObject() throws IOException {
        String bucketName = sharedBucketName1;
        String message = "Hello world!\n";
        int numBytesWritten = gcsiHelper.writeTextFile(bucketName, objectName, message);
        String message2 = gcsiHelper.readTextFile(bucketName, objectName, 0, numBytesWritten, true);
        Truth.assertThat((String)message2).isEqualTo((Object)message);
    }

    @Test
    public void testReadPartialObject() throws IOException {
        String bucketName = sharedBucketName1;
        String message = "Hello world!\n";
        gcsiHelper.writeTextFile(bucketName, objectName, message);
        int offset = 6;
        String message1 = gcsiHelper.readTextFile(bucketName, objectName, 0, offset, false);
        String message2 = gcsiHelper.readTextFile(bucketName, objectName, offset, message.length() - offset, true);
        Truth.assertWithMessage((String)"partial read mismatch").that(message1).isEqualTo((Object)message.substring(0, offset));
        Truth.assertWithMessage((String)"partial read mismatch").that(message2).isEqualTo((Object)message.substring(offset));
    }

    @Test
    public void read_failure_ifObjectWasModifiedDuringRead() throws IOException {
        URI testObject = gcsiHelper.getUniqueObjectUri("generation-strict");
        String message1 = "Hello world!\n";
        String message2 = "Sayonara world!\n";
        gcsiHelper.writeTextFile(testObject, message1);
        int offset = 5;
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setMinRangeRequestSize(0).build();
        try (SeekableByteChannel readChannel = gcsiHelper.open(testObject, readOptions);){
            String read1 = gcsiHelper.readText(readChannel, 0, offset, false);
            Truth.assertWithMessage((String)"partial read mismatch").that(read1).isEqualTo((Object)message1.substring(0, offset));
            gcsiHelper.writeTextFileOverwriting(testObject, message2);
            FileNotFoundException expected = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> gcsiHelper.readText(readChannel, offset, message1.length() - offset, true));
            Truth.assertThat((Throwable)expected).hasMessageThat().contains((CharSequence)"Note, it is possible that the live version is still available but the requested generation is deleted.");
        }
    }

    @Test
    public void testOpenNonExistentObject() throws IOException {
        String bucketName = sharedBucketName1;
        Assert.assertThrows(FileNotFoundException.class, () -> gcsiHelper.readTextFile(bucketName, objectName + "_open-non-existent", 0, 100, true));
    }

    @Test
    public void testOpenInNonExistentBucket() throws IOException {
        String bucketName = gcsiHelper.getUniqueBucketName("open-non-existent");
        Assert.assertThrows(FileNotFoundException.class, () -> gcsiHelper.readTextFile(bucketName, objectName, 0, 100, true));
    }

    public void deleteHelper(DeletionBehavior behavior) throws Exception {
        String bucketName = sharedBucketName1;
        String[] objectNames = new String[]{"f1", "d0/", "d1/f1", "d1/d0/", "d1/d11/f1"};
        gcsiHelper.clearBucket(bucketName);
        gcsiHelper.createObjectsWithSubdirs(bucketName, objectNames);
        String tempBucket = gcsiHelper.createUniqueBucket("delete");
        gcsiHelper.createObjectsWithSubdirs(tempBucket, objectNames);
        ArrayList<DeleteData> deleteData = new ArrayList<DeleteData>();
        String doesNotExist = "does-not-exist";
        String dirDoesNotExist = "does-not-exist";
        deleteData.add(new DeleteData("Delete an object that does not exist: file", bucketName, doesNotExist, false, behavior.nonExistentDeleteOutcome(), null, null));
        deleteData.add(new DeleteData("Delete an object that does not exist: dir", bucketName, dirDoesNotExist, false, behavior.nonExistentDeleteOutcome(), null, null));
        deleteData.add(new DeleteData("Delete a bucket that does not exist", doesNotExist, doesNotExist, false, behavior.nonExistentDeleteOutcome(), null, null));
        deleteData.add(new DeleteData("Delete an empty directory", bucketName, "d0/", true, new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), null, Lists.newArrayList((Object[])new String[]{"d0/"})));
        deleteData.add(new DeleteData("Delete a non-empty directory (recursive == false)", bucketName, "d1/", false, behavior.nonEmptyDeleteOutcome(), Lists.newArrayList((Object[])new String[]{"d1/", "d1/f1", "d1/d0/", "d1/d11/f1"}), null));
        deleteData.add(new DeleteData("Delete a non-empty directory (recursive == true)", bucketName, "d1/", true, new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), null, Lists.newArrayList((Object[])new String[]{"d1/", "d1/f1", "d1/d0/", "d1/d11/f1"})));
        deleteData.add(new DeleteData("Delete a non-empty bucket (recursive == false)", tempBucket, null, false, behavior.nonEmptyDeleteOutcome(), Lists.newArrayList((Object[])new String[]{"f1", "d0/", "d1/", "d1/f1", "d1/d0/", "d1/d11/f1"}), null));
        deleteData.add(new DeleteData("Delete a non-empty bucket (recursive == true)", tempBucket, null, true, new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), null, Lists.newArrayList((Object[])new String[]{"f1", "d0/", "d1/", "d1/f1", "d1/d0/", "d1/d11/f1"})));
        for (DeleteData dd : deleteData) {
            this.assertPathsExist(dd.description, dd.bucketName, dd.objectsExpectedToBeDeleted, true);
            URI path = gcsiHelper.getPath(dd.bucketName, dd.objectName);
            try {
                boolean result = gcsiHelper.delete(path, dd.recursive);
                if (result) {
                    Truth.assertWithMessage((String)"Unexpected result for '%s' path: %s :: expected %s, actually returned true.", (Object[])new Object[]{path, dd.description, dd.expectedOutcome}).that((Comparable)((Object)dd.expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.RETURNS_TRUE);
                } else {
                    Truth.assertWithMessage((String)"Unexpected result for '%s' path: %s :: expected %s, actually returned false.", (Object[])new Object[]{path, dd.description, dd.expectedOutcome}).that((Comparable)((Object)dd.expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.RETURNS_FALSE);
                }
            }
            catch (Exception e) {
                Truth.assertWithMessage((String)"Unexpected result for '%s' path: %s :: expected %s, actually threw exception %s", (Object[])new Object[]{path, dd.description, dd.expectedOutcome, Throwables.getStackTraceAsString((Throwable)e)}).that((Comparable)((Object)dd.expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.THROWS_EXCEPTION);
            }
            this.assertPathsExist(dd.description, dd.bucketName, dd.objectsExpectedToExist, true);
            this.assertPathsExist(dd.description, dd.bucketName, dd.objectsExpectedToBeDeleted, false);
        }
    }

    @Test
    public void testMkdirAndCreateFileOfSameName() throws Exception {
        String bucketName = sharedBucketName1;
        String uniqueDirName = "dir-" + UUID.randomUUID();
        gcsiHelper.mkdir(bucketName, uniqueDirName + "/");
        IOException ioe = (IOException)Assert.assertThrows(IOException.class, () -> gcsiHelper.writeTextFile(bucketName, uniqueDirName, "hello world"));
        Truth.assertWithMessage((String)"unexpected exception:%n%s", (Object[])new Object[]{Throwables.getStackTraceAsString((Throwable)ioe)}).that((Throwable)ioe).hasMessageThat().matches(".*(A directory with that name exists|Is a directory|already exists).*");
        gcsiHelper.delete(bucketName, uniqueDirName);
    }

    @Test
    public void testMkdirs() throws Exception {
        this.mkdirsHelper(new MkdirsBehavior(){

            @Override
            public MethodOutcome mkdirsRootOutcome() {
                return new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE);
            }

            @Override
            public MethodOutcome fileAlreadyExistsOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IOException.class);
            }
        });
    }

    public void mkdirsHelper(MkdirsBehavior behavior) throws Exception {
        String bucketName = sharedBucketName1;
        String[] objectNames = new String[]{"f1", "d0/", "d1/f11"};
        gcsiHelper.clearBucket(bucketName);
        gcsiHelper.createObjectsWithSubdirs(bucketName, objectNames);
        HashMap<URI, MethodOutcome> dirData = new HashMap<URI, MethodOutcome>();
        dirData.put(GoogleCloudStorageFileSystem.GCS_ROOT, behavior.mkdirsRootOutcome());
        dirData.put(gcsiHelper.getPath(bucketName, "d0/"), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        dirData.put(gcsiHelper.getPath(bucketName, "d0"), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        dirData.put(gcsiHelper.getPath(bucketName, "f1/"), behavior.fileAlreadyExistsOutcome());
        dirData.put(gcsiHelper.getPath(bucketName, "d1/f11/d3/"), behavior.fileAlreadyExistsOutcome());
        dirData.put(gcsiHelper.getPath(bucketName, "d1/d2/d3/"), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        dirData.put(gcsiHelper.getPath(bucketName, "dA/dB/dC/"), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        dirData.put(gcsiHelper.getPath(bucketName, "dA/dB/dC/"), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        String uniqueBucketName = gcsiHelper.getUniqueBucketName("mkdir-1");
        dirData.put(gcsiHelper.getPath(uniqueBucketName, null), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        dirData.put(gcsiHelper.getPath(uniqueBucketName, null), new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE));
        String uniqueBucketName2 = gcsiHelper.getUniqueBucketName("mkdir-2");
        dirData.put(gcsiHelper.getPath(uniqueBucketName2, "foo/bar"), new MethodOutcome(gcsiHelper.getClass().getSimpleName().equals("HadoopFileSystemIntegrationHelper") ? MethodOutcome.Type.RETURNS_TRUE : MethodOutcome.Type.THROWS_EXCEPTION));
        for (URI path : dirData.keySet()) {
            MethodOutcome expectedOutcome = (MethodOutcome)dirData.get(path);
            try {
                boolean result = gcsiHelper.mkdirs(path);
                if (result) {
                    Truth.assertWithMessage((String)"Unexpected result for path: '%s' : expected %s, actually returned true.", (Object[])new Object[]{path, expectedOutcome}).that((Comparable)((Object)expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.RETURNS_TRUE);
                    List<URI> subDirPaths = this.getSubDirPaths(path);
                    for (URI subDirPath : subDirPaths) {
                        Truth.assertWithMessage((String)"Sub-path '%s' of path '%s' not found or not a dir", (Object[])new Object[]{subDirPath, path}).that(Boolean.valueOf(gcsiHelper.exists(subDirPath) && gcsiHelper.isDirectory(subDirPath))).isTrue();
                    }
                    continue;
                }
                Truth.assertWithMessage((String)"Unexpected result for path: '%s' : expected '%s', actually returned false.", (Object[])new Object[]{path, expectedOutcome}).that((Comparable)((Object)expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.RETURNS_FALSE);
            }
            catch (Exception e) {
                Truth.assertWithMessage((String)"Unexpected result for path: '%s' : expected '%s', actually threw exception %s.", (Object[])new Object[]{path, expectedOutcome, Throwables.getStackTraceAsString((Throwable)e)}).that((Comparable)((Object)expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.THROWS_EXCEPTION);
            }
        }
    }

    @Test
    public void testGetFileInfos() throws Exception {
        String bucketName = sharedBucketName1;
        String[] objectNames = new String[]{"f1", "d0/"};
        gcsiHelper.clearBucket(bucketName);
        gcsiHelper.createObjectsWithSubdirs(bucketName, objectNames);
        ArrayList<URI> pathsToGet = new ArrayList<URI>();
        pathsToGet.add(gcsiHelper.getPath(bucketName, "nonexistent"));
        pathsToGet.add(gcsiHelper.getPath(bucketName, "f1"));
        pathsToGet.add(gcsiHelper.getPath(null, null));
        pathsToGet.add(gcsiHelper.getPath(bucketName, "d0"));
        pathsToGet.add(gcsiHelper.getPath(bucketName, null));
        List fileInfos = gcsfs.getFileInfos(pathsToGet);
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(0)).exists()).isFalse();
        Truth.assertThat((Object)((FileInfo)fileInfos.get(0)).getItemInfo().getResourceId()).isEqualTo((Object)new StorageResourceId(bucketName, "nonexistent"));
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(1)).exists()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(1)).getItemInfo().getResourceId().isStorageObject()).isTrue();
        Truth.assertThat((Object)((FileInfo)fileInfos.get(1)).getItemInfo().getResourceId()).isEqualTo((Object)new StorageResourceId(bucketName, "f1"));
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(2)).exists()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(2)).isGlobalRoot()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(3)).exists()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(3)).isDirectory()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(3)).getItemInfo().getResourceId().isStorageObject()).isTrue();
        Truth.assertThat((Object)((FileInfo)fileInfos.get(3)).getItemInfo().getResourceId()).isEqualTo((Object)new StorageResourceId(bucketName, "d0/"));
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(4)).exists()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(4)).isDirectory()).isTrue();
        Truth.assertThat((Boolean)((FileInfo)fileInfos.get(4)).getItemInfo().getResourceId().isBucket()).isTrue();
        Truth.assertThat((Object)((FileInfo)fileInfos.get(4)).getItemInfo().getResourceId()).isEqualTo((Object)new StorageResourceId(bucketName));
    }

    @Test
    public void testRename() throws Exception {
        this.renameHelper(new RenameBehavior(){

            @Override
            public MethodOutcome renameFileIntoRootOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IOException.class);
            }

            @Override
            public MethodOutcome renameRootOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IllegalArgumentException.class);
            }

            @Override
            public MethodOutcome nonExistentSourceOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, FileNotFoundException.class);
            }

            @Override
            public MethodOutcome destinationFileExistsSrcIsFileOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IOException.class);
            }

            @Override
            public MethodOutcome destinationFileExistsSrcIsDirectoryOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IOException.class);
            }

            @Override
            public MethodOutcome nonExistentDestinationFileParentOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, FileNotFoundException.class);
            }

            @Override
            public MethodOutcome nonExistentDestinationDirectoryParentOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, FileNotFoundException.class);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameHelper(RenameBehavior behavior) throws Exception {
        String bucketName = sharedBucketName1;
        String otherBucketName = sharedBucketName2;
        String uniqueDir = "dir-" + UUID.randomUUID() + "/";
        String uniqueFile = uniqueDir + "f1";
        String[] objectNames = new String[]{"f1", "f2", "d0/", "d0-a/", "d0-b/", "d1/f1", "d1/d0/", "d1/d11/f1", "d1-a/f1", "d1-b/f1", "d1-c/f1", "d1-d/f1", "d1-e/f1", "d1-f/f1", "d1-g/f1", "d1-h/f1", "d1-i/f1", uniqueFile, "td0-a/", "td0-b/", "n1-src/d1/f1", "n1-dst/", "n2-src/d0/", "n2-src/f1", "n2-src/d1/f1", "n2-src/d2/d21/d211/f1", "n2-dst/", "n2-dst/f1"};
        String[] otherObjectNames = new String[]{"td0/"};
        gcsiHelper.clearBucket(bucketName);
        gcsiHelper.clearBucket(otherBucketName);
        gcsiHelper.createObjectsWithSubdirs(bucketName, objectNames);
        gcsiHelper.createObjectsWithSubdirs(otherBucketName, otherObjectNames);
        ArrayList<RenameData> renameData = new ArrayList<RenameData>();
        String doesNotExist = "does-not-exist";
        String dirDoesNotExist = "does-not-exist";
        renameData.add(new RenameData("src == root", null, null, otherBucketName, doesNotExist, behavior.renameRootOutcome(), null, null, null));
        renameData.add(new RenameData("src does not exist: 1", bucketName, doesNotExist, otherBucketName, doesNotExist, behavior.nonExistentSourceOutcome(), null, null, null));
        renameData.add(new RenameData("src does not exist: 2", bucketName, dirDoesNotExist, otherBucketName, dirDoesNotExist, behavior.nonExistentSourceOutcome(), null, null, null));
        renameData.add(new RenameData("src does not exist: 3", doesNotExist, doesNotExist, otherBucketName, doesNotExist, behavior.nonExistentSourceOutcome(), null, null, null));
        if (behavior.destinationFileExistsSrcIsFileOutcome().getType() == MethodOutcome.Type.RETURNS_TRUE) {
            renameData.add(new RenameData("dst is a file that already exists: 1", bucketName, "f1", bucketName, "f2", behavior.destinationFileExistsSrcIsFileOutcome(), null, Lists.newArrayList((Object[])new String[]{"f2"}), Lists.newArrayList((Object[])new String[]{"f1"})));
        } else {
            renameData.add(new RenameData("dst is a file that already exists: 1", bucketName, "f1", bucketName, "f2", behavior.destinationFileExistsSrcIsFileOutcome(), Lists.newArrayList((Object[])new String[]{"f1"}), Lists.newArrayList((Object[])new String[]{"f2"}), null));
        }
        renameData.add(new RenameData("dst is a file that already exists: 2", bucketName, "d0/", bucketName, "f2", behavior.destinationFileExistsSrcIsDirectoryOutcome(), Lists.newArrayList((Object[])new String[]{"d0/"}), Lists.newArrayList((Object[])new String[]{"f2"}), null));
        renameData.add(new RenameData("Parent of destination does not exist: 1", bucketName, "f1", bucketName, "does-not-exist/f1", behavior.nonExistentDestinationFileParentOutcome(), null, null, null));
        if (behavior.nonExistentDestinationDirectoryParentOutcome().getType() == MethodOutcome.Type.RETURNS_TRUE) {
            renameData.add(new RenameData("Parent of destination does not exist: 2", bucketName, "d0-b/", bucketName, "does-not-exist2/d0-b/", behavior.nonExistentDestinationDirectoryParentOutcome(), null, Lists.newArrayList((Object[])new String[]{"does-not-exist2/d0-b/"}), Lists.newArrayList((Object[])new String[]{"d0-b/"})));
        } else {
            renameData.add(new RenameData("Parent of destination does not exist: 2", bucketName, "d0-b/", bucketName, "does-not-exist2/d0-b/", behavior.nonExistentDestinationDirectoryParentOutcome(), Lists.newArrayList((Object[])new String[]{"d0-b/"}), null, null));
        }
        renameData.add(new RenameData("destination is a dir that exists and non-empty: 2", bucketName, "d1-h/", bucketName, "td0-a", new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), Lists.newArrayList((Object[])new String[]{"td0-a/", "td0-a/d1-h/", "td0-a/d1-h/f1"}), null, Lists.newArrayList((Object[])new String[]{"d1-h/", "d1-h/f1"})));
        renameData.add(new RenameData("destination is a dir that does not exist", bucketName, "d1-b/", bucketName, "td0-x/", new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), Lists.newArrayList((Object[])new String[]{"td0-x/", "td0-x/f1"}), null, Lists.newArrayList((Object[])new String[]{"d1-b/", "d1-b/f1"})));
        renameData.add(new RenameData("destination is a file that does not exist", bucketName, "d1-c/", bucketName, "td0-a/df", new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), Lists.newArrayList((Object[])new String[]{"td0-a/", "td0-a/df/", "td0-a/df/f1"}), null, Lists.newArrayList((Object[])new String[]{"d1-c/", "d1-c/f1"})));
        renameData.add(new RenameData("destination is a file that does not exist", bucketName, "d1-d/f1", bucketName, "td0-a/f1-x", new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), Lists.newArrayList((Object[])new String[]{"d1-d/", "td0-a/", "td0-a/f1-x"}), null, Lists.newArrayList((Object[])new String[]{"d1-d/f1"})));
        if (behavior.renameFileIntoRootOutcome().getType() == MethodOutcome.Type.RETURNS_TRUE) {
            renameData.add(new RenameData("file : destination is root", bucketName, "d1-i/f1", null, null, behavior.renameFileIntoRootOutcome(), Lists.newArrayList((Object[])new String[]{"d1-i/"}), null, Lists.newArrayList((Object[])new String[]{"d1-i/f1"})));
        } else {
            renameData.add(new RenameData("file : destination is root", bucketName, "d1-i/f1", null, null, behavior.renameFileIntoRootOutcome(), Lists.newArrayList((Object[])new String[]{"d1-i/", "d1-i/f1"}), null, null));
        }
        renameData.add(new RenameData("src is a directory with a multi-level subdirectory; dst is a directory which exists.", bucketName, "n1-src/", bucketName, "n1-dst/", new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), Lists.newArrayList((Object[])new String[]{"n1-dst/", "n1-dst/n1-src/d1/", "n1-dst/n1-src/d1/f1"}), null, Lists.newArrayList((Object[])new String[]{"n1-src/", "n1-src/d1/", "n1-src/d1/f1"})));
        renameData.add(new RenameData("src is a directory with a multi-level subdirectory; dst is a directory which exists - 2", bucketName, "n2-src/", bucketName, "n2-dst/", new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE), Lists.newArrayList((Object[])new String[]{"n2-dst/", "n2-dst/f1", "n2-dst/n2-src/d0/", "n2-dst/n2-src/f1", "n2-dst/n2-src/d1/f1", "n2-dst/n2-src/d2/d21/d211/f1"}), null, Lists.newArrayList((Object[])new String[]{"n2-src/", "n2-src/d0/", "n2-src/f1", "n2-src/d1/f1", "n2-src/d2/d21/d211/f1"})));
        ExecutorService threadPool = Executors.newCachedThreadPool();
        try {
            ArrayList errorList = new ArrayList();
            CountDownLatch checkStartCounter = new CountDownLatch(renameData.size());
            for (RenameData renameData2 : renameData) {
                Future<?> future = threadPool.submit(() -> {
                    try {
                        this.assertPathsExist(rd.description, rd.srcBucketName, rd.objectsExpectedToBeDeleted, true);
                    }
                    catch (Throwable t) {
                        List list = errorList;
                        synchronized (list) {
                            errorList.add(t);
                        }
                    }
                    finally {
                        checkStartCounter.countDown();
                    }
                });
            }
            checkStartCounter.await();
            if (!errorList.isEmpty()) {
                AssertionError error = new AssertionError();
                for (Throwable throwable : errorList) {
                    ((Throwable)((Object)error)).addSuppressed(throwable);
                }
                throw error;
            }
            CountDownLatch renameCounter = new CountDownLatch(renameData.size());
            for (RenameData renameData3 : renameData) {
                Future<?> future = threadPool.submit(() -> {
                    block11: {
                        try {
                            URI src = gcsiHelper.getPath(rd.srcBucketName, rd.srcObjectName);
                            URI dst = gcsiHelper.getPath(rd.dstBucketName, rd.dstObjectName);
                            String desc = src + " -> " + dst;
                            try {
                                if (gcsiHelper.rename(src, dst)) {
                                    Truth.assertWithMessage((String)"Unexpected result for '%s': %s :: expected %s, actually returned true.", (Object[])new Object[]{desc, rd.description, rd.expectedOutcome}).that((Comparable)((Object)rd.expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.RETURNS_TRUE);
                                    break block11;
                                }
                                Truth.assertWithMessage((String)"Unexpected result for '%s': %s :: expected %s, actually returned false.", (Object[])new Object[]{desc, rd.description, rd.expectedOutcome}).that((Comparable)((Object)rd.expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.RETURNS_FALSE);
                            }
                            catch (Exception e) {
                                Truth.assertWithMessage((String)"Unexpected result for '%s': %s :: expected %s, actually threw %s.", (Object[])new Object[]{desc, rd.description, rd.expectedOutcome, Throwables.getStackTraceAsString((Throwable)e)}).that((Comparable)((Object)rd.expectedOutcome.getType())).isEqualTo((Object)MethodOutcome.Type.THROWS_EXCEPTION);
                            }
                        }
                        catch (Throwable t) {
                            List list = errorList;
                            synchronized (list) {
                                errorList.add(t);
                            }
                        }
                        finally {
                            renameCounter.countDown();
                        }
                    }
                });
            }
            renameCounter.await();
            if (!errorList.isEmpty()) {
                AssertionError assertionError = new AssertionError();
                for (Throwable t : errorList) {
                    ((Throwable)((Object)assertionError)).addSuppressed(t);
                }
                throw assertionError;
            }
            CountDownLatch countDownLatch = new CountDownLatch(renameData.size());
            for (RenameData rd : renameData) {
                Future<?> future = threadPool.submit(() -> {
                    try {
                        String srcDirName;
                        URI src = gcsiHelper.getPath(rd.srcBucketName, rd.srcObjectName);
                        this.assertPathsExist(rd.description, rd.srcBucketName, rd.objectsExpectedToExistSrc, true);
                        String dstBucketName = rd.dstBucketName == null && rd.dstObjectName == null ? (srcDirName = gcsiHelper.getItemName(src)) : rd.dstBucketName;
                        this.assertPathsExist(rd.description, dstBucketName, rd.objectsExpectedToExistDst, true);
                        this.assertPathsExist(rd.description, rd.srcBucketName, rd.objectsExpectedToBeDeleted, false);
                    }
                    catch (Throwable t) {
                        List list = errorList;
                        synchronized (list) {
                            errorList.add(t);
                        }
                    }
                    finally {
                        checkDestCounter.countDown();
                    }
                });
            }
            countDownLatch.await();
            if (!errorList.isEmpty()) {
                AssertionError assertionError = new AssertionError();
                for (Throwable t : errorList) {
                    ((Throwable)((Object)assertionError)).addSuppressed(t);
                }
                throw assertionError;
            }
        }
        finally {
            threadPool.shutdown();
            if (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                ((GoogleLogger.Api)logger.atSevere()).log("Failed to awaitTermination! Forcing executor shutdown.");
                threadPool.shutdownNow();
            }
        }
    }

    @Test
    public void testRenameWithContentChecking() throws Exception {
        String bucketName = sharedBucketName1;
        String[] fileNames = new String[]{"test-recursive/oldA/B/file2", "test-recursive/oldA/file1", "test-flat/oldA/aaa", "test-flat/oldA/b"};
        gcsiHelper.clearBucket(bucketName);
        gcsiHelper.createObjectsWithSubdirs(bucketName, fileNames);
        String testDescRecursive = "Rename of directory with file1 and subdirectory with file2";
        ImmutableList originalObjects = ImmutableList.of((Object)"test-recursive/", (Object)"test-recursive/oldA/", (Object)"test-recursive/oldA/B/", (Object)"test-recursive/oldA/B/file2", (Object)"test-recursive/oldA/file1", (Object)"test-flat/oldA/aaa", (Object)"test-flat/oldA/b");
        this.assertPathsExist(testDescRecursive, bucketName, (List<String>)originalObjects, true);
        for (String originalName : fileNames) {
            Truth.assertThat((String)gcsiHelper.readTextFile(bucketName, originalName)).isEqualTo((Object)originalName);
        }
        URI src = gcsiHelper.getPath(bucketName, "test-recursive/oldA");
        String[] dst = gcsiHelper.getPath(bucketName, "test-recursive/newA");
        Truth.assertThat((Boolean)gcsiHelper.rename(src, (URI)dst)).isTrue();
        src = gcsiHelper.getPath(bucketName, "test-flat/oldA");
        dst = gcsiHelper.getPath(bucketName, "test-flat/newA");
        Truth.assertThat((Boolean)gcsiHelper.rename(src, (URI)dst)).isTrue();
        ImmutableList resultingObjects = ImmutableList.of((Object)"test-recursive/", (Object)"test-recursive/newA/", (Object)"test-recursive/newA/B/", (Object)"test-recursive/newA/B/file2", (Object)"test-recursive/newA/file1", (Object)"test-flat/newA/aaa", (Object)"test-flat/newA/b");
        this.assertPathsExist(testDescRecursive, bucketName, (List<String>)resultingObjects, true);
        for (String originalName : fileNames) {
            String resultingName = originalName.replaceFirst("oldA", "newA");
            Truth.assertThat((String)gcsiHelper.readTextFile(bucketName, resultingName)).isEqualTo((Object)originalName);
        }
        ImmutableList deletedObjects = ImmutableList.of((Object)"test-recursive/oldA/", (Object)"test-recursive/oldA/B/", (Object)"test-recursive/oldA/B/file2", (Object)"test-recursive/oldA/file1", (Object)"test-flat/oldA/aaa", (Object)"test-flat/oldA/b");
        this.assertPathsExist(testDescRecursive, bucketName, (List<String>)deletedObjects, false);
    }

    @Test
    public void testFileCreationSetsAttributes() throws IOException {
        CreateFileOptions createFileOptions = CreateFileOptions.builder().setAttributes((Map)ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8))).build();
        URI testFilePath = gcsiHelper.getPath(sharedBucketName1, "test-file-creation-attributes.txt");
        try (WritableByteChannel channel = gcsfs.create(testFilePath, createFileOptions);){
            Truth.assertThat((Object)channel).isNotNull();
        }
        FileInfo info = gcsfs.getFileInfo(testFilePath);
        Truth.assertThat((Map)info.getAttributes()).hasSize(1);
        Truth.assertThat((Map)info.getAttributes()).containsKey((Object)"key1");
        Truth.assertThat((byte[])((byte[])info.getAttributes().get("key1"))).isEqualTo((Object)"value1".getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void renameDirectoryShouldCopyMarkerFilesLast() throws Exception {
        URI dir = gcsiHelper.getPath(sharedBucketName1, "test-marker-files/rename-dir/");
        String subDir = "subdirectory/";
        ImmutableList files = ImmutableList.of((Object)"file", (Object)(subDir + "file"));
        ImmutableList markerFiles = ImmutableList.of((Object)"_SUCCESS", (Object)(subDir + "_FAILURE"));
        URI srcDir = dir.resolve("src-directory/");
        gcsfs.mkdirs(srcDir);
        for (String file : Iterables.concat((Iterable)markerFiles, (Iterable)files)) {
            WritableByteChannel channel = gcsfs.create(srcDir.resolve(file));
            Object object = null;
            try {
                Truth.assertThat((Object)channel).isNotNull();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (channel == null) continue;
                if (object != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                channel.close();
            }
        }
        Thread.sleep(100L);
        URI dstDir = dir.resolve("dst-directory/");
        gcsfs.rename(srcDir, dstDir);
        List fileInfos = gcsfs.getFileInfos(files.stream().map(dstDir::resolve).collect(Collectors.toList()));
        List markerFileInfos = gcsfs.getFileInfos(markerFiles.stream().map(dstDir::resolve).collect(Collectors.toList()));
        for (FileInfo mf : markerFileInfos) {
            fileInfos.forEach(f -> Truth.assertThat((Long)f.getModificationTime()).isLessThan((Comparable)Long.valueOf(mf.getModificationTime())));
        }
    }

    @Test
    public void testComposeSuccess() throws IOException {
        String bucketName = sharedBucketName1;
        URI directory = gcsiHelper.getPath(bucketName, "test-compose/");
        URI object1 = directory.resolve("object1");
        URI object2 = directory.resolve("object2");
        URI destination = directory.resolve("destination");
        gcsfs.mkdirs(directory);
        try (WritableByteChannel channel1 = gcsfs.create(object1);){
            Truth.assertThat((Object)channel1).isNotNull();
            channel1.write(ByteBuffer.wrap("content1".getBytes(StandardCharsets.UTF_8)));
        }
        var7_7 = null;
        try (WritableByteChannel channel2 = gcsfs.create(object2);){
            Truth.assertThat((Object)channel2).isNotNull();
            channel2.write(ByteBuffer.wrap("content2".getBytes(StandardCharsets.UTF_8)));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        Truth.assertThat((Boolean)(gcsfs.exists(object1) && gcsfs.exists(object2) ? 1 : 0)).isTrue();
        gcsfs.compose((List)ImmutableList.of((Object)object1, (Object)object2), destination, "application/octet-stream");
        byte[] expectedOutput = "content1content2".getBytes(StandardCharsets.UTF_8);
        ByteBuffer actualOutput = ByteBuffer.allocate(expectedOutput.length);
        try (SeekableByteChannel destinationChannel = gcsiHelper.open(bucketName, "test-compose/destination");){
            destinationChannel.read(actualOutput);
        }
        Truth.assertThat((byte[])actualOutput.array()).isEqualTo((Object)expectedOutput);
    }

    public static URI getTempFilePath() {
        return gcsiHelper.getPath(sharedBucketName1, "file-" + UUID.randomUUID());
    }

    private List<URI> getSubDirPaths(URI path) {
        StorageResourceId resourceId = StorageResourceId.fromUriPath((URI)path, (boolean)true);
        List subdirs = GoogleCloudStorageFileSystem.getDirs((String)resourceId.getObjectName());
        ArrayList<URI> subDirPaths = new ArrayList<URI>(subdirs.size());
        for (String subdir : subdirs) {
            subDirPaths.add(gcsiHelper.getPath(resourceId.getBucketName(), subdir));
        }
        return subDirPaths;
    }

    private void assertPathsExist(String testCaseDescription, String bucketName, List<String> objectNames, boolean expectedToExist) throws IOException {
        if (objectNames != null) {
            for (String object : objectNames) {
                URI path = gcsiHelper.getPath(bucketName, object);
                String msg = String.format("test-case: %s :: %s: %s", testCaseDescription, expectedToExist ? "Path expected to exist but not found" : "Path expected to not exist but found", path.toString());
                Truth.assertWithMessage((String)msg).that(Boolean.valueOf(gcsiHelper.exists(path))).isEqualTo((Object)expectedToExist);
            }
        }
    }

    static {
        objectName = "gcsio-test.txt";
        storageResource = new NotInheritableExternalResource((Class)GoogleCloudStorageFileSystemIntegrationTest.class){

            @Override
            public void before() throws Throwable {
                if (gcsfs == null) {
                    Credential credential = GoogleCloudStorageTestHelper.getCredential();
                    String projectId = (String)Preconditions.checkNotNull((Object)TestConfiguration.getInstance().getProjectId());
                    GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = GoogleCloudStorageFileSystemOptions.builder().setMarkerFilePattern("_(FAILURE|SUCCESS)");
                    optionsBuilder.setBucketDeleteEnabled(true).setCloudStorageOptions(GoogleCloudStorageOptions.builder().setAppName("GHFS/test").setProjectId(projectId).setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(0x4000000).build()).build());
                    gcsfs = new GoogleCloudStorageFileSystem(credential, optionsBuilder.build());
                    gcs = gcsfs.getGcs();
                    GoogleCloudStorageFileSystemIntegrationTest.postCreateInit();
                }
            }

            @Override
            public void after() {
                if (gcs != null) {
                    gcsiHelper.afterAllTests();
                    gcsiHelper = null;
                }
                if (gcsfs != null) {
                    gcsfs.close();
                    gcsfs = null;
                }
            }
        };
    }

    private static class RenameData {
        String description;
        String srcBucketName;
        String srcObjectName;
        String dstBucketName;
        String dstObjectName;
        MethodOutcome expectedOutcome;
        List<String> objectsExpectedToExistSrc;
        List<String> objectsExpectedToExistDst;
        List<String> objectsExpectedToBeDeleted;

        RenameData(String description, String srcBucketName, String srcObjectName, String dstBucketName, String dstObjectName, MethodOutcome expectedOutcome, List<String> objectsExpectedToExistSrc, List<String> objectsExpectedToExistDst, List<String> objectsExpectedToBeDeleted) {
            this.description = description;
            this.srcBucketName = srcBucketName;
            this.srcObjectName = srcObjectName;
            this.dstBucketName = dstBucketName;
            this.dstObjectName = dstObjectName;
            this.expectedOutcome = expectedOutcome;
            this.objectsExpectedToExistSrc = objectsExpectedToExistSrc;
            this.objectsExpectedToExistDst = objectsExpectedToExistDst;
            this.objectsExpectedToBeDeleted = objectsExpectedToBeDeleted;
        }
    }

    private static class DeleteData {
        String description;
        String bucketName;
        String objectName;
        boolean recursive;
        MethodOutcome expectedOutcome;
        List<String> objectsExpectedToExist;
        List<String> objectsExpectedToBeDeleted;

        DeleteData(String description, String bucketName, String objectName, boolean recursive, MethodOutcome expectedOutcome, List<String> objectsExpectedToExist, List<String> objectsExpectedToBeDeleted) {
            this.description = description;
            this.bucketName = bucketName;
            this.objectName = objectName;
            this.recursive = recursive;
            this.expectedOutcome = expectedOutcome;
            this.objectsExpectedToExist = objectsExpectedToExist;
            this.objectsExpectedToBeDeleted = objectsExpectedToBeDeleted;
        }
    }

    public static class NotInheritableExternalResource
    extends ExternalResource {
        private final Class<?> testClass;

        public NotInheritableExternalResource(Class<?> testClass) {
            this.testClass = testClass;
        }

        public Statement apply(Statement base, Description description) {
            if (this.testClass.equals(description.getTestClass())) {
                return super.apply(base, description);
            }
            return base;
        }

        public void before() throws Throwable {
        }

        public void after() {
        }
    }
}

