/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageFileSystemOptionsTest {
    @BeforeClass
    public static void beforeAllTests() throws IOException {
        Logger.getLogger("").setLevel(Level.OFF);
    }

    @Test
    public void testGcsFsInheritsGcsOptions() throws Exception {
        GoogleCloudStorageOptions gcsOptions = GoogleCloudStorageOptions.builder().setProjectId("foo-project").setAppName("foo-app").build();
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(gcsOptions).build());
        Truth.assertThat((String)gcsfs.getOptions().getCloudStorageOptions().getProjectId()).isEqualTo((Object)"foo-project");
        Truth.assertThat((String)gcsfs.getOptions().getCloudStorageOptions().getAppName()).isEqualTo((Object)"foo-app");
    }

    @Test
    public void testInferredDirectories() throws IOException, URISyntaxException {
        String testBucketName = "bucket1";
        ImmutableList inputFiles = ImmutableList.of((Object)("gs://" + testBucketName + "/a/b/f1.txt"), (Object)("gs://" + testBucketName + "/a/c/f2.txt"), (Object)("gs://" + testBucketName + "/e/f"));
        ImmutableList impliedDirs0 = ImmutableList.of((Object)("gs://" + testBucketName + "/a/b"), (Object)("gs://" + testBucketName + "/a/c"), (Object)("gs://" + testBucketName + "/e"));
        String impliedDirA = "gs://" + testBucketName + "/a";
        ImmutableList impliedDirs1 = ImmutableList.of((Object)impliedDirA);
        ImmutableList impliedDirs = ImmutableList.builder().addAll((Iterable)impliedDirs0).addAll((Iterable)impliedDirs1).build();
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build());
        GoogleCloudStorage gcs = gcsfs.getGcs();
        gcs.createBucket(testBucketName);
        for (String inputFile : inputFiles) {
            gcs.createEmptyObject(StorageResourceId.fromStringPath((String)inputFile));
        }
        for (String inputFile : inputFiles) {
            FileInfo fileInfo = gcsfs.getFileInfo(new URI(inputFile));
            Truth.assertThat((Boolean)fileInfo.exists()).isTrue();
        }
        for (String dir : impliedDirs) {
            FileInfo dirInfo = gcsfs.getFileInfo(new URI(dir));
            Truth.assertWithMessage((String)"Directory %s should exist (inferred)", (Object[])new Object[]{dir}).that(Boolean.valueOf(dirInfo.exists())).isTrue();
            Truth.assertWithMessage((String)"Creation time on inferred directory %s should be zero.", (Object[])new Object[]{dir}).that(Long.valueOf(dirInfo.getCreationTime())).isEqualTo((Object)0);
        }
        List subInfo = gcsfs.listFileInfo(new URI(impliedDirA));
        Truth.assertWithMessage((String)"Implied directory %s should have 2 children", (Object[])new Object[]{impliedDirA}).that(Integer.valueOf(subInfo.size())).isEqualTo((Object)2);
    }
}

