/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageFileSystemTest
extends GoogleCloudStorageFileSystemIntegrationTest {
    @ClassRule
    public static GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource storageResource = new GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource((Class)GoogleCloudStorageFileSystemTest.class){

        @Override
        public void before() throws IOException {
            Logger.getLogger("").setLevel(Level.OFF);
            if (GoogleCloudStorageFileSystemIntegrationTest.gcsfs == null) {
                GoogleCloudStorageFileSystemIntegrationTest.gcsfs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).setMarkerFilePattern("_(FAILURE|SUCCESS)").build());
                GoogleCloudStorageFileSystemIntegrationTest.gcs = GoogleCloudStorageFileSystemIntegrationTest.gcsfs.getGcs();
                GoogleCloudStorageFileSystemIntegrationTest.postCreateInit();
            }
        }

        @Override
        public void after() {
            GoogleCloudStorageFileSystemIntegrationTest.storageResource.after();
        }
    };

    private static void setDefaultValidOptions(GoogleCloudStorageFileSystemOptions.Builder optionsBuilder) {
        optionsBuilder.setCloudStorageOptions(GoogleCloudStorageOptions.builder().setAppName("appName").setProjectId("projectId").setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(0x4000000).build()).build());
    }

    @Test
    public void testConstructor() throws IOException {
        GoogleCredential cred = new GoogleCredential();
        GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = GoogleCloudStorageFileSystemOptions.builder();
        GoogleCloudStorageFileSystemTest.setDefaultValidOptions(optionsBuilder);
        GoogleCloudStorageFileSystemOptions options = optionsBuilder.build();
        optionsBuilder.setCloudStorageOptions(options.getCloudStorageOptions().toBuilder().setProjectId(null).build());
        new GoogleCloudStorageFileSystem((Credential)cred, optionsBuilder.build());
        optionsBuilder.setCloudStorageOptions(options.getCloudStorageOptions().toBuilder().setProjectId("").build());
        new GoogleCloudStorageFileSystem((Credential)cred, optionsBuilder.build());
        optionsBuilder.setCloudStorageOptions(options.getCloudStorageOptions().toBuilder().setProjectId("projectId").setRequesterPaysOptions(RequesterPaysOptions.DEFAULT).build());
        optionsBuilder.setCloudStorageOptions(options.getCloudStorageOptions().toBuilder().setAppName(null).build());
        Assert.assertThrows(IllegalArgumentException.class, () -> new GoogleCloudStorageFileSystem((Credential)cred, optionsBuilder.build()));
        optionsBuilder.setCloudStorageOptions(options.getCloudStorageOptions().toBuilder().setAppName("").build());
        Assert.assertThrows(IllegalArgumentException.class, () -> new GoogleCloudStorageFileSystem((Credential)cred, optionsBuilder.build()));
        optionsBuilder.setCloudStorageOptions(options.getCloudStorageOptions().toBuilder().setAppName("appName").build());
        new GoogleCloudStorageFileSystem((Credential)null, optionsBuilder.build());
        GoogleCloudStorageFileSystemTest.setDefaultValidOptions(optionsBuilder);
        GoogleCloudStorageFileSystem tmpGcsFs = new GoogleCloudStorageFileSystem((Credential)cred, optionsBuilder.build());
        Truth.assertThat((Object)tmpGcsFs.getGcs()).isInstanceOf(GoogleCloudStorageImpl.class);
        Truth.assertThat((Object)gcsfs.getOptions().getCloudStorageOptions().getRequesterPaysOptions()).isEqualTo((Object)RequesterPaysOptions.DEFAULT);
    }

    @Test
    public void testPathComparator() throws URISyntaxException {
        String[] paths = new String[]{"gs://aa", "gs://abcdefghij", "gs://aaa", "gs:/", "gs://aa/f", "gs://aaa/f", "gs://aa/bb/f", "gs://ab", "gs://aa/bb/", "gs://aa"};
        String[] expectedAfterSort = new String[]{"gs:/", "gs://aa", "gs://aa", "gs://ab", "gs://aaa", "gs://aa/f", "gs://aaa/f", "gs://aa/bb/", "gs://aa/bb/f", "gs://abcdefghij"};
        ArrayList<URI> pathUris = new ArrayList<URI>();
        ArrayList<URI> expectedUris = new ArrayList<URI>();
        for (String path : paths) {
            pathUris.add(new URI(path));
        }
        for (String path : expectedAfterSort) {
            expectedUris.add(new URI(path));
        }
        ArrayList pathUrisNaturalSorted = new ArrayList(pathUris);
        Collections.sort(pathUrisNaturalSorted);
        ArrayList expectedUrisNaturalSorted = new ArrayList(expectedUris);
        Collections.sort(expectedUrisNaturalSorted);
        Truth.assertThat((Object[])pathUrisNaturalSorted.toArray()).isEqualTo((Object)expectedUrisNaturalSorted.toArray());
        Collections.sort(pathUris, GoogleCloudStorageFileSystem.PATH_COMPARATOR);
        Truth.assertThat((Object[])pathUris.toArray()).isEqualTo((Object)expectedUris.toArray());
    }

    @Test
    public void testInvalidPath() throws IOException, URISyntaxException {
        String[] validPaths;
        String[] invalidPaths;
        for (String invalidPath : invalidPaths = new String[]{"foo://bucket/object", "gs://bucket/", "gs://bucket", "gs://bucket//obj", "gs://bucket/obj//foo/bar"}) {
            Assert.assertThrows(IllegalArgumentException.class, () -> StorageResourceId.fromUriPath((URI)new URI(invalidPath), (boolean)false));
        }
        for (String validPath : validPaths = new String[]{"gs:/", "gs://bucket/obj", "gs://bucket/obj/", "gs://bucket/obj/bar"}) {
            StorageResourceId.fromUriPath((URI)new URI(validPath), (boolean)false);
        }
        String invalidBucketName = "bucket-name-has-invalid-char^";
        Assert.assertThrows(IllegalArgumentException.class, () -> UriPaths.fromStringPathComponents((String)invalidBucketName, null, (boolean)true));
    }

    @Test
    public void testGetItemName() throws URISyntaxException {
        String[] inputPaths = new String[]{"gs:/", "gs://my-bucket", "gs://my-bucket/", "gs://my-bucket/foo", "gs://my-bucket/foo/", "gs://my-bucket/foo/bar", "gs://my-bucket/foo/bar/"};
        String[] expectedNames = new String[]{null, "my-bucket", "my-bucket", "foo", "foo/", "bar", "bar/"};
        ArrayList<String> actualNames = new ArrayList<String>();
        for (String inputPath : inputPaths) {
            actualNames.add(gcsfs.getItemName(new URI(inputPath)));
        }
        Truth.assertThat((Object[])actualNames.toArray(new String[0])).isEqualTo((Object)expectedNames);
    }

    @Test
    public void testGetParentPathEdgeCases() throws URISyntaxException {
        URI[] inputPaths = new URI[]{new URI("gs:/"), new URI("gs://my-bucket"), new URI("gs://my-bucket/"), new URI("gs://my-bucket/foo"), new URI("gs://my-bucket/foo/"), new URI("gs://my-bucket/foo/bar"), new URI("gs://my-bucket/foo/bar/")};
        URI[] expectedPaths = new URI[]{null, new URI("gs:/"), new URI("gs:/"), new URI("gs://my-bucket/"), new URI("gs://my-bucket/"), new URI("gs://my-bucket/foo/"), new URI("gs://my-bucket/foo/")};
        ArrayList<URI> actualPaths = new ArrayList<URI>();
        for (URI inputPath : inputPaths) {
            actualPaths.add(UriPaths.getParentPath((URI)inputPath));
        }
        Truth.assertThat((Object[])actualPaths.toArray(new URI[0])).isEqualTo((Object)expectedPaths);
    }

    @Test
    public void testValidateBucketName() {
        String[] validBucketNames;
        String[] invalidBucketNames;
        for (String bucketName : invalidBucketNames = new String[]{null, "", "foo/bar", "/bar"}) {
            Assert.assertThrows(IllegalArgumentException.class, () -> StringPaths.validateBucketName((String)bucketName));
        }
        for (String bucketName : validBucketNames = new String[]{"foo", "foo/"}) {
            StringPaths.validateBucketName((String)bucketName);
        }
    }

    @Test
    public void testValidateObjectName() {
        String[] validObjectNames;
        String[] invalidObjectNames;
        for (String objectName : invalidObjectNames = new String[]{null, "", "//", "///", "foo//bar", "foo/bar//", "//foo/bar", "foo////bar", "/"}) {
            Assert.assertThrows(IllegalArgumentException.class, () -> StringPaths.validateObjectName((String)objectName, (boolean)false));
        }
        StringPaths.validateObjectName(null, (boolean)true);
        StringPaths.validateObjectName((String)"", (boolean)true);
        for (String objectName : validObjectNames = new String[]{"foo", "foo/bar", "foo/bar/"}) {
            StringPaths.validateObjectName((String)objectName, (boolean)false);
        }
    }

    @Test
    public void testFileInfo() throws IOException {
        Truth.assertThat((Comparable)gcsfs.getFileInfo(GoogleCloudStorageFileSystem.GCS_ROOT).getPath()).isEqualTo((Object)GoogleCloudStorageFileSystem.GCS_ROOT);
        Truth.assertThat((Object)gcsfs.getFileInfo(GoogleCloudStorageFileSystem.GCS_ROOT).getItemInfo()).isEqualTo((Object)GoogleCloudStorageItemInfo.ROOT_INFO);
    }

    @Test
    public void testMiscCreateAndOpen() throws URISyntaxException, IOException {
        URI dirPath = new URI("gs://foo/bar/");
        Assert.assertThrows(IOException.class, () -> gcsfs.create(dirPath));
        Assert.assertThrows(IllegalArgumentException.class, () -> gcsfs.open(dirPath));
    }

    @Test
    public void testCreateNoParentDirectories() throws URISyntaxException, IOException {
        String bucketName = sharedBucketName1;
        String testDir = "no/parent/dirs";
        gcsfs.create(new URI(String.format("gs://%s/%s/exist/a.txt", bucketName, testDir))).close();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        Truth.assertThat((Boolean)gcs.getItemInfo(new StorageResourceId(bucketName, testDir + "/exist/a.txt")).exists()).isTrue();
        Truth.assertThat((Boolean)gcs.getItemInfo(new StorageResourceId(bucketName, testDir + "/exist/")).exists()).isFalse();
        Truth.assertThat((Boolean)gcs.getItemInfo(new StorageResourceId(bucketName, testDir)).exists()).isFalse();
    }

    @Test
    public void testCreateAllowConflictWithExistingDirectory() throws URISyntaxException, IOException {
        String bucketName = sharedBucketName1;
        gcsfs.mkdirs(new URI("gs://" + bucketName + "/conflicting-dirname"));
        gcsfs.create(new URI("gs://" + bucketName + "/conflicting-dirname"), CreateFileOptions.builder().setEnsureNoDirectoryConflict(false).build()).close();
        Truth.assertThat((Boolean)gcsfs.getGcs().getItemInfo(new StorageResourceId(bucketName, "conflicting-dirname")).exists()).isTrue();
        Truth.assertThat((Boolean)gcsfs.getGcs().getItemInfo(new StorageResourceId(bucketName, "conflicting-dirname/")).exists()).isTrue();
    }

    @Override
    public void read_failure_ifObjectWasModifiedDuringRead() {
    }
}

