/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageGrpcReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.GrpcChannelUtils;
import com.google.cloud.hadoop.gcsio.MetricsRecorder;
import com.google.cloud.hadoop.gcsio.NoOpMetricsRecorder;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.gcsio.Watchdog;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.protobuf.ByteString;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StorageGrpc;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Channel;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannelBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.inprocess.InProcessChannelBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.inprocess.InProcessServerBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.AbstractStub;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.beam.io.pubsub.io.grpc.testing.GrpcCleanupRule;
import cz.o2.proxima.internal.shaded.com.google.common.hash.Hashing;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public final class GoogleCloudStorageGrpcReadChannelTest {
    private static final String V1_BUCKET_NAME = "bucket-name";
    private static final String BUCKET_NAME = GrpcChannelUtils.toV2BucketName((String)"bucket-name");
    private static final String OBJECT_NAME = "object-name";
    private static final long OBJECT_GENERATION = 7L;
    private static final int OBJECT_SIZE = 0x20000A;
    private static final int DEFAULT_OBJECT_CRC32C = 185327488;
    private static final com.google.storage.v2.Object DEFAULT_OBJECT = com.google.storage.v2.Object.newBuilder().setBucket("bucket-name").setName("object-name").setSize(0x20000AL).setChecksums(ObjectChecksums.newBuilder().setCrc32C(185327488).build()).setGeneration(7L).build();
    private static final ReadObjectRequest GET_OBJECT_MEDIA_REQUEST = ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject("object-name").setGeneration(7L).build();
    @Rule
    public final GrpcCleanupRule grpcCleanup = new GrpcCleanupRule();
    private StorageGrpc.StorageBlockingStub stub;
    private FakeService fakeService;
    @Mock
    private Credentials mockCredentials;
    private Storage storage;
    private ApiErrorExtractor errorExtractor;
    private Storage.Objects.Get get;
    private StorageObject storageObject;
    private static final Watchdog watchdog = Watchdog.create((Duration)Duration.ofMillis(100L));

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.fakeService = (FakeService)((Object)Mockito.spy((Object)((Object)new FakeService())));
        String serverName = InProcessServerBuilder.generateName();
        this.grpcCleanup.register(((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)this.fakeService)).build().start());
        this.stub = StorageGrpc.newBlockingStub((Channel)this.grpcCleanup.register(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build()));
        this.storage = (Storage)Mockito.mock(Storage.class);
        this.get = (Storage.Objects.Get)Mockito.mock(Storage.Objects.Get.class);
        Storage.Objects objects = (Storage.Objects)Mockito.mock(Storage.Objects.class);
        Mockito.when((Object)this.storage.objects()).thenReturn((Object)objects);
        Mockito.when((Object)objects.get(V1_BUCKET_NAME, OBJECT_NAME)).thenReturn((Object)this.get);
        this.storageObject = new StorageObject();
        this.storageObject.setBucket(V1_BUCKET_NAME);
        this.storageObject.setGeneration(Long.valueOf(7L));
        this.storageObject.setSize(BigInteger.valueOf(0x20000AL));
        Mockito.when((Object)this.get.setFields((String)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)this.get.execute()).thenReturn((Object)this.storageObject);
        this.errorExtractor = ApiErrorExtractor.INSTANCE;
    }

    @Test
    public void readSingleChunkSucceeds() throws Exception {
        int objectSize = 2048;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(4).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)(objectSize - 2)).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)(objectSize - 2)).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void readMultipleChunksSucceeds() throws Exception {
        int objectSize = 4096;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(4).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(objectSize);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setGeneration(7L).setObject(OBJECT_NAME).setReadOffset((long)(objectSize - 2)).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)(objectSize - 2)).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, objectSize).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void readAfterRepositioningAfterSkippingSucceeds() throws Exception {
        int objectSize = 0x1400000;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer bufferAtBeginning = ByteBuffer.allocate(20);
        readChannel.read(bufferAtBeginning);
        readChannel.position(25L);
        ByteBuffer bufferFromSkippedSection1 = ByteBuffer.allocate(5);
        readChannel.read(bufferFromSkippedSection1);
        readChannel.position(35L);
        ByteBuffer bufferFromSkippedSection2 = ByteBuffer.allocate(10);
        readChannel.read(bufferFromSkippedSection2);
        ByteBuffer bufferFromReposition = ByteBuffer.allocate(10);
        readChannel.position(1L);
        readChannel.read(bufferFromReposition);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 20).toByteArray(), (byte[])bufferAtBeginning.array());
        int footerOffset = objectSize - 0x100000;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset(1L).setReadLimit((long)(objectSize - 0x100000 - 1)).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(25, 30).toByteArray(), (byte[])bufferFromSkippedSection1.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(35, 45).toByteArray(), (byte[])bufferFromSkippedSection2.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(1, 11).toByteArray(), (byte[])bufferFromReposition.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void multipleSequentialReads() throws Exception {
        int objectSize = 0x1400000;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer first_buffer = ByteBuffer.allocate(10);
        ByteBuffer second_buffer = ByteBuffer.allocate(20);
        readChannel.read(first_buffer);
        readChannel.read(second_buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 10).toByteArray(), (byte[])first_buffer.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 30).toByteArray(), (byte[])second_buffer.array());
        int footerOffset = objectSize - 0x100000;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void randomReadRequestsExactBytes() throws Exception {
        int objectSize = 0x1400000;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.position(10L);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ReadObjectRequest expectedRequest = ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(10L).build();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)expectedRequest), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 60).toByteArray(), (byte[])buffer.array());
        int footerOffset = objectSize - 0x100000;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void repeatedRandomReadsWorkAsExpected() throws Exception {
        int objectSize = 0x1400000;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.position(10L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 60).toByteArray(), (byte[])buffer.array());
        buffer = ByteBuffer.allocate(25);
        readChannel.position(20L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(20, 45).toByteArray(), (byte[])buffer.array());
        ReadObjectRequest firstExpectedRequest = ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(10L).build();
        ReadObjectRequest secondExpectedRequest = ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(20L).build();
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = objectSize - 0x100000;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)firstExpectedRequest), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)secondExpectedRequest), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void randomReadRequestsExpectedBytes() throws Exception {
        int objectSize = 0x1400000;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.position(10L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 60).toByteArray(), (byte[])buffer.array());
        buffer = ByteBuffer.allocate(0x200001);
        readChannel.position(0L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 0x200001).toByteArray(), (byte[])buffer.array());
        ReadObjectRequest firstExpectedRequest = ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(10L).build();
        ReadObjectRequest secondExpectedRequest = ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200001L).setReadOffset(0L).build();
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = objectSize - 0x100000;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)firstExpectedRequest), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)secondExpectedRequest), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void readToBufferWithArrayOffset() throws Exception {
        int objectSize = 100;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(4).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        byte[] array = new byte[200];
        ByteBuffer buffer = ByteBuffer.wrap(array, 50, 150).slice();
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        byte[] expected = ByteString.copyFrom((byte[])array, (int)50, (int)objectSize).toByteArray();
        int footerOffset = 98;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, objectSize).toByteArray(), (byte[])expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void readSucceedsAfterSeek() throws Exception {
        int objectSize = 100;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(4).setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        readChannel.position(50L);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST.toBuilder().setReadOffset(50L).setReadLimit(48L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset(98L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(50, 60).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void singleReadSucceedsWithValidObjectChecksum() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setChecksums(ObjectChecksums.newBuilder().setCrc32C(185327488)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(0x20000A);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void partialReadSucceedsWithInvalidObjectChecksum() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setChecksums(ObjectChecksums.newBuilder().setCrc32C(185327488)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(0x200000);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 0x200000).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void multipleSequentialReadsSucceedWithValidObjectChecksum() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setChecksums(ObjectChecksums.newBuilder().setCrc32C(185327488)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer firstBuffer = ByteBuffer.allocate(100);
        ByteBuffer secondBuffer = ByteBuffer.allocate(2097062);
        readChannel.read(firstBuffer);
        readChannel.read(secondBuffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])firstBuffer.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(100).toByteArray(), (byte[])secondBuffer.array());
    }

    @Test
    public void readFailsWithInvalidMessageChecksum() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        this.fakeService.setReturnIncorrectMessageChecksum();
        ByteBuffer buffer = ByteBuffer.allocate(10);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"checksum");
    }

    @Test
    public void readToBufferWithArrayOffsetSucceeds() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        byte[] array = new byte[2097262];
        ByteBuffer buffer = ByteBuffer.wrap(array, 50, 0x20000A).slice();
        readChannel.read(buffer);
        byte[] expected = ByteString.copyFrom((byte[])array, (int)50, (int)0x20000A).toByteArray();
        Assert.assertArrayEquals((byte[])this.fakeService.data.toByteArray(), (byte[])expected);
    }

    @Test
    public void readToBufferWithArrayOffsetFailsWithInvalidMessageChecksum() throws Exception {
        this.fakeService.setReturnIncorrectMessageChecksum();
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(options));
        Assert.assertTrue((String)(thrown.getMessage() + " should have contained 'checksum'"), (boolean)thrown.getMessage().contains("checksum"));
    }

    @Test
    public void multipleReadsIgnoreObjectChecksumForLatestGenerationReads() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setChecksums(ObjectChecksums.newBuilder().setCrc32C(185327488)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer firstBuffer = ByteBuffer.allocate(100);
        ByteBuffer secondBuffer = ByteBuffer.allocate(2097062);
        readChannel.read(firstBuffer);
        readChannel.read(secondBuffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])firstBuffer.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(100).toByteArray(), (byte[])secondBuffer.array());
    }

    @Test
    public void testOpenReadsMetadata() throws IOException {
        int objectSize = 8192;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().build();
        StorageResourceId storageResourceId = new StorageResourceId(V1_BUCKET_NAME, OBJECT_NAME, 7L);
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(storageResourceId, options);
        Assert.assertTrue((boolean)readChannel.isOpen());
        Assert.assertEquals((long)objectSize, (long)readChannel.size());
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
    }

    @Test
    public void testOpenThrowsIOExceptionOnGetError() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.SERVER_ERROR)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(storage, options));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"backendError");
    }

    @Test
    public void readHandlesGetMediaError() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        this.fakeService.setReadObjectException((Throwable)Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("Custom error message.").asException());
        ByteBuffer buffer = ByteBuffer.allocate(10);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message.");
    }

    @Test
    public void testOpenThrowsIOExceptionOnGetMediaError() throws IOException {
        this.fakeService.setReadObjectException((Throwable)Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("Custom error message.").asException());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService)))).setReadObjectException((Throwable)Mockito.any());
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, this::newReadChannel);
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message.");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService)))).readObject((ReadObjectRequest)Mockito.any(), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testOpenThrowsIOExceptionOnGetMediaFileNotFound() throws IOException {
        this.fakeService.setReadObjectException((Throwable)Status.fromCode((Status.Code)Status.Code.NOT_FOUND).withDescription("Custom error message.").asException());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService)))).setReadObjectException((Throwable)Mockito.any());
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, this::newReadChannel);
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message.");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService)))).readObject((ReadObjectRequest)Mockito.any(), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testOpenThrowsIOExceptionOnGzipContent() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().build();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(storage, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Cannot read GZIP encoded files - content encoding support is disabled.");
    }

    @Test
    public void retryGetMediaError() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        this.fakeService.setReadObjectException((Throwable)Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("Custom error message.").asException());
        ByteBuffer buffer = ByteBuffer.allocate(10);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message");
    }

    @Test
    public void readFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        ByteBuffer buffer = ByteBuffer.allocate(10);
        Assert.assertThrows(ClosedChannelException.class, () -> readChannel.read(buffer));
    }

    @Test
    public void readWithStrictGenerationReadConsistencySucceeds() throws Exception {
        int objectSize = 100;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).setGeneration(1L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(4).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        readChannel.read(buffer);
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).setGeneration(2L).build());
        readChannel.position(0L);
        buffer.clear();
        readChannel.read(buffer);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(ReadObjectRequest.class);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)3)))).readObject((ReadObjectRequest)requestCaptor.capture(), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void readWithLatestGenerationReadConsistencySucceeds() throws Exception {
        int objectSize = 100;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).setGeneration(1L).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(4).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        readChannel.read(buffer);
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).setGeneration(2L).build());
        readChannel.position(0L);
        buffer.clear();
        readChannel.read(buffer);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(ReadObjectRequest.class);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)3)))).readObject((ReadObjectRequest)requestCaptor.capture(), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void seekUnderInplaceSeekLimitReadsCorrectBufferedData() throws Exception {
        int objectSize = 100;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 10;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.read(buffer);
        readChannel.position(25L);
        buffer.clear();
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset(95L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(95L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(25, 45).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void seekUnderInplaceSeekLimitReadsCorrectDataWithSomeBuffered() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(8192L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.read(buffer);
        readChannel.position(50L);
        buffer.clear();
        buffer = ByteBuffer.allocate(6151);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(50, 6201).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void seekBeyondInplaceSeekLimitReadsNoBufferedData() throws Exception {
        int objectSize = 100;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 10;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setMinRangeRequestSize(minRangeRequestSize).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.read(buffer);
        readChannel.position(35L);
        buffer.clear();
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset(95L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(95L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset(35L).setReadLimit(20L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(35, 55).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadPrefetchedFooter() throws Exception {
        int objectSize = 100;
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 2048;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.position(80L);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset(0L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(80).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadCachedFooter() throws Exception {
        int objectSize = 8192;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 2048;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setInplaceSeekLimit(2048L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = 7168;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        buffer.clear();
        readChannel.position((long)footerOffset);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(footerOffset).toByteArray(), (byte[])buffer.array());
        buffer.clear();
        readChannel.position((long)footerOffset);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(footerOffset).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadCachedFooterPartially() throws Exception {
        int objectSize = 16384;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 4096;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setInplaceSeekLimit(512L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = 14336;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        buffer.clear();
        int readOffset = 13312;
        readChannel.position((long)readOffset);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)readOffset).setReadLimit(1024L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(readOffset, readOffset + 2048).toByteArray(), (byte[])buffer.array());
        buffer.clear();
        readChannel.position((long)footerOffset);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(footerOffset).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadCachedFooterPartiallyWithInplaceSeek() throws Exception {
        int objectSize = 16384;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 4096;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setInplaceSeekLimit(2048L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = 14336;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        buffer.clear();
        int readOffset = 13312;
        readChannel.position((long)readOffset);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)readOffset).setReadLimit(1024L).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(readOffset, readOffset + 2048).toByteArray(), (byte[])buffer.array());
        buffer.clear();
        readChannel.position((long)footerOffset);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(footerOffset).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadWithInplaceSeekAndFadviseRandom() throws Exception {
        int objectSize = 16384;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 4096;
        int inplaceSeekLimit = 6144;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setInplaceSeekLimit((long)inplaceSeekLimit).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = 14336;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)inplaceSeekLimit).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        buffer.clear();
        int readOffset = 7168;
        readChannel.position((long)readOffset);
        int capacity = 4096;
        buffer = ByteBuffer.allocate(capacity);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)readOffset).setReadLimit((long)inplaceSeekLimit).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(readOffset, readOffset + capacity).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadWithInplaceSeekAndFadviseAuto() throws Exception {
        int objectSize = 16384;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 4096;
        int inplaceSeekLimit = 6144;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setInplaceSeekLimit((long)inplaceSeekLimit).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = 14336;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        buffer.clear();
        int readOffset = 7168;
        readChannel.position((long)readOffset);
        int capacity = 4096;
        buffer = ByteBuffer.allocate(capacity);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(readOffset, readOffset + capacity).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void testReadWithInplaceSeekAndFadviseSequential() throws Exception {
        int objectSize = 16384;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).setObject((com.google.storage.v2.Object)Mockito.any());
        int minRangeRequestSize = 4096;
        int inplaceSeekLimit = 6144;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setMinRangeRequestSize(minRangeRequestSize).setFadvise(GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL).setInplaceSeekLimit((long)inplaceSeekLimit).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        readChannel.read(buffer);
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
        int footerOffset = 14336;
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadOffset((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).readObject((ReadObjectRequest)Mockito.eq((Object)ReadObjectRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit((long)footerOffset).build()), (StreamObserver<ReadObjectResponse>)((StreamObserver)Mockito.any()));
        buffer.clear();
        int readOffset = 7168;
        readChannel.position((long)readOffset);
        int capacity = 4096;
        buffer = ByteBuffer.allocate(capacity);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(readOffset, readOffset + capacity).toByteArray(), (byte[])buffer.array());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeService});
    }

    @Test
    public void seekFailsOnNegative() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertThrows(IllegalArgumentException.class, () -> readChannel.position(-1L));
    }

    @Test
    public void seekFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> readChannel.position(2L));
    }

    @Test
    public void positionUpdatesOnRead() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.read(buffer);
        Assert.assertEquals((long)50L, (long)readChannel.position());
    }

    @Test
    public void positionUpdatesOnSeek() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.position(50L);
        Assert.assertEquals((long)50L, (long)readChannel.position());
    }

    @Test
    public void positionFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleCloudStorageGrpcReadChannel)readChannel).position());
    }

    @Test
    public void fastFailOnNotFoundFailsOnCreateWhenEnabled() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(true).build();
        Throwable throwable = Assert.assertThrows(IOException.class, () -> this.newReadChannel(storage, options));
        Truth.assertThat((Throwable)throwable).hasMessageThat().contains((CharSequence)"Item not found");
    }

    @Test
    public void fastFailOnNotFoundFailsByReadWhenDisabled() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(storage, options));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Item not found");
    }

    @Test
    public void fastFailOnNotFoundFailsByReadWhenDisabledItemInfo() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        StorageResourceId resourceId = StorageResourceId.fromStringPath((String)("gs://" + BUCKET_NAME + "/" + OBJECT_NAME));
        GoogleCloudStorageItemInfo itemInfo = GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)resourceId);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(itemInfo, options));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"File not found");
    }

    @Test
    public void sizeReturnsObjectSize() throws Exception {
        int objectSize = 1234;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertEquals((long)1234L, (long)readChannel.size());
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
    }

    @Test
    public void sizeFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleCloudStorageGrpcReadChannel)readChannel).size());
    }

    @Test
    public void sizeIsCached() throws Exception {
        int objectSize = 1234;
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize((long)objectSize).build());
        this.storageObject.setSize(BigInteger.valueOf(objectSize));
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertEquals((long)1234L, (long)readChannel.size());
        Assert.assertEquals((long)1234L, (long)readChannel.size());
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).setFields("contentEncoding,generation,size");
        ((Storage.Objects.Get)Mockito.verify((Object)this.get)).execute();
    }

    @Test
    public void isOpenReturnsTrueOnCreate() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertTrue((boolean)readChannel.isOpen());
    }

    @Test
    public void isOpenReturnsFalseAfterClose() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertFalse((boolean)readChannel.isOpen());
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel() throws IOException {
        return this.newReadChannel(GoogleCloudStorageReadOptions.DEFAULT);
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel(Storage storage, GoogleCloudStorageReadOptions options) throws IOException {
        return new GoogleCloudStorageGrpcReadChannel((StorageStubProvider)new FakeStubProvider(this.mockCredentials), storage, new StorageResourceId(BUCKET_NAME, OBJECT_NAME), watchdog, (MetricsRecorder)new NoOpMetricsRecorder(), options, () -> BackOff.STOP_BACKOFF);
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel(GoogleCloudStorageReadOptions options) throws IOException {
        return new GoogleCloudStorageGrpcReadChannel((StorageStubProvider)new FakeStubProvider(this.mockCredentials), this.storage, new StorageResourceId(V1_BUCKET_NAME, OBJECT_NAME), watchdog, (MetricsRecorder)new NoOpMetricsRecorder(), options, () -> BackOff.STOP_BACKOFF);
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel(StorageResourceId storageResourceId, GoogleCloudStorageReadOptions options) throws IOException {
        return new GoogleCloudStorageGrpcReadChannel((StorageStubProvider)new FakeStubProvider(this.mockCredentials), this.storage, storageResourceId, watchdog, (MetricsRecorder)new NoOpMetricsRecorder(), options, () -> BackOff.STOP_BACKOFF);
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel(GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions options) throws IOException {
        return new GoogleCloudStorageGrpcReadChannel((StorageStubProvider)new FakeStubProvider(this.mockCredentials), itemInfo, watchdog, (MetricsRecorder)new NoOpMetricsRecorder(), options, () -> BackOff.STOP_BACKOFF);
    }

    private static class FakeService
    extends StorageGrpc.StorageImplBase {
        private static final int CHUNK_SIZE = 2048;
        ByteString data;
        private com.google.storage.v2.Object object;
        private Throwable readObjectException;
        private boolean alterMessageChecksum = false;

        public FakeService() {
            this.setObject(DEFAULT_OBJECT);
        }

        private static ByteString createTestData(int numBytes) {
            byte[] result = new byte[numBytes];
            for (int i = 0; i < numBytes; ++i) {
                result[i] = (byte)i;
            }
            return ByteString.copyFrom((byte[])result);
        }

        public void readObject(ReadObjectRequest request, StreamObserver<ReadObjectResponse> responseObserver) {
            if (this.readObjectException != null) {
                responseObserver.onError(this.readObjectException);
            } else {
                int readStart = (int)request.getReadOffset();
                int readEnd = request.getReadLimit() > 0L ? (int)Math.min(this.object.getSize(), (long)readStart + request.getReadLimit()) : (int)this.object.getSize();
                for (int position = readStart; position < readEnd; position += 2048) {
                    int endIndex = Math.min((int)this.object.getSize(), position + 2048);
                    endIndex = Math.min(endIndex, readEnd);
                    ByteString messageData = this.data.substring(position, endIndex);
                    int crc32c = Hashing.crc32c().hashBytes(messageData.toByteArray()).asInt();
                    if (this.alterMessageChecksum) {
                        ++crc32c;
                    }
                    ReadObjectResponse response = ReadObjectResponse.newBuilder().setChecksummedData(ChecksummedData.newBuilder().setContent(messageData).setCrc32C(crc32c)).build();
                    responseObserver.onNext((Object)response);
                }
                responseObserver.onCompleted();
            }
        }

        public void setObject(com.google.storage.v2.Object object) {
            this.object = object;
            this.data = FakeService.createTestData((int)object.getSize());
        }

        void setReadObjectException(Throwable t) {
            this.readObjectException = t;
        }

        void setReturnIncorrectMessageChecksum() {
            this.alterMessageChecksum = true;
        }
    }

    private class FakeStubProvider
    extends StorageStubProvider {
        FakeStubProvider(Credentials credentials) {
            super(GoogleCloudStorageOptions.DEFAULT, null, (StorageStubProvider.GrpcDecorator)new FakeGrpcDecorator());
        }

        public StorageGrpc.StorageBlockingStub newBlockingStub() {
            return GoogleCloudStorageGrpcReadChannelTest.this.stub;
        }
    }

    private static class FakeGrpcDecorator
    implements StorageStubProvider.GrpcDecorator {
        private FakeGrpcDecorator() {
        }

        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return null;
        }

        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return null;
        }
    }
}

