/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.BackOff;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageGrpcWriteChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GrpcChannelUtils;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.gcsio.Watchdog;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageGrpc;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.WriteObjectSpec;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Channel;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannelBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.inprocess.InProcessChannelBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.inprocess.InProcessServerBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.AbstractStub;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public final class GoogleCloudStorageGrpcWriteChannelTest {
    private static final int GCS_MINIMUM_CHUNK_SIZE = 262144;
    private static final String V1_BUCKET_NAME = "bucket-name";
    private static final String BUCKET_NAME = GrpcChannelUtils.toV2BucketName((String)"bucket-name");
    private static final String OBJECT_NAME = "object-name";
    private static final String UPLOAD_ID = "upload-id";
    private static final String CONTENT_TYPE = "image/jpeg";
    private static final StartResumableWriteRequest START_REQUEST = StartResumableWriteRequest.newBuilder().setWriteObjectSpec(WriteObjectSpec.newBuilder().setResource(com.google.storage.v2.Object.newBuilder().setBucket(BUCKET_NAME).setName("object-name").setContentType("image/jpeg"))).build();
    private static final QueryWriteStatusRequest WRITE_STATUS_REQUEST = QueryWriteStatusRequest.newBuilder().setUploadId("upload-id").build();
    private static final Watchdog watchdog = Watchdog.create((Duration)Duration.ofMillis(100L));
    private StorageGrpc.StorageStub stub;
    private FakeService fakeService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Mock
    private Credentials mockCredentials;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.fakeService = (FakeService)((Object)Mockito.spy((Object)((Object)new FakeService())));
        String serverName = InProcessServerBuilder.generateName();
        ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)this.fakeService)).build().start();
        this.stub = StorageGrpc.newStub((Channel)((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build());
    }

    @Test
    public void writeSendsSingleInsertObjectRequestWithChecksums() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().setGrpcChecksumsEnabled(true).build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(0L).build(), (Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(0L).build()).iterator());
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        WriteObjectRequest expectedInsertRequest = WriteObjectRequest.newBuilder().setUploadId(UPLOAD_ID).setChecksummedData(ChecksummedData.newBuilder().setContent(data).setCrc32C(this.uInt32Value(863614154L))).setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(this.uInt32Value(863614154L))).setFinishWrite(true).build();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)START_REQUEST), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.times((int)1))).onNext(expectedInsertRequest);
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onCompleted();
    }

    @Test
    public void writeSendsSingleInsertObjectRequestWithoutChecksums() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().setGrpcChecksumsEnabled(false).build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        WriteObjectRequest expectedInsertRequest = WriteObjectRequest.newBuilder().setUploadId(UPLOAD_ID).setChecksummedData(ChecksummedData.newBuilder().setContent(data)).setFinishWrite(true).build();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)START_REQUEST), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.times((int)1))).onNext(expectedInsertRequest);
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onCompleted();
    }

    @Test
    public void writeSendsMultipleInsertObjectRequests() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(262144L).build(), (Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(524288L).build()).iterator());
        ByteString data = this.createTestData(655360);
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(WriteObjectRequest.class);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)START_REQUEST), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.times((int)1))).onNext((WriteObjectRequest)requestCaptor.capture());
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onCompleted();
    }

    @Test
    public void writeSendsMultipleInsertObjectRequestsWithChecksums() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().setGrpcChecksumsEnabled(true).build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(262144L).build(), (Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(524288L).build()).iterator());
        ByteString data = this.createTestData(655360);
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(WriteObjectRequest.class);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)START_REQUEST), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.times((int)1))).onNext((WriteObjectRequest)requestCaptor.capture());
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onCompleted();
    }

    @Test
    public void writeHandlesUncommittedData() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(196608L).build()).iterator());
        ByteString data = this.createTestData(393216);
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(WriteObjectRequest.class);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)START_REQUEST), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.times((int)1))).onNext((WriteObjectRequest)requestCaptor.capture());
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onCompleted();
    }

    @Test
    public void writeUsesContentGenerationIfProvided() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.builder().setContentGenerationMatch(Long.valueOf(1L)).build();
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        StartResumableWriteRequest.Builder expectedRequestBuilder = START_REQUEST.toBuilder();
        expectedRequestBuilder.getWriteObjectSpecBuilder().setIfGenerationMatch(1L);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)expectedRequestBuilder.build()), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void writeUsesMetaGenerationIfProvided() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.builder().setMetaGenerationMatch(Long.valueOf(1L)).build();
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        StartResumableWriteRequest.Builder expectedRequestBuilder = START_REQUEST.toBuilder();
        expectedRequestBuilder.getWriteObjectSpecBuilder().setIfMetagenerationMatch(1L);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)expectedRequestBuilder.build()), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void writeUsesRequesterPaysProjectIfProvided() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, "project-id");
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        StartResumableWriteRequest.Builder expectedRequestBuilder = START_REQUEST.toBuilder();
        expectedRequestBuilder.getCommonRequestParamsBuilder().setUserProject("project-id");
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)expectedRequestBuilder.build()), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void writeHandlesErrorOnStartRequest() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setStartRequestException(new IOException("Error!"));
        writeChannel.initialize();
        writeChannel.write(ByteBuffer.wrap("test data".getBytes()));
        Assert.assertThrows(IOException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void writeHandlesErrorOnInsertRequest() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setInsertRequestException(new IOException("Error!"));
        writeChannel.initialize();
        writeChannel.write(ByteBuffer.wrap("test data".getBytes()));
        Assert.assertThrows(IOException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void writeHandlesErrorOnQueryWriteStatusRequest() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setQueryWriteStatusException(new IOException("Test error!"));
        ByteString data = this.createTestData(524288);
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
    }

    @Test
    public void writeHandlesErrorOnInsertRequestWithUncommittedData() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setInsertRequestException(new IOException("Error!"));
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(196608L).build()).iterator());
        ByteString data = this.createTestData(393216);
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        Assert.assertThrows(IOException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void writeHandlesErrorOnInsertRequestWithoutUncommittedData() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setInsertRequestException(new IOException("Error!"));
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(262144L).build()).iterator());
        ByteString data = this.createTestData(262144);
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        Assert.assertThrows(IOException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void writeHandlesErrorOnStartRequestFailure() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        this.fakeService.setStartRequestException(new IOException("Error"));
        ByteString data = this.createTestData(0x200000);
        writeChannel.initialize();
        Assert.assertThrows(IOException.class, () -> writeChannel.write(data.asReadOnlyByteBuffer()));
    }

    @Test
    public void writeOneChunkWithSingleErrorAndResume() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().setUploadChunkSize(262144).build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null, () -> BackOff.ZERO_BACKOFF);
        this.fakeService.setInsertObjectExceptions((List<Throwable>)ImmutableList.of((Object)new StatusException(Status.DEADLINE_EXCEEDED)));
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(1L).build()).iterator());
        ByteString chunk = this.createTestData(262144);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(WriteObjectRequest.class);
        writeChannel.initialize();
        writeChannel.write(chunk.asReadOnlyByteBuffer());
        writeChannel.close();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).startResumableWrite((StartResumableWriteRequest)Mockito.eq((Object)START_REQUEST), (StreamObserver<StartResumableWriteResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).queryWriteStatus((QueryWriteStatusRequest)Mockito.eq((Object)WRITE_STATUS_REQUEST), (StreamObserver<QueryWriteStatusResponse>)((StreamObserver)Mockito.any()));
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onNext((WriteObjectRequest)requestCaptor.capture());
        ((FakeService.InsertRequestObserver)Mockito.verify((Object)this.fakeService.insertRequestObserver, (VerificationMode)Mockito.atLeast((int)1))).onCompleted();
    }

    @Test
    public void writeOneChunkWithSingleErrorFailedToResume() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().setUploadChunkSize(262144).build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        this.fakeService.setInsertObjectExceptions((List<Throwable>)ImmutableList.of((Object)new StatusException(Status.DEADLINE_EXCEEDED)));
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(-1L).build()).iterator());
        ByteString chunk = this.createTestData(262144);
        writeChannel.initialize();
        writeChannel.write(chunk.asReadOnlyByteBuffer());
        Assert.assertThrows(IOException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void retryInsertOnIOException() throws Exception {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().setUploadChunkSize(262144).build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel(options, writeConditions, null);
        this.fakeService.setInsertObjectExceptions((List<Throwable>)ImmutableList.of((Object)new StatusException(Status.DEADLINE_EXCEEDED), (Object)new StatusException(Status.DEADLINE_EXCEEDED), (Object)new StatusException(Status.DEADLINE_EXCEEDED), (Object)new StatusException(Status.DEADLINE_EXCEEDED), (Object)new StatusException(Status.DEADLINE_EXCEEDED)));
        this.fakeService.setQueryWriteStatusResponses((Iterator<QueryWriteStatusResponse>)ImmutableList.of((Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(1L).build(), (Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(1L).build(), (Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(1L).build(), (Object)QueryWriteStatusResponse.newBuilder().setPersistedSize(1L).build()).iterator());
        ByteString chunk = this.createTestData(262144);
        writeChannel.initialize();
        writeChannel.write(chunk.asReadOnlyByteBuffer());
        Assert.assertThrows(IOException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void writeFailsBeforeInitialize() {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        Assert.assertThrows(IllegalStateException.class, () -> writeChannel.write(ByteBuffer.wrap("test data".getBytes())));
    }

    @Test
    public void writeFailsAfterClose() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        writeChannel.initialize();
        writeChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> writeChannel.write(ByteBuffer.wrap("test data".getBytes())));
    }

    @Test
    public void closeFailsBeforeInitilize() {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        Assert.assertThrows(IllegalStateException.class, () -> ((GoogleCloudStorageGrpcWriteChannel)writeChannel).close());
    }

    @Test
    public void getItemInfoReturnsCorrectItemInfo() throws Exception {
        byte[] expectedMd5Hash = new byte[]{-109, 66, -75, 122, -93, -111, 86, -26, 54, -45, -55, -64, 0, 58, 115, -21};
        byte[] expectedCrc32C = new byte[]{51, 121, -76, -54};
        this.fakeService.setObject(FakeService.DEFAULT_OBJECT.toBuilder().setSize(9L).setGeneration(1L).setMetageneration(2L).setCreateTime(Timestamp.newBuilder().setSeconds(1560485630L).setNanos(7000000)).setUpdateTime(Timestamp.newBuilder().setSeconds(1560495630L).setNanos(123000000)).setContentType(CONTENT_TYPE).setContentEncoding("content-encoding").putMetadata("metadata-key-1", "dGVzdC1tZXRhZGF0YQ==").setChecksums(ObjectChecksums.newBuilder().setMd5Hash(ByteString.copyFrom((byte[])expectedMd5Hash)).setCrc32C(this.uInt32Value(863614154L)).build()).build());
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        writeChannel.close();
        GoogleCloudStorageItemInfo itemInfo = writeChannel.getItemInfo();
        ImmutableMap expectedMetadata = ImmutableMap.of((Object)"metadata-key-1", (Object)new byte[]{116, 101, 115, 116, 45, 109, 101, 116, 97, 100, 97, 116, 97});
        GoogleCloudStorageItemInfo expectedItemInfo = GoogleCloudStorageItemInfo.createObject((StorageResourceId)new StorageResourceId(V1_BUCKET_NAME, OBJECT_NAME), (long)1560485630007L, (long)1560495630123L, (long)9L, (String)CONTENT_TYPE, (String)"content-encoding", (Map)expectedMetadata, (long)1L, (long)2L, (VerificationAttributes)new VerificationAttributes(expectedMd5Hash, expectedCrc32C));
        Truth.assertThat((Object)itemInfo).isEqualTo((Object)expectedItemInfo);
    }

    @Test
    public void getItemInfoReturnsNullBeforeClose() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        ByteString data = ByteString.copyFromUtf8((String)"test data");
        writeChannel.initialize();
        writeChannel.write(data.asReadOnlyByteBuffer());
        Assert.assertNull((Object)writeChannel.getItemInfo());
    }

    @Test
    public void isOpenReturnsFalseBeforeInitialize() {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        Assert.assertFalse((boolean)writeChannel.isOpen());
    }

    @Test
    public void isOpenReturnsTrueAfterInitialize() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        writeChannel.initialize();
        Assert.assertTrue((boolean)writeChannel.isOpen());
    }

    @Test
    public void isOpenReturnsFalseAfterClose() throws Exception {
        GoogleCloudStorageGrpcWriteChannel writeChannel = this.newWriteChannel();
        writeChannel.initialize();
        writeChannel.close();
        Assert.assertFalse((boolean)writeChannel.isOpen());
    }

    private GoogleCloudStorageGrpcWriteChannel newWriteChannel(AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, String requesterPaysProject) {
        return this.newWriteChannel(options, writeConditions, requesterPaysProject, () -> BackOff.STOP_BACKOFF);
    }

    private GoogleCloudStorageGrpcWriteChannel newWriteChannel(AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, String requesterPaysProject, GoogleCloudStorageImpl.BackOffFactory backOffFactory) {
        return new GoogleCloudStorageGrpcWriteChannel((StorageStubProvider)new FakeStubProvider(this.mockCredentials), this.executor, options, new StorageResourceId(V1_BUCKET_NAME, OBJECT_NAME), CreateObjectOptions.DEFAULT_NO_OVERWRITE.toBuilder().setContentType(CONTENT_TYPE).build(), watchdog, writeConditions, requesterPaysProject, backOffFactory);
    }

    private GoogleCloudStorageGrpcWriteChannel newWriteChannel() {
        AsyncWriteChannelOptions options = AsyncWriteChannelOptions.builder().build();
        ObjectWriteConditions writeConditions = ObjectWriteConditions.NONE;
        return this.newWriteChannel(options, writeConditions, null);
    }

    private int uInt32Value(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(0, (int)value);
        return buffer.getInt();
    }

    private ByteString createTestData(int numBytes) {
        byte[] result = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            result[i] = (byte)(i % 257);
        }
        return ByteString.copyFrom((byte[])result);
    }

    static /* synthetic */ String access$300() {
        return BUCKET_NAME;
    }

    private static class FakeService
    extends StorageGrpc.StorageImplBase {
        static final com.google.storage.v2.Object DEFAULT_OBJECT = com.google.storage.v2.Object.newBuilder().setBucket(GoogleCloudStorageGrpcWriteChannelTest.access$300()).setName("object-name").setGeneration(1L).setMetageneration(2L).build();
        InsertRequestObserver insertRequestObserver = (InsertRequestObserver)Mockito.spy((Object)new InsertRequestObserver());
        private Throwable startRequestException;
        private List<Throwable> insertObjectExceptions;
        private Throwable queryWriteStatusException;
        private Iterator<QueryWriteStatusResponse> queryWriteStatusResponses;

        private FakeService() {
        }

        public void startResumableWrite(StartResumableWriteRequest request, StreamObserver<StartResumableWriteResponse> responseObserver) {
            if (this.startRequestException != null) {
                responseObserver.onError(this.startRequestException);
            } else {
                StartResumableWriteResponse response = StartResumableWriteResponse.newBuilder().setUploadId(GoogleCloudStorageGrpcWriteChannelTest.UPLOAD_ID).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
            }
        }

        public void queryWriteStatus(QueryWriteStatusRequest request, StreamObserver<QueryWriteStatusResponse> responseObserver) {
            if (this.queryWriteStatusException != null && this.queryWriteStatusResponses.hasNext()) {
                responseObserver.onError(this.queryWriteStatusException);
            } else {
                QueryWriteStatusResponse response = this.queryWriteStatusResponses.next();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
            }
        }

        public StreamObserver<WriteObjectRequest> writeObject(StreamObserver<WriteObjectResponse> responseObserver) {
            Throwable throwable;
            if (!(this.insertObjectExceptions == null || this.insertObjectExceptions.size() <= 0 || (throwable = this.insertObjectExceptions.remove(0)).getClass().isAssignableFrom(Throwable.class) && throwable.getCause() == null)) {
                this.insertRequestObserver.insertRequestException = throwable;
                this.insertRequestObserver.resumeFromInsertException = true;
            }
            this.insertRequestObserver.responseObserver = responseObserver;
            return this.insertRequestObserver;
        }

        public void setObject(com.google.storage.v2.Object object) {
            this.insertRequestObserver.object = object;
            this.insertRequestObserver.writeObjectResponse = WriteObjectResponse.newBuilder().setResource(object).build();
        }

        void setQueryWriteStatusResponses(Iterator<QueryWriteStatusResponse> responses) {
            this.queryWriteStatusResponses = responses;
        }

        void setQueryWriteStatusException(Throwable t) {
            this.queryWriteStatusException = t;
        }

        void setStartRequestException(Throwable t) {
            this.startRequestException = t;
        }

        void setInsertRequestException(Throwable t) {
            this.insertRequestObserver.insertRequestException = t;
        }

        public void setInsertObjectExceptions(List<Throwable> insertObjectExceptions) {
            this.insertObjectExceptions = Lists.newArrayList(insertObjectExceptions);
        }

        private static class InsertRequestObserver
        implements StreamObserver<WriteObjectRequest> {
            private StreamObserver<WriteObjectResponse> responseObserver;
            private com.google.storage.v2.Object object = DEFAULT_OBJECT;
            WriteObjectResponse writeObjectResponse = WriteObjectResponse.newBuilder().setResource(this.object).build();
            Throwable insertRequestException;
            boolean resumeFromInsertException = false;

            private InsertRequestObserver() {
            }

            public void onNext(WriteObjectRequest request) {
                if (this.insertRequestException != null) {
                    this.responseObserver.onError(this.insertRequestException);
                    if (this.resumeFromInsertException) {
                        this.insertRequestException = null;
                    }
                } else {
                    this.responseObserver.onNext((Object)this.writeObjectResponse);
                }
            }

            public void onError(Throwable t) {
                this.responseObserver.onError(t);
            }

            public void onCompleted() {
                this.responseObserver.onCompleted();
            }
        }
    }

    private class FakeStubProvider
    extends StorageStubProvider {
        FakeStubProvider(Credentials credentials) {
            super(GoogleCloudStorageOptions.DEFAULT, null, (StorageStubProvider.GrpcDecorator)new FakeGrpcDecorator());
        }

        public StorageGrpc.StorageStub newAsyncStub() {
            return GoogleCloudStorageGrpcWriteChannelTest.this.stub;
        }
    }

    private static class FakeGrpcDecorator
    implements StorageStubProvider.GrpcDecorator {
        private FakeGrpcDecorator() {
        }

        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return null;
        }

        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }
    }
}

