/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.services.storage.Storage;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.gcsio.ThrowingInputStream;
import com.google.cloud.hadoop.gcsio.testing.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageImplCreateTest {
    private static final String BUCKET_NAME = "foo-bucket";
    private static final String OBJECT_NAME = "bar-object";

    private Storage createStorage() throws IOException {
        return new Storage.Builder(HttpTransportFactory.createHttpTransport((HttpTransportFactory.HttpTransportType)HttpTransportFactory.HttpTransportType.JAVA_NET), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new RetryHttpInitializer(null, "foo-user-agent")).build();
    }

    @Test
    public void create_grpcAndVmComputeEngineCredentials_useDirectpath() throws IOException {
        GoogleCloudStorageImpl gcs = new GoogleCloudStorageImpl(GoogleCloudStorageOptions.builder().setAppName("app").setGrpcEnabled(true).setTrafficDirectorEnabled(false).build(), this.createStorage(), (Credentials)ComputeEngineCredentials.newBuilder().build());
        Truth.assertThat((Object)gcs.getStorageStubProvider().getGrpcDecorator()).isInstanceOf(StorageStubProvider.DirectPathGrpcDecorator.class);
    }

    @Test
    public void create_grpcAndDisableDirectPath_useCloudpath() throws IOException {
        GoogleCloudStorageImpl gcs = new GoogleCloudStorageImpl(GoogleCloudStorageOptions.builder().setAppName("app").setGrpcEnabled(true).setDirectPathPreferred(false).setTrafficDirectorEnabled(false).build(), this.createStorage(), (Credentials)ComputeEngineCredentials.newBuilder().build(), null);
        Truth.assertThat((Object)gcs.getStorageStubProvider().getGrpcDecorator()).isInstanceOf(StorageStubProvider.CloudPathGrpcDecorator.class);
    }

    @Test
    public void create_grpcAndTrafficDirector_useTrafficDirector() throws IOException {
        GoogleCloudStorageImpl gcs = new GoogleCloudStorageImpl(GoogleCloudStorageOptions.builder().setAppName("app").setGrpcEnabled(true).build(), this.createStorage(), (Credentials)ComputeEngineCredentials.newBuilder().build(), null);
        Truth.assertThat((Object)gcs.getStorageStubProvider().getGrpcDecorator()).isInstanceOf(StorageStubProvider.TrafficDirectorGrpcDecorator.class);
    }

    @Test
    public void testCreateObjectApiError() throws IOException {
        Error fakeError = new Error("Fake error");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream(null, fakeError))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcs((HttpTransport)transport);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        Error thrown = (Error)Assert.assertThrows(Error.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).isEqualTo((Object)fakeError);
    }

    @Test
    public void testCreateObjectApiRuntimeException() throws IOException {
        RuntimeException fakeException = new RuntimeException("Fake exception");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream(null, fakeException))});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcs((HttpTransport)transport);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().isEqualTo((Object)fakeException);
    }

    @Test
    public void testCreateObjectApiInterruptedException() throws Exception {
        CountDownLatch waitForEverLatch = new CountDownLatch(1);
        CountDownLatch writeStartedLatch = new CountDownLatch(2);
        CountDownLatch threadsDoneLatch = new CountDownLatch(2);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.arbitraryInputStreamSupplier(() -> {
            try {
                writeStartedLatch.countDown();
                waitForEverLatch.await();
                Assert.fail((String)"Unexpected to get here.");
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                threadsDoneLatch.countDown();
            }
            return null;
        })});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcs((HttpTransport)transport);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<?> write = executorService.submit(() -> {
            writeStartedLatch.countDown();
            try {
                IOException ioe = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
                Truth.assertThat((Throwable)ioe).isInstanceOf(ClosedByInterruptException.class);
            }
            finally {
                threadsDoneLatch.countDown();
            }
        });
        Truth.assertWithMessage((String)"Neither thread started.").that(Boolean.valueOf(writeStartedLatch.await(5000L, TimeUnit.MILLISECONDS))).isTrue();
        write.cancel(true);
        Truth.assertWithMessage((String)"Failed to wait for tasks to get interrupted.").that(Boolean.valueOf(threadsDoneLatch.await(5000L, TimeUnit.MILLISECONDS))).isTrue();
    }
}

