/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.base.Strings;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Iterables;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class GoogleCloudStorageIntegrationHelper {
    private static final String TEST_BUCKET_NAME_PREFIX = "gcsio-test";
    private final GoogleCloudStorageTestHelper.TestBucketHelper bucketHelper = new GoogleCloudStorageTestHelper.TestBucketHelper("gcsio-test");
    public String sharedBucketName1;
    public String sharedBucketName2;
    final GoogleCloudStorage gcs;

    public GoogleCloudStorageIntegrationHelper(GoogleCloudStorage gcs) {
        this.gcs = gcs;
    }

    public void beforeAllTests() throws IOException {
        this.sharedBucketName1 = this.createUniqueBucket("shared-1");
        this.sharedBucketName2 = this.createUniqueBucket("shared-2");
    }

    public void afterAllTests() {
        try {
            this.bucketHelper.cleanup(this.gcs);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to cleanup test buckets", e);
        }
    }

    public int writeTextFile(String bucketName, String objectName, String text) throws IOException {
        URI path = UriPaths.fromStringPathComponents((String)bucketName, (String)objectName, (boolean)false);
        return this.writeTextFile(path, text);
    }

    public int writeTextFile(URI path, String text) throws IOException {
        return this.writeFile(path, text.getBytes(StandardCharsets.UTF_8), 1);
    }

    protected int writeTextFileOverwriting(URI path, String text) throws IOException {
        return this.writeFileOverwriting(path, text.getBytes(StandardCharsets.UTF_8), 1);
    }

    protected int writeFile(URI path, String text, int numWrites, boolean overwrite) throws IOException {
        return this.writeFile(path, text.getBytes(StandardCharsets.UTF_8), numWrites, overwrite);
    }

    protected int writeFile(URI path, byte[] buffer, int numWrites, boolean overwriteExisting) throws IOException {
        int totalBytesWritten = 0;
        try (WritableByteChannel writeChannel = this.create(path, CreateFileOptions.builder().setOverwriteExisting(overwriteExisting).build());){
            for (int i = 0; i < numWrites; ++i) {
                int numBytesWritten = writeChannel.write(ByteBuffer.wrap(buffer));
                Truth.assertWithMessage((String)"could not write the entire buffer").that(Integer.valueOf(numBytesWritten)).isEqualTo((Object)buffer.length);
                totalBytesWritten += numBytesWritten;
            }
        }
        return totalBytesWritten;
    }

    protected int writeFile(URI path, byte[] buffer, int numWrites) throws IOException {
        return this.writeFile(path, buffer, numWrites, false);
    }

    protected int writeFileOverwriting(URI path, byte[] buffer, int numWrites) throws IOException {
        return this.writeFile(path, buffer, numWrites, true);
    }

    public String readTextFile(String bucketName, String objectName) throws IOException {
        return this.readTextFile(UriPaths.fromStringPathComponents((String)bucketName, (String)objectName, (boolean)false));
    }

    public String readTextFile(URI path) throws IOException {
        return new String(this.readFile(path), StandardCharsets.UTF_8);
    }

    public byte[] readFile(URI objectPath) throws IOException {
        ByteArrayOutputStream allReadBytes = new ByteArrayOutputStream(262144);
        byte[] readBuffer = new byte[524288];
        try (SeekableByteChannel in = this.open(objectPath);){
            int readBytes;
            while ((readBytes = in.read(ByteBuffer.wrap(readBuffer))) > 0) {
                allReadBytes.write(readBuffer, 0, readBytes);
            }
        }
        return allReadBytes.toByteArray();
    }

    protected String readTextFile(String bucketName, String objectName, int offset, int len, boolean checkOverflow) throws IOException {
        int bufferSize = len + (checkOverflow ? 1 : 0);
        ByteBuffer readBuffer = ByteBuffer.allocate(bufferSize);
        try (SeekableByteChannel readChannel = this.open(bucketName, objectName);){
            if (offset > 0) {
                readChannel.position(offset);
            }
            int numBytesRead = readChannel.read(readBuffer);
            Truth.assertWithMessage((String)"readTextFile: read size mismatch").that(Integer.valueOf(numBytesRead)).isEqualTo((Object)len);
        }
        readBuffer.flip();
        return StandardCharsets.UTF_8.decode(readBuffer).toString();
    }

    protected String readText(SeekableByteChannel readChannel, int offset, int len, boolean checkOverflow) throws IOException {
        int bufferSize = len + (checkOverflow ? 1 : 0);
        ByteBuffer readBuffer = ByteBuffer.allocate(bufferSize);
        if (offset > 0) {
            readChannel.position(offset);
        }
        int numBytesRead = readChannel.read(readBuffer);
        Truth.assertWithMessage((String)"readText: read size mismatch").that(Integer.valueOf(numBytesRead)).isEqualTo((Object)len);
        readBuffer.flip();
        return StandardCharsets.UTF_8.decode(readBuffer).toString();
    }

    protected abstract SeekableByteChannel open(URI var1) throws IOException;

    protected abstract SeekableByteChannel open(String var1, String var2) throws IOException;

    protected abstract SeekableByteChannel open(String var1, String var2, GoogleCloudStorageReadOptions var3) throws IOException;

    protected abstract SeekableByteChannel open(URI var1, GoogleCloudStorageReadOptions var2) throws IOException;

    protected WritableByteChannel create(URI path) throws IOException {
        return this.create(path, CreateFileOptions.DEFAULT_OVERWRITE);
    }

    protected abstract WritableByteChannel create(URI var1, CreateFileOptions var2) throws IOException;

    protected abstract void mkdir(String var1, String var2) throws IOException;

    protected abstract void mkdir(String var1) throws IOException;

    protected abstract void delete(String var1) throws IOException;

    protected abstract void delete(String var1, String var2) throws IOException;

    protected abstract void clearBucket(String var1) throws IOException;

    public long getExpectedObjectSize(String objectName, boolean expectedToExist) throws UnsupportedEncodingException {
        if (expectedToExist) {
            if (Strings.isNullOrEmpty((String)objectName) || objectName.endsWith("/")) {
                return 0L;
            }
            return objectName.getBytes(StandardCharsets.UTF_8).length;
        }
        return -1L;
    }

    public void createObjectsWithSubdirs(String bucketName, String ... objectNames) throws Exception {
        ArrayList<String> allNames = new ArrayList<String>();
        HashSet<String> created = new HashSet<String>();
        for (String objectName : objectNames) {
            for (String subdir : this.getSubdirs(objectName)) {
                if (!created.add(subdir)) continue;
                allNames.add(subdir);
            }
            if (created.contains(objectName)) continue;
            allNames.add(objectName);
        }
        this.createObjects(bucketName, allNames.toArray(new String[0]));
    }

    private List<String> getSubdirs(String objectName) {
        int index;
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)objectName) || objectName.charAt(0) != '/' ? 1 : 0) != 0, (String)"objectName can not start from '/': %s", (Object)objectName);
        ArrayList<String> subdirs = new ArrayList<String>();
        int currentIndex = 0;
        while (currentIndex < objectName.length() && (index = objectName.indexOf(47, currentIndex)) >= 0) {
            subdirs.add(objectName.substring(0, index + 1));
            currentIndex = index + 1;
        }
        return subdirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObjects(String bucketName, String ... objectNames) throws Exception {
        ExecutorService threadPool = Executors.newCachedThreadPool();
        CountDownLatch counter = new CountDownLatch(objectNames.length);
        ArrayList futures = new ArrayList();
        for (String objectName : objectNames) {
            Future<?> future = threadPool.submit(() -> {
                try {
                    if (objectName.endsWith("/")) {
                        this.mkdir(bucketName, objectName);
                    } else {
                        this.writeTextFile(bucketName, objectName, objectName);
                    }
                }
                catch (Throwable ioe) {
                    throw new RuntimeException(String.format("Exception creating %s/%s", bucketName, objectName), ioe);
                }
                finally {
                    counter.countDown();
                }
            });
            futures.add(future);
        }
        try {
            counter.await();
        }
        finally {
            threadPool.shutdown();
            if (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                System.err.println("Failed to awaitTermination! Forcing executor shutdown.");
                threadPool.shutdownNow();
            }
        }
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IOException("Creation of file failed with exception", e);
            }
        }
    }

    public URI getUniqueObjectUri(Class<?> clazz, String namePrefix) {
        return this.getUniqueObjectUri(clazz.getSimpleName() + "." + namePrefix);
    }

    public URI getUniqueObjectUri(String namePrefix) {
        return UriPaths.fromStringPathComponents((String)this.sharedBucketName1, (String)this.getUniqueObjectName(namePrefix), (boolean)false);
    }

    public String getUniqueObjectName(String prefix) {
        return prefix + "-" + UUID.randomUUID().toString().substring(0, 8);
    }

    public String getUniqueBucketName() {
        return this.getUniqueBucketName("");
    }

    public String getUniqueBucketName(String suffix) {
        return this.bucketHelper.getUniqueBucketName(suffix);
    }

    public static String requestToString(HttpRequest request) {
        String method = request.getRequestMethod();
        String url = request.getUrl().toString();
        String requestString = method + ":" + url;
        if ("POST".equals(method) && url.contains("uploadType=multipart")) {
            MultipartContent content = (MultipartContent)request.getContent();
            JsonHttpContent jsonRequest = (JsonHttpContent)((MultipartContent.Part)Iterables.get((Iterable)content.getParts(), (int)0)).getContent();
            String objectName = ((StorageObject)jsonRequest.getData()).getName();
            requestString = requestString + ":" + objectName;
        }
        return requestString;
    }

    public String createUniqueBucket(String suffix) throws IOException {
        String bucketName = this.getUniqueBucketName(suffix);
        this.mkdir(bucketName);
        return bucketName;
    }
}

