/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.testing.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageMockitoTest {
    private static final String PROJECT_ID = "google.com:foo-project";
    private static final String BUCKET_NAME = "foo-bucket";
    private static final String OBJECT_NAME = "bar-object";
    private GoogleCloudStorageImpl gcs;
    @Mock
    private ApiErrorExtractor mockErrorExtractor;
    @Mock
    private BatchHelper.Factory mockBatchFactory;
    @Mock
    private BatchHelper mockBatchHelper;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[0]);
        this.gcs = MockGoogleCloudStorageImplFactory.mockedGcs((HttpTransport)transport);
        this.gcs.setBatchFactory(this.mockBatchFactory);
        this.gcs.setErrorExtractor(this.mockErrorExtractor);
        Mockito.when((Object)this.mockBatchFactory.newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBatchHelper);
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockErrorExtractor});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBatchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBatchHelper});
    }

    @Test
    public void testDeleteObjectApiException() throws IOException {
        GoogleJsonError notFoundError = new GoogleJsonError();
        notFoundError.setMessage("Fake not-found exception");
        GoogleJsonError unexpectedError = new GoogleJsonError();
        unexpectedError.setMessage("Other API exception");
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            JsonBatchCallback getCallback = (JsonBatchCallback)invocation.getArguments()[1];
            getCallback.onSuccess((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setGeneration(Long.valueOf(1L)), new HttpHeaders());
            return null;
        }).doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(notFoundError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).doAnswer(invocation -> {
            JsonBatchCallback getCallback = (JsonBatchCallback)invocation.getArguments()[1];
            getCallback.onSuccess((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setGeneration(Long.valueOf(1L)), new HttpHeaders());
            return null;
        }).doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)this.mockErrorExtractor)).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        Mockito.when((Object)this.mockErrorExtractor.preconditionNotMet((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)false);
        try {
            this.gcs.deleteObjects((List)Lists.newArrayList((Object[])new StorageResourceId[]{new StorageResourceId(BUCKET_NAME, OBJECT_NAME)}));
        }
        catch (Exception e) {
            Assert.fail((String)("Expected no exception when mocking itemNotFound error from API call, got " + e));
        }
        Assert.assertThrows(IOException.class, () -> this.gcs.deleteObjects((List)Lists.newArrayList((Object[])new StorageResourceId[]{new StorageResourceId(BUCKET_NAME, OBJECT_NAME)})));
        ((BatchHelper.Factory)Mockito.verify((Object)this.mockBatchFactory, (VerificationMode)Mockito.times((int)2))).newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)4))).queue((StorageRequest)ArgumentMatchers.any(), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)2))).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor)).preconditionNotMet((IOException)ArgumentMatchers.any(IOException.class));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)2))).flush();
    }

    @Test
    public void testCopyObjectsApiExceptionSameBucket() throws IOException {
        GoogleJsonError notFoundError = new GoogleJsonError();
        notFoundError.setMessage("Fake not-found exception");
        GoogleJsonError unexpectedError = new GoogleJsonError();
        unexpectedError.setMessage("Other API exception");
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(notFoundError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(Storage.Objects.Copy.class), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)this.mockErrorExtractor)).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        String dstObjectName = "bar-object-copy";
        Assert.assertThrows(FileNotFoundException.class, () -> this.gcs.copy(BUCKET_NAME, (List)ImmutableList.of((Object)OBJECT_NAME), BUCKET_NAME, (List)ImmutableList.of((Object)dstObjectName)));
        Assert.assertThrows(IOException.class, () -> this.gcs.copy(BUCKET_NAME, (List)ImmutableList.of((Object)OBJECT_NAME), BUCKET_NAME, (List)ImmutableList.of((Object)dstObjectName)));
        ((BatchHelper.Factory)Mockito.verify((Object)this.mockBatchFactory, (VerificationMode)Mockito.times((int)2))).newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)2))).queue((StorageRequest)ArgumentMatchers.any(Storage.Objects.Copy.class), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)2))).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)2))).flush();
    }

    @Test
    public void testGetItemInfosApiException() throws IOException {
        GoogleJsonError unexpectedError = new GoogleJsonError();
        unexpectedError.setMessage("Unexpected API exception ");
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(Storage.Buckets.Get.class), (JsonBatchCallback)ArgumentMatchers.any());
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(Storage.Objects.Get.class), (JsonBatchCallback)ArgumentMatchers.any());
        Mockito.when((Object)this.mockErrorExtractor.itemNotFound((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)false);
        IOException ioe = (IOException)Assert.assertThrows(IOException.class, () -> this.gcs.getItemInfos((List)ImmutableList.of((Object)new StorageResourceId(BUCKET_NAME, OBJECT_NAME), (Object)StorageResourceId.ROOT, (Object)new StorageResourceId(BUCKET_NAME))));
        Truth.assertThat((Object[])ioe.getSuppressed()).isNotNull();
        Truth.assertThat((Object[])ioe.getSuppressed()).hasLength(2);
        ((BatchHelper.Factory)Mockito.verify((Object)this.mockBatchFactory)).newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(Storage.Buckets.Get.class), (JsonBatchCallback)ArgumentMatchers.any());
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(Storage.Objects.Get.class), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)2))).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper)).flush();
    }
}

