/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.util.RedactedString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageOptionsTest {
    @Test
    public void build_throwsException_whenMaxBytesRewrittenPerCallNotMbMultiple() {
        long maxBytesRewrittenPerCall = 1L;
        GoogleCloudStorageOptions.Builder builder = GoogleCloudStorageOptions.builder().setMaxBytesRewrittenPerCall(maxBytesRewrittenPerCall);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)builder).build());
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)("maxBytesRewrittenPerCall must be an integral multiple of 1 MiB (1048576), but was: " + maxBytesRewrittenPerCall));
    }

    @Test
    public void build_throwsException_whenProxyNotSetAndPasswordNotNull() {
        GoogleCloudStorageOptions.Builder builder = GoogleCloudStorageOptions.builder().setProxyPassword(RedactedString.create((String)"proxy-password"));
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)builder).build());
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"if proxyAddress is null then proxyUsername and proxyPassword should be null too");
    }

    @Test
    public void build_throwsException_whenProxyNotSetAndUsernameNotNull() {
        GoogleCloudStorageOptions.Builder builder = GoogleCloudStorageOptions.builder().setProxyUsername(RedactedString.create((String)"proxy-username"));
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)builder).build());
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"if proxyAddress is null then proxyUsername and proxyPassword should be null too");
    }

    @Test
    public void build_throwsException_whenProxySetAndUsernameNull() {
        GoogleCloudStorageOptions.Builder builder = GoogleCloudStorageOptions.builder().setProxyAddress("proxy-address").setProxyPassword(RedactedString.create((String)"proxy-password")).setProxyUsername(null);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)builder).build());
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"both proxyUsername and proxyPassword should be null or not null together");
    }

    @Test
    public void build_throwsException_whenProxySetAndPasswordNull() {
        GoogleCloudStorageOptions.Builder builder = GoogleCloudStorageOptions.builder().setProxyAddress("proxy-address").setProxyPassword(null).setProxyUsername(RedactedString.create((String)"proxy-username"));
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)builder).build());
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"both proxyUsername and proxyPassword should be null or not null together");
    }

    @Test
    public void encryptionKey_hide_whenSetEncryptionKey() {
        GoogleCloudStorageOptions.Builder builder = GoogleCloudStorageOptions.builder().setEncryptionAlgorithm("AES256").setEncryptionKey(RedactedString.create((String)"test-key")).setEncryptionKeyHash(RedactedString.create((String)"test-key-hash"));
        GoogleCloudStorageOptions options = builder.build();
        String optionsString = options.toString();
        Truth.assertThat((String)optionsString).contains((CharSequence)"encryptionKey=<redacted>");
        Truth.assertThat((String)optionsString).contains((CharSequence)"encryptionKeyHash=<redacted>");
    }
}

