/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.testing.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageReadChannelTest {
    private static final String PROJECT_ID = "google.com:foo-project";

    @Test
    public void metadataInitialization_eager() throws IOException {
        StorageObject object = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)object)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).hasSize(1);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)object.getSize().longValue());
        Truth.assertThat(requests).hasSize(1);
    }

    @Test
    public void metadataInitialization_lazy() throws IOException {
        StorageObject object = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)object)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).isEmpty();
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)object.getSize().longValue());
        Truth.assertThat(requests).hasSize(1);
    }

    @Test
    public void fadviseAuto_onForwardRead_switchesToRandom() throws IOException {
        int seekPosition = 5;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] testData2 = Arrays.copyOfRange(testData, seekPosition, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])Arrays.copyOfRange(testData, 1, testData.length), (long)1L, (long)testData.length), MockHttpTransportHelper.dataRangeResponse((byte[])testData2, (long)seekPosition, (long)testData2.length)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setMinRangeRequestSize(1).setInplaceSeekLimit(2L).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        byte[] readBytes = new byte[1];
        readChannel.position(1L);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[1]});
        readChannel.position((long)seekPosition);
        Truth.assertThat((Boolean)readChannel.randomAccess).isFalse();
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[seekPosition]});
        Truth.assertThat((Boolean)readChannel.randomAccess).isTrue();
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=1-", "bytes=5-5"}).inOrder();
    }

    @Test
    public void fadviseAuto_onBackwardRead_switchesToRandom() throws IOException {
        int seekPosition = 5;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] testData2 = Arrays.copyOfRange(testData, seekPosition, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])testData2, (long)seekPosition, (long)testData2.length), MockHttpTransportHelper.dataRangeResponse((byte[])testData, (long)0L, (long)testData.length)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setMinRangeRequestSize(1).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        byte[] readBytes = new byte[1];
        readChannel.position((long)seekPosition);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[seekPosition]});
        readChannel.position(0L);
        Truth.assertThat((Boolean)readChannel.randomAccess).isFalse();
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)1);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)new byte[]{testData[0]});
        Truth.assertThat((Boolean)readChannel.randomAccess).isTrue();
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=5-", "bytes=0-0"}).inOrder();
    }

    @Test
    public void footerPrefetch_reused() throws IOException {
        int footeSize = 2;
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int footerStart = testData.length - footeSize;
        byte[] footer = Arrays.copyOfRange(testData, footerStart, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.dataRangeResponse((byte[])footer, (long)footerStart, (long)testData.length), MockHttpTransportHelper.dataResponse((byte[])new byte[]{testData[footerStart - 1]})});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setMinRangeRequestSize(footeSize).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        Truth.assertThat(requests).isEmpty();
        byte[] readBytes = new byte[2];
        readChannel.position((long)footerStart);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)2);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)Arrays.copyOfRange(testData, footerStart, testData.length));
        readChannel.position((long)(footerStart - 1));
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(readBytes))).isEqualTo((Object)2);
        Truth.assertThat((byte[])readBytes).isEqualTo((Object)Arrays.copyOfRange(testData, footerStart - 1, testData.length - 1));
        List rangeHeaders = requests.stream().map(r -> r.getHeaders().getRange()).collect(Collectors.toList());
        Truth.assertThat(rangeHeaders).containsExactly(new Object[]{"bytes=8-9", "bytes=7-7"}).inOrder();
    }

    @Test
    public void read_whenBufferIsEmpty() throws IOException {
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().build());
        Truth.assertThat((Integer)readChannel.read(emptyBuffer)).isEqualTo((Object)0);
    }

    @Test
    public void read_whenPositionIsEqualToSize() throws IOException {
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[1]);
        StorageObject object = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)object.setSize(BigInteger.ZERO))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadOptions.DEFAULT);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)readChannel.size());
        Truth.assertThat((Integer)readChannel.read(readBuffer)).isEqualTo((Object)-1);
    }

    @Test
    public void size_whenObjectIsGzipEncoded_shouldBeSetToMaxLongValue() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadOptions.DEFAULT);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void initMetadata_throwsException_whenReadConsistencyEnabledAndGenerationIsNull() throws IOException {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> readChannel.initMetadata("gzip", 1L, -1L));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Generation parameter of -1 is invalid");
    }

    @Test
    public void initMetadata_succeeds_whenReadConsistencyEnabledAndGenerationIsValid() throws IOException {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadChannelTest.newLazyReadOptionsBuilder().build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        readChannel.initMetadata("gzip", 1L, 1234L);
    }

    @Test
    public void initGeneration_hasGenerationId() throws IOException {
        StorageObject storageObject = GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)storageObject)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        readChannel.size();
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)storageObject.getGeneration());
    }

    @Test
    public void lazyInitGeneration_succeeds_whenReadConsistencyStrict() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(5L)))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options);
        readChannel.size();
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)5L);
    }

    @Test
    public void lazyReadFileAtSpecificGeneration_fails_ifGenerationChanged() throws IOException {
        long requestedGeneration = 5L;
        long actualGeneration = 342L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(actualGeneration)))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, new ArrayList()::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, requestedGeneration);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((GoogleCloudStorageReadChannel)readChannel).size());
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)String.format("Provided generation (%d) should be equal to fetched generation (%d)", requestedGeneration, actualGeneration));
    }

    @Test
    public void eagerReadFileAtSpecificGeneration_fails_ifGenerationChanged() throws IOException {
        long requestedGeneration = 5L;
        long actualGeneration = 342L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(actualGeneration)))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, new ArrayList()::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(true).build();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> GoogleCloudStorageTestUtils.createReadChannel(storage, options, requestedGeneration));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)String.format("Provided generation (%d) should be equal to fetched generation (%d)", requestedGeneration, actualGeneration));
    }

    @Test
    public void lazyReadFileAtSpecificGeneration_succeeds_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        readChannel.size();
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)generation);
    }

    @Test
    public void eagerReadFileAtSpecificGeneration_succeeds_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(true).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)generation);
    }

    @Test
    public void lazyReadFileAtSpecificGeneration_fails_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Assert.assertThrows(FileNotFoundException.class, () -> readChannel.size());
    }

    @Test
    public void eagerReadFileAtSpecificGeneration_fails_whenReadConsistencyStrict() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND)});
        ArrayList requests = new ArrayList();
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, requests::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(true).build();
        Assert.assertThrows(FileNotFoundException.class, () -> GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation));
    }

    @Test
    public void afterRetry_subsequentReads_succeed() throws IOException {
        long generation = 5L;
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setGeneration(Long.valueOf(generation)))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, new ArrayList()::add);
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, options, generation);
        Assert.assertThrows(FileNotFoundException.class, () -> ((GoogleCloudStorageReadChannel)readChannel).size());
        Truth.assertThat((Long)readChannel.size()).isNotEqualTo((Object)0);
        Truth.assertThat((Long)readChannel.generation()).isEqualTo((Object)generation);
    }

    @Test
    public void read_gzipEncoded_shouldReadAllBytes() throws IOException {
        byte[] testData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip")), MockHttpTransportHelper.dataRangeResponse((byte[])testData, (long)0L, (long)testData.length)});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadChannel readChannel = GoogleCloudStorageTestUtils.createReadChannel(storage, GoogleCloudStorageReadOptions.DEFAULT);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)Long.MAX_VALUE);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(new byte[testData.length + 1]))).isEqualTo((Object)testData.length);
        Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)testData.length);
    }

    @Test
    public void open_gzipContentEncoding_succeeds_whenContentEncodingSupported() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setSupportGzipEncoding(true).build();
        try (GoogleCloudStorageReadChannel channel = GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions);){
            channel.position();
        }
    }

    @Test
    public void open_gzipContentEncoding_throwsIOException_ifContentEncodingNotSupported() throws Exception {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTest.newStorageObject("foo-bucket", "bar-object").setContentEncoding("gzip"))});
        Storage storage = new Storage((HttpTransport)transport, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {});
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setSupportGzipEncoding(false).build();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTestUtils.createReadChannel(storage, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Cannot read GZIP encoded files - content encoding support is disabled.");
    }

    private void setUpAndValidateReadChannelMocksAndSetMaxRetries(GoogleCloudStorageReadChannel readChannel, int maxRetries) throws IOException {
        readChannel.setMaxRetries(maxRetries);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
    }

    @Test
    public void testReadWithFailedInplaceSeekSucceeds() throws IOException {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        byte[] testData2 = Arrays.copyOfRange(testData, 3, testData.length);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)new StorageObject().setBucket("foo-bucket").setName("bar-object").setTimeCreated(new DateTime(11L)).setUpdated(new DateTime(12L)).setSize(BigInteger.valueOf(testData.length)).setContentEncoding(null).setGeneration(Long.valueOf(1L)).setMetageneration(Long.valueOf(1L))), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)testData.length, (InputStream)new InputStream(){
            private int current = 0;

            @Override
            public synchronized int read() throws IOException {
                if (this.current == 0) {
                    ++this.current;
                    return 1;
                }
                throw new IOException("In-place seek IOException");
            }
        }), MockHttpTransportHelper.dataResponse((Map)ImmutableMap.of((Object)"Content-Length", (Object)testData2.length), (byte[])testData2)});
        GoogleCloudStorageImpl gcs = MockGoogleCloudStorageImplFactory.mockedGcs((HttpTransport)transport);
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)gcs.open(new StorageResourceId("foo-bucket", "bar-object"), GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(3L).build());
        this.setUpAndValidateReadChannelMocksAndSetMaxRetries(readChannel, 3);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(new byte[1]))).isEqualTo((Object)1);
        readChannel.position(3L);
        byte[] byte3 = new byte[1];
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(byte3))).isEqualTo((Object)1);
        Truth.assertThat((byte[])byte3).isEqualTo((Object)new byte[]{testData[3]});
    }

    private static GoogleCloudStorageReadOptions.Builder newLazyReadOptionsBuilder() {
        return GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false);
    }
}

