/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GrpcChannelUtils;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GrpcChannelUtilsTest {
    @Test
    public void toV2BucketNameConvertsV1BucketName() {
        String bucketName = "bucketName";
        String v2BucketName = GrpcChannelUtils.toV2BucketName((String)bucketName);
        Truth.assertThat((String)v2BucketName).isNotNull();
        Truth.assertThat((String)v2BucketName).isNotEmpty();
        Truth.assertThat((String)v2BucketName).isEqualTo((Object)("projects/_/buckets/" + bucketName));
    }

    @Test
    public void toV2BucketNameThrowsExceptionOnNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GrpcChannelUtils.toV2BucketName(null));
    }

    @Test
    public void toV2BucketNameThrowsExceptionOnEmpty() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GrpcChannelUtils.toV2BucketName((String)""));
    }
}

