/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;

public class InputStreamSeekableReadableByteChannel
implements SeekableByteChannel {
    private final InputStream readStream;
    private final int maxBytesToRead;
    private final ReadableByteChannel readChannelDelegate;
    private int position;

    public InputStreamSeekableReadableByteChannel(InputStream readStream, int maxBytesToRead) {
        Preconditions.checkArgument((readStream != null ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBytesToRead >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)readStream.markSupported());
        this.readStream = readStream;
        this.maxBytesToRead = maxBytesToRead;
        readStream.mark(this.maxBytesToRead);
        this.readChannelDelegate = Channels.newChannel(this.readStream);
        this.position = 0;
    }

    @Override
    public long position() throws IOException {
        this.throwIfNotOpen();
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.throwIfNotOpen();
        if (newPosition != 0L && (newPosition < 0L || newPosition >= this.size())) {
            throw new IllegalArgumentException(String.format("Invalid seek offset: position value (%d) must be between 0 and %d", newPosition, this.size()));
        }
        this.readStream.reset();
        this.readStream.skip(newPosition);
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        this.throwIfNotOpen();
        return this.maxBytesToRead;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.throwIfNotOpen();
        if (dst.remaining() > 0 && this.position == this.maxBytesToRead) {
            return -1;
        }
        if (dst.remaining() > this.maxBytesToRead - this.position) {
            int oldLimit = dst.limit();
            dst.limit(dst.position() + this.maxBytesToRead - this.position);
            int numRead = this.readChannelDelegate.read(dst);
            dst.limit(oldLimit);
            this.position += numRead;
            return numRead;
        }
        int numRead = this.readChannelDelegate.read(dst);
        this.position += numRead;
        return numRead;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException("Cannot mutate read-only channel");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException("Cannot mutate read-only channel");
    }

    @Override
    public void close() throws IOException {
        this.readChannelDelegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.readChannelDelegate.isOpen();
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

