/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PerformanceCachingGoogleCloudStorageIntegrationTest {
    private static final GoogleCloudStorageTestHelper.TestBucketHelper BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("gcs-perf-cache");
    private static final String TEST_BUCKET = BUCKET_HELPER.getUniqueBucketPrefix();
    private static final GoogleCloudStorageOptions GCS_OPTIONS = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
    private static final PerformanceCachingGoogleCloudStorageOptions PERF_CACHE_GCS_OPTIONS = PerformanceCachingGoogleCloudStorageOptions.DEFAULT.toBuilder().setMaxEntryAgeMillis(10000L).build();
    private static GoogleCloudStorage helperGcs;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAll() throws IOException {
        helperGcs = GoogleCloudStorageTestHelper.createGoogleCloudStorage();
        helperGcs.createBucket(TEST_BUCKET);
    }

    @AfterClass
    public static void afterAll() throws IOException {
        try {
            BUCKET_HELPER.cleanup(helperGcs);
        }
        finally {
            helperGcs.close();
        }
    }

    @Test
    public void getItemInfo_multipleCalls_oneGcsGetRequest() throws Exception {
        String objectName = this.name.getMethodName() + "/object";
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, objectName);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<PerformanceCachingGoogleCloudStorage> trackingGcs = PerformanceCachingGoogleCloudStorageIntegrationTest.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        helperGcs.createEmptyObject(resourceId);
        GoogleCloudStorageItemInfo object1 = ((PerformanceCachingGoogleCloudStorage)trackingGcs.delegate).getItemInfo(resourceId);
        GoogleCloudStorageItemInfo object2 = ((PerformanceCachingGoogleCloudStorage)trackingGcs.delegate).getItemInfo(resourceId);
        GoogleCloudStorageItemInfo object3 = ((PerformanceCachingGoogleCloudStorage)trackingGcs.delegate).getItemInfo(resourceId);
        Truth.assertThat((Object)object1.getResourceId()).isEqualTo((Object)resourceId);
        Truth.assertThat((Object)object1).isSameInstanceAs((Object)object2);
        Truth.assertThat((Object)object1).isSameInstanceAs((Object)object3);
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, objectName)});
    }

    private static GoogleCloudStorageTestHelper.TrackingStorageWrapper<PerformanceCachingGoogleCloudStorage> newTrackingGoogleCloudStorage(GoogleCloudStorageOptions options) throws IOException {
        return new GoogleCloudStorageTestHelper.TrackingStorageWrapper<PerformanceCachingGoogleCloudStorage>(options, httpRequestInitializer -> new PerformanceCachingGoogleCloudStorage((GoogleCloudStorage)new GoogleCloudStorageImpl(options, (HttpRequestInitializer)httpRequestInitializer), PERF_CACHE_GCS_OPTIONS));
    }
}

