/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.PrefixMappedItemCache;
import cz.o2.proxima.internal.shaded.com.google.common.base.Ticker;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PrefixMappedItemCacheTest {
    private static final String BUCKET_A = "alpha";
    private static final String PREFIX_A = "bar";
    private static final String PREFIX_AA = "bar/apple";
    private static final GoogleCloudStorageItemInfo ITEM_A_A = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alpha", "bar");
    private static final GoogleCloudStorageItemInfo ITEM_A_AA = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alpha", "bar/apple");
    private TestTicker ticker;
    private PrefixMappedItemCache cache;

    @Before
    public void setUp() {
        this.ticker = new TestTicker();
        this.cache = new PrefixMappedItemCache((Ticker)this.ticker, Duration.ofMillis(10L));
    }

    @Test
    public void testGetItemNormal() {
        this.cache.putItem(ITEM_A_A);
        GoogleCloudStorageItemInfo actualItem = this.cache.getItem(ITEM_A_A.getResourceId());
        Truth.assertThat((Object)actualItem).isEqualTo((Object)ITEM_A_A);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_A_A});
    }

    @Test
    public void testGetItemMissing() {
        GoogleCloudStorageItemInfo actualItem = this.cache.getItem(ITEM_A_A.getResourceId());
        Truth.assertThat((Object)actualItem).isNull();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).isEmpty();
    }

    @Test
    public void testPutItemNormal() {
        GoogleCloudStorageItemInfo previousItem = this.cache.putItem(ITEM_A_A);
        Truth.assertThat((Object)previousItem).isNull();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_A_A});
    }

    @Test
    public void testPutItemOverwrite() {
        this.cache.putItem(ITEM_A_A);
        GoogleCloudStorageItemInfo previousItem = this.cache.putItem(ITEM_A_A);
        Truth.assertThat((Object)previousItem).isEqualTo((Object)ITEM_A_A);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_A_A});
    }

    @Test
    public void testRemoveItemNormal() {
        this.cache.putItem(ITEM_A_A);
        GoogleCloudStorageItemInfo actualItem = this.cache.removeItem(ITEM_A_A.getResourceId());
        Truth.assertThat((Object)actualItem).isEqualTo((Object)ITEM_A_A);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).isEmpty();
    }

    @Test
    public void testRemoveItemMissing() {
        GoogleCloudStorageItemInfo actualItem = this.cache.removeItem(ITEM_A_AA.getResourceId());
        Truth.assertThat((Object)actualItem).isNull();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).isEmpty();
    }

    private static class TestTicker
    extends Ticker {
        private long time;

        private TestTicker() {
        }

        public long read() {
            return this.time;
        }

        public void setTimeMillis(long millis) {
            this.time = TimeUnit.NANOSECONDS.convert(millis, TimeUnit.MILLISECONDS);
        }
    }
}

