/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.StorageRequestFactory;
import com.google.cloud.hadoop.gcsio.StorageRequestToAccessBoundaryConverter;
import com.google.cloud.hadoop.util.AccessBoundary;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StorageRequestToAccessBoundaryConverterTest {
    private static final String BUCKET_NAME = "test-bucket-name";
    private static final String OBJECT_NAME = "/dir/test-object";
    private static final String BUCKET_NAME_DST = "test-bucket-name-dst";
    private static final String OBJECT_NAME_DST = "/dir/test-object-dst";
    private Storage storage;

    @Before
    public void setup() {
        this.storage = new Storage((HttpTransport)new NetHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), null);
    }

    @Test
    public void translateObjectListRequest() throws IOException {
        Storage.Objects.List request = this.storage.objects().list(BUCKET_NAME).setPrefix(OBJECT_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.LIST_OBJECTS)});
    }

    @Test
    public void testTranslateObjectListRequestWithNullPrefix() throws IOException {
        Storage.Objects.List request = this.storage.objects().list(BUCKET_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)"/", (AccessBoundary.Action)AccessBoundary.Action.LIST_OBJECTS)});
    }

    @Test
    public void testTranslateObjectInsertRequest() throws IOException {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Insert request = this.storage.objects().insert(BUCKET_NAME, object);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS)});
    }

    @Test
    public void testTranslateObjectComposeRequest() throws IOException {
        List sources = (List)Stream.of(0, 1, 2).map(i -> new ComposeRequest.SourceObjects().setName("/dir/test-object-" + i)).collect(ImmutableList.toImmutableList());
        ComposeRequest composeRequest = new ComposeRequest().setSourceObjects(sources);
        Storage.Objects.Compose request = this.storage.objects().compose(BUCKET_NAME, OBJECT_NAME, composeRequest);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)"/dir/test-object-0", (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS), AccessBoundary.create((String)BUCKET_NAME, (String)"/dir/test-object-1", (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS), AccessBoundary.create((String)BUCKET_NAME, (String)"/dir/test-object-2", (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS), AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS)});
    }

    @Test
    public void testTranslateObjectGetDataRequest() {
        StorageRequestFactory.ObjectsGetData request = new StorageRequestFactory(this.storage).objectsGetData(BUCKET_NAME, OBJECT_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS)});
    }

    @Test
    public void testTranslateObjectGetMetadataRequest() {
        StorageRequestFactory.ObjectsGetMetadata request = new StorageRequestFactory(this.storage).objectsGetMetadata(BUCKET_NAME, OBJECT_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.GET_METADATA_OBJECTS)});
    }

    @Test
    public void testDisallowGetRequest() throws IOException {
        Storage.Objects.Get request = this.storage.objects().get(BUCKET_NAME, OBJECT_NAME);
        Assert.assertThrows(InvalidParameterException.class, () -> StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request));
    }

    @Test
    public void testTranslateObjectDeleteRequest() throws IOException {
        Storage.Objects.Delete request = this.storage.objects().delete(BUCKET_NAME, OBJECT_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.DELETE_OBJECTS)});
    }

    @Test
    public void testTranslateObjectRewriteRequest() throws IOException {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Rewrite request = this.storage.objects().rewrite(BUCKET_NAME, OBJECT_NAME, BUCKET_NAME_DST, OBJECT_NAME_DST, object);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS), AccessBoundary.create((String)BUCKET_NAME_DST, (String)OBJECT_NAME_DST, (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS)});
    }

    @Test
    public void testTranslateObjectCopyRequest() throws IOException {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Copy request = this.storage.objects().copy(BUCKET_NAME, OBJECT_NAME, BUCKET_NAME_DST, OBJECT_NAME_DST, object);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS), AccessBoundary.create((String)BUCKET_NAME_DST, (String)OBJECT_NAME_DST, (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS)});
    }

    @Test
    public void testTranslateObjectPatchRequest() throws IOException {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Patch request = this.storage.objects().patch(BUCKET_NAME, OBJECT_NAME, object);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)OBJECT_NAME, (AccessBoundary.Action)AccessBoundary.Action.EDIT_OBJECTS)});
    }

    @Test
    public void testTranslateBucketGetRequest() throws IOException {
        Storage.Buckets.Get request = this.storage.buckets().get(BUCKET_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)"/", (AccessBoundary.Action)AccessBoundary.Action.GET_BUCKETS)});
    }

    @Test
    public void testTranslateBucketInsertRequest() throws IOException {
        Bucket bucket = new Bucket().setName(BUCKET_NAME);
        Storage.Buckets.Insert request = this.storage.buckets().insert("project", bucket);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)"/", (AccessBoundary.Action)AccessBoundary.Action.CREATE_BUCKETS)});
    }

    @Test
    public void testTranslateBucketDeleteRequest() throws IOException {
        Storage.Buckets.Delete request = this.storage.buckets().delete(BUCKET_NAME);
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)BUCKET_NAME, (String)"/", (AccessBoundary.Action)AccessBoundary.Action.DELETE_BUCKETS)});
    }

    @Test
    public void testTranslateBucketListRequest() throws IOException {
        Storage.Buckets.List request = this.storage.buckets().list("project");
        List results = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{AccessBoundary.create((String)"", (String)"", (AccessBoundary.Action)AccessBoundary.Action.LIST_BUCKETS)});
    }

    @Test
    public void translateNotRecognizedRequest() throws IOException {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Update request = this.storage.objects().update(BUCKET_NAME, OBJECT_NAME, object);
        InvalidParameterException actualException = (InvalidParameterException)Assert.assertThrows(InvalidParameterException.class, () -> StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest((StorageRequest)request));
        Truth.assertThat((Throwable)actualException).hasMessageThat().isEqualTo((Object)"StorageRequest not used by the connector: com.google.api.services.storage.Storage.Objects.Update");
    }
}

