/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UriPaths;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UriEncodingPathCodecTest {
    @Test
    public void testGetPath_PathEncoding() {
        URI id = UriPaths.fromStringPathComponents((String)"b1", (String)"/path/to/!@#$%&*()_/my/resource", (boolean)false);
        Truth.assertThat((String)id.getAuthority()).isEqualTo((Object)"b1");
        Truth.assertThat((String)id.getScheme()).isEqualTo((Object)"gs");
        Truth.assertThat((String)id.getRawSchemeSpecificPart()).isEqualTo((Object)"//b1/path/to/!@%23$%25&*()_/my/resource");
        Truth.assertThat((String)id.getPath()).isEqualTo((Object)"/path/to/!@#$%&*()_/my/resource");
    }

    @Test
    public void testGetPath_BadFragments() {
        URI id = UriPaths.fromStringPathComponents((String)"b1", (String)"/path/to/segment1_#Foo#bar#123", (boolean)false);
        Truth.assertThat((String)id.getAuthority()).isEqualTo((Object)"b1");
        Truth.assertThat((String)id.getScheme()).isEqualTo((Object)"gs");
        Truth.assertThat((String)id.getRawSchemeSpecificPart()).isEqualTo((Object)"//b1/path/to/segment1_%23Foo%23bar%23123");
        Truth.assertThat((String)id.getPath()).isEqualTo((Object)"/path/to/segment1_#Foo#bar#123");
    }

    @Test
    public void testGetPath_InvalidObjectName() {
        Assert.assertThrows(IllegalArgumentException.class, () -> UriPaths.fromStringPathComponents((String)"b1", (String)"", (boolean)false));
    }

    @Test
    public void testGetPath_InvalidBucketName() {
        Assert.assertThrows(IllegalArgumentException.class, () -> UriPaths.fromStringPathComponents((String)"", (String)"/foo/bar", (boolean)false));
    }

    @Test
    public void testValidatePathAndGetId_Foo() throws URISyntaxException {
        StorageResourceId id = StorageResourceId.fromUriPath((URI)new URI("gs", "bucket-name", "/object/name", null), (boolean)true);
        Truth.assertThat((String)id.getBucketName()).isEqualTo((Object)"bucket-name");
        Truth.assertThat((String)id.getObjectName()).isEqualTo((Object)"object/name");
    }

    @Test
    public void testRoundTrip() {
        String objectName = "foo/!@#$%&*()@#$& %%()/bar";
        StorageResourceId rid1 = new StorageResourceId("bucket1", objectName);
        URI encodedURI = UriPaths.fromStringPathComponents((String)rid1.getBucketName(), (String)rid1.getObjectName(), (boolean)true);
        StorageResourceId rid2 = StorageResourceId.fromUriPath((URI)encodedURI, (boolean)true);
        Truth.assertThat((Object)rid1).isEqualTo((Object)rid2);
        Truth.assertThat((String)rid2.getBucketName()).isEqualTo((Object)"bucket1");
        Truth.assertThat((String)rid2.getObjectName()).isEqualTo((Object)objectName);
    }

    @Test
    public void testAuthorityAllowsNonHostCharacters() {
        URI withRegistryBasedAuthority = UriPaths.fromStringPathComponents((String)"foo_bar", (String)"/some/object/name", (boolean)true);
        Truth.assertThat((String)withRegistryBasedAuthority.getAuthority()).isEqualTo((Object)"foo_bar");
        Truth.assertThat((String)withRegistryBasedAuthority.getRawAuthority()).isEqualTo((Object)"foo_bar");
    }
}

