/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.ZeroCopyMessageMarshaller;
import com.google.protobuf.MessageLite;
import com.google.storage.v2.ReadObjectRequest;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.internal.ReadableBuffer;
import cz.o2.proxima.beam.io.pubsub.io.grpc.internal.ReadableBuffers;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ZeroCopyMessageMarshallerTest {
    private ReadObjectRequest REQUEST = ReadObjectRequest.newBuilder().setBucket("b").setObject("o").build();

    private ZeroCopyMessageMarshaller<ReadObjectRequest> createMarshaller() {
        return new ZeroCopyMessageMarshaller((MessageLite)ReadObjectRequest.getDefaultInstance());
    }

    private byte[] dropLastOneByte(byte[] bytes) {
        return Arrays.copyOfRange(bytes, 0, bytes.length - 1);
    }

    private InputStream createInputStream(byte[] bytes, boolean isZeroCopyable) {
        ReadableBuffer buffer = isZeroCopyable ? ReadableBuffers.wrap((ByteBuffer)ByteBuffer.wrap(bytes)) : ReadableBuffers.wrap((byte[])bytes);
        return ReadableBuffers.openStream((ReadableBuffer)buffer, (boolean)true);
    }

    @Test
    public void testParseOnFastPath() throws IOException {
        InputStream stream = this.createInputStream(this.REQUEST.toByteArray(), true);
        ZeroCopyMessageMarshaller<ReadObjectRequest> marshaller = this.createMarshaller();
        ReadObjectRequest request = (ReadObjectRequest)marshaller.parse(stream);
        Truth.assertThat((Object)request).isEqualTo((Object)this.REQUEST);
        InputStream stream2 = marshaller.popStream((MessageLite)request);
        Truth.assertThat((Object)stream2).isNotNull();
        stream2.close();
        InputStream stream3 = marshaller.popStream((MessageLite)request);
        Truth.assertThat((Object)stream3).isNull();
    }

    @Test
    public void testParseOnSlowPath() {
        InputStream stream = this.createInputStream(this.REQUEST.toByteArray(), false);
        ZeroCopyMessageMarshaller<ReadObjectRequest> marshaller = this.createMarshaller();
        ReadObjectRequest request = (ReadObjectRequest)marshaller.parse(stream);
        Truth.assertThat((Object)request).isEqualTo((Object)this.REQUEST);
        InputStream stream2 = marshaller.popStream((MessageLite)request);
        Truth.assertThat((Object)stream2).isNull();
    }

    @Test
    public void testParseBrokenMessageOnFastPath() {
        InputStream stream = this.createInputStream(this.dropLastOneByte(this.REQUEST.toByteArray()), true);
        ZeroCopyMessageMarshaller<ReadObjectRequest> marshaller = this.createMarshaller();
        Assert.assertThrows(StatusRuntimeException.class, () -> marshaller.parse(stream));
    }

    @Test
    public void testParseBrokenMessageOnSlowPath() {
        InputStream stream = this.createInputStream(this.dropLastOneByte(this.REQUEST.toByteArray()), false);
        ZeroCopyMessageMarshaller<ReadObjectRequest> marshaller = this.createMarshaller();
        Assert.assertThrows(StatusRuntimeException.class, () -> marshaller.parse(stream));
    }
}

