/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.authorization;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.authorization.FakeAuthorizationHandler;
import com.google.cloud.hadoop.gcsio.authorization.StorageRequestAuthorizer;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class StorageRequestAuthorizerTest {
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    public static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final String PROJECT = "test-project";
    private static final String BUCKET_NAME = "test-bucket-name";
    private static final String OBJECT_NAME = "/dir/test-object";
    private static final String BUCKET_NAME_DST = "test-bucket-name-dst";
    private static final String OBJECT_NAME_DST = "/dir/test-object-dst";
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    AuthorizationHandler mockHandler;

    @Test
    public void testAuthorizationHandlerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new StorageRequestAuthorizer(null, (Map)ImmutableMap.of()));
    }

    @Test
    public void testInitiateAuthorizationHandler() {
        new StorageRequestAuthorizer(FakeAuthorizationHandler.class, (Map)ImmutableMap.of((Object)FakeAuthorizationHandler.PROPERTY_KEY, (Object)FakeAuthorizationHandler.EXPECTED_VALUE));
    }

    @Test
    public void testAuthorizationHandlerInstantiateException() {
        Assert.assertThrows(RuntimeException.class, () -> new StorageRequestAuthorizer(BrokenAuthorizationHandler.class, (Map)ImmutableMap.of()));
    }

    @Test
    public void testAuthorizationAllowed() throws Exception {
        Storage.Objects.List list = StorageRequestAuthorizerTest.newStorage().objects().list(BUCKET_NAME).setPrefix(OBJECT_NAME);
        ((AuthorizationHandler)Mockito.doNothing().when((Object)this.mockHandler)).handleListObjects((URI)ArgumentMatchers.any(URI.class));
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)list);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleListObjects((URI)ArgumentMatchers.any(URI.class));
    }

    @Test
    public void testAccessDenied() throws Exception {
        Storage.Objects.List list = StorageRequestAuthorizerTest.newStorage().objects().list(BUCKET_NAME).setPrefix(OBJECT_NAME);
        ((AuthorizationHandler)Mockito.doThrow(AccessDeniedException.class).when((Object)this.mockHandler)).handleListObjects((URI)ArgumentMatchers.any(URI.class));
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        Assert.assertThrows(AccessDeniedException.class, () -> authorizer.authorize((StorageRequest)list));
    }

    @Test
    public void testListObject() throws Exception {
        Storage.Objects.List list = StorageRequestAuthorizerTest.newStorage().objects().list(BUCKET_NAME).setPrefix(OBJECT_NAME);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)list);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleListObjects((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
    }

    @Test
    public void testInsertObject() throws Exception {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Insert insert = StorageRequestAuthorizerTest.newStorage().objects().insert(BUCKET_NAME, object);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)insert);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleInsertObject((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
    }

    @Test
    public void testComposeObject() throws Exception {
        List sourceObjects = (List)Stream.of(0, 1, 2).map(x -> new ComposeRequest.SourceObjects().setName("/dir/test-object-" + x)).collect(ImmutableList.toImmutableList());
        ComposeRequest request = new ComposeRequest().setSourceObjects(sourceObjects);
        Storage.Objects.Compose compose = StorageRequestAuthorizerTest.newStorage().objects().compose(BUCKET_NAME, OBJECT_NAME, request);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)compose);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ArgumentCaptor listCaptor = ArgumentCaptor.forClass(ArrayList.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleComposeObject((URI)captor.capture(), (List)listCaptor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
        for (int i = 0; i < 3; ++i) {
            Truth.assertThat((String)((URI)((List)listCaptor.getValue()).get(i)).getAuthority()).isEqualTo((Object)BUCKET_NAME);
            Truth.assertThat((String)((URI)((List)listCaptor.getValue()).get(i)).getPath()).isEqualTo((Object)("/dir/test-object-" + i));
        }
    }

    @Test
    public void testGetObject() throws Exception {
        Storage.Objects.Get get = StorageRequestAuthorizerTest.newStorage().objects().get(BUCKET_NAME, OBJECT_NAME);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)get);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleGetObject((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
    }

    @Test
    public void testDeleteObject() throws Exception {
        Storage.Objects.Delete delete = StorageRequestAuthorizerTest.newStorage().objects().delete(BUCKET_NAME, OBJECT_NAME);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)delete);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleDeleteObject((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
    }

    @Test
    public void testRewriteObject() throws Exception {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Rewrite rewrite = StorageRequestAuthorizerTest.newStorage().objects().rewrite(BUCKET_NAME, OBJECT_NAME, BUCKET_NAME_DST, OBJECT_NAME_DST, object);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)rewrite);
        ArgumentCaptor sourceCaptor = ArgumentCaptor.forClass(URI.class);
        ArgumentCaptor destinationCaptor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleRewriteObject((URI)sourceCaptor.capture(), (URI)destinationCaptor.capture());
        Truth.assertThat((String)((URI)sourceCaptor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)sourceCaptor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
        Truth.assertThat((String)((URI)destinationCaptor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME_DST);
        Truth.assertThat((String)((URI)destinationCaptor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME_DST);
    }

    @Test
    public void testCopyObject() throws Exception {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Copy copy = StorageRequestAuthorizerTest.newStorage().objects().copy(BUCKET_NAME, OBJECT_NAME, BUCKET_NAME_DST, OBJECT_NAME_DST, object);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)copy);
        ArgumentCaptor sourceCaptor = ArgumentCaptor.forClass(URI.class);
        ArgumentCaptor destinationCaptor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleCopyObject((URI)sourceCaptor.capture(), (URI)destinationCaptor.capture());
        Truth.assertThat((String)((URI)sourceCaptor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)sourceCaptor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
        Truth.assertThat((String)((URI)destinationCaptor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME_DST);
        Truth.assertThat((String)((URI)destinationCaptor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME_DST);
    }

    @Test
    public void testPatchObject() throws Exception {
        StorageObject object = new StorageObject().setName(OBJECT_NAME);
        Storage.Objects.Patch patch = StorageRequestAuthorizerTest.newStorage().objects().patch(BUCKET_NAME, OBJECT_NAME, object);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)patch);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handlePatchObject((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)OBJECT_NAME);
    }

    @Test
    public void testListBucket() throws Exception {
        Storage.Buckets.List list = StorageRequestAuthorizerTest.newStorage().buckets().list(PROJECT);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)list);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleListBuckets((String)ArgumentMatchers.eq((Object)PROJECT));
    }

    @Test
    public void testInsertBucket() throws Exception {
        Bucket bucket = new Bucket().setName(BUCKET_NAME);
        Storage.Buckets.Insert insert = StorageRequestAuthorizerTest.newStorage().buckets().insert(BUCKET_NAME, bucket).setProject(PROJECT);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)insert);
        ArgumentCaptor projectCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleInsertBucket((String)projectCaptor.capture(), (URI)captor.capture());
        Truth.assertThat((String)((String)projectCaptor.getValue())).isEqualTo((Object)PROJECT);
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)"/");
    }

    @Test
    public void testGetBucket() throws Exception {
        Storage.Buckets.Get get = StorageRequestAuthorizerTest.newStorage().buckets().get(BUCKET_NAME);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)get);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleGetBucket((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)"/");
    }

    @Test
    public void testDeleteBucket() throws Exception {
        Storage.Buckets.Delete delete = StorageRequestAuthorizerTest.newStorage().buckets().delete(BUCKET_NAME);
        StorageRequestAuthorizer authorizer = new StorageRequestAuthorizer(this.mockHandler);
        authorizer.authorize((StorageRequest)delete);
        ArgumentCaptor captor = ArgumentCaptor.forClass(URI.class);
        ((AuthorizationHandler)Mockito.verify((Object)this.mockHandler)).handleDeleteBucket((URI)captor.capture());
        Truth.assertThat((String)((URI)captor.getValue()).getAuthority()).isEqualTo((Object)BUCKET_NAME);
        Truth.assertThat((String)((URI)captor.getValue()).getPath()).isEqualTo((Object)"/");
    }

    private static Storage newStorage() {
        return new Storage(HTTP_TRANSPORT, JSON_FACTORY, null);
    }

    public static class BrokenAuthorizationHandler
    extends FakeAuthorizationHandler {
        public BrokenAuthorizationHandler(Object ignore) {
        }
    }
}

