/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import cz.o2.proxima.internal.shaded.com.google.common.base.Equivalence;
import cz.o2.proxima.internal.shaded.com.google.common.base.Supplier;
import cz.o2.proxima.internal.shaded.com.google.common.base.Suppliers;
import cz.o2.proxima.internal.shaded.com.google.common.cache.CacheBuilder;
import cz.o2.proxima.internal.shaded.com.google.common.cache.CacheLoader;
import cz.o2.proxima.internal.shaded.com.google.common.cache.LoadingCache;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Iterables;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.collect.MapDifference;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Maps;
import cz.o2.proxima.internal.shaded.com.google.common.hash.HashCode;
import cz.o2.proxima.internal.shaded.com.google.common.hash.Hashing;
import cz.o2.proxima.internal.shaded.com.google.common.primitives.Bytes;
import cz.o2.proxima.internal.shaded.com.google.common.primitives.Ints;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GoogleCloudStorageTest {
    private static final String BUCKET_NAME_PREFIX = "gcsio-it";
    private static final ListObjectOptions INCLUDE_PREFIX_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).build();
    private static final Supplier<GoogleCloudStorageTestHelper.TestBucketHelper> BUCKET_HELPER = Suppliers.memoize(() -> new GoogleCloudStorageTestHelper.TestBucketHelper(BUCKET_NAME_PREFIX));
    private static final LoadingCache<GoogleCloudStorage, String> SHARED_BUCKETS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<GoogleCloudStorage, String>(){

        public String load(GoogleCloudStorage gcs) throws Exception {
            return GoogleCloudStorageTest.createUniqueBucket(gcs, "shared");
        }
    });
    public static final Equivalence<byte[]> BYTE_ARRAY_EQUIVALENCE = new Equivalence<byte[]>(){

        protected boolean doEquivalent(byte[] bytes, byte[] bytes2) {
            return Arrays.equals(bytes, bytes2);
        }

        protected int doHash(byte[] bytes) {
            return Arrays.hashCode(bytes);
        }
    };
    private final GoogleCloudStorage rawStorage;

    private static String createUniqueBucket(GoogleCloudStorage gcs, String suffix) throws IOException {
        String bucketName = GoogleCloudStorageTest.getUniqueBucketName(suffix) + "_" + gcs.hashCode();
        gcs.createBucket(bucketName);
        return bucketName;
    }

    private String createUniqueBucket(String suffix) throws IOException {
        return GoogleCloudStorageTest.createUniqueBucket(this.rawStorage, suffix);
    }

    private static String getUniqueBucketName(String suffix) {
        return ((GoogleCloudStorageTestHelper.TestBucketHelper)BUCKET_HELPER.get()).getUniqueBucketName(suffix);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConstructorArguments() throws IOException {
        return Arrays.asList({new InMemoryGoogleCloudStorage()}, {new PerformanceCachingGoogleCloudStorage((GoogleCloudStorage)new InMemoryGoogleCloudStorage(), PerformanceCachingGoogleCloudStorageOptions.DEFAULT)});
    }

    public GoogleCloudStorageTest(GoogleCloudStorage rawStorage) {
        this.rawStorage = rawStorage;
    }

    @Before
    public void setUp() {
        if (this.rawStorage instanceof PerformanceCachingGoogleCloudStorage) {
            ((PerformanceCachingGoogleCloudStorage)this.rawStorage).invalidateCache();
        }
    }

    @AfterClass
    public static void cleanupBuckets() throws IOException {
        ((GoogleCloudStorageTestHelper.TestBucketHelper)BUCKET_HELPER.get()).cleanup((GoogleCloudStorage)Iterables.getLast(SHARED_BUCKETS.asMap().keySet()));
    }

    private String getSharedBucketName() {
        return (String)SHARED_BUCKETS.getUnchecked((Object)this.rawStorage);
    }

    @Test
    public void testCreateSuccessfulBucket() throws IOException {
        String bucketName = this.createUniqueBucket("create-successful");
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "CreateTestObject");
        this.rawStorage.createEmptyObject(objectToCreate);
    }

    @Test
    public void testCreateExistingBucket() throws IOException {
        String bucketName = this.getSharedBucketName();
        Assert.assertThrows(IOException.class, () -> this.rawStorage.createBucket(bucketName));
    }

    @Test
    public void testCreateInvalidBucket() throws IOException {
        String bucketName = "--" + GoogleCloudStorageTest.getUniqueBucketName("create-invalid");
        Assert.assertThrows(IOException.class, () -> this.rawStorage.createBucket(bucketName));
    }

    @Test
    public void testCreateObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateObject_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCreate, objectBytes);
    }

    @Test
    public void testCreateInvalidObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateInvalidObject_InvalidObject\n");
        Assert.assertThrows(IOException.class, () -> GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 10));
    }

    @Test
    public void testCreateZeroLengthObjectUsingCreate() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateZeroLengthObjectUsingCreate_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 0);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCreate, objectBytes);
    }

    @Test
    public void testCreate1PageLengthObjectUsingCreate() throws IOException {
        String bucketName = this.getSharedBucketName();
        int objectSize = 0x100000;
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreate1PageLengthObjectUsingCreate_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, objectSize);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCreate, objectBytes);
    }

    @Test
    public void testCreate1PageLengthPlus1byteObjectUsingCreate() throws IOException {
        String bucketName = this.getSharedBucketName();
        int objectSize = 0x100001;
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreate1PageLengthPlus1byteObjectUsingCreate_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, objectSize);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCreate, objectBytes);
    }

    @Test
    public void testCreateExistingObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateExistingObject_Object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 128);
        byte[] overwriteBytesToWrite = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 256);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCreate, overwriteBytesToWrite);
    }

    @Test
    public void testCreateEmptyObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateEmptyObject_Object");
        this.rawStorage.createEmptyObject(objectToCreate);
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        Truth.assertThat((Boolean)itemInfo.exists()).isTrue();
        Truth.assertThat((Long)itemInfo.getSize()).isEqualTo((Object)0);
    }

    @Test
    public void testCreateEmptyObjects() throws IOException {
        String bucketName = this.getSharedBucketName();
        ArrayList storageResourceIds = Lists.newArrayList((Object[])new StorageResourceId[]{new StorageResourceId(bucketName, "testCreateEmptyObjects_Object1"), new StorageResourceId(bucketName, "testCreateEmptyObjects_Object2")});
        this.rawStorage.createEmptyObjects((List)storageResourceIds);
        this.rawStorage.getItemInfos((List)storageResourceIds).forEach(itemInfo -> {
            Truth.assertWithMessage((String)"%s should be empty", (Object[])new Object[]{itemInfo}).that(Boolean.valueOf(itemInfo.exists())).isTrue();
            Truth.assertWithMessage((String)"%s should be empty", (Object[])new Object[]{itemInfo}).that(Long.valueOf(itemInfo.getSize())).isEqualTo((Object)0);
        });
    }

    @Test
    public void testCreateEmptyObjectsWithOptions() throws IOException {
        String bucketName = this.getSharedBucketName();
        ArrayList storageResourceIds = Lists.newArrayList((Object[])new StorageResourceId[]{new StorageResourceId(bucketName, "testCreateEmptyObjectsWithOptions_Object1"), new StorageResourceId(bucketName, "testCreateEmptyObjectsWithOptions_Object2")});
        this.rawStorage.createEmptyObjects((List)storageResourceIds, CreateObjectOptions.DEFAULT_OVERWRITE);
        this.rawStorage.getItemInfos((List)storageResourceIds).forEach(itemInfo -> {
            Truth.assertWithMessage((String)"%s should be empty", (Object[])new Object[]{itemInfo}).that(Boolean.valueOf(itemInfo.exists())).isTrue();
            Truth.assertWithMessage((String)"%s should be empty", (Object[])new Object[]{itemInfo}).that(Long.valueOf(itemInfo.getSize())).isEqualTo((Object)0);
        });
    }

    @Test
    public void testGetOptions() {
        GoogleCloudStorageOptions options = this.rawStorage.getOptions();
        Truth.assertThat((String)options.getAppName()).startsWith("GHFS/");
    }

    @Test
    public void testOpenFileWithMatchingSize() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testOpenFileWithMatchingSize_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        try (SeekableByteChannel channel = this.rawStorage.open(objectToCreate);){
            Truth.assertThat((Long)channel.size()).isEqualTo((Object)objectBytes.length);
        }
    }

    @Test
    public void testOpenFileWithMatchingSizeAndSpecifiedReadOptions() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testOpenFileWithMatchingSizeAndSpecifiedReadOptions_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        try (SeekableByteChannel channel = this.rawStorage.open(objectToCreate, GoogleCloudStorageReadOptions.DEFAULT);){
            Truth.assertThat((Long)channel.size()).isEqualTo((Object)objectBytes.length);
        }
    }

    @Test
    public void listObjectInfo() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "listObjectInfo_test_object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        List listedObjects = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_test_");
        Truth.assertThat((Iterable)listedObjects.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{objectToCreate.getObjectName()});
    }

    @Test
    public void listObjectInfo_includePrefix() throws IOException {
        String bucketName = this.getSharedBucketName();
        String prefix = "listObjectInfo_includePrefix_test_";
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, prefix + "object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        List listedObjects = this.rawStorage.listObjectInfo(bucketName, prefix, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat((Iterable)listedObjects.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{prefix, objectToCreate.getObjectName()}).inOrder();
    }

    @Test
    public void listObjectInfoPage() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "listObjectInfoPage_test_object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        GoogleCloudStorage.ListPage listedObjectsPage = this.rawStorage.listObjectInfoPage(bucketName, "listObjectInfoPage_test_", "");
        Truth.assertThat((String)listedObjectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)listedObjectsPage.getItems().stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{objectToCreate.getObjectName()});
    }

    @Test
    public void listObjectInfoPage_includePrefix() throws IOException {
        String bucketName = this.getSharedBucketName();
        String prefix = "listObjectInfoPage_includePrefix_test_";
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, prefix + "object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 512);
        GoogleCloudStorage.ListPage listedObjectsPage = this.rawStorage.listObjectInfoPage(bucketName, prefix, INCLUDE_PREFIX_LIST_OPTIONS, "");
        Truth.assertThat((String)listedObjectsPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)listedObjectsPage.getItems().stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{prefix, objectToCreate.getObjectName()}).inOrder();
    }

    @Test
    public void testComposeObjectsMovesObjectToAnother() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId srcObject = new StorageResourceId(bucketName, "testListObjectMovesObjectToAnother_srcObject");
        StorageResourceId dstObject = new StorageResourceId(bucketName, "testListObjectMovesObjectToAnother_dstObject");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, srcObject, 512);
        GoogleCloudStorageItemInfo composedObject = this.rawStorage.composeObjects((List)ImmutableList.of((Object)srcObject), dstObject, CreateObjectOptions.DEFAULT_OVERWRITE);
        Truth.assertThat((Boolean)composedObject.exists()).isTrue();
        Truth.assertThat((String)composedObject.getObjectName()).isEqualTo((Object)dstObject.getObjectName());
    }

    @Test
    public void testCreateWithOptions() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateWithOptions_Object");
        this.rawStorage.create(objectToCreate, CreateObjectOptions.DEFAULT_OVERWRITE).close();
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        Truth.assertThat((Boolean)itemInfo.exists()).isTrue();
        Truth.assertThat((String)itemInfo.getObjectName()).isEqualTo((Object)objectToCreate.getObjectName());
        Truth.assertThat((Long)itemInfo.getSize()).isEqualTo((Object)0);
    }

    @Test
    public void testCreateEmptyExistingObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCreateEmptyExistingObject_Object");
        this.rawStorage.createEmptyObject(objectToCreate);
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        Truth.assertThat((Boolean)itemInfo.exists()).isTrue();
        Truth.assertThat((Long)itemInfo.getSize()).isEqualTo((Object)0);
        this.rawStorage.createEmptyObject(objectToCreate);
        GoogleCloudStorageItemInfo secondItemInfo = this.rawStorage.getItemInfo(objectToCreate);
        Truth.assertThat((Boolean)secondItemInfo.exists()).isTrue();
        Truth.assertThat((Long)secondItemInfo.getSize()).isEqualTo((Object)0);
        Truth.assertThat((Long)secondItemInfo.getCreationTime()).isNotSameInstanceAs((Object)itemInfo.getCreationTime());
    }

    @Test
    public void testGetSingleItemInfo() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testGetSingleItemInfo_Object1");
        this.rawStorage.createEmptyObject(objectToCreate);
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        Truth.assertThat((Boolean)itemInfo.exists()).isTrue();
        Truth.assertThat((Long)itemInfo.getSize()).isEqualTo((Object)0);
        StorageResourceId secondObjectToCreate = new StorageResourceId(bucketName, "testGetSingleItemInfo_Object2");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, secondObjectToCreate, 100);
        GoogleCloudStorageItemInfo secondItemInfo = this.rawStorage.getItemInfo(secondObjectToCreate);
        Truth.assertThat((Boolean)secondItemInfo.exists()).isTrue();
        Truth.assertThat((Long)secondItemInfo.getSize()).isEqualTo((Object)100);
        Truth.assertThat((Boolean)secondItemInfo.isBucket()).isFalse();
        Truth.assertThat((Boolean)secondItemInfo.isRoot()).isFalse();
        GoogleCloudStorageItemInfo nonExistentItemInfo = this.rawStorage.getItemInfo(new StorageResourceId(bucketName, "testGetSingleItemInfo_IDontExist"));
        Truth.assertThat((Boolean)nonExistentItemInfo.exists()).isFalse();
        Truth.assertThat((Boolean)nonExistentItemInfo.isBucket()).isFalse();
        Truth.assertThat((Boolean)nonExistentItemInfo.isRoot()).isFalse();
        GoogleCloudStorageItemInfo bucketInfo = this.rawStorage.getItemInfo(new StorageResourceId(bucketName));
        Truth.assertThat((Boolean)bucketInfo.exists()).isTrue();
        Truth.assertThat((Boolean)bucketInfo.isBucket()).isTrue();
        GoogleCloudStorageItemInfo rootInfo = this.rawStorage.getItemInfo(StorageResourceId.ROOT);
        Truth.assertThat((Boolean)rootInfo.exists()).isTrue();
        Truth.assertThat((Boolean)rootInfo.isRoot()).isTrue();
    }

    @Test
    public void testGetMultipleItemInfo() throws IOException {
        String bucketName = this.getSharedBucketName();
        ArrayList<StorageResourceId> objectsCreated = new ArrayList<StorageResourceId>();
        for (int i = 0; i < 3; ++i) {
            StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testGetMultipleItemInfo_Object" + i);
            this.rawStorage.createEmptyObject(objectToCreate);
            objectsCreated.add(objectToCreate);
        }
        StorageResourceId bucketResourceId = new StorageResourceId(bucketName);
        StorageResourceId nonExistentResourceId = new StorageResourceId(bucketName, "testGetMultipleItemInfo_IDontExist");
        ArrayList allResources = Lists.newArrayList();
        allResources.addAll(objectsCreated);
        allResources.add(nonExistentResourceId);
        allResources.add(bucketResourceId);
        List allInfo = this.rawStorage.getItemInfos((List)allResources);
        for (int i = 0; i < objectsCreated.size(); ++i) {
            StorageResourceId resourceId = (StorageResourceId)objectsCreated.get(i);
            GoogleCloudStorageItemInfo info = (GoogleCloudStorageItemInfo)allInfo.get(i);
            Truth.assertThat((Object)info.getResourceId()).isEqualTo((Object)resourceId);
            Truth.assertThat((Long)info.getSize()).isEqualTo((Object)0);
            Truth.assertWithMessage((String)"Item should exist").that(Boolean.valueOf(info.exists())).isTrue();
            Truth.assertThat((Long)info.getCreationTime()).isNotEqualTo((Object)0);
            Truth.assertThat((Boolean)info.isBucket()).isFalse();
        }
        GoogleCloudStorageItemInfo nonExistentItemInfo = (GoogleCloudStorageItemInfo)allInfo.get(allInfo.size() - 2);
        Truth.assertThat((Boolean)nonExistentItemInfo.exists()).isFalse();
        GoogleCloudStorageItemInfo bucketInfo = (GoogleCloudStorageItemInfo)allInfo.get(allInfo.size() - 1);
        Truth.assertThat((Boolean)bucketInfo.exists()).isTrue();
        Truth.assertThat((Boolean)bucketInfo.isBucket()).isTrue();
    }

    @Test
    @Ignore
    public void testGetMultipleItemInfoWithSomeInvalid() throws IOException {
        String bucketName = this.getSharedBucketName();
        ArrayList<StorageResourceId> resourceIdList = new ArrayList<StorageResourceId>();
        StorageResourceId newObject = new StorageResourceId(bucketName, "testGetMultipleItemInfoWithSomeInvalid_Object");
        resourceIdList.add(newObject);
        this.rawStorage.createEmptyObject(newObject);
        StorageResourceId invalidObject = new StorageResourceId(bucketName, "testGetMultipleItemInfoWithSomeInvalid_InvalidObject\n");
        resourceIdList.add(invalidObject);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.rawStorage.getItemInfos(resourceIdList));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Error getting StorageObject");
    }

    @Test
    @Ignore
    public void testOneInvalidGetItemInfo() throws IOException {
        String bucketName = this.getSharedBucketName();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.rawStorage.getItemInfo(new StorageResourceId(bucketName, "testOneInvalidGetItemInfo_InvalidObject\n")));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Error accessing");
    }

    @Test
    public void testSingleObjectDelete() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resource = new StorageResourceId(bucketName, "testSingleObjectDelete_Object");
        this.rawStorage.createEmptyObject(resource);
        GoogleCloudStorageItemInfo info = this.rawStorage.getItemInfo(resource);
        Truth.assertThat((Boolean)info.exists()).isTrue();
        this.rawStorage.deleteObjects((List)ImmutableList.of((Object)resource));
        GoogleCloudStorageItemInfo deletedInfo = this.rawStorage.getItemInfo(resource);
        Truth.assertThat((Boolean)deletedInfo.exists()).isFalse();
    }

    @Test
    public void testMultipleObjectDelete() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resource = new StorageResourceId(bucketName, "testMultipleObjectDelete_Object1");
        this.rawStorage.createEmptyObject(resource);
        StorageResourceId secondResource = new StorageResourceId(bucketName, "testMultipleObjectDelete_Object2");
        this.rawStorage.createEmptyObject(secondResource);
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(resource).exists()).isTrue();
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(secondResource).exists()).isTrue();
        this.rawStorage.deleteObjects((List)ImmutableList.of((Object)resource, (Object)secondResource));
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(resource).exists()).isFalse();
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(secondResource).exists()).isFalse();
    }

    @Test
    @Ignore
    public void testSomeInvalidObjectsDelete() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resource = new StorageResourceId(bucketName, "testSomeInvalidObjectsDelete_Object");
        this.rawStorage.createEmptyObject(resource);
        StorageResourceId secondResource = new StorageResourceId(bucketName, "testSomeInvalidObjectsDelete_IDontExist");
        StorageResourceId invalidName = new StorageResourceId(bucketName, "testSomeInvalidObjectsDelete_InvalidObject\n");
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(resource).exists()).isTrue();
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(secondResource).exists()).isFalse();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.rawStorage.deleteObjects((List)ImmutableList.of((Object)resource, (Object)secondResource, (Object)invalidName)));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Error deleting");
    }

    @Test
    public void testDeleteNonExistingObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resource = new StorageResourceId(bucketName, "testDeleteNonExistingObject_IDontExist");
        this.rawStorage.deleteObjects((List)ImmutableList.of((Object)resource));
    }

    @Test
    public void testDeleteNonExistingBucket() throws IOException {
        String bucketName = GoogleCloudStorageTest.getUniqueBucketName("delete_ne_bucket");
        Assert.assertThrows(IOException.class, () -> this.rawStorage.deleteBuckets((List)ImmutableList.of((Object)bucketName)));
    }

    @Test
    public void testSingleDeleteBucket() throws IOException {
        String bucketName = this.createUniqueBucket("delete-single");
        this.rawStorage.deleteBuckets((List)ImmutableList.of((Object)bucketName));
        GoogleCloudStorageItemInfo info = this.rawStorage.getItemInfo(new StorageResourceId(bucketName));
        Truth.assertThat((Boolean)info.exists()).isFalse();
        this.rawStorage.createBucket(bucketName);
    }

    @Test
    public void testMultipleDeleteBucket() throws IOException {
        StorageResourceId bucket1 = new StorageResourceId(this.createUniqueBucket("delete-multi-1"));
        StorageResourceId bucket2 = new StorageResourceId(this.createUniqueBucket("delete-multi-2"));
        this.rawStorage.getItemInfos((List)ImmutableList.of((Object)bucket1, (Object)bucket2)).forEach(i -> Truth.assertWithMessage((String)"Expected to exist:%n%s", (Object[])new Object[]{i}).that(Boolean.valueOf(i.exists())).isTrue());
        this.rawStorage.deleteBuckets((List)ImmutableList.of((Object)bucket1.getBucketName(), (Object)bucket2.getBucketName()));
        this.rawStorage.getItemInfos((List)ImmutableList.of((Object)bucket1, (Object)bucket2)).forEach(i -> Truth.assertWithMessage((String)"Expected to not exist:%n%s", (Object[])new Object[]{i}).that(Boolean.valueOf(i.exists())).isFalse());
    }

    @Test
    public void testSomeInvalidDeleteBucket() throws IOException {
        String bucketName1 = this.createUniqueBucket("delete-multi-valid-1");
        String bucketName2 = this.createUniqueBucket("delete-multi-valid-2");
        String invalidBucketName = "--" + GoogleCloudStorageTest.getUniqueBucketName("delete-multi-invalid");
        Assert.assertThrows(IOException.class, () -> this.rawStorage.deleteBuckets((List)ImmutableList.of((Object)bucketName1, (Object)bucketName2, (Object)invalidBucketName)));
        List infoList = this.rawStorage.getItemInfos((List)ImmutableList.of((Object)new StorageResourceId(bucketName1), (Object)new StorageResourceId(bucketName2)));
        for (GoogleCloudStorageItemInfo info : infoList) {
            Truth.assertThat((Boolean)info.exists()).isFalse();
        }
    }

    @Test
    public void testListBucketInfo() throws IOException {
        String bucketName = this.getSharedBucketName();
        List infoList = this.rawStorage.listBucketInfo();
        Truth.assertWithMessage((String)"At least one bucket should exist").that((Iterable)infoList).isNotEmpty();
        boolean bucketListed = false;
        for (GoogleCloudStorageItemInfo info : infoList) {
            Truth.assertThat((Boolean)info.exists()).isTrue();
            Truth.assertThat((Boolean)info.isBucket()).isTrue();
            Truth.assertThat((Boolean)info.isRoot()).isFalse();
            bucketListed |= info.getBucketName().equals(bucketName);
        }
        Truth.assertThat((Boolean)bucketListed).isTrue();
    }

    @Test
    public void testListBucketNames() throws IOException {
        String bucketName = this.getSharedBucketName();
        List bucketNames = this.rawStorage.listBucketNames();
        Truth.assertWithMessage((String)"Bucket names should not be empty").that((Iterable)bucketNames).isNotEmpty();
        Truth.assertThat((Iterable)bucketNames).contains((Object)bucketName);
    }

    @Test
    public void listObjectInfo_limited() throws IOException {
        String[] names;
        String bucketName = this.getSharedBucketName();
        for (String name : names = new String[]{"x", "y", "z"}) {
            StorageResourceId id = new StorageResourceId(bucketName, "listObjectInfo_limited_test_" + name);
            this.rawStorage.createEmptyObject(id);
        }
        List info = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_limited_", ListObjectOptions.DEFAULT.toBuilder().setMaxResults(2L).build());
        Truth.assertThat((Iterable)info.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_limited_test_x", "listObjectInfo_limited_test_y"}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_limited() throws IOException {
        String[] names;
        String bucketName = this.getSharedBucketName();
        this.rawStorage.createEmptyObject(new StorageResourceId(bucketName, "listObjectInfo_includePrefix_limited_test_"));
        for (String name : names = new String[]{"x", "y", "z"}) {
            StorageResourceId id = new StorageResourceId(bucketName, "listObjectInfo_includePrefix_limited_test_" + name);
            this.rawStorage.createEmptyObject(id);
        }
        List info = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_includePrefix_limited_test_", ListObjectOptions.DEFAULT.toBuilder().setMaxResults(2L).build());
        Truth.assertThat((Iterable)info.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_includePrefix_limited_test_", "listObjectInfo_includePrefix_limited_test_x"}).inOrder();
    }

    @Test
    public void listObjectInfo_subdirectories() throws IOException {
        String[] names;
        String bucketName = this.getSharedBucketName();
        for (String name : names = new String[]{"listObjectInfo_subdirectories_test_", "listObjectInfo_subdirectories_test_d1/", "listObjectInfo_subdirectories_test_d1/o1", "listObjectInfo_subdirectories_test_d2/d3/", "listObjectInfo_subdirectories_test_d2/d3/o2"}) {
            StorageResourceId id = new StorageResourceId(bucketName, name);
            this.rawStorage.createEmptyObject(id);
        }
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(new StorageResourceId(bucketName, "listObjectInfo_subdirectories_test_d2/"));
        Truth.assertThat((Boolean)itemInfo.exists()).isFalse();
        List rootInfo = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_subdirectories_test_");
        Truth.assertWithMessage((String)"Infos not expected to be empty").that((Iterable)rootInfo.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_subdirectories_test_", "listObjectInfo_subdirectories_test_d1/", "listObjectInfo_subdirectories_test_d2/"}).inOrder();
        GoogleCloudStorageItemInfo d2Info = this.rawStorage.getItemInfo(new StorageResourceId(bucketName, "listObjectInfo_subdirectories_test_d2/"));
        Truth.assertThat((Boolean)d2Info.exists()).isEqualTo((Object)(this.rawStorage instanceof PerformanceCachingGoogleCloudStorage));
        List d2ItemInfos = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_subdirectories_test_d2/");
        Truth.assertWithMessage((String)"D2 item infos expected to be not empty").that((Iterable)d2ItemInfos.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_subdirectories_test_d2/d3/"});
        List d3ItemInfos = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_subdirectories_test_d2/d3/");
        Truth.assertWithMessage((String)"D3 item infos expected to be not empty").that((Iterable)d3ItemInfos.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_subdirectories_test_d2/d3/o2"});
        List blobNamesInfo = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_subdirectories_test_", ListObjectOptions.DEFAULT_FLAT_LIST);
        Truth.assertWithMessage((String)"blobNamesInfo not expected to be empty").that((Iterable)blobNamesInfo.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_subdirectories_test_", "listObjectInfo_subdirectories_test_d1/", "listObjectInfo_subdirectories_test_d1/o1", "listObjectInfo_subdirectories_test_d2/d3/", "listObjectInfo_subdirectories_test_d2/d3/o2"}).inOrder();
    }

    @Test
    public void listObjectInfo_includePrefix_subdirectories() throws IOException {
        String[] names;
        String bucketName = this.getSharedBucketName();
        for (String name : names = new String[]{"listObjectInfo_includePrefix_subdirectories_test_", "listObjectInfo_includePrefix_subdirectories_test_d1/", "listObjectInfo_includePrefix_subdirectories_test_d1/o1", "listObjectInfo_includePrefix_subdirectories_test_d2/d3/", "listObjectInfo_includePrefix_subdirectories_test_d2/d3/o2"}) {
            StorageResourceId id = new StorageResourceId(bucketName, name);
            this.rawStorage.createEmptyObject(id);
        }
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(new StorageResourceId(bucketName, "listObjectInfo_includePrefix_subdirectories_test_d2/"));
        Truth.assertThat((Boolean)itemInfo.exists()).isFalse();
        List rootInfo = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_includePrefix_subdirectories_test_", INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertWithMessage((String)"Infos not expected to be empty").that((Iterable)rootInfo.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_includePrefix_subdirectories_test_", "listObjectInfo_includePrefix_subdirectories_test_d1/", "listObjectInfo_includePrefix_subdirectories_test_d2/"}).inOrder();
        GoogleCloudStorageItemInfo d2Info = this.rawStorage.getItemInfo(new StorageResourceId(bucketName, "listObjectInfo_includePrefix_subdirectories_test_d2/"));
        Truth.assertThat((Boolean)d2Info.exists()).isEqualTo((Object)(this.rawStorage instanceof PerformanceCachingGoogleCloudStorage));
        List d2ItemInfos = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_includePrefix_subdirectories_test_d2/", INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertWithMessage((String)"D2 item infos expected to be not empty").that((Iterable)d2ItemInfos.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_includePrefix_subdirectories_test_d2/", "listObjectInfo_includePrefix_subdirectories_test_d2/d3/"}).inOrder();
        List d3ItemInfos = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_includePrefix_subdirectories_test_d2/d3/", INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertWithMessage((String)"D3 item infos expected to be not empty").that((Iterable)d3ItemInfos.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_includePrefix_subdirectories_test_d2/d3/", "listObjectInfo_includePrefix_subdirectories_test_d2/d3/o2"}).inOrder();
        List blobNamesInfo = this.rawStorage.listObjectInfo(bucketName, "listObjectInfo_includePrefix_subdirectories_test_", ListObjectOptions.DEFAULT_FLAT_LIST.toBuilder().setIncludePrefix(true).build());
        Truth.assertWithMessage((String)"blobNamesInfo not expected to be empty").that((Iterable)blobNamesInfo.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList())).containsExactly(new Object[]{"listObjectInfo_includePrefix_subdirectories_test_", "listObjectInfo_includePrefix_subdirectories_test_d1/", "listObjectInfo_includePrefix_subdirectories_test_d1/o1", "listObjectInfo_includePrefix_subdirectories_test_d2/d3/", "listObjectInfo_includePrefix_subdirectories_test_d2/d3/o2"}).inOrder();
    }

    @Test
    public void testCopySingleItem() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testCopySingleItem_SourceObject");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 4096);
        StorageResourceId copiedResourceId = new StorageResourceId(bucketName, "testCopySingleItem_DestinationObject");
        this.rawStorage.copy(bucketName, (List)ImmutableList.of((Object)objectToCreate.getObjectName()), bucketName, (List)ImmutableList.of((Object)copiedResourceId.getObjectName()));
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, copiedResourceId, objectBytes);
    }

    @Test
    public void testCopyToDifferentBucket() throws IOException {
        String sourceBucketName = this.getSharedBucketName();
        String destinationBucketName = this.createUniqueBucket("copy-destination");
        StorageResourceId objectToCreate = new StorageResourceId(sourceBucketName, "testCopyToDifferentBucket_SourceObject");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 4096);
        StorageResourceId copiedResourceId = new StorageResourceId(destinationBucketName, "testCopyToDifferentBucket_DestinationObject");
        this.rawStorage.copy(sourceBucketName, (List)ImmutableList.of((Object)objectToCreate.getObjectName()), destinationBucketName, (List)ImmutableList.of((Object)copiedResourceId.getObjectName()));
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, copiedResourceId, objectBytes);
    }

    @Test
    public void testCopySingleItemOverExistingItem() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCopy = new StorageResourceId(bucketName, "testCopySingleItemOverExistingItem_Object1");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCopy, 4096);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCopy, objectBytes);
        StorageResourceId secondObject = new StorageResourceId(bucketName, "testCopySingleItemOverExistingItem_Object2");
        byte[] secondObjectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, secondObject, 2046);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, secondObject, secondObjectBytes);
        this.rawStorage.copy(bucketName, (List)ImmutableList.of((Object)objectToCopy.getObjectName()), bucketName, (List)ImmutableList.of((Object)secondObject.getObjectName()));
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, secondObject, objectBytes);
    }

    @Test
    public void testCopySingleItemOverItself() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCopy = new StorageResourceId(bucketName, "testCopySingleItemOverItself_Object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCopy, 1024);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.rawStorage.copy(bucketName, (List)ImmutableList.of((Object)objectToCopy.getObjectName()), bucketName, (List)ImmutableList.of((Object)objectToCopy.getObjectName())));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("Copy destination must be different");
    }

    @Test
    public void testCopyMultipleItems() throws IOException {
        String bucketName = this.getSharedBucketName();
        int copyObjectCount = 3;
        ArrayList<CopyObjectData> objectsToCopy = new ArrayList<CopyObjectData>();
        for (int i = 0; i < 3; ++i) {
            String sourceObjectName = "testCopyMultipleItems_SourceObject" + i;
            String destinationObjectName = "testCopyMultipleItems_DestinationObject" + i;
            StorageResourceId sourceId = new StorageResourceId(bucketName, sourceObjectName);
            byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, sourceId, 1024 * i);
            StorageResourceId destinationId = new StorageResourceId(bucketName, destinationObjectName);
            objectsToCopy.add(new CopyObjectData(sourceId, destinationId, objectBytes));
        }
        List sourceObjects = Lists.transform(objectsToCopy, copyObjectData -> copyObjectData.sourceResourceId.getObjectName());
        List destinationObjects = Lists.transform(objectsToCopy, copyObjectData -> copyObjectData.destinationResourceId.getObjectName());
        this.rawStorage.copy(bucketName, sourceObjects, bucketName, destinationObjects);
        for (CopyObjectData copyObjectData2 : objectsToCopy) {
            GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, copyObjectData2.sourceResourceId, copyObjectData2.objectBytes);
            GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, copyObjectData2.destinationResourceId, copyObjectData2.objectBytes);
        }
    }

    @Test
    public void testCopyNonExistentItem() throws IOException {
        String bucketName = this.getSharedBucketName();
        String notExistentName = "testCopyNonExistentItem_IDontExist";
        Assert.assertThrows(FileNotFoundException.class, () -> this.rawStorage.copy(bucketName, (List)ImmutableList.of((Object)notExistentName), bucketName, (List)ImmutableList.of((Object)"testCopyNonExistentItem_DestinationObject")));
    }

    @Test
    public void testCopyMultipleItemsToSingleDestination() throws IOException {
        String bucketName = this.getSharedBucketName();
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.rawStorage.copy(bucketName, (List)ImmutableList.of((Object)"testCopyMultipleItemsToSingleDestination_SourceObject1", (Object)"testCopyMultipleItemsToSingleDestination_SourceObject2"), bucketName, (List)ImmutableList.of((Object)"testCopyMultipleItemsToSingleDestination_DestinationObject")));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("Must supply same number of elements");
    }

    @Test
    public void testOpen() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testOpen_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 100);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, objectToCreate, objectBytes);
    }

    @Test
    public void testOpenNonExistentItem() throws IOException {
        String bucketName = this.getSharedBucketName();
        Assert.assertThrows(FileNotFoundException.class, () -> this.rawStorage.open(new StorageResourceId(bucketName, "testOpenNonExistentItem_Object")));
    }

    @Test
    public void testOpenEmptyObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testOpenEmptyObject_Object");
        this.rawStorage.createEmptyObject(resourceId);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, resourceId, new byte[0]);
    }

    @Test
    public void testOpenLargeObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testOpenLargeObject_Object");
        int partitionsCount = 50;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 0xA00000, partitionsCount);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, resourceId, partition, partitionsCount);
    }

    @Test
    public void testPlusInObjectNames() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testPlusInObjectNames_An+Object");
        this.rawStorage.createEmptyObject(resourceId);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, resourceId, new byte[0]);
    }

    @Test
    public void testObjectPosition() throws IOException {
        int totalBytes = 1200;
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testObjectPosition_Object");
        byte[] data = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 1200);
        byte[] readBackingArray = new byte[1200];
        ByteBuffer readBuffer = ByteBuffer.wrap(readBackingArray);
        try (SeekableByteChannel readChannel = this.rawStorage.open(resourceId);){
            Truth.assertWithMessage((String)"Expected new file to open at position 0").that(Long.valueOf(readChannel.position())).isEqualTo((Object)0);
            Truth.assertWithMessage((String)"Unexpected readChannel.size()").that(Long.valueOf(readChannel.size())).isEqualTo((Object)1200);
            readBuffer.limit(4);
            int bytesRead = readChannel.read(readBuffer);
            Truth.assertWithMessage((String)"Unexpected number of bytes read").that(Integer.valueOf(bytesRead)).isEqualTo((Object)4);
            Truth.assertWithMessage((String)"Unexpected position after read()").that(Long.valueOf(readChannel.position())).isEqualTo((Object)4);
            Truth.assertWithMessage((String)"Unexpected readChannel.size()").that(Long.valueOf(readChannel.size())).isEqualTo((Object)1200);
            readChannel.position(4L);
            Truth.assertWithMessage((String)"Unexpected position after no-op").that(Long.valueOf(readChannel.position())).isEqualTo((Object)4);
            readChannel.position(6L);
            Truth.assertWithMessage((String)"Unexpected position after explicit position(6)").that(Long.valueOf(readChannel.position())).isEqualTo((Object)6);
            readChannel.position(data.length - 1);
            Truth.assertWithMessage((String)"Unexpected position after seek to EOF - 1").that(Long.valueOf(readChannel.position())).isEqualTo((Object)(data.length - 1));
            readBuffer.clear();
            bytesRead = readChannel.read(readBuffer);
            Truth.assertWithMessage((String)"Expected to read 1 byte").that(Integer.valueOf(bytesRead)).isEqualTo((Object)1);
            Truth.assertWithMessage((String)"Unexpected data read for last byte").that((Comparable)Byte.valueOf(readBackingArray[0])).isEqualTo((Object)data[data.length - 1]);
            bytesRead = readChannel.read(readBuffer);
            Truth.assertWithMessage((String)"Expected to read -1 bytes for EOF marker").that(Integer.valueOf(bytesRead)).isEqualTo((Object)-1);
            readChannel.position(0L);
            Truth.assertWithMessage((String)"Unexpected position after reset to 0").that(Long.valueOf(readChannel.position())).isEqualTo((Object)0);
            Assert.assertThrows(EOFException.class, () -> readChannel.position(-1L));
            Assert.assertThrows(EOFException.class, () -> readChannel.position(1200L));
        }
    }

    @Test
    public void testReadPartialObjects() throws IOException {
        int segmentSize = 553;
        int segmentCount = 5;
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testReadPartialObjects_Object");
        byte[] data = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 2765);
        byte[][] readSegments = new byte[5][553];
        try (SeekableByteChannel readChannel = this.rawStorage.open(resourceId);){
            for (int i = 0; i < 5; ++i) {
                ByteBuffer segmentBuffer = ByteBuffer.wrap(readSegments[i]);
                int bytesRead = readChannel.read(segmentBuffer);
                Truth.assertThat((Integer)bytesRead).isEqualTo((Object)553);
                byte[] expectedSegment = Arrays.copyOfRange(data, i * 553, i * 553 + 553);
                Truth.assertWithMessage((String)"Unexpected segment data read.").that(readSegments[i]).isEqualTo((Object)expectedSegment);
            }
        }
    }

    @Test
    public void testSpecialResourceIds() throws IOException {
        Truth.assertWithMessage((String)"Unexpected ROOT item info returned").that((Object)this.rawStorage.getItemInfo(StorageResourceId.ROOT)).isEqualTo((Object)GoogleCloudStorageItemInfo.ROOT_INFO);
        Assert.assertThrows(IllegalArgumentException.class, () -> StringPaths.fromComponents(null, (String)"objectName"));
    }

    @Test
    public void testChannelClosedException() throws IOException {
        int totalBytes = 1200;
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testChannelClosedException_Object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 1200);
        byte[] readArray = new byte[1200];
        SeekableByteChannel readableByteChannel = this.rawStorage.open(resourceId);
        ByteBuffer readBuffer = ByteBuffer.wrap(readArray);
        readBuffer.limit(5);
        readableByteChannel.read(readBuffer);
        Truth.assertThat((Long)readableByteChannel.position()).isEqualTo((Object)readBuffer.position());
        readableByteChannel.close();
        readBuffer.clear();
        Assert.assertThrows(ClosedChannelException.class, () -> readableByteChannel.read(readBuffer));
    }

    @Test
    @Ignore(value="Not implemented")
    public void testOperationsAfterCloseFail() {
    }

    @Test
    public void testMetadataIsWrittenWhenCreatingObjects() throws IOException {
        String bucketName = this.getSharedBucketName();
        byte[] bytesToWrite = new byte[100];
        GoogleCloudStorageTestHelper.fillBytes(bytesToWrite);
        ImmutableMap metadata = ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testUpdateItemInfoUpdatesMetadata_Object");
        try (WritableByteChannel channel = this.rawStorage.create(objectToCreate, CreateObjectOptions.builder().setMetadata((Map)metadata).build());){
            channel.write(ByteBuffer.wrap(bytesToWrite));
        }
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        GoogleCloudStorageTest.assertMapsEqual(metadata, itemInfo.getMetadata(), BYTE_ARRAY_EQUIVALENCE);
    }

    @Test
    public void testMetadataIsWrittenWhenCreatingEmptyObjects() throws IOException {
        String bucketName = this.getSharedBucketName();
        ImmutableMap metadata = ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testMetadataIsWrittenWhenCreatingEmptyObjects_Object");
        this.rawStorage.createEmptyObject(objectToCreate, CreateObjectOptions.builder().setMetadata((Map)metadata).build());
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        GoogleCloudStorageTest.assertMapsEqual(metadata, itemInfo.getMetadata(), BYTE_ARRAY_EQUIVALENCE);
    }

    @Test
    public void testUpdateItemInfoUpdatesMetadata() throws IOException {
        String bucketName = this.getSharedBucketName();
        ImmutableMap metadata = ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        StorageResourceId objectToCreate = new StorageResourceId(bucketName, "testUpdateItemInfoUpdatesMetadata_Object");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, objectToCreate, 100);
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        Truth.assertWithMessage((String)"initial metadata should be empty").that(itemInfo.getMetadata()).isEmpty();
        List results = this.rawStorage.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(objectToCreate, (Map)metadata)));
        Truth.assertThat((Iterable)results).hasSize(1);
        GoogleCloudStorageTest.assertMapsEqual(metadata, ((GoogleCloudStorageItemInfo)results.get(0)).getMetadata(), BYTE_ARRAY_EQUIVALENCE);
        itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        GoogleCloudStorageTest.assertMapsEqual(metadata, itemInfo.getMetadata(), BYTE_ARRAY_EQUIVALENCE);
        HashMap<String, Object> deletionMap = new HashMap<String, Object>();
        deletionMap.put("key1", null);
        this.rawStorage.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(objectToCreate, deletionMap)));
        itemInfo = this.rawStorage.getItemInfo(objectToCreate);
        GoogleCloudStorageTest.assertMapsEqual(ImmutableMap.of((Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8)), itemInfo.getMetadata(), BYTE_ARRAY_EQUIVALENCE);
    }

    @Test
    public void testGetBeforeAndAfterCreateObject() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(this.getSharedBucketName(), "testGetBeforeAndAfterCreateObject_Object");
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(resourceId).exists()).isFalse();
        byte[] objectContent = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 512);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, resourceId, objectContent);
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(resourceId);
        Truth.assertThat((Boolean)itemInfo.exists()).isTrue();
        Truth.assertThat((Long)itemInfo.getSize()).isEqualTo((Object)512);
    }

    @Test
    public void testGetMultipleBeforeAndAfterCreateObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        ImmutableList resourceIds = ImmutableList.of((Object)new StorageResourceId(bucketName, "testGetMultipleBeforeAndAfterCreateObject_Object1"), (Object)new StorageResourceId(bucketName, "testGetMultipleBeforeAndAfterCreateObject_Object2"), (Object)new StorageResourceId(bucketName, "testGetMultipleBeforeAndAfterCreateObject_Object3"));
        for (GoogleCloudStorageItemInfo itemInfo : this.rawStorage.getItemInfos((List)resourceIds)) {
            Truth.assertThat((Boolean)itemInfo.exists()).isFalse();
        }
        this.rawStorage.createEmptyObjects((List)resourceIds);
        List itemInfos = this.rawStorage.getItemInfos((List)resourceIds);
        for (int i = 0; i < resourceIds.size(); ++i) {
            StorageResourceId resourceId = (StorageResourceId)resourceIds.get(i);
            GoogleCloudStorageItemInfo itemInfo = (GoogleCloudStorageItemInfo)itemInfos.get(i);
            Truth.assertThat((Object)itemInfo.getResourceId()).isEqualTo((Object)resourceId);
            Truth.assertThat((Long)itemInfo.getSize()).isEqualTo((Object)0);
            Truth.assertThat((Boolean)itemInfo.exists()).isTrue();
            Truth.assertThat((Long)itemInfo.getCreationTime()).isNotEqualTo((Object)0);
            Truth.assertThat((Boolean)itemInfo.isBucket()).isFalse();
            Truth.assertThat((Boolean)itemInfo.isDirectory()).isFalse();
        }
    }

    @Test
    public void testListObjectInfoBeforeAndAfterCreate() throws IOException {
        String bucketName = this.getSharedBucketName();
        String objectName = "testListObjectInfoBeforeAndAfterCreate_";
        ImmutableList resourceIds = ImmutableList.of((Object)new StorageResourceId(bucketName, objectName + "x"), (Object)new StorageResourceId(bucketName, objectName + "y"), (Object)new StorageResourceId(bucketName, objectName + "z"));
        Truth.assertThat((Iterable)this.rawStorage.listObjectInfo(bucketName, objectName)).isEmpty();
        this.rawStorage.createEmptyObjects((List)resourceIds);
        Truth.assertThat((Iterable)this.rawStorage.listObjectInfo(bucketName, objectName)).hasSize(3);
    }

    @Test
    public void testlistObjectInfoPageBeforeAndAfterCreate() throws IOException {
        String bucketName = this.getSharedBucketName();
        String objectName = "testlistObjectInfoPageBeforeAndAfterCreate_Object";
        StorageResourceId resourceId = new StorageResourceId(bucketName, objectName);
        GoogleCloudStorage.ListPage itemInfosPage = this.rawStorage.listObjectInfoPage(bucketName, objectName, null);
        Truth.assertThat((String)itemInfosPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)itemInfosPage.getItems()).isEmpty();
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 512);
        itemInfosPage = this.rawStorage.listObjectInfoPage(bucketName, objectName, null);
        Truth.assertThat((String)itemInfosPage.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)itemInfosPage.getItems()).hasSize(1);
        Truth.assertThat((Object)((GoogleCloudStorageItemInfo)itemInfosPage.getItems().get(0)).getResourceId()).isEqualTo((Object)resourceId);
    }

    @Test
    public void testOverwriteExistingObject() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId resourceId = new StorageResourceId(bucketName, "testOverwriteExistingObject_Object");
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(resourceId).exists()).isFalse();
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 128);
        GoogleCloudStorageItemInfo createdItemInfo = this.rawStorage.getItemInfo(resourceId);
        Truth.assertThat((Boolean)createdItemInfo.exists()).isTrue();
        Truth.assertThat((Long)createdItemInfo.getSize()).isEqualTo((Object)128);
        byte[] objectContent = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, resourceId, 256);
        GoogleCloudStorageItemInfo overwrittenItemInfo = this.rawStorage.getItemInfo(resourceId);
        Truth.assertThat((Boolean)overwrittenItemInfo.exists()).isTrue();
        Truth.assertThat((Long)overwrittenItemInfo.getSize()).isEqualTo((Object)256);
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, resourceId, objectContent);
    }

    @Test
    public void testMoveSingleItem() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId srcResourceId = new StorageResourceId(bucketName, "testMoveSingleItem_src");
        StorageResourceId dstResourceId = new StorageResourceId(bucketName, "testMoveSingleItem_dst");
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(srcResourceId).exists()).isFalse();
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(dstResourceId).exists()).isFalse();
        byte[] objectContent = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, srcResourceId, 4096);
        this.rawStorage.copy(bucketName, (List)ImmutableList.of((Object)srcResourceId.getObjectName()), bucketName, (List)ImmutableList.of((Object)dstResourceId.getObjectName()));
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(srcResourceId).exists()).isTrue();
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(dstResourceId).exists()).isTrue();
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, dstResourceId, objectContent);
        this.rawStorage.deleteObjects((List)ImmutableList.of((Object)srcResourceId));
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(srcResourceId).exists()).isFalse();
        Truth.assertThat((Boolean)this.rawStorage.getItemInfo(dstResourceId).exists()).isTrue();
    }

    @Test
    public void testCompose() throws Exception {
        String bucketName = this.getSharedBucketName();
        StorageResourceId destinationObject = new StorageResourceId(bucketName, "testCompose_DestinationObject");
        StorageResourceId sourceObject1 = new StorageResourceId(bucketName, "testCompose_SourceObject1");
        byte[] content1 = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, sourceObject1, 50);
        StorageResourceId sourceObject2 = new StorageResourceId(bucketName, "testCompose_SourceObject2");
        byte[] content2 = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, sourceObject2, 150);
        this.rawStorage.compose(bucketName, (List)ImmutableList.of((Object)"testCompose_SourceObject1", (Object)"testCompose_SourceObject2"), destinationObject.getObjectName(), "application/octet-stream");
        GoogleCloudStorageTestHelper.assertObjectContent(this.rawStorage, destinationObject, Bytes.concat((byte[][])new byte[][]{content1, content2}));
    }

    @Test
    public void testObjectVerificationAttributes() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId testObject = new StorageResourceId(bucketName, "testObjectValidationAttributes_Object");
        byte[] objectBytes = GoogleCloudStorageTestHelper.writeObject(this.rawStorage, testObject, 1024);
        GoogleCloudStorageItemInfo itemInfo = this.rawStorage.getItemInfo(testObject);
        HashCode originalMd5 = Hashing.md5().hashBytes(objectBytes);
        HashCode originalCrc32c = Hashing.crc32c().hashBytes(objectBytes);
        byte[] bigEndianCrc32c = Ints.toByteArray((int)originalCrc32c.asInt());
        GoogleCloudStorageTestHelper.assertByteArrayEquals(originalMd5.asBytes(), itemInfo.getVerificationAttributes().getMd5hash());
        String originalCrc32cString = Integer.toHexString(Ints.fromByteArray((byte[])bigEndianCrc32c));
        String newCrc32cString = Integer.toHexString(Ints.fromByteArray((byte[])itemInfo.getVerificationAttributes().getCrc32c()));
        Truth.assertThat((String)newCrc32cString).isEqualTo((Object)originalCrc32cString);
        GoogleCloudStorageTestHelper.assertByteArrayEquals(bigEndianCrc32c, itemInfo.getVerificationAttributes().getCrc32c());
        VerificationAttributes expectedAttributes = new VerificationAttributes(originalMd5.asBytes(), bigEndianCrc32c);
        Truth.assertThat((Object)itemInfo.getVerificationAttributes()).isEqualTo((Object)expectedAttributes);
    }

    @Test
    public void googleCloudStorageItemInfo_equals() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId object1 = new StorageResourceId(bucketName, "testEquals_Object_1");
        StorageResourceId object2 = new StorageResourceId(bucketName, "testEquals_Object_2");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, object1, 1024);
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, object2, 1024);
        GoogleCloudStorageItemInfo itemInfo1 = this.rawStorage.getItemInfo(object1);
        GoogleCloudStorageItemInfo itemInfo2 = this.rawStorage.getItemInfo(object2);
        Truth.assertThat((Boolean)itemInfo1.equals((Object)itemInfo1)).isTrue();
        Truth.assertThat((Boolean)itemInfo1.equals((Object)itemInfo2)).isFalse();
    }

    @Test
    public void googleCloudStorageItemInfo_toString() throws IOException {
        String bucketName = this.getSharedBucketName();
        StorageResourceId object1 = new StorageResourceId(bucketName, "testToString_Object_1");
        StorageResourceId object2 = new StorageResourceId(bucketName, "testToString_Object_2");
        GoogleCloudStorageTestHelper.writeObject(this.rawStorage, object1, 1024);
        GoogleCloudStorageItemInfo itemInfo1 = this.rawStorage.getItemInfo(object1);
        GoogleCloudStorageItemInfo itemInfo2 = this.rawStorage.getItemInfo(object2);
        Truth.assertThat((Boolean)itemInfo1.exists()).isTrue();
        Truth.assertThat((String)itemInfo1.toString()).contains((CharSequence)"created on:");
        Truth.assertThat((Boolean)itemInfo2.exists()).isFalse();
        Truth.assertThat((String)itemInfo2.toString()).contains((CharSequence)"exists: no");
    }

    static <K, V> void assertMapsEqual(Map<K, V> expected, Map<K, V> result, Equivalence<V> valueEquivalence) {
        MapDifference diff = Maps.difference(expected, result, valueEquivalence);
        if (!diff.areEqual()) {
            Assert.fail((String)String.format("Maps differ. Entries differing: %s%nMissing entries: %s%nExtra entries: %s%n", diff.entriesDiffering(), diff.entriesOnlyOnLeft(), diff.entriesOnlyOnRight()));
        }
    }

    static class CopyObjectData {
        public final StorageResourceId sourceResourceId;
        public final StorageResourceId destinationResourceId;
        public final byte[] objectBytes;

        CopyObjectData(StorageResourceId sourceResourceId, StorageResourceId destinationResourceId, byte[] objectBytes) {
            this.sourceResourceId = sourceResourceId;
            this.destinationResourceId = destinationResourceId;
            this.objectBytes = objectBytes;
        }
    }
}

