/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.services.iamcredentials.v1.model.GenerateAccessTokenResponse;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.GoogleCredentialWithIamAccessToken;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class GoogleCredentialWithIamAccessTokenTest {
    private static final String TEST_ACCESS_TOKEN = "test.token";
    public static final long TEST_TIME_MILLISECONDS = 2000L;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCreateCredentialFromIamAccessToken() throws IOException {
        GenerateAccessTokenResponse accessTokenRes = new GenerateAccessTokenResponse();
        accessTokenRes.setAccessToken(TEST_ACCESS_TOKEN);
        accessTokenRes.setExpireTime("1970-01-01T00:00:02Z");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)accessTokenRes)});
        GoogleCredentialWithIamAccessToken credential = new GoogleCredentialWithIamAccessToken((HttpTransport)transport, ignore -> {}, "test-service-account", CredentialFactory.DEFAULT_SCOPES);
        Truth.assertThat((String)credential.getAccessToken()).isEqualTo((Object)TEST_ACCESS_TOKEN);
        Truth.assertThat((Long)credential.getExpirationTimeMilliseconds()).isEqualTo((Object)2000L);
    }

    @Test
    public void testCreateCredentialFromIamAccessTokenWithoutExpirationTime() throws IOException {
        GenerateAccessTokenResponse accessTokenRes = new GenerateAccessTokenResponse();
        accessTokenRes.setAccessToken(TEST_ACCESS_TOKEN);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)accessTokenRes)});
        GoogleCredentialWithIamAccessToken credential = new GoogleCredentialWithIamAccessToken((HttpTransport)transport, ignore -> {}, "test-service-account", CredentialFactory.DEFAULT_SCOPES);
        Truth.assertThat((String)credential.getAccessToken()).isEqualTo((Object)TEST_ACCESS_TOKEN);
    }

    @Test
    public void testCreateCredentialFromIamAccessTokenThrowsExceptionForNullToken() throws IOException {
        GenerateAccessTokenResponse accessTokenRes = new GenerateAccessTokenResponse();
        accessTokenRes.setExpireTime("1970-01-01T00:00:02Z");
        accessTokenRes.setAccessToken(null);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)accessTokenRes)});
        Assert.assertThrows(NullPointerException.class, () -> new GoogleCredentialWithIamAccessToken((HttpTransport)transport, ignore -> {}, "test-service-account", CredentialFactory.DEFAULT_SCOPES));
    }
}

