/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.HttpTransportFactory;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HttpTransportFactoryTest {
    private static final FakeSslSocketFactory FAKE_SOCKET_FACTORY = new FakeSslSocketFactory();
    private static final String[] SUPPORTED_TEST_SUITES = new String[]{"testSuite"};
    private static final String[] DEFAULT_CIPHER_SUITES = new String[]{"testDefaultCipherSuite"};

    @Test
    public void testParseProxyAddress() throws Exception {
        String address = "foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI(null, "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressHttp() throws Exception {
        String address = "http://foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI("http", "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressHttps() throws Exception {
        String address = "https://foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI("https", "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressInvalidScheme() throws Exception {
        String address = "socks5://foo-host:1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"HTTP proxy address 'socks5://foo-host:1234' has invalid scheme 'socks5'.");
    }

    @Test
    public void testParseProxyAddressNoHost() throws Exception {
        String address = ":1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Proxy address ':1234' has no host.");
    }

    @Test
    public void testParseProxyAddressNoPort() throws Exception {
        String address = "foo-host";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Proxy address 'foo-host' has no port.");
    }

    @Test
    public void testParseProxyAddressInvalidSyntax() throws Exception {
        String address = "foo-host-with-illegal-char^:1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid proxy address 'foo-host-with-illegal-char^:1234'.");
    }

    @Test
    public void testParseProxyAddressWithPath() throws Exception {
        String address = "foo-host:1234/some/path";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid proxy address 'foo-host:1234/some/path'.");
    }

    @Test
    public void testKeepAliveSocketFactoryDefaultCipherSuites() {
        HttpTransportFactory.SslKeepAliveSocketFactory sslKeepAliveSocketFactory = new HttpTransportFactory.SslKeepAliveSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY);
        Truth.assertThat((Object[])sslKeepAliveSocketFactory.getDefaultCipherSuites()).isEqualTo((Object)DEFAULT_CIPHER_SUITES);
    }

    @Test
    public void testKeepAliveSocketFactorySupportedCipherSuites() {
        HttpTransportFactory.SslKeepAliveSocketFactory sslKeepAliveSocketFactory = new HttpTransportFactory.SslKeepAliveSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY);
        Truth.assertThat((Object[])sslKeepAliveSocketFactory.getSupportedCipherSuites()).isEqualTo((Object)SUPPORTED_TEST_SUITES);
    }

    @Test
    public void testKeepAliveSocketFactoryKeepAliveTrue() throws IOException {
        HttpTransportFactory.SslKeepAliveSocketFactory sslKeepAliveSocketFactory = new HttpTransportFactory.SslKeepAliveSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY);
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket().getKeepAlive()).isTrue();
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket(null, "localhost", 80, false).getKeepAlive()).isTrue();
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket(null, null, false).getKeepAlive()).isTrue();
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket("localhost", 80).getKeepAlive()).isTrue();
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket("localhost", 80, null, 443).getKeepAlive()).isTrue();
        InetAddress fakeInet = InetAddress.getByName("10.0.0.0");
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket(fakeInet, 443).getKeepAlive()).isTrue();
        Truth.assertThat((Boolean)sslKeepAliveSocketFactory.createSocket(fakeInet, 443, fakeInet, 80).getKeepAlive()).isTrue();
    }

    private static URI getURI(String scheme, String host, int port) throws URISyntaxException {
        return new URI(scheme, null, host, port, null, null, null);
    }

    private static class FakeSslSocketFactory
    extends SSLSocketFactory {
        private FakeSslSocketFactory() {
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return DEFAULT_CIPHER_SUITES;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return SUPPORTED_TEST_SUITES;
        }

        @Override
        public Socket createSocket() {
            return new Socket();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(Socket socket, InputStream inputStream, boolean b) throws IOException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.createSocket();
        }
    }
}

