/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.LazyExecutorService;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LazyExecutorServiceTest {
    private LazyExecutorService lazyExecutorService;

    @Before
    public void before() {
        this.lazyExecutorService = new LazyExecutorService();
    }

    @Test
    public void testConstructorWithBackingService() {
        this.lazyExecutorService = new LazyExecutorService((ExecutorService)new LazyExecutorService());
        Truth.assertThat((Boolean)this.lazyExecutorService.isShutdown()).isFalse();
    }

    @Test
    public void testIsTerminated() {
        this.lazyExecutorService.shutdown();
        Truth.assertThat((Boolean)this.lazyExecutorService.isTerminated()).isTrue();
    }

    @Test
    public void testAwaitTermination() throws Exception {
        Truth.assertThat((Boolean)this.lazyExecutorService.awaitTermination(1L, TimeUnit.MILLISECONDS)).isFalse();
        this.lazyExecutorService.shutdown();
        Truth.assertThat((Boolean)this.lazyExecutorService.awaitTermination(1L, TimeUnit.MILLISECONDS)).isTrue();
    }

    @Test
    public void testSubmitTask() {
        Future future = this.lazyExecutorService.submit(() -> {});
        Truth.assertThat((Boolean)future.isDone()).isTrue();
    }

    @Test
    public void testSubmitTaskWithResult() {
        Future future = this.lazyExecutorService.submit(() -> {}, null);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
    }

    @Test
    public void testInvokeAllSubmitAllTasks() throws Exception {
        ImmutableList tasks = ImmutableList.of(() -> null, () -> null);
        List futures = this.lazyExecutorService.invokeAll((Collection)tasks);
        Truth.assertThat((Iterable)futures).hasSize(2);
    }

    @Test
    public void testInvokeAllSubmitAllTasksWithTimeout() throws Exception {
        ImmutableList tasks = ImmutableList.of(() -> null, () -> null);
        List futures = this.lazyExecutorService.invokeAll((Collection)tasks, 1L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Iterable)futures).hasSize(2);
    }

    @Test
    public void testBackingService_shouldBeShutDownWithMainService() {
        LazyExecutorService backingService = new LazyExecutorService();
        this.lazyExecutorService = new LazyExecutorService((ExecutorService)backingService);
        backingService.shutdown();
        Truth.assertThat((Boolean)this.lazyExecutorService.isShutdown()).isTrue();
    }

    @Test
    public void testSubmitTaskToDeadExecutorService_shouldThrowRejectedExecutionException() {
        this.lazyExecutorService.shutdown();
        Assert.assertThrows(RejectedExecutionException.class, () -> this.lazyExecutorService.submit(() -> {}));
    }

    @Test
    public void testCancelledTask() {
        this.lazyExecutorService = new LazyExecutorService((ExecutorService)new LazyExecutorService());
        Future future = this.lazyExecutorService.submit(() -> {});
        this.lazyExecutorService.shutdownNow();
        Truth.assertThat((Boolean)future.isCancelled()).isTrue();
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Assert.assertThrows(CancellationException.class, future::get);
        Assert.assertThrows(CancellationException.class, () -> future.get(1L, TimeUnit.MILLISECONDS));
        Truth.assertThat((Boolean)future.cancel(true)).isFalse();
    }
}

