/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.cloud.hadoop.util.LoggingMediaHttpUploaderProgressListener;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayOutputStream;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LoggingMediaHttpUploaderProgressListenerTest {
    private static final Logger jdkLoggerForConfig = Logger.getLogger(LoggingMediaHttpUploaderProgressListener.class.getCanonicalName());
    private static final Formatter LOG_FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord record) {
            return record.getLevel() + ": " + record.getMessage();
        }
    };
    private LoggingMediaHttpUploaderProgressListener listener;
    private ByteArrayOutputStream logCapturingStream;
    private StreamHandler customLogHandler;

    @Before
    public void setUp() {
        this.listener = new LoggingMediaHttpUploaderProgressListener("NAME", 60000L);
        jdkLoggerForConfig.setLevel(Level.FINE);
        this.logCapturingStream = new ByteArrayOutputStream();
        this.customLogHandler = new StreamHandler(this.logCapturingStream, LOG_FORMATTER);
        this.customLogHandler.setLevel(Level.FINE);
        jdkLoggerForConfig.addHandler(this.customLogHandler);
    }

    @After
    public void verifyAndRemoveAssertingHandler() {
        jdkLoggerForConfig.removeHandler(this.customLogHandler);
    }

    @Test
    public void testLoggingInitiation() {
        this.listener.progressChanged(MediaHttpUploader.UploadState.INITIATION_STARTED, 0L, 0L);
        Truth.assertThat((String)this.getTestCapturedLog()).isEqualTo((Object)"FINE: Uploading: NAME");
    }

    @Test
    public void testLoggingProgressAfterSixtySeconds() {
        this.listener.progressChanged(MediaHttpUploader.UploadState.MEDIA_IN_PROGRESS, 0xA00000L, 60001L);
        Truth.assertThat((String)this.getTestCapturedLog()).isEqualTo((Object)"FINE: Uploading: NAME Average Rate: 0.167 MiB/s, Current Rate: 0.167 MiB/s, Total: 10.000 MiB");
        this.listener.progressChanged(MediaHttpUploader.UploadState.MEDIA_IN_PROGRESS, 0x6400000L, 120002L);
        Truth.assertThat((String)this.getTestCapturedLog()).isEqualTo((Object)"FINE: Uploading: NAME Average Rate: 0.833 MiB/s, Current Rate: 1.500 MiB/s, Total: 100.000 MiB");
    }

    @Test
    public void testSkippingLoggingAnInProgressUpdate() {
        this.listener.progressChanged(MediaHttpUploader.UploadState.MEDIA_IN_PROGRESS, 0x6400000L, 60000L);
        Truth.assertThat((String)this.getTestCapturedLog()).isEmpty();
    }

    @Test
    public void testLoggingCompletion() {
        this.listener.progressChanged(MediaHttpUploader.UploadState.MEDIA_COMPLETE, 0x6400000L, 60000L);
        Truth.assertThat((String)this.getTestCapturedLog()).isEqualTo((Object)"FINE: Finished Uploading: NAME");
    }

    @Test
    public void testOtherUpdatesIgnored() {
        this.listener.progressChanged(MediaHttpUploader.UploadState.NOT_STARTED, 0L, 60001L);
        this.listener.progressChanged(MediaHttpUploader.UploadState.INITIATION_COMPLETE, 0L, 60001L);
        Truth.assertThat((String)this.getTestCapturedLog()).isEmpty();
    }

    private String getTestCapturedLog() {
        this.customLogHandler.flush();
        try {
            String string = this.logCapturingStream.toString();
            return string;
        }
        finally {
            this.logCapturingStream.reset();
        }
    }
}

