/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.cloud.hadoop.util.RetryDeterminer;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryDeterminerTest {
    HttpResponseException makeHttpException(int status) throws IOException {
        MockHttpTransport.Builder builder = new MockHttpTransport.Builder();
        MockLowLevelHttpResponse resp = new MockLowLevelHttpResponse();
        resp.setStatusCode(status);
        builder.setLowLevelHttpResponse(resp);
        try {
            HttpResponse res = builder.build().createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).execute();
            return new HttpResponseException(res);
        }
        catch (HttpResponseException exception) {
            return exception;
        }
    }

    @Test
    public void defaultRetriesCorrectly() throws Exception {
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)new SocketTimeoutException())).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)new SSLException("test", new SocketException()))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)new SSLException("invalid certificate"))).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)new IllegalArgumentException())).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)new InterruptedException())).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)((Object)this.makeHttpException(300)))).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)((Object)this.makeHttpException(504)))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)((Object)this.makeHttpException(500)))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)((Object)this.makeHttpException(599)))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.DEFAULT.shouldRetry((Exception)((Object)this.makeHttpException(499)))).isFalse();
    }

    @Test
    public void socketRetriesCorrectly() throws IOException {
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)new SocketTimeoutException())).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)new SSLException("test", new SocketException()))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)new SSLException("invalid certificate"))).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)new IOException("Hey"))).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(300)))).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(504)))).isFalse();
    }

    @Test
    public void serverRetriesCorrectly() throws IOException {
        Truth.assertThat((Boolean)RetryDeterminer.SERVER_ERRORS.shouldRetry((Exception)new SocketTimeoutException())).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.SERVER_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(300)))).isFalse();
        Truth.assertThat((Boolean)RetryDeterminer.SERVER_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(504)))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SERVER_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(500)))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SERVER_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(599)))).isTrue();
        Truth.assertThat((Boolean)RetryDeterminer.SERVER_ERRORS.shouldRetry((Exception)((Object)this.makeHttpException(499)))).isFalse();
    }
}

