/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.AlertPolicyServiceClient;
import com.google.cloud.monitoring.v3.AlertPolicyServiceSettings;
import com.google.cloud.monitoring.v3.MockAlertPolicyService;
import com.google.monitoring.v3.AlertPolicy;
import com.google.monitoring.v3.AlertPolicyName;
import com.google.monitoring.v3.CreateAlertPolicyRequest;
import com.google.monitoring.v3.DeleteAlertPolicyRequest;
import com.google.monitoring.v3.FolderName;
import com.google.monitoring.v3.GetAlertPolicyRequest;
import com.google.monitoring.v3.ListAlertPoliciesRequest;
import com.google.monitoring.v3.ListAlertPoliciesResponse;
import com.google.monitoring.v3.MutationRecord;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.UpdateAlertPolicyRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlertPolicyServiceClientTest {
    private static MockAlertPolicyService mockAlertPolicyService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private AlertPolicyServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockAlertPolicyService = new MockAlertPolicyService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAlertPolicyService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        AlertPolicyServiceSettings settings = ((AlertPolicyServiceSettings.Builder)((AlertPolicyServiceSettings.Builder)AlertPolicyServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = AlertPolicyServiceClient.create((AlertPolicyServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listAlertPoliciesTest() throws Exception {
        AlertPolicy responsesElement = AlertPolicy.newBuilder().build();
        ListAlertPoliciesResponse expectedResponse = ListAlertPoliciesResponse.newBuilder().setNextPageToken("").addAllAlertPolicies(Arrays.asList(responsesElement)).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        AlertPolicyServiceClient.ListAlertPoliciesPagedResponse pagedListResponse = this.client.listAlertPolicies((ResourceName)name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAlertPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAlertPoliciesRequest actualRequest = (ListAlertPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAlertPoliciesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            this.client.listAlertPolicies((ResourceName)name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAlertPoliciesTest2() throws Exception {
        AlertPolicy responsesElement = AlertPolicy.newBuilder().build();
        ListAlertPoliciesResponse expectedResponse = ListAlertPoliciesResponse.newBuilder().setNextPageToken("").addAllAlertPolicies(Arrays.asList(responsesElement)).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        AlertPolicyServiceClient.ListAlertPoliciesPagedResponse pagedListResponse = this.client.listAlertPolicies(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAlertPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAlertPoliciesRequest actualRequest = (ListAlertPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAlertPoliciesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listAlertPolicies(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAlertPoliciesTest3() throws Exception {
        AlertPolicy responsesElement = AlertPolicy.newBuilder().build();
        ListAlertPoliciesResponse expectedResponse = ListAlertPoliciesResponse.newBuilder().setNextPageToken("").addAllAlertPolicies(Arrays.asList(responsesElement)).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        AlertPolicyServiceClient.ListAlertPoliciesPagedResponse pagedListResponse = this.client.listAlertPolicies(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAlertPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAlertPoliciesRequest actualRequest = (ListAlertPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAlertPoliciesExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.listAlertPolicies(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAlertPoliciesTest4() throws Exception {
        AlertPolicy responsesElement = AlertPolicy.newBuilder().build();
        ListAlertPoliciesResponse expectedResponse = ListAlertPoliciesResponse.newBuilder().setNextPageToken("").addAllAlertPolicies(Arrays.asList(responsesElement)).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AlertPolicyServiceClient.ListAlertPoliciesPagedResponse pagedListResponse = this.client.listAlertPolicies(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAlertPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAlertPoliciesRequest actualRequest = (ListAlertPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAlertPoliciesExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listAlertPolicies(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAlertPolicyTest() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        AlertPolicyName name = AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]");
        AlertPolicy actualResponse = this.client.getAlertPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAlertPolicyRequest actualRequest = (GetAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAlertPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            AlertPolicyName name = AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]");
            this.client.getAlertPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAlertPolicyTest2() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AlertPolicy actualResponse = this.client.getAlertPolicy(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAlertPolicyRequest actualRequest = (GetAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAlertPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAlertPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAlertPolicyTest() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
        AlertPolicy actualResponse = this.client.createAlertPolicy((ResourceName)name, alertPolicy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAlertPolicyRequest actualRequest = (CreateAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)alertPolicy, (Object)actualRequest.getAlertPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAlertPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
            this.client.createAlertPolicy((ResourceName)name, alertPolicy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAlertPolicyTest2() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
        AlertPolicy actualResponse = this.client.createAlertPolicy(name, alertPolicy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAlertPolicyRequest actualRequest = (CreateAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)alertPolicy, (Object)actualRequest.getAlertPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAlertPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
            this.client.createAlertPolicy(name, alertPolicy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAlertPolicyTest3() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
        AlertPolicy actualResponse = this.client.createAlertPolicy(name, alertPolicy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAlertPolicyRequest actualRequest = (CreateAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)alertPolicy, (Object)actualRequest.getAlertPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAlertPolicyExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
            this.client.createAlertPolicy(name, alertPolicy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAlertPolicyTest4() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
        AlertPolicy actualResponse = this.client.createAlertPolicy(name, alertPolicy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAlertPolicyRequest actualRequest = (CreateAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)alertPolicy, (Object)actualRequest.getAlertPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAlertPolicyExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            String name = "name3373707";
            AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
            this.client.createAlertPolicy(name, alertPolicy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAlertPolicyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        AlertPolicyName name = AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]");
        this.client.deleteAlertPolicy(name);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAlertPolicyRequest actualRequest = (DeleteAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAlertPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            AlertPolicyName name = AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]");
            this.client.deleteAlertPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteAlertPolicyTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteAlertPolicy(name);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAlertPolicyRequest actualRequest = (DeleteAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAlertPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteAlertPolicy(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateAlertPolicyTest() throws Exception {
        AlertPolicy expectedResponse = AlertPolicy.newBuilder().setName(AlertPolicyName.ofProjectAlertPolicyName((String)"[PROJECT]", (String)"[ALERT_POLICY]").toString()).setDisplayName("displayName1714148973").setDocumentation(AlertPolicy.Documentation.newBuilder().build()).putAllUserLabels(new HashMap()).addAllConditions(new ArrayList()).setEnabled(BoolValue.newBuilder().build()).setValidity(com.google.rpc.Status.newBuilder().build()).addAllNotificationChannels(new ArrayList()).setCreationRecord(MutationRecord.newBuilder().build()).setMutationRecord(MutationRecord.newBuilder().build()).setAlertStrategy(AlertPolicy.AlertStrategy.newBuilder().build()).build();
        mockAlertPolicyService.addResponse((AbstractMessage)expectedResponse);
        FieldMask updateMask = FieldMask.newBuilder().build();
        AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
        AlertPolicy actualResponse = this.client.updateAlertPolicy(updateMask, alertPolicy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAlertPolicyService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAlertPolicyRequest actualRequest = (UpdateAlertPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertEquals((Object)alertPolicy, (Object)actualRequest.getAlertPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAlertPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAlertPolicyService.addException((Exception)exception);
        try {
            FieldMask updateMask = FieldMask.newBuilder().build();
            AlertPolicy alertPolicy = AlertPolicy.newBuilder().build();
            this.client.updateAlertPolicy(updateMask, alertPolicy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

