/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.StatusCode;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.AlertPolicyServiceClient;
import com.google.cloud.monitoring.v3.GroupServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.NotificationChannelServiceClient;
import com.google.cloud.monitoring.v3.ServiceMonitoringServiceClient;
import com.google.cloud.monitoring.v3.UptimeCheckServiceClient;
import com.google.monitoring.v3.AlertPolicy;
import com.google.monitoring.v3.AlertPolicyName;
import com.google.monitoring.v3.CreateAlertPolicyRequest;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateNotificationChannelRequest;
import com.google.monitoring.v3.CreateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.CreateServiceRequest;
import com.google.monitoring.v3.CreateUptimeCheckConfigRequest;
import com.google.monitoring.v3.DeleteAlertPolicyRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.DeleteNotificationChannelRequest;
import com.google.monitoring.v3.DeleteServiceLevelObjectiveRequest;
import com.google.monitoring.v3.DeleteServiceRequest;
import com.google.monitoring.v3.DeleteUptimeCheckConfigRequest;
import com.google.monitoring.v3.GetAlertPolicyRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.GetNotificationChannelDescriptorRequest;
import com.google.monitoring.v3.GetNotificationChannelRequest;
import com.google.monitoring.v3.GetServiceLevelObjectiveRequest;
import com.google.monitoring.v3.GetServiceRequest;
import com.google.monitoring.v3.GetUptimeCheckConfigRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.GroupName;
import com.google.monitoring.v3.ListAlertPoliciesRequest;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListNotificationChannelDescriptorsRequest;
import com.google.monitoring.v3.ListNotificationChannelsRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesRequest;
import com.google.monitoring.v3.ListServicesRequest;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsRequest;
import com.google.monitoring.v3.MetricDescriptorName;
import com.google.monitoring.v3.MonitoredResourceDescriptorName;
import com.google.monitoring.v3.NotificationChannel;
import com.google.monitoring.v3.NotificationChannelDescriptorName;
import com.google.monitoring.v3.NotificationChannelName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.Service;
import com.google.monitoring.v3.ServiceLevelObjective;
import com.google.monitoring.v3.ServiceLevelObjectiveName;
import com.google.monitoring.v3.ServiceName;
import com.google.monitoring.v3.UpdateAlertPolicyRequest;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.monitoring.v3.UpdateNotificationChannelRequest;
import com.google.monitoring.v3.UpdateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.UpdateServiceRequest;
import com.google.monitoring.v3.UpdateUptimeCheckConfigRequest;
import com.google.monitoring.v3.UptimeCheckConfig;
import com.google.monitoring.v3.UptimeCheckConfigName;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITVPCServiceControlTest {
    static final String PROJECT_INSIDE = System.getenv("PROJECT_ID");
    static final String PROJECT_OUTSIDE = System.getenv("GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT");
    static final String IS_INSIDE_VPCSC = System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC");
    static final String COLLECTD_TIME_SERIES_REQUEST_TEMPLATE = "{ \"name\": \"%s\" }";
    private static final Logger logger = Logger.getLogger(ITVPCServiceControlTest.class.getName());

    private static Exception getError(Callable callable) {
        try {
            callable.call();
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage());
            return e;
        }
        return null;
    }

    private static void doTest(Callable delayedInside, Callable delayedOutside) {
        if (IS_INSIDE_VPCSC != null && IS_INSIDE_VPCSC.equalsIgnoreCase("true")) {
            logger.log(Level.INFO, "inside perimeter");
            Exception e = ITVPCServiceControlTest.getError(delayedOutside);
            Assert.assertTrue((PermissionDeniedException.class.isInstance(e) && e.getMessage().contains("Request is prohibited by organization's policy") ? 1 : 0) != 0);
            e = ITVPCServiceControlTest.getError(delayedInside);
            Assert.assertFalse((PermissionDeniedException.class.isInstance(e) && e.getMessage().contains("Request is prohibited by organization's policy") ? 1 : 0) != 0);
        } else {
            logger.log(Level.INFO, "outside perimeter");
            Exception e = ITVPCServiceControlTest.getError(delayedOutside);
            Assert.assertFalse((PermissionDeniedException.class.isInstance(e) && e.getMessage().contains("Request is prohibited by organization's policy") ? 1 : 0) != 0);
            e = ITVPCServiceControlTest.getError(delayedInside);
            Assert.assertTrue((PermissionDeniedException.class.isInstance(e) && e.getMessage().contains("Request is prohibited by organization's policy") ? 1 : 0) != 0);
        }
    }

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((String)"Missing environment variable: PROJECT_ID", (PROJECT_INSIDE != null && !PROJECT_INSIDE.isEmpty() ? 1 : 0) != 0);
        Assume.assumeTrue((String)"Missing environment variable: GOOGLE_CLOUD_TESTS_VPCSC_OUTSIDE_PERIMETER_PROJECT", (PROJECT_OUTSIDE != null && !PROJECT_OUTSIDE.isEmpty() ? 1 : 0) != 0);
    }

    private static void postJSON(URL url, String payload) throws Exception {
        String line;
        GoogleCredentials adc = GoogleCredentials.getApplicationDefault().createScoped((Collection)ImmutableList.of((Object)"https://www.googleapis.com/auth/monitoring", (Object)"https://www.googleapis.com/auth/monitoring.write", (Object)"https://www.googleapis.com/auth/cloud-platform"));
        adc.refresh();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", "Bearer " + adc.getAccessToken().getTokenValue());
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json, */*");
        conn.setDoOutput(true);
        OutputStream body = conn.getOutputStream();
        body.write(payload.getBytes("UTF-8"));
        body.close();
        conn.getResponseMessage();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line).append("\n");
        }
        if (conn.getResponseCode() == 403) {
            throw new PermissionDeniedException(response.toString(), null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.PERMISSION_DENIED), false);
        }
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException(response.toString());
        }
    }

    @Test
    public void collectdTimeSeriesTest() throws Exception {
        String prefix = "https://monitoring.googleapis.com/v3/";
        String endpoint = "/collectdTimeSeries";
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                URL url = new URL("https://monitoring.googleapis.com/v3/" + nameInside.toString() + "/collectdTimeSeries");
                logger.log(Level.INFO, "collectdTimeSeriesTest: requesting {0}", url.toString());
                ITVPCServiceControlTest.postJSON(url, String.format(ITVPCServiceControlTest.COLLECTD_TIME_SERIES_REQUEST_TEMPLATE, nameInside.toString()));
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                URL url = new URL("https://monitoring.googleapis.com/v3/" + nameOutside.toString() + "/collectdTimeSeries");
                logger.log(Level.INFO, "collectdTimeSeriesTest: requesting {0}", url.toString());
                ITVPCServiceControlTest.postJSON(url, String.format(ITVPCServiceControlTest.COLLECTD_TIME_SERIES_REQUEST_TEMPLATE, nameOutside.toString()));
                return null;
            }
        };
        ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createAlertPolicyTest() throws Exception {
        final AlertPolicyServiceClient client = AlertPolicyServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createAlertPolicyTest: requesting {0}", nameInside);
                client.createAlertPolicy(CreateAlertPolicyRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createAlertPolicyTest: requesting {0}", nameOutside);
                client.createAlertPolicy(CreateAlertPolicyRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteAlertPolicyTest() throws Exception {
        final AlertPolicyServiceClient client = AlertPolicyServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                AlertPolicyName nameInside = AlertPolicyName.of((String)PROJECT_INSIDE, (String)"MockAlertPolicy");
                logger.log(Level.INFO, "deleteAlertPolicyTest: requesting {0}", nameInside);
                client.deleteAlertPolicy(DeleteAlertPolicyRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                AlertPolicyName nameOutside = AlertPolicyName.of((String)PROJECT_OUTSIDE, (String)"MockAlertPolicy");
                logger.log(Level.INFO, "deleteAlertPolicyTest: requesting {0}", nameOutside);
                client.deleteAlertPolicy(DeleteAlertPolicyRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getAlertPolicyTest() throws Exception {
        final AlertPolicyServiceClient client = AlertPolicyServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                AlertPolicyName nameInside = AlertPolicyName.of((String)PROJECT_INSIDE, (String)"MockAlertPolicy");
                logger.log(Level.INFO, "getAlertPolicyTest: requesting {0}", nameInside);
                client.getAlertPolicy(GetAlertPolicyRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                AlertPolicyName nameOutside = AlertPolicyName.of((String)PROJECT_OUTSIDE, (String)"MockAlertPolicy");
                logger.log(Level.INFO, "getAlertPolicyTest: requesting {0}", nameOutside);
                client.getAlertPolicy(GetAlertPolicyRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listAlertPoliciesTest() throws Exception {
        final AlertPolicyServiceClient client = AlertPolicyServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listAlertPoliciesTest: requesting {0}", nameInside);
                client.listAlertPolicies(ListAlertPoliciesRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listAlertPoliciesTest: requesting {0}", nameOutside);
                client.listAlertPolicies(ListAlertPoliciesRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateAlertPolicyTest() throws Exception {
        final AlertPolicyServiceClient client = AlertPolicyServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                AlertPolicyName nameInside = AlertPolicyName.of((String)PROJECT_INSIDE, (String)"MockAlertPolicy");
                logger.log(Level.INFO, "updateAlertPolicyTest: requesting {0}", nameInside);
                client.updateAlertPolicy(UpdateAlertPolicyRequest.newBuilder().setAlertPolicy(AlertPolicy.newBuilder().setName(nameInside.toString()).build()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                AlertPolicyName nameOutside = AlertPolicyName.of((String)PROJECT_OUTSIDE, (String)"MockAlertPolicy");
                logger.log(Level.INFO, "updateAlertPolicyTest: requesting {0}", nameOutside);
                client.updateAlertPolicy(UpdateAlertPolicyRequest.newBuilder().setAlertPolicy(AlertPolicy.newBuilder().setName(nameOutside.toString()).build()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createGroupTest() throws Exception {
        final GroupServiceClient client = GroupServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createGroupTest: requesting {0}", nameInside);
                client.createGroup(CreateGroupRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createGroupTest: requesting {0}", nameOutside);
                client.createGroup(CreateGroupRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteGroupTest() throws Exception {
        final GroupServiceClient client = GroupServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                GroupName nameInside = GroupName.of((String)PROJECT_INSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "deleteGroupTest: requesting {0}", nameInside);
                client.deleteGroup(DeleteGroupRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                GroupName nameOutside = GroupName.of((String)PROJECT_OUTSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "deleteGroupTest: requesting {0}", nameOutside);
                client.deleteGroup(DeleteGroupRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getGroupTest() throws Exception {
        final GroupServiceClient client = GroupServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                GroupName nameInside = GroupName.of((String)PROJECT_INSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "getGroupTest: requesting {0}", nameInside);
                client.getGroup(GetGroupRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                GroupName nameOutside = GroupName.of((String)PROJECT_OUTSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "getGroupTest: requesting {0}", nameOutside);
                client.getGroup(GetGroupRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listGroupMembersTest() throws Exception {
        final GroupServiceClient client = GroupServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                GroupName nameInside = GroupName.of((String)PROJECT_INSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "listGroupMembersTest: requesting {0}", nameInside);
                client.listGroupMembers(ListGroupMembersRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                GroupName nameOutside = GroupName.of((String)PROJECT_OUTSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "listGroupMembersTest: requesting {0}", nameOutside);
                client.listGroupMembers(ListGroupMembersRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listGroupsTest() throws Exception {
        final GroupServiceClient client = GroupServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listGroupsTest: requesting {0}", nameInside);
                client.listGroups(ListGroupsRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listGroupsTest: requesting {0}", nameOutside);
                client.listGroups(ListGroupsRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateGroupTest() throws Exception {
        final GroupServiceClient client = GroupServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                GroupName nameInside = GroupName.of((String)PROJECT_INSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "updateGroupTest: requesting {0}", nameInside);
                client.updateGroup(UpdateGroupRequest.newBuilder().setGroup(Group.newBuilder().setName(nameInside.toString()).build()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                GroupName nameOutside = GroupName.of((String)PROJECT_OUTSIDE, (String)"MockGroup");
                logger.log(Level.INFO, "updateGroupTest: requesting {0}", nameOutside);
                client.updateGroup(UpdateGroupRequest.newBuilder().setGroup(Group.newBuilder().setName(nameOutside.toString()).build()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createMetricDescriptorTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createMetricDescriptorTest: requesting {0}", nameInside);
                client.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createMetricDescriptorTest: requesting {0}", nameOutside);
                client.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTimeSeriesTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createTimeSeriesTest: requesting {0}", nameInside);
                client.createTimeSeries(nameInside, new ArrayList());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createTimeSeriesTest: requesting {0}", nameOutside);
                client.createTimeSeries(nameOutside, new ArrayList());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteMetricDescriptorTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                MetricDescriptorName nameInside = MetricDescriptorName.of((String)PROJECT_INSIDE, (String)"MockMetricDescriptor");
                logger.log(Level.INFO, "deleteMetricDescriptorTest: requesting {0}", nameInside);
                client.deleteMetricDescriptor(DeleteMetricDescriptorRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                MetricDescriptorName nameOutside = MetricDescriptorName.of((String)PROJECT_OUTSIDE, (String)"MockMetricDescriptor");
                logger.log(Level.INFO, "deleteMetricDescriptorTest: requesting {0}", nameOutside);
                client.deleteMetricDescriptor(DeleteMetricDescriptorRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getMetricDescriptorTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                MetricDescriptorName nameInside = MetricDescriptorName.of((String)PROJECT_INSIDE, (String)"MockMetricDescriptor");
                logger.log(Level.INFO, "getMetricDescriptorTest: requesting {0}", nameInside);
                client.getMetricDescriptor(GetMetricDescriptorRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                MetricDescriptorName nameOutside = MetricDescriptorName.of((String)PROJECT_OUTSIDE, (String)"MockMetricDescriptor");
                logger.log(Level.INFO, "getMetricDescriptorTest: requesting {0}", nameOutside);
                client.getMetricDescriptor(GetMetricDescriptorRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getMonitoredResourceDescriptorTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                MonitoredResourceDescriptorName nameInside = MonitoredResourceDescriptorName.of((String)PROJECT_INSIDE, (String)"MockMonitoredResourceDescriptor");
                logger.log(Level.INFO, "getMonitoredResourceDescriptorTest: requesting {0}", nameInside);
                client.getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                MonitoredResourceDescriptorName nameOutside = MonitoredResourceDescriptorName.of((String)PROJECT_OUTSIDE, (String)"MockMonitoredResourceDescriptor");
                logger.log(Level.INFO, "getMonitoredResourceDescriptorTest: requesting {0}", nameOutside);
                client.getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listMetricDescriptorsTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listMetricDescriptorsTest: requesting {0}", nameInside);
                client.listMetricDescriptors(ListMetricDescriptorsRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listMetricDescriptorsTest: requesting {0}", nameOutside);
                client.listMetricDescriptors(ListMetricDescriptorsRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listMonitoredResourceDescriptorsTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listMonitoredResourceDescriptorsTest: requesting {0}", nameInside);
                client.listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listMonitoredResourceDescriptorsTest: requesting {0}", nameOutside);
                client.listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listTimeSeriesTest() throws Exception {
        final MetricServiceClient client = MetricServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listTimeSeriesTest: requesting {0}", nameInside);
                client.listTimeSeries(ListTimeSeriesRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listTimeSeriesTest: requesting {0}", nameOutside);
                client.listTimeSeries(ListTimeSeriesRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNotificationChannelTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createNotificationChannelTest: requesting {0}", nameInside);
                client.createNotificationChannel(CreateNotificationChannelRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createNotificationChannelTest: requesting {0}", nameOutside);
                client.createNotificationChannel(CreateNotificationChannelRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteNotificationChannelTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelName nameInside = NotificationChannelName.of((String)PROJECT_INSIDE, (String)"MockNotificationChannel");
                logger.log(Level.INFO, "deleteNotificationChannelTest: requesting {0}", nameInside);
                client.deleteNotificationChannel(DeleteNotificationChannelRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelName nameOutside = NotificationChannelName.of((String)PROJECT_OUTSIDE, (String)"MockNotificationChannel");
                logger.log(Level.INFO, "deleteNotificationChannelTest: requesting {0}", nameOutside);
                client.deleteNotificationChannel(DeleteNotificationChannelRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getNotificationChannelTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelName nameInside = NotificationChannelName.of((String)PROJECT_INSIDE, (String)"MockNotificationChannel");
                logger.log(Level.INFO, "getNotificationChannelTest: requesting {0}", nameInside);
                client.getNotificationChannel(GetNotificationChannelRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelName nameOutside = NotificationChannelName.of((String)PROJECT_OUTSIDE, (String)"MockNotificationChannel");
                logger.log(Level.INFO, "getNotificationChannelTest: requesting {0}", nameOutside);
                client.getNotificationChannel(GetNotificationChannelRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getNotificationChannelDescriptorTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelDescriptorName nameInside = NotificationChannelDescriptorName.of((String)PROJECT_INSIDE, (String)"MockNotificationChannelDescriptor");
                logger.log(Level.INFO, "getNotificationChannelDescriptorTest: requesting {0}", nameInside);
                client.getNotificationChannelDescriptor(GetNotificationChannelDescriptorRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelDescriptorName nameOutside = NotificationChannelDescriptorName.of((String)PROJECT_OUTSIDE, (String)"MockNotificationChannelDescriptor");
                logger.log(Level.INFO, "getNotificationChannelDescriptorTest: requesting {0}", nameOutside);
                client.getNotificationChannelDescriptor(GetNotificationChannelDescriptorRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listNotificationChannelDescriptorsTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listNotificationChannelDescriptorsTest: requesting {0}", nameInside);
                client.listNotificationChannelDescriptors(ListNotificationChannelDescriptorsRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listNotificationChannelDescriptorsTest: requesting {0}", nameOutside);
                client.listNotificationChannelDescriptors(ListNotificationChannelDescriptorsRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listNotificationChannelsTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listNotificationChannelsTest: requesting {0}", nameInside);
                client.listNotificationChannels(ListNotificationChannelsRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listNotificationChannelsTest: requesting {0}", nameOutside);
                client.listNotificationChannels(ListNotificationChannelsRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateNotificationChannelTest() throws Exception {
        final NotificationChannelServiceClient client = NotificationChannelServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelName nameInside = NotificationChannelName.of((String)PROJECT_INSIDE, (String)"MockNotificationChannel");
                logger.log(Level.INFO, "updateNotificationChannelTest: requesting {0}", nameInside);
                client.updateNotificationChannel(UpdateNotificationChannelRequest.newBuilder().setNotificationChannel(NotificationChannel.newBuilder().setName(nameInside.toString()).build()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                NotificationChannelName nameOutside = NotificationChannelName.of((String)PROJECT_OUTSIDE, (String)"MockNotificationChannel");
                logger.log(Level.INFO, "updateNotificationChannelTest: requesting {0}", nameOutside);
                client.updateNotificationChannel(UpdateNotificationChannelRequest.newBuilder().setNotificationChannel(NotificationChannel.newBuilder().setName(nameOutside.toString()).build()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createServiceTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createServiceTest: requesting {0}", nameInside);
                client.createService(CreateServiceRequest.newBuilder().setParent(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createServiceTest: requesting {0}", nameOutside);
                client.createService(CreateServiceRequest.newBuilder().setParent(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createServiceLevelObjectiveTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameInside = ServiceName.of((String)PROJECT_INSIDE, (String)"MockService");
                logger.log(Level.INFO, "createServiceLevelObjectiveTest: requesting {0}", nameInside);
                client.createServiceLevelObjective(CreateServiceLevelObjectiveRequest.newBuilder().setParent(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameOutside = ServiceName.of((String)PROJECT_OUTSIDE, (String)"MockService");
                logger.log(Level.INFO, "createServiceLevelObjectiveTest: requesting {0}", nameOutside);
                client.createServiceLevelObjective(CreateServiceLevelObjectiveRequest.newBuilder().setParent(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteServiceTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameInside = ServiceName.of((String)PROJECT_INSIDE, (String)"MockService");
                logger.log(Level.INFO, "deleteServiceTest: requesting {0}", nameInside);
                client.deleteService(DeleteServiceRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameOutside = ServiceName.of((String)PROJECT_OUTSIDE, (String)"MockService");
                logger.log(Level.INFO, "deleteServiceTest: requesting {0}", nameOutside);
                client.deleteService(DeleteServiceRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteServiceLevelObjectiveTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceLevelObjectiveName nameInside = ServiceLevelObjectiveName.of((String)PROJECT_INSIDE, (String)"MockService", (String)"MockServiceLevelObjective");
                logger.log(Level.INFO, "deleteServiceLevelObjectiveTest: requesting {0}", nameInside);
                client.deleteServiceLevelObjective(DeleteServiceLevelObjectiveRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceLevelObjectiveName nameOutside = ServiceLevelObjectiveName.of((String)PROJECT_OUTSIDE, (String)"MockService", (String)"MockServiceLevelObjective");
                logger.log(Level.INFO, "deleteServiceLevelObjectiveTest: requesting {0}", nameOutside);
                client.deleteServiceLevelObjective(DeleteServiceLevelObjectiveRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getServiceTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameInside = ServiceName.of((String)PROJECT_INSIDE, (String)"MockService");
                logger.log(Level.INFO, "getServiceTest: requesting {0}", nameInside);
                client.getService(GetServiceRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameOutside = ServiceName.of((String)PROJECT_OUTSIDE, (String)"MockService");
                logger.log(Level.INFO, "getServiceTest: requesting {0}", nameOutside);
                client.getService(GetServiceRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getServiceLevelObjectiveTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceLevelObjectiveName nameInside = ServiceLevelObjectiveName.of((String)PROJECT_INSIDE, (String)"MockService", (String)"MockServiceLevelObjective");
                logger.log(Level.INFO, "getServiceLevelObjectiveTest: requesting {0}", nameInside);
                client.getServiceLevelObjective(GetServiceLevelObjectiveRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceLevelObjectiveName nameOutside = ServiceLevelObjectiveName.of((String)PROJECT_OUTSIDE, (String)"MockService", (String)"MockServiceLevelObjective");
                logger.log(Level.INFO, "getServiceLevelObjectiveTest: requesting {0}", nameOutside);
                client.getServiceLevelObjective(GetServiceLevelObjectiveRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listServiceLevelObjectivesTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameInside = ServiceName.of((String)PROJECT_INSIDE, (String)"MockService");
                logger.log(Level.INFO, "listServiceLevelObjectivesTest: requesting {0}", nameInside);
                client.listServiceLevelObjectives(ListServiceLevelObjectivesRequest.newBuilder().setParent(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameOutside = ServiceName.of((String)PROJECT_OUTSIDE, (String)"MockService");
                logger.log(Level.INFO, "listServiceLevelObjectivesTest: requesting {0}", nameOutside);
                client.listServiceLevelObjectives(ListServiceLevelObjectivesRequest.newBuilder().setParent(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listServicesTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listServicesTest: requesting {0}", nameInside);
                client.listServices(ListServicesRequest.newBuilder().setParent(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listServicesTest: requesting {0}", nameOutside);
                client.listServices(ListServicesRequest.newBuilder().setParent(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateServiceTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameInside = ServiceName.of((String)PROJECT_INSIDE, (String)"MockService");
                logger.log(Level.INFO, "updateServiceTest: requesting {0}", nameInside);
                client.updateService(UpdateServiceRequest.newBuilder().setService(Service.newBuilder().setName(nameInside.toString()).build()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceName nameOutside = ServiceName.of((String)PROJECT_OUTSIDE, (String)"MockService");
                logger.log(Level.INFO, "updateServiceTest: requesting {0}", nameOutside);
                client.updateService(UpdateServiceRequest.newBuilder().setService(Service.newBuilder().setName(nameOutside.toString()).build()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateServiceLevelObjectiveTest() throws Exception {
        final ServiceMonitoringServiceClient client = ServiceMonitoringServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ServiceLevelObjectiveName nameInside = ServiceLevelObjectiveName.of((String)PROJECT_INSIDE, (String)"MockService", (String)"MockServiceLevelObjective");
                logger.log(Level.INFO, "updateServiceLevelObjectiveTest: requesting {0}", nameInside);
                client.updateServiceLevelObjective(UpdateServiceLevelObjectiveRequest.newBuilder().setServiceLevelObjective(ServiceLevelObjective.newBuilder().setName(nameInside.toString()).build()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ServiceLevelObjectiveName nameOutside = ServiceLevelObjectiveName.of((String)PROJECT_OUTSIDE, (String)"MockService", (String)"MockServiceLevelObjective");
                logger.log(Level.INFO, "updateServiceLevelObjectiveTest: requesting {0}", nameOutside);
                client.updateServiceLevelObjective(UpdateServiceLevelObjectiveRequest.newBuilder().setServiceLevelObjective(ServiceLevelObjective.newBuilder().setName(nameOutside.toString()).build()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createUptimeCheckConfigTest() throws Exception {
        final UptimeCheckServiceClient client = UptimeCheckServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "createUptimeCheckConfigTest: requesting {0}", nameInside);
                client.createUptimeCheckConfig(CreateUptimeCheckConfigRequest.newBuilder().setParent(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "createUptimeCheckConfigTest: requesting {0}", nameOutside);
                client.createUptimeCheckConfig(CreateUptimeCheckConfigRequest.newBuilder().setParent(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteUptimeCheckConfigTest() throws Exception {
        final UptimeCheckServiceClient client = UptimeCheckServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                UptimeCheckConfigName nameInside = UptimeCheckConfigName.of((String)PROJECT_INSIDE, (String)"MockUptimeCheckConfig");
                logger.log(Level.INFO, "deleteUptimeCheckConfigTest: requesting {0}", nameInside);
                client.deleteUptimeCheckConfig(DeleteUptimeCheckConfigRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                UptimeCheckConfigName nameOutside = UptimeCheckConfigName.of((String)PROJECT_OUTSIDE, (String)"MockUptimeCheckConfig");
                logger.log(Level.INFO, "deleteUptimeCheckConfigTest: requesting {0}", nameOutside);
                client.deleteUptimeCheckConfig(DeleteUptimeCheckConfigRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getUptimeCheckConfigTest() throws Exception {
        final UptimeCheckServiceClient client = UptimeCheckServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                UptimeCheckConfigName nameInside = UptimeCheckConfigName.of((String)PROJECT_INSIDE, (String)"MockUptimeCheckConfig");
                logger.log(Level.INFO, "getUptimeCheckConfigTest: requesting {0}", nameInside);
                client.getUptimeCheckConfig(GetUptimeCheckConfigRequest.newBuilder().setName(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                UptimeCheckConfigName nameOutside = UptimeCheckConfigName.of((String)PROJECT_OUTSIDE, (String)"MockUptimeCheckConfig");
                logger.log(Level.INFO, "getUptimeCheckConfigTest: requesting {0}", nameOutside);
                client.getUptimeCheckConfig(GetUptimeCheckConfigRequest.newBuilder().setName(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listUptimeCheckConfigsTest() throws Exception {
        final UptimeCheckServiceClient client = UptimeCheckServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameInside = ProjectName.of((String)PROJECT_INSIDE);
                logger.log(Level.INFO, "listUptimeCheckConfigsTest: requesting {0}", nameInside);
                client.listUptimeCheckConfigs(ListUptimeCheckConfigsRequest.newBuilder().setParent(nameInside.toString()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                ProjectName nameOutside = ProjectName.of((String)PROJECT_OUTSIDE);
                logger.log(Level.INFO, "listUptimeCheckConfigsTest: requesting {0}", nameOutside);
                client.listUptimeCheckConfigs(ListUptimeCheckConfigsRequest.newBuilder().setParent(nameOutside.toString()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateUptimeCheckConfigTest() throws Exception {
        final UptimeCheckServiceClient client = UptimeCheckServiceClient.create();
        Callable delayedInside = new Callable(){

            public Object call() throws Exception {
                UptimeCheckConfigName nameInside = UptimeCheckConfigName.of((String)PROJECT_INSIDE, (String)"MockUptimeCheckConfig");
                logger.log(Level.INFO, "updateUptimeCheckConfigTest: requesting {0}", nameInside);
                client.updateUptimeCheckConfig(UpdateUptimeCheckConfigRequest.newBuilder().setUptimeCheckConfig(UptimeCheckConfig.newBuilder().setName(nameInside.toString()).build()).build());
                return null;
            }
        };
        Callable delayedOutside = new Callable(){

            public Object call() throws Exception {
                UptimeCheckConfigName nameOutside = UptimeCheckConfigName.of((String)PROJECT_OUTSIDE, (String)"MockUptimeCheckConfig");
                logger.log(Level.INFO, "updateUptimeCheckConfigTest: requesting {0}", nameOutside);
                client.updateUptimeCheckConfig(UpdateUptimeCheckConfigRequest.newBuilder().setUptimeCheckConfig(UptimeCheckConfig.newBuilder().setName(nameOutside.toString()).build()).build());
                return null;
            }
        };
        try {
            ITVPCServiceControlTest.doTest(delayedInside, delayedOutside);
        }
        finally {
            client.close();
        }
    }
}

