/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.LaunchStage;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.MockNotificationChannelService;
import com.google.cloud.monitoring.v3.NotificationChannelServiceClient;
import com.google.cloud.monitoring.v3.NotificationChannelServiceSettings;
import com.google.monitoring.v3.CreateNotificationChannelRequest;
import com.google.monitoring.v3.DeleteNotificationChannelRequest;
import com.google.monitoring.v3.FolderName;
import com.google.monitoring.v3.GetNotificationChannelDescriptorRequest;
import com.google.monitoring.v3.GetNotificationChannelRequest;
import com.google.monitoring.v3.GetNotificationChannelVerificationCodeRequest;
import com.google.monitoring.v3.GetNotificationChannelVerificationCodeResponse;
import com.google.monitoring.v3.ListNotificationChannelDescriptorsRequest;
import com.google.monitoring.v3.ListNotificationChannelDescriptorsResponse;
import com.google.monitoring.v3.ListNotificationChannelsRequest;
import com.google.monitoring.v3.ListNotificationChannelsResponse;
import com.google.monitoring.v3.MutationRecord;
import com.google.monitoring.v3.NotificationChannel;
import com.google.monitoring.v3.NotificationChannelDescriptor;
import com.google.monitoring.v3.NotificationChannelDescriptorName;
import com.google.monitoring.v3.NotificationChannelName;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.SendNotificationChannelVerificationCodeRequest;
import com.google.monitoring.v3.UpdateNotificationChannelRequest;
import com.google.monitoring.v3.VerifyNotificationChannelRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class NotificationChannelServiceClientTest {
    private static MockNotificationChannelService mockNotificationChannelService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private NotificationChannelServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockNotificationChannelService = new MockNotificationChannelService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockNotificationChannelService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        NotificationChannelServiceSettings settings = ((NotificationChannelServiceSettings.Builder)((NotificationChannelServiceSettings.Builder)NotificationChannelServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = NotificationChannelServiceClient.create((NotificationChannelServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listNotificationChannelDescriptorsTest() throws Exception {
        NotificationChannelDescriptor responsesElement = NotificationChannelDescriptor.newBuilder().build();
        ListNotificationChannelDescriptorsResponse expectedResponse = ListNotificationChannelDescriptorsResponse.newBuilder().setNextPageToken("").addAllChannelDescriptors(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        NotificationChannelServiceClient.ListNotificationChannelDescriptorsPagedResponse pagedListResponse = this.client.listNotificationChannelDescriptors((ResourceName)name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getChannelDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelDescriptorsRequest actualRequest = (ListNotificationChannelDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelDescriptorsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            this.client.listNotificationChannelDescriptors((ResourceName)name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelDescriptorsTest2() throws Exception {
        NotificationChannelDescriptor responsesElement = NotificationChannelDescriptor.newBuilder().build();
        ListNotificationChannelDescriptorsResponse expectedResponse = ListNotificationChannelDescriptorsResponse.newBuilder().setNextPageToken("").addAllChannelDescriptors(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        NotificationChannelServiceClient.ListNotificationChannelDescriptorsPagedResponse pagedListResponse = this.client.listNotificationChannelDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getChannelDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelDescriptorsRequest actualRequest = (ListNotificationChannelDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelDescriptorsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listNotificationChannelDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelDescriptorsTest3() throws Exception {
        NotificationChannelDescriptor responsesElement = NotificationChannelDescriptor.newBuilder().build();
        ListNotificationChannelDescriptorsResponse expectedResponse = ListNotificationChannelDescriptorsResponse.newBuilder().setNextPageToken("").addAllChannelDescriptors(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        NotificationChannelServiceClient.ListNotificationChannelDescriptorsPagedResponse pagedListResponse = this.client.listNotificationChannelDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getChannelDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelDescriptorsRequest actualRequest = (ListNotificationChannelDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelDescriptorsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.listNotificationChannelDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelDescriptorsTest4() throws Exception {
        NotificationChannelDescriptor responsesElement = NotificationChannelDescriptor.newBuilder().build();
        ListNotificationChannelDescriptorsResponse expectedResponse = ListNotificationChannelDescriptorsResponse.newBuilder().setNextPageToken("").addAllChannelDescriptors(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        NotificationChannelServiceClient.ListNotificationChannelDescriptorsPagedResponse pagedListResponse = this.client.listNotificationChannelDescriptors(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getChannelDescriptorsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelDescriptorsRequest actualRequest = (ListNotificationChannelDescriptorsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelDescriptorsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listNotificationChannelDescriptors(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationChannelDescriptorTest() throws Exception {
        NotificationChannelDescriptor expectedResponse = NotificationChannelDescriptor.newBuilder().setName(NotificationChannelDescriptorName.ofProjectChannelDescriptorName((String)"[PROJECT]", (String)"[CHANNEL_DESCRIPTOR]").toString()).setType("type3575610").setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllLabels(new ArrayList()).addAllSupportedTiers(new ArrayList()).setLaunchStage(LaunchStage.forNumber((int)0)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        NotificationChannelDescriptorName name = NotificationChannelDescriptorName.ofProjectChannelDescriptorName((String)"[PROJECT]", (String)"[CHANNEL_DESCRIPTOR]");
        NotificationChannelDescriptor actualResponse = this.client.getNotificationChannelDescriptor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationChannelDescriptorRequest actualRequest = (GetNotificationChannelDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationChannelDescriptorExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            NotificationChannelDescriptorName name = NotificationChannelDescriptorName.ofProjectChannelDescriptorName((String)"[PROJECT]", (String)"[CHANNEL_DESCRIPTOR]");
            this.client.getNotificationChannelDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationChannelDescriptorTest2() throws Exception {
        NotificationChannelDescriptor expectedResponse = NotificationChannelDescriptor.newBuilder().setName(NotificationChannelDescriptorName.ofProjectChannelDescriptorName((String)"[PROJECT]", (String)"[CHANNEL_DESCRIPTOR]").toString()).setType("type3575610").setDisplayName("displayName1714148973").setDescription("description-1724546052").addAllLabels(new ArrayList()).addAllSupportedTiers(new ArrayList()).setLaunchStage(LaunchStage.forNumber((int)0)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        NotificationChannelDescriptor actualResponse = this.client.getNotificationChannelDescriptor(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationChannelDescriptorRequest actualRequest = (GetNotificationChannelDescriptorRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationChannelDescriptorExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNotificationChannelDescriptor(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelsTest() throws Exception {
        NotificationChannel responsesElement = NotificationChannel.newBuilder().build();
        ListNotificationChannelsResponse expectedResponse = ListNotificationChannelsResponse.newBuilder().setNextPageToken("").addAllNotificationChannels(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        NotificationChannelServiceClient.ListNotificationChannelsPagedResponse pagedListResponse = this.client.listNotificationChannels((ResourceName)name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationChannelsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelsRequest actualRequest = (ListNotificationChannelsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            this.client.listNotificationChannels((ResourceName)name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelsTest2() throws Exception {
        NotificationChannel responsesElement = NotificationChannel.newBuilder().build();
        ListNotificationChannelsResponse expectedResponse = ListNotificationChannelsResponse.newBuilder().setNextPageToken("").addAllNotificationChannels(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        NotificationChannelServiceClient.ListNotificationChannelsPagedResponse pagedListResponse = this.client.listNotificationChannels(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationChannelsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelsRequest actualRequest = (ListNotificationChannelsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listNotificationChannels(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelsTest3() throws Exception {
        NotificationChannel responsesElement = NotificationChannel.newBuilder().build();
        ListNotificationChannelsResponse expectedResponse = ListNotificationChannelsResponse.newBuilder().setNextPageToken("").addAllNotificationChannels(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        NotificationChannelServiceClient.ListNotificationChannelsPagedResponse pagedListResponse = this.client.listNotificationChannels(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationChannelsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelsRequest actualRequest = (ListNotificationChannelsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.listNotificationChannels(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNotificationChannelsTest4() throws Exception {
        NotificationChannel responsesElement = NotificationChannel.newBuilder().build();
        ListNotificationChannelsResponse expectedResponse = ListNotificationChannelsResponse.newBuilder().setNextPageToken("").addAllNotificationChannels(Arrays.asList(responsesElement)).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        NotificationChannelServiceClient.ListNotificationChannelsPagedResponse pagedListResponse = this.client.listNotificationChannels(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNotificationChannelsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNotificationChannelsRequest actualRequest = (ListNotificationChannelsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNotificationChannelsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listNotificationChannels(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationChannelTest() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
        NotificationChannel actualResponse = this.client.getNotificationChannel(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationChannelRequest actualRequest = (GetNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationChannelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
            this.client.getNotificationChannel(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationChannelTest2() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        NotificationChannel actualResponse = this.client.getNotificationChannel(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationChannelRequest actualRequest = (GetNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationChannelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNotificationChannel(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationChannelTest() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        FolderName name = FolderName.of((String)"[FOLDER]");
        NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
        NotificationChannel actualResponse = this.client.createNotificationChannel((ResourceName)name, notificationChannel);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationChannelRequest actualRequest = (CreateNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)notificationChannel, (Object)actualRequest.getNotificationChannel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationChannelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            FolderName name = FolderName.of((String)"[FOLDER]");
            NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
            this.client.createNotificationChannel((ResourceName)name, notificationChannel);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationChannelTest2() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
        NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
        NotificationChannel actualResponse = this.client.createNotificationChannel(name, notificationChannel);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationChannelRequest actualRequest = (CreateNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)notificationChannel, (Object)actualRequest.getNotificationChannel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationChannelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            OrganizationName name = OrganizationName.of((String)"[ORGANIZATION]");
            NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
            this.client.createNotificationChannel(name, notificationChannel);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationChannelTest3() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
        NotificationChannel actualResponse = this.client.createNotificationChannel(name, notificationChannel);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationChannelRequest actualRequest = (CreateNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)notificationChannel, (Object)actualRequest.getNotificationChannel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationChannelExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
            this.client.createNotificationChannel(name, notificationChannel);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNotificationChannelTest4() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
        NotificationChannel actualResponse = this.client.createNotificationChannel(name, notificationChannel);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNotificationChannelRequest actualRequest = (CreateNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)notificationChannel, (Object)actualRequest.getNotificationChannel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNotificationChannelExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
            this.client.createNotificationChannel(name, notificationChannel);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateNotificationChannelTest() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        FieldMask updateMask = FieldMask.newBuilder().build();
        NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
        NotificationChannel actualResponse = this.client.updateNotificationChannel(updateMask, notificationChannel);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateNotificationChannelRequest actualRequest = (UpdateNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertEquals((Object)notificationChannel, (Object)actualRequest.getNotificationChannel());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateNotificationChannelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            FieldMask updateMask = FieldMask.newBuilder().build();
            NotificationChannel notificationChannel = NotificationChannel.newBuilder().build();
            this.client.updateNotificationChannel(updateMask, notificationChannel);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationChannelTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
        boolean force = true;
        this.client.deleteNotificationChannel(name, force);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNotificationChannelRequest actualRequest = (DeleteNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)force, (Object)actualRequest.getForce());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNotificationChannelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
            boolean force = true;
            this.client.deleteNotificationChannel(name, force);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNotificationChannelTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        boolean force = true;
        this.client.deleteNotificationChannel(name, force);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNotificationChannelRequest actualRequest = (DeleteNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)force, (Object)actualRequest.getForce());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNotificationChannelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            boolean force = true;
            this.client.deleteNotificationChannel(name, force);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void sendNotificationChannelVerificationCodeTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
        this.client.sendNotificationChannelVerificationCode(name);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SendNotificationChannelVerificationCodeRequest actualRequest = (SendNotificationChannelVerificationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void sendNotificationChannelVerificationCodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
            this.client.sendNotificationChannelVerificationCode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void sendNotificationChannelVerificationCodeTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.sendNotificationChannelVerificationCode(name);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SendNotificationChannelVerificationCodeRequest actualRequest = (SendNotificationChannelVerificationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void sendNotificationChannelVerificationCodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.sendNotificationChannelVerificationCode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationChannelVerificationCodeTest() throws Exception {
        GetNotificationChannelVerificationCodeResponse expectedResponse = GetNotificationChannelVerificationCodeResponse.newBuilder().setCode("code3059181").setExpireTime(Timestamp.newBuilder().build()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
        GetNotificationChannelVerificationCodeResponse actualResponse = this.client.getNotificationChannelVerificationCode(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationChannelVerificationCodeRequest actualRequest = (GetNotificationChannelVerificationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationChannelVerificationCodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
            this.client.getNotificationChannelVerificationCode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNotificationChannelVerificationCodeTest2() throws Exception {
        GetNotificationChannelVerificationCodeResponse expectedResponse = GetNotificationChannelVerificationCodeResponse.newBuilder().setCode("code3059181").setExpireTime(Timestamp.newBuilder().build()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GetNotificationChannelVerificationCodeResponse actualResponse = this.client.getNotificationChannelVerificationCode(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNotificationChannelVerificationCodeRequest actualRequest = (GetNotificationChannelVerificationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNotificationChannelVerificationCodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNotificationChannelVerificationCode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifyNotificationChannelTest() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
        String code = "code3059181";
        NotificationChannel actualResponse = this.client.verifyNotificationChannel(name, code);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        VerifyNotificationChannelRequest actualRequest = (VerifyNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)code, (Object)actualRequest.getCode());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void verifyNotificationChannelExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            NotificationChannelName name = NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]");
            String code = "code3059181";
            this.client.verifyNotificationChannel(name, code);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifyNotificationChannelTest2() throws Exception {
        NotificationChannel expectedResponse = NotificationChannel.newBuilder().setType("type3575610").setName(NotificationChannelName.ofProjectNotificationChannelName((String)"[PROJECT]", (String)"[NOTIFICATION_CHANNEL]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").putAllLabels(new HashMap()).putAllUserLabels(new HashMap()).setEnabled(BoolValue.newBuilder().build()).setCreationRecord(MutationRecord.newBuilder().build()).addAllMutationRecords(new ArrayList()).build();
        mockNotificationChannelService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String code = "code3059181";
        NotificationChannel actualResponse = this.client.verifyNotificationChannel(name, code);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockNotificationChannelService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        VerifyNotificationChannelRequest actualRequest = (VerifyNotificationChannelRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)code, (Object)actualRequest.getCode());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void verifyNotificationChannelExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockNotificationChannelService.addException((Exception)exception);
        try {
            String name = "name3373707";
            String code = "code3059181";
            this.client.verifyNotificationChannel(name, code);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

