/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.MockServiceMonitoringService;
import com.google.cloud.monitoring.v3.ServiceMonitoringServiceClient;
import com.google.cloud.monitoring.v3.ServiceMonitoringServiceSettings;
import com.google.monitoring.v3.CreateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.CreateServiceRequest;
import com.google.monitoring.v3.DeleteServiceLevelObjectiveRequest;
import com.google.monitoring.v3.DeleteServiceRequest;
import com.google.monitoring.v3.FolderName;
import com.google.monitoring.v3.GetServiceLevelObjectiveRequest;
import com.google.monitoring.v3.GetServiceRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesResponse;
import com.google.monitoring.v3.ListServicesRequest;
import com.google.monitoring.v3.ListServicesResponse;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.Service;
import com.google.monitoring.v3.ServiceLevelIndicator;
import com.google.monitoring.v3.ServiceLevelObjective;
import com.google.monitoring.v3.ServiceLevelObjectiveName;
import com.google.monitoring.v3.ServiceName;
import com.google.monitoring.v3.UpdateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.UpdateServiceRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServiceMonitoringServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockServiceMonitoringService mockServiceMonitoringService;
    private LocalChannelProvider channelProvider;
    private ServiceMonitoringServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockServiceMonitoringService = new MockServiceMonitoringService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockServiceMonitoringService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        ServiceMonitoringServiceSettings settings = ((ServiceMonitoringServiceSettings.Builder)((ServiceMonitoringServiceSettings.Builder)ServiceMonitoringServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ServiceMonitoringServiceClient.create((ServiceMonitoringServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        Service service = Service.newBuilder().build();
        Service actualResponse = this.client.createService((ResourceName)parent, service);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceRequest actualRequest = (CreateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            Service service = Service.newBuilder().build();
            this.client.createService((ResourceName)parent, service);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest2() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        Service service = Service.newBuilder().build();
        Service actualResponse = this.client.createService(parent, service);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceRequest actualRequest = (CreateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            Service service = Service.newBuilder().build();
            this.client.createService(parent, service);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest3() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Service service = Service.newBuilder().build();
        Service actualResponse = this.client.createService(parent, service);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceRequest actualRequest = (CreateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Service service = Service.newBuilder().build();
            this.client.createService(parent, service);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceTest4() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Service service = Service.newBuilder().build();
        Service actualResponse = this.client.createService(parent, service);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceRequest actualRequest = (CreateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Service service = Service.newBuilder().build();
            this.client.createService(parent, service);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceName name = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
        Service actualResponse = this.client.getService(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetServiceRequest actualRequest = (GetServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceName name = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
            this.client.getService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceTest2() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Service actualResponse = this.client.getService(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetServiceRequest actualRequest = (GetServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getServiceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        ServiceMonitoringServiceClient.ListServicesPagedResponse pagedListResponse = this.client.listServices((ResourceName)parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.listServices((ResourceName)parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest2() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        ServiceMonitoringServiceClient.ListServicesPagedResponse pagedListResponse = this.client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest3() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ServiceMonitoringServiceClient.ListServicesPagedResponse pagedListResponse = this.client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServicesTest4() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ServiceMonitoringServiceClient.ListServicesPagedResponse pagedListResponse = this.client.listServices(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listServices(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateServiceTest() throws Exception {
        Service expectedResponse = Service.newBuilder().setName(ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]").toString()).setDisplayName("displayName1714148973").setTelemetry(Service.Telemetry.newBuilder().build()).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        Service service = Service.newBuilder().build();
        Service actualResponse = this.client.updateService(service);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateServiceRequest actualRequest = (UpdateServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)service, (Object)actualRequest.getService());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            Service service = Service.newBuilder().build();
            this.client.updateService(service);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceName name = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
        this.client.deleteService(name);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteServiceRequest actualRequest = (DeleteServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteServiceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceName name = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
            this.client.deleteService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteService(name);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteServiceRequest actualRequest = (DeleteServiceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteServiceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteService(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceLevelObjectiveTest() throws Exception {
        ServiceLevelObjective expectedResponse = ServiceLevelObjective.newBuilder().setName(ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]").toString()).setDisplayName("displayName1714148973").setServiceLevelIndicator(ServiceLevelIndicator.newBuilder().build()).setGoal(3178259.0).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceName parent = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
        ServiceLevelObjective serviceLevelObjective = ServiceLevelObjective.newBuilder().build();
        ServiceLevelObjective actualResponse = this.client.createServiceLevelObjective(parent, serviceLevelObjective);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceLevelObjectiveRequest actualRequest = (CreateServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)serviceLevelObjective, (Object)actualRequest.getServiceLevelObjective());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceLevelObjectiveExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
            ServiceLevelObjective serviceLevelObjective = ServiceLevelObjective.newBuilder().build();
            this.client.createServiceLevelObjective(parent, serviceLevelObjective);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createServiceLevelObjectiveTest2() throws Exception {
        ServiceLevelObjective expectedResponse = ServiceLevelObjective.newBuilder().setName(ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]").toString()).setDisplayName("displayName1714148973").setServiceLevelIndicator(ServiceLevelIndicator.newBuilder().build()).setGoal(3178259.0).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ServiceLevelObjective serviceLevelObjective = ServiceLevelObjective.newBuilder().build();
        ServiceLevelObjective actualResponse = this.client.createServiceLevelObjective(parent, serviceLevelObjective);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateServiceLevelObjectiveRequest actualRequest = (CreateServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)serviceLevelObjective, (Object)actualRequest.getServiceLevelObjective());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createServiceLevelObjectiveExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ServiceLevelObjective serviceLevelObjective = ServiceLevelObjective.newBuilder().build();
            this.client.createServiceLevelObjective(parent, serviceLevelObjective);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceLevelObjectiveTest() throws Exception {
        ServiceLevelObjective expectedResponse = ServiceLevelObjective.newBuilder().setName(ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]").toString()).setDisplayName("displayName1714148973").setServiceLevelIndicator(ServiceLevelIndicator.newBuilder().build()).setGoal(3178259.0).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceLevelObjectiveName name = ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]");
        ServiceLevelObjective actualResponse = this.client.getServiceLevelObjective(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetServiceLevelObjectiveRequest actualRequest = (GetServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getServiceLevelObjectiveExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceLevelObjectiveName name = ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]");
            this.client.getServiceLevelObjective(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getServiceLevelObjectiveTest2() throws Exception {
        ServiceLevelObjective expectedResponse = ServiceLevelObjective.newBuilder().setName(ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]").toString()).setDisplayName("displayName1714148973").setServiceLevelIndicator(ServiceLevelIndicator.newBuilder().build()).setGoal(3178259.0).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ServiceLevelObjective actualResponse = this.client.getServiceLevelObjective(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetServiceLevelObjectiveRequest actualRequest = (GetServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getServiceLevelObjectiveExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getServiceLevelObjective(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServiceLevelObjectivesTest() throws Exception {
        ServiceLevelObjective responsesElement = ServiceLevelObjective.newBuilder().build();
        ListServiceLevelObjectivesResponse expectedResponse = ListServiceLevelObjectivesResponse.newBuilder().setNextPageToken("").addAllServiceLevelObjectives(Arrays.asList(responsesElement)).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceName parent = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
        ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse pagedListResponse = this.client.listServiceLevelObjectives(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServiceLevelObjectivesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServiceLevelObjectivesRequest actualRequest = (ListServiceLevelObjectivesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServiceLevelObjectivesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.ofProjectServiceName((String)"[PROJECT]", (String)"[SERVICE]");
            this.client.listServiceLevelObjectives(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listServiceLevelObjectivesTest2() throws Exception {
        ServiceLevelObjective responsesElement = ServiceLevelObjective.newBuilder().build();
        ListServiceLevelObjectivesResponse expectedResponse = ListServiceLevelObjectivesResponse.newBuilder().setNextPageToken("").addAllServiceLevelObjectives(Arrays.asList(responsesElement)).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse pagedListResponse = this.client.listServiceLevelObjectives(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServiceLevelObjectivesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServiceLevelObjectivesRequest actualRequest = (ListServiceLevelObjectivesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServiceLevelObjectivesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listServiceLevelObjectives(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateServiceLevelObjectiveTest() throws Exception {
        ServiceLevelObjective expectedResponse = ServiceLevelObjective.newBuilder().setName(ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]").toString()).setDisplayName("displayName1714148973").setServiceLevelIndicator(ServiceLevelIndicator.newBuilder().build()).setGoal(3178259.0).putAllUserLabels(new HashMap()).build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceLevelObjective serviceLevelObjective = ServiceLevelObjective.newBuilder().build();
        ServiceLevelObjective actualResponse = this.client.updateServiceLevelObjective(serviceLevelObjective);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateServiceLevelObjectiveRequest actualRequest = (UpdateServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)serviceLevelObjective, (Object)actualRequest.getServiceLevelObjective());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateServiceLevelObjectiveExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceLevelObjective serviceLevelObjective = ServiceLevelObjective.newBuilder().build();
            this.client.updateServiceLevelObjective(serviceLevelObjective);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceLevelObjectiveTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        ServiceLevelObjectiveName name = ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]");
        this.client.deleteServiceLevelObjective(name);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteServiceLevelObjectiveRequest actualRequest = (DeleteServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteServiceLevelObjectiveExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            ServiceLevelObjectiveName name = ServiceLevelObjectiveName.ofProjectServiceServiceLevelObjectiveName((String)"[PROJECT]", (String)"[SERVICE]", (String)"[SERVICE_LEVEL_OBJECTIVE]");
            this.client.deleteServiceLevelObjective(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteServiceLevelObjectiveTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockServiceMonitoringService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteServiceLevelObjective(name);
        List<AbstractMessage> actualRequests = mockServiceMonitoringService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteServiceLevelObjectiveRequest actualRequest = (DeleteServiceLevelObjectiveRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteServiceLevelObjectiveExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockServiceMonitoringService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteServiceLevelObjective(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

