/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.monitoring.v3.MockUptimeCheckService;
import com.google.cloud.monitoring.v3.UptimeCheckServiceClient;
import com.google.cloud.monitoring.v3.UptimeCheckServiceSettings;
import com.google.monitoring.v3.CreateUptimeCheckConfigRequest;
import com.google.monitoring.v3.DeleteUptimeCheckConfigRequest;
import com.google.monitoring.v3.FolderName;
import com.google.monitoring.v3.GetUptimeCheckConfigRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsResponse;
import com.google.monitoring.v3.ListUptimeCheckIpsRequest;
import com.google.monitoring.v3.ListUptimeCheckIpsResponse;
import com.google.monitoring.v3.OrganizationName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.UpdateUptimeCheckConfigRequest;
import com.google.monitoring.v3.UptimeCheckConfig;
import com.google.monitoring.v3.UptimeCheckConfigName;
import com.google.monitoring.v3.UptimeCheckIp;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class UptimeCheckServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockUptimeCheckService mockUptimeCheckService;
    private LocalChannelProvider channelProvider;
    private UptimeCheckServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockUptimeCheckService = new MockUptimeCheckService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockUptimeCheckService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        UptimeCheckServiceSettings settings = ((UptimeCheckServiceSettings.Builder)((UptimeCheckServiceSettings.Builder)UptimeCheckServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = UptimeCheckServiceClient.create((UptimeCheckServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listUptimeCheckConfigsTest() throws Exception {
        UptimeCheckConfig responsesElement = UptimeCheckConfig.newBuilder().build();
        ListUptimeCheckConfigsResponse expectedResponse = ListUptimeCheckConfigsResponse.newBuilder().setNextPageToken("").addAllUptimeCheckConfigs(Arrays.asList(responsesElement)).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse pagedListResponse = this.client.listUptimeCheckConfigs((ResourceName)parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getUptimeCheckConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUptimeCheckConfigsRequest actualRequest = (ListUptimeCheckConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUptimeCheckConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            this.client.listUptimeCheckConfigs((ResourceName)parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUptimeCheckConfigsTest2() throws Exception {
        UptimeCheckConfig responsesElement = UptimeCheckConfig.newBuilder().build();
        ListUptimeCheckConfigsResponse expectedResponse = ListUptimeCheckConfigsResponse.newBuilder().setNextPageToken("").addAllUptimeCheckConfigs(Arrays.asList(responsesElement)).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse pagedListResponse = this.client.listUptimeCheckConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getUptimeCheckConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUptimeCheckConfigsRequest actualRequest = (ListUptimeCheckConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUptimeCheckConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            this.client.listUptimeCheckConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUptimeCheckConfigsTest3() throws Exception {
        UptimeCheckConfig responsesElement = UptimeCheckConfig.newBuilder().build();
        ListUptimeCheckConfigsResponse expectedResponse = ListUptimeCheckConfigsResponse.newBuilder().setNextPageToken("").addAllUptimeCheckConfigs(Arrays.asList(responsesElement)).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse pagedListResponse = this.client.listUptimeCheckConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getUptimeCheckConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUptimeCheckConfigsRequest actualRequest = (ListUptimeCheckConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUptimeCheckConfigsExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listUptimeCheckConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUptimeCheckConfigsTest4() throws Exception {
        UptimeCheckConfig responsesElement = UptimeCheckConfig.newBuilder().build();
        ListUptimeCheckConfigsResponse expectedResponse = ListUptimeCheckConfigsResponse.newBuilder().setNextPageToken("").addAllUptimeCheckConfigs(Arrays.asList(responsesElement)).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        UptimeCheckServiceClient.ListUptimeCheckConfigsPagedResponse pagedListResponse = this.client.listUptimeCheckConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getUptimeCheckConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUptimeCheckConfigsRequest actualRequest = (ListUptimeCheckConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUptimeCheckConfigsExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listUptimeCheckConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getUptimeCheckConfigTest() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        UptimeCheckConfigName name = UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]");
        UptimeCheckConfig actualResponse = this.client.getUptimeCheckConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetUptimeCheckConfigRequest actualRequest = (GetUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getUptimeCheckConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            UptimeCheckConfigName name = UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]");
            this.client.getUptimeCheckConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getUptimeCheckConfigTest2() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        UptimeCheckConfig actualResponse = this.client.getUptimeCheckConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetUptimeCheckConfigRequest actualRequest = (GetUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getUptimeCheckConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getUptimeCheckConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createUptimeCheckConfigTest() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        FolderName parent = FolderName.of((String)"[FOLDER]");
        UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
        UptimeCheckConfig actualResponse = this.client.createUptimeCheckConfig((ResourceName)parent, uptimeCheckConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateUptimeCheckConfigRequest actualRequest = (CreateUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)uptimeCheckConfig, (Object)actualRequest.getUptimeCheckConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createUptimeCheckConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            FolderName parent = FolderName.of((String)"[FOLDER]");
            UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
            this.client.createUptimeCheckConfig((ResourceName)parent, uptimeCheckConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createUptimeCheckConfigTest2() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
        UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
        UptimeCheckConfig actualResponse = this.client.createUptimeCheckConfig(parent, uptimeCheckConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateUptimeCheckConfigRequest actualRequest = (CreateUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)uptimeCheckConfig, (Object)actualRequest.getUptimeCheckConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createUptimeCheckConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            OrganizationName parent = OrganizationName.of((String)"[ORGANIZATION]");
            UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
            this.client.createUptimeCheckConfig(parent, uptimeCheckConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createUptimeCheckConfigTest3() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
        UptimeCheckConfig actualResponse = this.client.createUptimeCheckConfig(parent, uptimeCheckConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateUptimeCheckConfigRequest actualRequest = (CreateUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)uptimeCheckConfig, (Object)actualRequest.getUptimeCheckConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createUptimeCheckConfigExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
            this.client.createUptimeCheckConfig(parent, uptimeCheckConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createUptimeCheckConfigTest4() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
        UptimeCheckConfig actualResponse = this.client.createUptimeCheckConfig(parent, uptimeCheckConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateUptimeCheckConfigRequest actualRequest = (CreateUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)uptimeCheckConfig, (Object)actualRequest.getUptimeCheckConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createUptimeCheckConfigExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
            this.client.createUptimeCheckConfig(parent, uptimeCheckConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateUptimeCheckConfigTest() throws Exception {
        UptimeCheckConfig expectedResponse = UptimeCheckConfig.newBuilder().setName(UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]").toString()).setDisplayName("displayName1714148973").setPeriod(Duration.newBuilder().build()).setTimeout(Duration.newBuilder().build()).addAllContentMatchers(new ArrayList()).addAllSelectedRegions(new ArrayList()).setIsInternal(true).addAllInternalCheckers(new ArrayList()).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
        UptimeCheckConfig actualResponse = this.client.updateUptimeCheckConfig(uptimeCheckConfig);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateUptimeCheckConfigRequest actualRequest = (UpdateUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)uptimeCheckConfig, (Object)actualRequest.getUptimeCheckConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateUptimeCheckConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            UptimeCheckConfig uptimeCheckConfig = UptimeCheckConfig.newBuilder().build();
            this.client.updateUptimeCheckConfig(uptimeCheckConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteUptimeCheckConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        UptimeCheckConfigName name = UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]");
        this.client.deleteUptimeCheckConfig(name);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteUptimeCheckConfigRequest actualRequest = (DeleteUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteUptimeCheckConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            UptimeCheckConfigName name = UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)"[PROJECT]", (String)"[UPTIME_CHECK_CONFIG]");
            this.client.deleteUptimeCheckConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteUptimeCheckConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteUptimeCheckConfig(name);
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteUptimeCheckConfigRequest actualRequest = (DeleteUptimeCheckConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteUptimeCheckConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteUptimeCheckConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listUptimeCheckIpsTest() throws Exception {
        UptimeCheckIp responsesElement = UptimeCheckIp.newBuilder().build();
        ListUptimeCheckIpsResponse expectedResponse = ListUptimeCheckIpsResponse.newBuilder().setNextPageToken("").addAllUptimeCheckIps(Arrays.asList(responsesElement)).build();
        mockUptimeCheckService.addResponse((AbstractMessage)expectedResponse);
        ListUptimeCheckIpsRequest request = ListUptimeCheckIpsRequest.newBuilder().setPageSize(883849137).setPageToken("pageToken873572522").build();
        UptimeCheckServiceClient.ListUptimeCheckIpsPagedResponse pagedListResponse = this.client.listUptimeCheckIps(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getUptimeCheckIpsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockUptimeCheckService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListUptimeCheckIpsRequest actualRequest = (ListUptimeCheckIpsRequest)actualRequests.get(0);
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listUptimeCheckIpsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockUptimeCheckService.addException((Exception)exception);
        try {
            ListUptimeCheckIpsRequest request = ListUptimeCheckIpsRequest.newBuilder().setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listUptimeCheckIps(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

