/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MockIAMPolicy;
import com.google.cloud.pubsub.v1.MockSubscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.GetPolicyOptions;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.BigQueryConfig;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeadLetterPolicy;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.ExpirationPolicy;
import com.google.pubsub.v1.GetSnapshotRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.RetryPolicy;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.SnapshotName;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SubscriptionAdminClientTest {
    private static MockIAMPolicy mockIAMPolicy;
    private static MockServiceHelper mockServiceHelper;
    private static MockSubscriber mockSubscriber;
    private LocalChannelProvider channelProvider;
    private SubscriptionAdminClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockSubscriber = new MockSubscriber();
        mockIAMPolicy = new MockIAMPolicy();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockSubscriber, mockIAMPolicy));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        SubscriptionAdminSettings settings = ((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = SubscriptionAdminClient.create((SubscriptionAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Subscription actualRequest = (Subscription)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest2() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        String topic = "topic110546223";
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Subscription actualRequest = (Subscription)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName name = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            String topic = "topic110546223";
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest3() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Subscription actualRequest = (Subscription)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)topic.toString(), (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String name = "name3373707";
            TopicName topic = TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubscriptionTest4() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String topic = "topic110546223";
        PushConfig pushConfig = PushConfig.newBuilder().build();
        int ackDeadlineSeconds = 2135351438;
        Subscription actualResponse = this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Subscription actualRequest = (Subscription)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)topic, (Object)actualRequest.getTopic());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubscriptionExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String name = "name3373707";
            String topic = "topic110546223";
            PushConfig pushConfig = PushConfig.newBuilder().build();
            int ackDeadlineSeconds = 2135351438;
            this.client.createSubscription(name, topic, pushConfig, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Subscription actualResponse = this.client.getSubscription(subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubscriptionRequest actualRequest = (GetSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.getSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubscriptionTest2() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        Subscription actualResponse = this.client.getSubscription(subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubscriptionRequest actualRequest = (GetSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubscriptionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            this.client.getSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSubscriptionTest() throws Exception {
        Subscription expectedResponse = Subscription.newBuilder().setName(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setPushConfig(PushConfig.newBuilder().build()).setBigqueryConfig(BigQueryConfig.newBuilder().build()).setAckDeadlineSeconds(2135351438).setRetainAckedMessages(true).setMessageRetentionDuration(Duration.newBuilder().build()).putAllLabels(new HashMap()).setEnableMessageOrdering(true).setExpirationPolicy(ExpirationPolicy.newBuilder().build()).setFilter("filter-1274492040").setDeadLetterPolicy(DeadLetterPolicy.newBuilder().build()).setRetryPolicy(RetryPolicy.newBuilder().build()).setDetached(true).setEnableExactlyOnceDelivery(true).setTopicMessageRetentionDuration(Duration.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        UpdateSubscriptionRequest request = UpdateSubscriptionRequest.newBuilder().setSubscription(Subscription.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Subscription actualResponse = this.client.updateSubscription(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSubscriptionRequest actualRequest = (UpdateSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSubscription(), (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            UpdateSubscriptionRequest request = UpdateSubscriptionRequest.newBuilder().setSubscription(Subscription.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.updateSubscription(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest() throws Exception {
        Subscription responsesElement = Subscription.newBuilder().build();
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        SubscriptionAdminClient.ListSubscriptionsPagedResponse pagedListResponse = this.client.listSubscriptions(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubscriptionsRequest actualRequest = (ListSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project.toString(), (Object)actualRequest.getProject());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubscriptionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            this.client.listSubscriptions(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubscriptionsTest2() throws Exception {
        Subscription responsesElement = Subscription.newBuilder().build();
        ListSubscriptionsResponse expectedResponse = ListSubscriptionsResponse.newBuilder().setNextPageToken("").addAllSubscriptions(Arrays.asList(responsesElement)).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String project = "project-309310695";
        SubscriptionAdminClient.ListSubscriptionsPagedResponse pagedListResponse = this.client.listSubscriptions(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubscriptionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubscriptionsRequest actualRequest = (ListSubscriptionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project, (Object)actualRequest.getProject());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubscriptionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String project = "project-309310695";
            this.client.listSubscriptions(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        this.client.deleteSubscription(subscription);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubscriptionRequest actualRequest = (DeleteSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubscriptionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.deleteSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubscriptionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        this.client.deleteSubscription(subscription);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubscriptionRequest actualRequest = (DeleteSubscriptionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubscriptionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            this.client.deleteSubscription(subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyAckDeadlineTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList ackIds = new ArrayList();
        int ackDeadlineSeconds = 2135351438;
        this.client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyAckDeadlineRequest actualRequest = (ModifyAckDeadlineRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertEquals(ackIds, (Object)actualRequest.getAckIdsList());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyAckDeadlineExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList ackIds = new ArrayList();
            int ackDeadlineSeconds = 2135351438;
            this.client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyAckDeadlineTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        ArrayList ackIds = new ArrayList();
        int ackDeadlineSeconds = 2135351438;
        this.client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyAckDeadlineRequest actualRequest = (ModifyAckDeadlineRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals(ackIds, (Object)actualRequest.getAckIdsList());
        Assert.assertEquals((long)ackDeadlineSeconds, (long)actualRequest.getAckDeadlineSeconds());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyAckDeadlineExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            ArrayList ackIds = new ArrayList();
            int ackDeadlineSeconds = 2135351438;
            this.client.modifyAckDeadline(subscription, ackIds, ackDeadlineSeconds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void acknowledgeTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        ArrayList ackIds = new ArrayList();
        this.client.acknowledge(subscription, ackIds);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AcknowledgeRequest actualRequest = (AcknowledgeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertEquals(ackIds, (Object)actualRequest.getAckIdsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void acknowledgeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            ArrayList ackIds = new ArrayList();
            this.client.acknowledge(subscription, ackIds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void acknowledgeTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        ArrayList ackIds = new ArrayList();
        this.client.acknowledge(subscription, ackIds);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        AcknowledgeRequest actualRequest = (AcknowledgeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals(ackIds, (Object)actualRequest.getAckIdsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void acknowledgeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            ArrayList ackIds = new ArrayList();
            this.client.acknowledge(subscription, ackIds);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        int maxMessages = 496131527;
        PullResponse actualResponse = this.client.pull(subscription, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PullRequest actualRequest = (PullRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertEquals((long)maxMessages, (long)actualRequest.getMaxMessages());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void pullExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            int maxMessages = 496131527;
            this.client.pull(subscription, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest2() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        int maxMessages = 496131527;
        PullResponse actualResponse = this.client.pull(subscription, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PullRequest actualRequest = (PullRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals((long)maxMessages, (long)actualRequest.getMaxMessages());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void pullExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            int maxMessages = 496131527;
            this.client.pull(subscription, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest3() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        boolean returnImmediately = true;
        int maxMessages = 496131527;
        PullResponse actualResponse = this.client.pull(subscription, returnImmediately, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PullRequest actualRequest = (PullRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)returnImmediately, (Object)actualRequest.getReturnImmediately());
        Assert.assertEquals((long)maxMessages, (long)actualRequest.getMaxMessages());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void pullExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            boolean returnImmediately = true;
            int maxMessages = 496131527;
            this.client.pull(subscription, returnImmediately, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void pullTest4() throws Exception {
        PullResponse expectedResponse = PullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        boolean returnImmediately = true;
        int maxMessages = 496131527;
        PullResponse actualResponse = this.client.pull(subscription, returnImmediately, maxMessages);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PullRequest actualRequest = (PullRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)returnImmediately, (Object)actualRequest.getReturnImmediately());
        Assert.assertEquals((long)maxMessages, (long)actualRequest.getMaxMessages());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void pullExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            boolean returnImmediately = true;
            int maxMessages = 496131527;
            this.client.pull(subscription, returnImmediately, maxMessages);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void streamingPullTest() throws Exception {
        StreamingPullResponse expectedResponse = StreamingPullResponse.newBuilder().addAllReceivedMessages(new ArrayList()).setAcknowledgeConfirmation(StreamingPullResponse.AcknowledgeConfirmation.newBuilder().build()).setModifyAckDeadlineConfirmation(StreamingPullResponse.ModifyAckDeadlineConfirmation.newBuilder().build()).setSubscriptionProperties(StreamingPullResponse.SubscriptionProperties.newBuilder().build()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        StreamingPullRequest request = StreamingPullRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).addAllAckIds(new ArrayList()).addAllModifyDeadlineSeconds(new ArrayList()).addAllModifyDeadlineAckIds(new ArrayList()).setStreamAckDeadlineSeconds(1875467245).setClientId("clientId908408390").setMaxOutstandingMessages(-1315266996L).setMaxOutstandingBytes(-2103098517L).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamingPullCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void streamingPullExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        StreamingPullRequest request = StreamingPullRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).addAllAckIds(new ArrayList()).addAllModifyDeadlineSeconds(new ArrayList()).addAllModifyDeadlineAckIds(new ArrayList()).setStreamAckDeadlineSeconds(1875467245).setClientId("clientId908408390").setMaxOutstandingMessages(-1315266996L).setMaxOutstandingBytes(-2103098517L).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamingPullCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void modifyPushConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        PushConfig pushConfig = PushConfig.newBuilder().build();
        this.client.modifyPushConfig(subscription, pushConfig);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyPushConfigRequest actualRequest = (ModifyPushConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyPushConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            PushConfig pushConfig = PushConfig.newBuilder().build();
            this.client.modifyPushConfig(subscription, pushConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void modifyPushConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String subscription = "subscription341203229";
        PushConfig pushConfig = PushConfig.newBuilder().build();
        this.client.modifyPushConfig(subscription, pushConfig);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ModifyPushConfigRequest actualRequest = (ModifyPushConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)pushConfig, (Object)actualRequest.getPushConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void modifyPushConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String subscription = "subscription341203229";
            PushConfig pushConfig = PushConfig.newBuilder().build();
            this.client.modifyPushConfig(subscription, pushConfig);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        Snapshot actualResponse = this.client.getSnapshot(snapshot);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnapshotRequest actualRequest = (GetSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snapshot.toString(), (Object)actualRequest.getSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            this.client.getSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String snapshot = "snapshot284874180";
        Snapshot actualResponse = this.client.getSnapshot(snapshot);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnapshotRequest actualRequest = (GetSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snapshot, (Object)actualRequest.getSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String snapshot = "snapshot284874180";
            this.client.getSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        ProjectName project = ProjectName.of((String)"[PROJECT]");
        SubscriptionAdminClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project.toString(), (Object)actualRequest.getProject());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            ProjectName project = ProjectName.of((String)"[PROJECT]");
            this.client.listSnapshots(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest2() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String project = "project-309310695";
        SubscriptionAdminClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(project);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)project, (Object)actualRequest.getProject());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String project = "project-309310695";
            this.client.listSnapshots(project);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Snapshot actualResponse = this.client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        String subscription = "subscription341203229";
        Snapshot actualResponse = this.client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            String subscription = "subscription341203229";
            this.client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest3() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
        Snapshot actualResponse = this.client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)subscription.toString(), (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String name = "name3373707";
            SubscriptionName subscription = SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]");
            this.client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest4() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String subscription = "subscription341203229";
        Snapshot actualResponse = this.client.createSnapshot(name, subscription);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)subscription, (Object)actualRequest.getSubscription());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String name = "name3373707";
            String subscription = "subscription341203229";
            this.client.createSnapshot(name, subscription);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]").toString()).setTopic(TopicName.ofProjectTopicName((String)"[PROJECT]", (String)"[TOPIC]").toString()).setExpireTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        UpdateSnapshotRequest request = UpdateSnapshotRequest.newBuilder().setSnapshot(Snapshot.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Snapshot actualResponse = this.client.updateSnapshot(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSnapshotRequest actualRequest = (UpdateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSnapshot(), (Object)actualRequest.getSnapshot());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            UpdateSnapshotRequest request = UpdateSnapshotRequest.newBuilder().setSnapshot(Snapshot.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.updateSnapshot(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
        this.client.deleteSnapshot(snapshot);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snapshot.toString(), (Object)actualRequest.getSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SnapshotName snapshot = SnapshotName.of((String)"[PROJECT]", (String)"[SNAPSHOT]");
            this.client.deleteSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        String snapshot = "snapshot284874180";
        this.client.deleteSnapshot(snapshot);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snapshot, (Object)actualRequest.getSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            String snapshot = "snapshot284874180";
            this.client.deleteSnapshot(snapshot);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void seekTest() throws Exception {
        SeekResponse expectedResponse = SeekResponse.newBuilder().build();
        mockSubscriber.addResponse((AbstractMessage)expectedResponse);
        SeekRequest request = SeekRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
        SeekResponse actualResponse = this.client.seek(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockSubscriber.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SeekRequest actualRequest = (SeekRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getSubscription(), (Object)actualRequest.getSubscription());
        Assert.assertEquals((Object)request.getTime(), (Object)actualRequest.getTime());
        Assert.assertEquals((Object)request.getSnapshot(), (Object)actualRequest.getSnapshot());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void seekExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockSubscriber.addException((Exception)exception);
        try {
            SeekRequest request = SeekRequest.newBuilder().setSubscription(SubscriptionName.of((String)"[PROJECT]", (String)"[SUBSCRIPTION]").toString()).build();
            this.client.seek(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
        Policy actualResponse = this.client.setIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPolicy(), (Object)actualRequest.getPolicy());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setPolicy(Policy.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).build();
            this.client.setIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
        Policy actualResponse = this.client.getIamPolicy(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getOptions(), (Object)actualRequest.getOptions());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).setOptions(GetPolicyOptions.newBuilder().build()).build();
            this.client.getIamPolicy(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockIAMPolicy.addResponse((AbstractMessage)expectedResponse);
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockIAMPolicy.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getResource(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)request.getPermissionsList(), (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockIAMPolicy.addException((Exception)exception);
        try {
            TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SchemaName.of((String)"[PROJECT]", (String)"[SCHEMA]").toString()).addAllPermissions(new ArrayList()).build();
            this.client.testIamPermissions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

