/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.testing.UnitTestExamples;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.google.pubsub.v1.PubsubMessage;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableListMultimap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Base64;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MessageTransformsTest {
    private static final byte[] notUtf8Array = new byte[]{-1, -1};
    private static final MessageTransformer<SequencedMessage, PubsubMessage> subscribeTransformer = MessageTransforms.toCpsSubscribeTransformer();
    private static final MessageTransformer<PubsubMessage, Message> publishTransformer = MessageTransforms.fromCpsPublishTransformer((KeyExtractor)KeyExtractor.DEFAULT);

    @Test
    public void subscribeTransformInvalidKey() {
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            PubsubMessage cfr_ignored_0 = (PubsubMessage)subscribeTransformer.transform((Object)SequencedMessage.of((Message)Message.builder().setKey(ByteString.copyFrom((byte[])notUtf8Array)).build(), (Timestamp)Timestamps.fromNanos((long)0L), (Offset)Offset.of((long)10L), (long)10L));
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void subscribeTransformContainsMagicAttribute() {
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            PubsubMessage cfr_ignored_0 = (PubsubMessage)subscribeTransformer.transform((Object)SequencedMessage.of((Message)Message.builder().setAttributes(ImmutableListMultimap.builder().put((Object)"x-goog-pubsublite-event-time-timestamp-proto", (Object)ByteString.EMPTY).build()).build(), (Timestamp)Timestamps.fromNanos((long)0L), (Offset)Offset.of((long)10L), (long)10L));
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void subscribeTransformContainsMultipleAttributes() {
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            PubsubMessage cfr_ignored_0 = (PubsubMessage)subscribeTransformer.transform((Object)SequencedMessage.of((Message)Message.builder().setAttributes(ImmutableListMultimap.builder().put((Object)"abc", (Object)ByteString.EMPTY).put((Object)"abc", (Object)ByteString.copyFromUtf8((String)"def")).build()).build(), (Timestamp)Timestamps.fromNanos((long)0L), (Offset)Offset.of((long)10L), (long)10L));
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void subscribeTransformContainsNonUtf8Attributes() {
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            PubsubMessage cfr_ignored_0 = (PubsubMessage)subscribeTransformer.transform((Object)SequencedMessage.of((Message)Message.builder().setAttributes(ImmutableListMultimap.builder().put((Object)"abc", (Object)ByteString.copyFrom((byte[])notUtf8Array)).build()).build(), (Timestamp)Timestamps.fromNanos((long)0L), (Offset)Offset.of((long)10L), (long)10L));
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void subscribeTransformCorrect() throws ApiException {
        SequencedMessage message = SequencedMessage.of((Message)Message.builder().setAttributes(ImmutableListMultimap.builder().put((Object)"abc", (Object)ByteString.EMPTY).put((Object)"def", (Object)ByteString.copyFromUtf8((String)"hij")).build()).setData(ByteString.copyFrom((byte[])notUtf8Array)).setEventTime(Timestamps.fromNanos((long)10L)).setKey(ByteString.copyFromUtf8((String)"some_key")).build(), (Timestamp)Timestamps.fromSeconds((long)5L), (Offset)Offset.of((long)7L), (long)2L);
        PubsubMessage result = PubsubMessage.newBuilder().setData(message.message().data()).setOrderingKey("some_key").setPublishTime(message.publishTime()).putAttributes("abc", "").putAttributes("def", "hij").putAttributes("x-goog-pubsublite-event-time-timestamp-proto", MessageTransforms.encodeAttributeEventTime((Timestamp)((Timestamp)message.message().eventTime().get()))).build();
        Truth.assertThat((Object)subscribeTransformer.transform((Object)message)).isEqualTo((Object)result);
    }

    @Test
    public void wrappedSubscribeTransformerSetsIdFailure() throws ApiException {
        MessageTransformer mockTransformer = (MessageTransformer)Mockito.mock(MessageTransformer.class);
        MessageTransformer wrapped = MessageTransforms.addIdCpsSubscribeTransformer((Partition)((Partition)UnitTestExamples.example(Partition.class)), (MessageTransformer)mockTransformer);
        Mockito.when((Object)mockTransformer.transform(ArgumentMatchers.any())).thenReturn((Object)PubsubMessage.newBuilder().setMessageId("3").build());
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            PubsubMessage cfr_ignored_0 = (PubsubMessage)wrapped.transform((Object)SequencedMessage.of((Message)Message.builder().setAttributes(ImmutableListMultimap.builder().put((Object)"abc", (Object)ByteString.EMPTY).put((Object)"def", (Object)ByteString.copyFromUtf8((String)"hij")).build()).setData(ByteString.copyFrom((byte[])notUtf8Array)).setEventTime(Timestamps.fromNanos((long)10L)).setKey(ByteString.copyFromUtf8((String)"some_key")).build(), (Timestamp)Timestamps.fromSeconds((long)5L), (Offset)Offset.of((long)7L), (long)2L));
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void wrappedSubscribeTransformerMetadataId() throws ApiException {
        MessageTransformer wrapped = MessageTransforms.addIdCpsSubscribeTransformer((Partition)((Partition)UnitTestExamples.example(Partition.class)), subscribeTransformer);
        SequencedMessage message = SequencedMessage.of((Message)Message.builder().setAttributes(ImmutableListMultimap.builder().put((Object)"abc", (Object)ByteString.EMPTY).put((Object)"def", (Object)ByteString.copyFromUtf8((String)"hij")).build()).setData(ByteString.copyFrom((byte[])notUtf8Array)).setEventTime(Timestamps.fromNanos((long)10L)).setKey(ByteString.copyFromUtf8((String)"some_key")).build(), (Timestamp)Timestamps.fromSeconds((long)5L), (Offset)((Offset)UnitTestExamples.example(Offset.class)), (long)2L);
        PubsubMessage result = PubsubMessage.newBuilder().setData(message.message().data()).setMessageId(MessageMetadata.of((Partition)((Partition)UnitTestExamples.example(Partition.class)), (Offset)((Offset)UnitTestExamples.example(Offset.class))).encode()).setOrderingKey("some_key").setPublishTime(message.publishTime()).putAttributes("abc", "").putAttributes("def", "hij").putAttributes("x-goog-pubsublite-event-time-timestamp-proto", MessageTransforms.encodeAttributeEventTime((Timestamp)((Timestamp)message.message().eventTime().get()))).build();
        Truth.assertThat((Object)wrapped.transform((Object)message)).isEqualTo((Object)result);
    }

    @Test
    public void publishTransformExtractorFailure() {
        MessageTransformer transformer = MessageTransforms.fromCpsPublishTransformer(message -> {
            throw new CheckedApiException((StatusCode.Code)StatusCode.Code.INTERNAL).underlying;
        });
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            Message cfr_ignored_0 = (Message)transformer.transform((Object)PubsubMessage.getDefaultInstance());
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INTERNAL);
    }

    @Test
    public void publishTransformInvalidEventTime() {
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            Message cfr_ignored_0 = (Message)publishTransformer.transform((Object)PubsubMessage.newBuilder().putAttributes("x-goog-pubsublite-event-time-timestamp-proto", "Unlikely to be an encoded timestamp proto.").build());
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void publishTransformValidBase64InvalidEventTime() {
        ApiException e = (ApiException)Assert.assertThrows(ApiException.class, () -> {
            Message cfr_ignored_0 = (Message)publishTransformer.transform((Object)PubsubMessage.newBuilder().putAttributes("x-goog-pubsublite-event-time-timestamp-proto", Base64.getEncoder().encodeToString("Unlikely to be an encoded timestamp proto.".getBytes())).build());
        });
        Truth.assertThat((Comparable)e.getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
    }

    @Test
    public void publishTransformCorrect() throws ApiException {
        PubsubMessage message = PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])notUtf8Array)).setOrderingKey("some_key").putAttributes("abc", "").putAttributes("def", "hij").putAttributes("x-goog-pubsublite-event-time-timestamp-proto", MessageTransforms.encodeAttributeEventTime((Timestamp)Timestamps.fromNanos((long)100L))).build();
        Message result = Message.builder().setData(ByteString.copyFrom((byte[])notUtf8Array)).setKey(ByteString.copyFromUtf8((String)"some_key")).setAttributes(ImmutableListMultimap.builder().put((Object)"abc", (Object)ByteString.EMPTY).put((Object)"def", (Object)ByteString.copyFromUtf8((String)"hij")).build()).setEventTime(Timestamps.fromNanos((long)100L)).build();
        Truth.assertThat((Object)publishTransformer.transform((Object)message)).isEqualTo((Object)result);
    }
}

