/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class PublisherSettingsTest {
    @Spy
    private FakePublisher underlying;
    @Spy
    private FakeConfigWatcher fakeWatcher;

    TopicPath getPath() throws CheckedApiException {
        return ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setProject(ProjectNumber.of((long)56L))).setLocation(CloudZone.parse((String)"us-central1-a"))).setName(TopicName.of((String)"xyz")).build();
    }

    @Test
    public void testSettings() throws CheckedApiException {
        MockitoAnnotations.initMocks((Object)this);
        SinglePartitionPublisherBuilder.Builder mockBuilder = (SinglePartitionPublisherBuilder.Builder)Mockito.mock(SinglePartitionPublisherBuilder.Builder.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)mockBuilder.build()).thenReturn((Object)this.underlying);
        PublisherSettings.newBuilder().setTopicPath(this.getPath()).setServiceClient((PublisherServiceClient)Mockito.mock(PublisherServiceClient.class)).setAdminClient((AdminClient)Mockito.mock(AdminClient.class)).setUnderlyingBuilder(mockBuilder).build().instantiate();
    }

    static abstract class FakeConfigWatcher
    extends FakeApiService
    implements PartitionCountWatcher {
        FakeConfigWatcher() {
        }
    }

    static abstract class FakePublisher
    extends FakeApiService
    implements Publisher<MessageMetadata> {
        FakePublisher() {
        }
    }
}

