/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.SubscriberSettings;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SubscriberSettingsTest {
    SubscriptionPath getPath() {
        return ((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(ProjectNumber.of((long)56L))).setLocation(CloudZone.parse((String)"us-central1-a"))).setName(SubscriptionName.of((String)"xyz")).build();
    }

    @Test
    public void testSettingsWithPartitons() {
        SubscriberSettings.newBuilder().setReceiver((MessageReceiver)Mockito.mock(MessageReceiver.class)).setSubscriptionPath(this.getPath()).setPerPartitionFlowControlSettings(FlowControlSettings.builder().setBytesOutstanding(1L).setMessagesOutstanding(1L).build()).setCursorServiceClient((CursorServiceClient)Mockito.mock(CursorServiceClient.class)).setSubscriberServiceClient((SubscriberServiceClient)Mockito.mock(SubscriberServiceClient.class)).setPartitions((List)ImmutableList.of((Object)Partition.of((long)3L), (Object)Partition.of((long)1L))).build().instantiate();
    }

    @Test
    public void testSettingsWithoutPartitons() {
        SubscriberSettings.newBuilder().setReceiver((MessageReceiver)Mockito.mock(MessageReceiver.class)).setSubscriptionPath(this.getPath()).setPerPartitionFlowControlSettings(FlowControlSettings.builder().setBytesOutstanding(1L).setMessagesOutstanding(1L).build()).setAssignmentServiceClient((PartitionAssignmentServiceClient)Mockito.mock(PartitionAssignmentServiceClient.class)).setCursorServiceClient((CursorServiceClient)Mockito.mock(CursorServiceClient.class)).setSubscriberServiceClient((SubscriberServiceClient)Mockito.mock(SubscriberServiceClient.class)).build().instantiate();
    }
}

