/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub.internal;

import com.google.api.core.ApiService;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTracker;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTrackerImpl;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.cloud.pubsublite.internal.testing.RetryingConnectionHelpers;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.proto.Cursor;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class AckSetTrackerImplTest {
    @Spy
    private FakeCommitter committer;
    AckSetTracker tracker;

    private static SequencedMessage messageForOffset(int offset) {
        return SequencedMessage.fromProto((com.google.cloud.pubsublite.proto.SequencedMessage)com.google.cloud.pubsublite.proto.SequencedMessage.newBuilder().setCursor(Cursor.newBuilder().setOffset((long)offset).build()).build());
    }

    @Before
    public void setUp() throws ApiException {
        MockitoAnnotations.initMocks((Object)this);
        this.tracker = new AckSetTrackerImpl((Committer)this.committer);
        this.tracker.startAsync().awaitRunning();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer)))).startAsync();
    }

    @After
    public void tearDown() {
        if (this.tracker.isRunning()) {
            this.tracker.stopAsync().awaitTerminated();
            ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer)))).stopAsync();
        }
    }

    @Test
    public void trackAndAggregateAcks() throws CheckedApiException {
        Runnable ack1 = this.tracker.track(AckSetTrackerImplTest.messageForOffset(1));
        Runnable ack3 = this.tracker.track(AckSetTrackerImplTest.messageForOffset(3));
        Runnable ack5 = this.tracker.track(AckSetTrackerImplTest.messageForOffset(5));
        Runnable ignoredAck7 = this.tracker.track(AckSetTrackerImplTest.messageForOffset(7));
        SettableApiFuture commitFuture = SettableApiFuture.create();
        Mockito.when((Object)this.committer.commitOffset(Offset.of((long)6L))).thenReturn((Object)commitFuture);
        ack3.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer), (VerificationMode)Mockito.times((int)0)))).commitOffset((Offset)Mockito.any());
        ack5.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer), (VerificationMode)Mockito.times((int)0)))).commitOffset((Offset)Mockito.any());
        ack1.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer), (VerificationMode)Mockito.times((int)1)))).commitOffset((Offset)Mockito.any());
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer)))).commitOffset(Offset.of((long)6L));
        commitFuture.set(null);
        Truth.assertThat((Boolean)this.tracker.isRunning()).isTrue();
    }

    @Test
    public void duplicateAckFails() throws Exception {
        Runnable ack1 = this.tracker.track(AckSetTrackerImplTest.messageForOffset(1));
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.tracker);
        SettableApiFuture commitFuture = SettableApiFuture.create();
        Mockito.when((Object)this.committer.commitOffset(Offset.of((long)2L))).thenReturn((Object)commitFuture);
        ack1.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer), (VerificationMode)Mockito.times((int)1)))).commitOffset((Offset)Mockito.any());
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer)))).commitOffset(Offset.of((long)2L));
        commitFuture.set(null);
        Truth.assertThat((Boolean)this.tracker.isRunning()).isTrue();
        Assert.assertThrows(ApiException.class, ack1::run);
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.tracker.failureCause(), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void waitUntilCommittedDiscardsPendingAcks() throws Exception {
        Runnable ack = this.tracker.track(AckSetTrackerImplTest.messageForOffset(1));
        this.tracker.waitUntilCommitted();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer)))).waitUntilEmpty();
        ack.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer), (VerificationMode)Mockito.never()))).commitOffset((Offset)Mockito.any());
    }

    @Test
    public void ackAfterShutdown() throws Exception {
        Runnable ack = this.tracker.track(AckSetTrackerImplTest.messageForOffset(1));
        this.tracker.stopAsync().awaitTerminated();
        ack.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.committer), (VerificationMode)Mockito.never()))).commitOffset((Offset)Mockito.any());
    }

    static abstract class FakeCommitter
    extends FakeApiService
    implements Committer {
        FakeCommitter() {
        }
    }
}

