/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.internal.WrappingPublisher;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class WrappingPublisherTest {
    @Spy
    private FakePublisher underlying;
    private WrappingPublisher publisher;

    @Before
    public void setUp() throws CheckedApiException {
        MockitoAnnotations.initMocks((Object)this);
        this.publisher = new WrappingPublisher((Publisher)this.underlying, MessageTransforms.fromCpsPublishTransformer((KeyExtractor)KeyExtractor.DEFAULT));
        this.publisher.startAsync().awaitRunning();
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.underlying)))).startAsync();
    }

    @After
    public void tearDown() {
        if (this.publisher.isRunning()) {
            this.publisher.stopAsync().awaitTerminated();
            ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.underlying)))).stopAsync();
        }
    }

    @Test
    public void validPublish() throws Exception {
        PubsubMessage message = PubsubMessage.newBuilder().setOrderingKey("abc").build();
        Message wireMessage = Message.builder().setKey(ByteString.copyFromUtf8((String)"abc")).build();
        SettableApiFuture metadataFuture = SettableApiFuture.create();
        Mockito.when((Object)this.underlying.publish(wireMessage)).thenReturn((Object)metadataFuture);
        ApiFuture published = this.publisher.publish(message);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.underlying)))).publish(wireMessage);
        Truth.assertThat((Boolean)published.isDone()).isFalse();
        MessageMetadata metadata = MessageMetadata.of((Partition)Partition.of((long)3L), (Offset)Offset.of((long)88L));
        metadataFuture.set((Object)metadata);
        Truth.assertThat((String)((String)published.get())).isEqualTo((Object)metadata.encode());
    }

    @Test
    public void badTimestampCannotBeTransformed() {
        PubsubMessage message = PubsubMessage.newBuilder().setOrderingKey("abc").putAttributes("x-goog-pubsublite-event-time-timestamp-proto", "Not a valid encoded timestamp").build();
        ApiFuture published = this.publisher.publish(message);
        ((FakePublisher)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)0)))).publish((Message)ArgumentMatchers.any());
        ApiExceptionMatcher.assertFutureThrowsCode(published, StatusCode.Code.INVALID_ARGUMENT);
        Truth.assertThat((Boolean)this.publisher.isRunning()).isFalse();
    }

    @Test
    public void publishAfterFailureFailedImmediately() throws Exception {
        this.underlying.fail((Throwable)new CheckedApiException(StatusCode.Code.FAILED_PRECONDITION));
        Assert.assertThrows(Throwable.class, () -> ((WrappingPublisher)this.publisher).awaitTerminated());
        PubsubMessage message = PubsubMessage.newBuilder().setOrderingKey("abc").build();
        ApiFuture published = this.publisher.publish(message);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> published.get());
        Truth.assertThat((Comparable)ExtractStatus.toCanonical((Throwable)e).code()).isEqualTo((Object)StatusCode.Code.FAILED_PRECONDITION);
    }

    static abstract class FakePublisher
    extends FakeApiService
    implements Publisher<MessageMetadata> {
        FakePublisher() {
        }
    }
}

