/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.BacklogLocation;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.LocationPath;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.ReservationName;
import com.google.cloud.pubsublite.ReservationPath;
import com.google.cloud.pubsublite.SeekTarget;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.AdminClientImpl;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.testing.UnitTestExamples;
import com.google.cloud.pubsublite.proto.CreateReservationRequest;
import com.google.cloud.pubsublite.proto.CreateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.CreateTopicRequest;
import com.google.cloud.pubsublite.proto.DeleteReservationRequest;
import com.google.cloud.pubsublite.proto.DeleteSubscriptionRequest;
import com.google.cloud.pubsublite.proto.DeleteTopicRequest;
import com.google.cloud.pubsublite.proto.GetReservationRequest;
import com.google.cloud.pubsublite.proto.GetSubscriptionRequest;
import com.google.cloud.pubsublite.proto.GetTopicPartitionsRequest;
import com.google.cloud.pubsublite.proto.GetTopicRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsRequest;
import com.google.cloud.pubsublite.proto.ListReservationTopicsResponse;
import com.google.cloud.pubsublite.proto.ListReservationsRequest;
import com.google.cloud.pubsublite.proto.ListReservationsResponse;
import com.google.cloud.pubsublite.proto.ListSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsRequest;
import com.google.cloud.pubsublite.proto.ListTopicSubscriptionsResponse;
import com.google.cloud.pubsublite.proto.ListTopicsRequest;
import com.google.cloud.pubsublite.proto.ListTopicsResponse;
import com.google.cloud.pubsublite.proto.OperationMetadata;
import com.google.cloud.pubsublite.proto.Reservation;
import com.google.cloud.pubsublite.proto.SeekSubscriptionRequest;
import com.google.cloud.pubsublite.proto.SeekSubscriptionResponse;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.proto.TimeTarget;
import com.google.cloud.pubsublite.proto.Topic;
import com.google.cloud.pubsublite.proto.TopicPartitions;
import com.google.cloud.pubsublite.proto.UpdateReservationRequest;
import com.google.cloud.pubsublite.proto.UpdateSubscriptionRequest;
import com.google.cloud.pubsublite.proto.UpdateTopicRequest;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.stub.AdminServiceStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class AdminClientImplTest {
    private static final FieldMask MASK = FieldMask.newBuilder().addPaths("config").build();
    private static final Topic TOPIC_2 = ((Topic)UnitTestExamples.example(Topic.class)).toBuilder().setPartitionConfig(Topic.PartitionConfig.newBuilder().setCount(88L)).build();
    private static final Subscription SUBSCRIPTION_2 = ((Subscription)UnitTestExamples.example(Subscription.class)).toBuilder().setDeliveryConfig(Subscription.DeliveryConfig.newBuilder().setDeliveryRequirement(Subscription.DeliveryConfig.DeliveryRequirement.DELIVER_IMMEDIATELY)).build();
    private static final Reservation RESERVATION_2 = ((Reservation)UnitTestExamples.example(Reservation.class)).toBuilder().setThroughputCapacity(((Reservation)UnitTestExamples.example(Reservation.class)).getThroughputCapacity() + 1L).build();
    private static final String OPERATION_PATH = "/path/for/operation";
    @Mock
    UnaryCallable<CreateTopicRequest, Topic> createTopicCallable;
    @Mock
    UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    @Mock
    UnaryCallable<GetTopicPartitionsRequest, TopicPartitions> getTopicPartitionsCallable;
    @Mock
    UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    @Mock
    UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable;
    @Mock
    UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    @Mock
    UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    @Mock
    UnaryCallable<CreateSubscriptionRequest, Subscription> createSubscriptionCallable;
    @Mock
    UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    @Mock
    UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    @Mock
    UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable;
    @Mock
    UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable;
    @Mock
    OperationCallable<SeekSubscriptionRequest, SeekSubscriptionResponse, OperationMetadata> seekSubscriptionCallable;
    @Mock
    OperationFuture<SeekSubscriptionResponse, OperationMetadata> seekFuture;
    @Mock
    UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable;
    @Mock
    UnaryCallable<GetReservationRequest, Reservation> getReservationCallable;
    @Mock
    UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable;
    @Mock
    UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable;
    @Mock
    UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable;
    @Mock
    UnaryCallable<ListReservationTopicsRequest, ListReservationTopicsResponse> listReservationTopicsCallable;
    @Mock
    AdminServiceStub stub;
    private AdminClientImpl client;

    private static final <T> ApiFuture<T> failedPreconditionFuture() {
        return ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION).underlying);
    }

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.stub.createTopicCallable()).thenReturn(this.createTopicCallable);
        Mockito.when((Object)this.stub.getTopicCallable()).thenReturn(this.getTopicCallable);
        Mockito.when((Object)this.stub.getTopicPartitionsCallable()).thenReturn(this.getTopicPartitionsCallable);
        Mockito.when((Object)this.stub.listTopicsCallable()).thenReturn(this.listTopicsCallable);
        Mockito.when((Object)this.stub.updateTopicCallable()).thenReturn(this.updateTopicCallable);
        Mockito.when((Object)this.stub.deleteTopicCallable()).thenReturn(this.deleteTopicCallable);
        Mockito.when((Object)this.stub.listTopicSubscriptionsCallable()).thenReturn(this.listTopicSubscriptionsCallable);
        Mockito.when((Object)this.stub.createSubscriptionCallable()).thenReturn(this.createSubscriptionCallable);
        Mockito.when((Object)this.stub.getSubscriptionCallable()).thenReturn(this.getSubscriptionCallable);
        Mockito.when((Object)this.stub.listSubscriptionsCallable()).thenReturn(this.listSubscriptionsCallable);
        Mockito.when((Object)this.stub.updateSubscriptionCallable()).thenReturn(this.updateSubscriptionCallable);
        Mockito.when((Object)this.stub.deleteSubscriptionCallable()).thenReturn(this.deleteSubscriptionCallable);
        Mockito.when((Object)this.stub.seekSubscriptionOperationCallable()).thenReturn(this.seekSubscriptionCallable);
        Mockito.when((Object)this.stub.createReservationCallable()).thenReturn(this.createReservationCallable);
        Mockito.when((Object)this.stub.getReservationCallable()).thenReturn(this.getReservationCallable);
        Mockito.when((Object)this.stub.listReservationsCallable()).thenReturn(this.listReservationsCallable);
        Mockito.when((Object)this.stub.updateReservationCallable()).thenReturn(this.updateReservationCallable);
        Mockito.when((Object)this.stub.deleteReservationCallable()).thenReturn(this.deleteReservationCallable);
        Mockito.when((Object)this.stub.listReservationTopicsCallable()).thenReturn(this.listReservationTopicsCallable);
        this.client = new AdminClientImpl((CloudRegion)UnitTestExamples.example(CloudRegion.class), AdminServiceClient.create((AdminServiceStub)this.stub));
    }

    @After
    public void tearDown() throws Exception {
        this.client.shutdownNow();
        ((AdminServiceStub)Mockito.verify((Object)this.stub)).shutdownNow();
    }

    @Test
    public void region_isConstructedRegion() {
        Truth.assertThat((Object)this.client.region()).isEqualTo(UnitTestExamples.example(CloudRegion.class));
    }

    @Test
    public void createTopic_Ok() throws Exception {
        CreateTopicRequest request = CreateTopicRequest.newBuilder().setParent(((TopicPath)UnitTestExamples.example(TopicPath.class)).locationPath().toString()).setTopic((Topic)UnitTestExamples.example(Topic.class)).setTopicId(((TopicName)UnitTestExamples.example(TopicName.class)).value()).build();
        Mockito.when((Object)this.createTopicCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)TOPIC_2));
        Truth.assertThat((Object)this.client.createTopic((Topic)UnitTestExamples.example(Topic.class)).get()).isEqualTo((Object)TOPIC_2);
    }

    @Test
    public void createTopic_Error() {
        CreateTopicRequest request = CreateTopicRequest.newBuilder().setParent(((TopicPath)UnitTestExamples.example(TopicPath.class)).locationPath().toString()).setTopic((Topic)UnitTestExamples.example(Topic.class)).setTopicId(((TopicName)UnitTestExamples.example(TopicName.class)).value()).build();
        Mockito.when((Object)this.createTopicCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.createTopic((Topic)UnitTestExamples.example(Topic.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void updateTopic_Ok() throws Exception {
        UpdateTopicRequest request = UpdateTopicRequest.newBuilder().setTopic((Topic)UnitTestExamples.example(Topic.class)).setUpdateMask(MASK).build();
        Mockito.when((Object)this.updateTopicCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)TOPIC_2));
        Truth.assertThat((Object)this.client.updateTopic((Topic)UnitTestExamples.example(Topic.class), MASK).get()).isEqualTo((Object)TOPIC_2);
    }

    @Test
    public void updateTopic_NonRetryableError() {
        UpdateTopicRequest request = UpdateTopicRequest.newBuilder().setTopic((Topic)UnitTestExamples.example(Topic.class)).setUpdateMask(MASK).build();
        Mockito.when((Object)this.updateTopicCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.updateTopic((Topic)UnitTestExamples.example(Topic.class), MASK), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void deleteTopic_Ok() throws Exception {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.deleteTopicCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        this.client.deleteTopic((TopicPath)UnitTestExamples.example(TopicPath.class)).get();
    }

    @Test
    public void deleteTopic_Error() {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.deleteTopicCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.deleteTopic((TopicPath)UnitTestExamples.example(TopicPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void getTopic_Ok() throws Exception {
        GetTopicRequest request = GetTopicRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.getTopicCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)UnitTestExamples.example(Topic.class)));
        Truth.assertThat((Object)this.client.getTopic((TopicPath)UnitTestExamples.example(TopicPath.class)).get()).isEqualTo(UnitTestExamples.example(Topic.class));
    }

    @Test
    public void getTopic_Error() {
        GetTopicRequest request = GetTopicRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.getTopicCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.getTopic((TopicPath)UnitTestExamples.example(TopicPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void getTopicPartitionCount_Ok() throws Exception {
        GetTopicPartitionsRequest request = GetTopicPartitionsRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.getTopicPartitionsCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicPartitions.newBuilder().setPartitionCount(10L).build()));
        Truth.assertThat((Long)((Long)this.client.getTopicPartitionCount((TopicPath)UnitTestExamples.example(TopicPath.class)).get())).isEqualTo((Object)10);
    }

    @Test
    public void getTopicPartitionCount_NonRetryableError() {
        GetTopicPartitionsRequest request = GetTopicPartitionsRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.getTopicPartitionsCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.getTopicPartitionCount((TopicPath)UnitTestExamples.example(TopicPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void listTopicSubscriptions_Ok() throws Exception {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        SubscriptionPath path1 = ((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(ProjectNumber.of((long)111L))).setName(SubscriptionName.of((String)"def")).setLocation((CloudZone)UnitTestExamples.example(CloudZone.class))).build();
        SubscriptionPath path2 = ((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(ProjectNumber.of((long)222L))).setName(SubscriptionName.of((String)"abc")).setLocation((CloudZone)UnitTestExamples.example(CloudZone.class))).build();
        ListTopicSubscriptionsResponse response = ListTopicSubscriptionsResponse.newBuilder().addSubscriptions(path1.toString()).addSubscriptions(path2.toString()).build();
        Mockito.when((Object)this.listTopicSubscriptionsCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)response));
        Truth.assertThat((Iterable)((Iterable)this.client.listTopicSubscriptions((TopicPath)UnitTestExamples.example(TopicPath.class)).get())).containsExactly(new Object[]{path1, path2});
    }

    @Test
    public void listTopicSubscriptions_Error() {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setName(((TopicPath)UnitTestExamples.example(TopicPath.class)).toString()).build();
        Mockito.when((Object)this.listTopicSubscriptionsCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.listTopicSubscriptions((TopicPath)UnitTestExamples.example(TopicPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void listTopics_Ok() throws Exception {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setParent(((LocationPath)UnitTestExamples.example(LocationPath.class)).toString()).build();
        Mockito.when((Object)this.listTopicsCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)ListTopicsResponse.newBuilder().addAllTopics((Iterable)ImmutableList.of((Object)TOPIC_2, (Object)UnitTestExamples.example(Topic.class))).build()));
        Truth.assertThat((Iterable)((Iterable)this.client.listTopics((LocationPath)UnitTestExamples.example(LocationPath.class)).get())).containsExactly(new Object[]{TOPIC_2, UnitTestExamples.example(Topic.class)});
    }

    @Test
    public void listTopics_Error() {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setParent(((LocationPath)UnitTestExamples.example(LocationPath.class)).toString()).build();
        Mockito.when((Object)this.listTopicsCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.listTopics((LocationPath)UnitTestExamples.example(LocationPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void createSubscription_Ok() throws Exception {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setParent(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).locationPath().toString()).setSubscription((Subscription)UnitTestExamples.example(Subscription.class)).setSubscriptionId(((SubscriptionName)UnitTestExamples.example(SubscriptionName.class)).value()).setSkipBacklog(true).build();
        Mockito.when((Object)this.createSubscriptionCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)SUBSCRIPTION_2));
        Truth.assertThat((Object)this.client.createSubscription((Subscription)UnitTestExamples.example(Subscription.class)).get()).isEqualTo((Object)SUBSCRIPTION_2);
    }

    @Test
    public void createSubscription_Error() {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setParent(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).locationPath().toString()).setSubscription((Subscription)UnitTestExamples.example(Subscription.class)).setSubscriptionId(((SubscriptionName)UnitTestExamples.example(SubscriptionName.class)).value()).setSkipBacklog(true).build();
        Mockito.when((Object)this.createSubscriptionCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.createSubscription((Subscription)UnitTestExamples.example(Subscription.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void createSubscriptionAtBeginning_Ok() throws Exception {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setParent(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).locationPath().toString()).setSubscription((Subscription)UnitTestExamples.example(Subscription.class)).setSubscriptionId(((SubscriptionName)UnitTestExamples.example(SubscriptionName.class)).value()).setSkipBacklog(false).build();
        Mockito.when((Object)this.createSubscriptionCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)SUBSCRIPTION_2));
        Truth.assertThat((Object)this.client.createSubscription((Subscription)UnitTestExamples.example(Subscription.class), BacklogLocation.BEGINNING).get()).isEqualTo((Object)SUBSCRIPTION_2);
    }

    @Test
    public void createSubscriptionAtBeginning_Error() throws Exception {
        CreateSubscriptionRequest request = CreateSubscriptionRequest.newBuilder().setParent(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).locationPath().toString()).setSubscription((Subscription)UnitTestExamples.example(Subscription.class)).setSubscriptionId(((SubscriptionName)UnitTestExamples.example(SubscriptionName.class)).value()).setSkipBacklog(false).build();
        Mockito.when((Object)this.createSubscriptionCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.createSubscription((Subscription)UnitTestExamples.example(Subscription.class), BacklogLocation.BEGINNING), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void updateSubscription_Ok() throws Exception {
        UpdateSubscriptionRequest request = UpdateSubscriptionRequest.newBuilder().setSubscription((Subscription)UnitTestExamples.example(Subscription.class)).setUpdateMask(MASK).build();
        Mockito.when((Object)this.updateSubscriptionCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)SUBSCRIPTION_2));
        Truth.assertThat((Object)this.client.updateSubscription((Subscription)UnitTestExamples.example(Subscription.class), MASK).get()).isEqualTo((Object)SUBSCRIPTION_2);
    }

    @Test
    public void updateSubscription_Error() {
        UpdateSubscriptionRequest request = UpdateSubscriptionRequest.newBuilder().setSubscription((Subscription)UnitTestExamples.example(Subscription.class)).setUpdateMask(MASK).build();
        Mockito.when((Object)this.updateSubscriptionCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.updateSubscription((Subscription)UnitTestExamples.example(Subscription.class), MASK), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void deleteSubscription_Ok() throws Exception {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).build();
        Mockito.when((Object)this.deleteSubscriptionCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        this.client.deleteSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).get();
    }

    @Test
    public void deleteSubscription_Error() {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).build();
        Mockito.when((Object)this.deleteSubscriptionCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.deleteSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void getSubscription_Ok() throws Exception {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).build();
        Mockito.when((Object)this.getSubscriptionCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)UnitTestExamples.example(Subscription.class)));
        Truth.assertThat((Object)this.client.getSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).get()).isEqualTo(UnitTestExamples.example(Subscription.class));
    }

    @Test
    public void getSubscription_Error() {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).build();
        Mockito.when((Object)this.getSubscriptionCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.getSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void listSubscriptions_Ok() throws Exception {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setParent(((LocationPath)UnitTestExamples.example(LocationPath.class)).toString()).build();
        Mockito.when((Object)this.listSubscriptionsCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)ListSubscriptionsResponse.newBuilder().addAllSubscriptions((Iterable)ImmutableList.of((Object)SUBSCRIPTION_2, (Object)UnitTestExamples.example(Subscription.class))).build()));
        Truth.assertThat((Iterable)((Iterable)this.client.listSubscriptions((LocationPath)UnitTestExamples.example(LocationPath.class)).get())).containsExactly(new Object[]{SUBSCRIPTION_2, UnitTestExamples.example(Subscription.class)});
    }

    @Test
    public void listSubscriptions_Error() {
        ListSubscriptionsRequest request = ListSubscriptionsRequest.newBuilder().setParent(((LocationPath)UnitTestExamples.example(LocationPath.class)).toString()).build();
        Mockito.when((Object)this.listSubscriptionsCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.listSubscriptions((LocationPath)UnitTestExamples.example(LocationPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void seekSubscription_PublishTimeOk() throws Exception {
        Timestamp publishTime = Timestamp.newBuilder().setSeconds(123L).build();
        SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).setTimeTarget(TimeTarget.newBuilder().setPublishTime(publishTime)).build();
        Mockito.when((Object)this.seekFuture.getName()).thenReturn((Object)OPERATION_PATH);
        Mockito.when((Object)this.seekSubscriptionCallable.futureCall((Object)request)).thenReturn(this.seekFuture);
        Truth.assertThat((String)this.client.seekSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class), SeekTarget.ofPublishTime((Timestamp)publishTime)).getName()).isEqualTo((Object)OPERATION_PATH);
    }

    @Test
    public void seekSubscription_EventTimeOk() throws Exception {
        Timestamp eventTime = Timestamp.newBuilder().setSeconds(456L).build();
        SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).setTimeTarget(TimeTarget.newBuilder().setEventTime(eventTime)).build();
        Mockito.when((Object)this.seekFuture.getName()).thenReturn((Object)OPERATION_PATH);
        Mockito.when((Object)this.seekSubscriptionCallable.futureCall((Object)request)).thenReturn(this.seekFuture);
        Truth.assertThat((String)this.client.seekSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class), SeekTarget.ofEventTime((Timestamp)eventTime)).getName()).isEqualTo((Object)OPERATION_PATH);
    }

    @Test
    public void seekSubscription_BacklogBeginningOk() throws Exception {
        SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).setNamedTarget(SeekSubscriptionRequest.NamedTarget.TAIL).build();
        Mockito.when((Object)this.seekFuture.getName()).thenReturn((Object)OPERATION_PATH);
        Mockito.when((Object)this.seekSubscriptionCallable.futureCall((Object)request)).thenReturn(this.seekFuture);
        Truth.assertThat((String)this.client.seekSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class), SeekTarget.of((BacklogLocation)BacklogLocation.BEGINNING)).getName()).isEqualTo((Object)OPERATION_PATH);
    }

    @Test
    public void seekSubscription_BacklogEndOk() throws Exception {
        SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).setNamedTarget(SeekSubscriptionRequest.NamedTarget.HEAD).build();
        Mockito.when((Object)this.seekFuture.getName()).thenReturn((Object)OPERATION_PATH);
        Mockito.when((Object)this.seekSubscriptionCallable.futureCall((Object)request)).thenReturn(this.seekFuture);
        Truth.assertThat((String)this.client.seekSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class), SeekTarget.of((BacklogLocation)BacklogLocation.END)).getName()).isEqualTo((Object)OPERATION_PATH);
    }

    @Test
    public void seekSubscription_Error() throws Exception {
        SeekSubscriptionRequest request = SeekSubscriptionRequest.newBuilder().setName(((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class)).toString()).setNamedTarget(SeekSubscriptionRequest.NamedTarget.HEAD).build();
        Mockito.when((Object)this.seekFuture.getName()).thenThrow(new Throwable[]{new CheckedApiException((StatusCode.Code)StatusCode.Code.NOT_FOUND).underlying});
        Mockito.when((Object)this.seekSubscriptionCallable.futureCall((Object)request)).thenReturn(this.seekFuture);
        Assert.assertThrows(ApiException.class, () -> this.client.seekSubscription((SubscriptionPath)UnitTestExamples.example(SubscriptionPath.class), SeekTarget.of((BacklogLocation)BacklogLocation.END)).getName());
    }

    @Test
    public void createReservation_Ok() throws Exception {
        CreateReservationRequest request = CreateReservationRequest.newBuilder().setParent(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).locationPath().toString()).setReservation((Reservation)UnitTestExamples.example(Reservation.class)).setReservationId(((ReservationName)UnitTestExamples.example(ReservationName.class)).value()).build();
        Mockito.when((Object)this.createReservationCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)RESERVATION_2));
        Truth.assertThat((Object)this.client.createReservation((Reservation)UnitTestExamples.example(Reservation.class)).get()).isEqualTo((Object)RESERVATION_2);
    }

    @Test
    public void createReservation_Error() {
        CreateReservationRequest request = CreateReservationRequest.newBuilder().setParent(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).locationPath().toString()).setReservation((Reservation)UnitTestExamples.example(Reservation.class)).setReservationId(((ReservationName)UnitTestExamples.example(ReservationName.class)).value()).build();
        Mockito.when((Object)this.createReservationCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.createReservation((Reservation)UnitTestExamples.example(Reservation.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void updateReservation_Ok() throws Exception {
        UpdateReservationRequest request = UpdateReservationRequest.newBuilder().setReservation((Reservation)UnitTestExamples.example(Reservation.class)).setUpdateMask(MASK).build();
        Mockito.when((Object)this.updateReservationCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)RESERVATION_2));
        Truth.assertThat((Object)this.client.updateReservation((Reservation)UnitTestExamples.example(Reservation.class), MASK).get()).isEqualTo((Object)RESERVATION_2);
    }

    @Test
    public void updateReservation_NonRetryableError() {
        UpdateReservationRequest request = UpdateReservationRequest.newBuilder().setReservation((Reservation)UnitTestExamples.example(Reservation.class)).setUpdateMask(MASK).build();
        Mockito.when((Object)this.updateReservationCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.updateReservation((Reservation)UnitTestExamples.example(Reservation.class), MASK), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void deleteReservation_Ok() throws Exception {
        DeleteReservationRequest request = DeleteReservationRequest.newBuilder().setName(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).toString()).build();
        Mockito.when((Object)this.deleteReservationCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        this.client.deleteReservation((ReservationPath)UnitTestExamples.example(ReservationPath.class)).get();
    }

    @Test
    public void deleteReservation_Error() {
        DeleteReservationRequest request = DeleteReservationRequest.newBuilder().setName(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).toString()).build();
        Mockito.when((Object)this.deleteReservationCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.deleteReservation((ReservationPath)UnitTestExamples.example(ReservationPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void getReservation_Ok() throws Exception {
        GetReservationRequest request = GetReservationRequest.newBuilder().setName(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).toString()).build();
        Mockito.when((Object)this.getReservationCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)UnitTestExamples.example(Reservation.class)));
        Truth.assertThat((Object)this.client.getReservation((ReservationPath)UnitTestExamples.example(ReservationPath.class)).get()).isEqualTo(UnitTestExamples.example(Reservation.class));
    }

    @Test
    public void getReservation_Error() {
        GetReservationRequest request = GetReservationRequest.newBuilder().setName(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).toString()).build();
        Mockito.when((Object)this.getReservationCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.getReservation((ReservationPath)UnitTestExamples.example(ReservationPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void listReservationTopics_Ok() throws Exception {
        ListReservationTopicsRequest request = ListReservationTopicsRequest.newBuilder().setName(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).toString()).build();
        TopicPath path1 = ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setProject(ProjectNumber.of((long)111L))).setName(TopicName.of((String)"def")).setLocation((CloudZone)UnitTestExamples.example(CloudZone.class))).build();
        TopicPath path2 = ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setProject(ProjectNumber.of((long)222L))).setName(TopicName.of((String)"abc")).setLocation((CloudZone)UnitTestExamples.example(CloudZone.class))).build();
        ListReservationTopicsResponse response = ListReservationTopicsResponse.newBuilder().addTopics(path1.toString()).addTopics(path2.toString()).build();
        Mockito.when((Object)this.listReservationTopicsCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)response));
        Truth.assertThat((Iterable)((Iterable)this.client.listReservationTopics((ReservationPath)UnitTestExamples.example(ReservationPath.class)).get())).containsExactly(new Object[]{path1, path2});
    }

    @Test
    public void listReservationTopics_Error() {
        ListReservationTopicsRequest request = ListReservationTopicsRequest.newBuilder().setName(((ReservationPath)UnitTestExamples.example(ReservationPath.class)).toString()).build();
        Mockito.when((Object)this.listReservationTopicsCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.listReservationTopics((ReservationPath)UnitTestExamples.example(ReservationPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void listReservations_Ok() throws Exception {
        ListReservationsRequest request = ListReservationsRequest.newBuilder().setParent(((LocationPath)UnitTestExamples.example(LocationPath.class)).toString()).build();
        Mockito.when((Object)this.listReservationsCallable.futureCall((Object)request)).thenReturn((Object)ApiFutures.immediateFuture((Object)ListReservationsResponse.newBuilder().addAllReservations((Iterable)ImmutableList.of((Object)RESERVATION_2, (Object)UnitTestExamples.example(Reservation.class))).build()));
        Truth.assertThat((Iterable)((Iterable)this.client.listReservations((LocationPath)UnitTestExamples.example(LocationPath.class)).get())).containsExactly(new Object[]{RESERVATION_2, UnitTestExamples.example(Reservation.class)});
    }

    @Test
    public void listReservations_Error() {
        ListReservationsRequest request = ListReservationsRequest.newBuilder().setParent(((LocationPath)UnitTestExamples.example(LocationPath.class)).toString()).build();
        Mockito.when((Object)this.listReservationsCallable.futureCall((Object)request)).thenReturn(AdminClientImplTest.failedPreconditionFuture());
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.listReservations((LocationPath)UnitTestExamples.example(LocationPath.class)), StatusCode.Code.FAILED_PRECONDITION);
    }
}

