/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth8;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.mockito.ArgumentMatcher;

public class ApiExceptionMatcher
implements ArgumentMatcher<Throwable> {
    private final Optional<StatusCode.Code> code;
    private final Optional<String> message;

    public ApiExceptionMatcher(StatusCode.Code code, String message) {
        this.code = Optional.of(code);
        this.message = Optional.of(message);
    }

    public ApiExceptionMatcher(StatusCode.Code code) {
        this.code = Optional.of(code);
        this.message = Optional.empty();
    }

    public ApiExceptionMatcher() {
        this.code = Optional.empty();
        this.message = Optional.empty();
    }

    private boolean matches(CheckedApiException e) {
        return !(this.code.isPresent() && this.code.get() != e.code() || this.message.isPresent() && !this.message.get().equals(e.getMessage()));
    }

    public boolean matches(Throwable argument) {
        Optional statusOr = ExtractStatus.extract((Throwable)argument);
        if (!statusOr.isPresent()) {
            return false;
        }
        return this.matches((CheckedApiException)statusOr.get());
    }

    public static void assertFutureThrowsCode(Future<?> f, StatusCode.Code code) {
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, f::get);
        ApiExceptionMatcher.assertThrowableMatches(exception.getCause(), code);
    }

    public static void assertThrowableMatches(Throwable t, StatusCode.Code code) {
        Optional statusOr = ExtractStatus.extract((Throwable)t);
        Truth8.assertThat((Optional)statusOr).isPresent();
        Truth.assertThat((Comparable)((CheckedApiException)statusOr.get()).code()).isEqualTo((Object)code);
    }
}

