/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.BufferingPullSubscriber;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.PullSubscriber;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth8;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BufferingPullSubscriberTest {
    private final SubscriberFactory underlyingFactory = (SubscriberFactory)Mockito.mock(SubscriberFactory.class);
    private final Subscriber underlying = (Subscriber)Mockito.mock(Subscriber.class);
    private final FlowControlSettings flowControlSettings = FlowControlSettings.builder().setBytesOutstanding(10L).setMessagesOutstanding(20L).build();
    private PullSubscriber<SequencedMessage> subscriber;
    private Consumer<ImmutableList<SequencedMessage>> messageConsumer;
    private ApiService.Listener errorListener;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.underlying.startAsync()).thenReturn((Object)this.underlying);
        FlowControlRequest flow = FlowControlRequest.newBuilder().setAllowedBytes(this.flowControlSettings.bytesOutstanding()).setAllowedMessages(this.flowControlSettings.messagesOutstanding()).build();
        Mockito.when((Object)this.underlyingFactory.newSubscriber((Consumer)ArgumentMatchers.any())).thenAnswer(args -> {
            this.messageConsumer = (Consumer)args.getArgument(0);
            return this.underlying;
        });
        ((Subscriber)Mockito.doAnswer(args -> {
            this.errorListener = (ApiService.Listener)args.getArgument(0);
            return null;
        }).when((Object)this.underlying)).addListener((ApiService.Listener)ArgumentMatchers.any(), (Executor)ArgumentMatchers.any());
        this.subscriber = new BufferingPullSubscriber(this.underlyingFactory, this.flowControlSettings);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.underlyingFactory, this.underlying});
        ((SubscriberFactory)inOrder.verify((Object)this.underlyingFactory)).newSubscriber((Consumer)ArgumentMatchers.any());
        ((Subscriber)inOrder.verify((Object)this.underlying)).addListener((ApiService.Listener)ArgumentMatchers.any(), (Executor)ArgumentMatchers.any());
        ((Subscriber)inOrder.verify((Object)this.underlying)).startAsync();
        ((Subscriber)inOrder.verify((Object)this.underlying)).awaitRunning();
        ((Subscriber)inOrder.verify((Object)this.underlying)).allowFlow(flow);
        Truth.assertThat(this.messageConsumer).isNotNull();
        Truth.assertThat((Object)this.errorListener).isNotNull();
    }

    @Test
    public void createDestroy() {
    }

    @Test
    public void pullAfterErrorThrows() {
        this.errorListener.failed(null, (Throwable)new CheckedApiException(StatusCode.Code.INTERNAL));
        CheckedApiException e = (CheckedApiException)Assert.assertThrows(CheckedApiException.class, () -> this.subscriber.pull());
        Truth.assertThat((Comparable)e.code()).isEqualTo((Object)StatusCode.Code.INTERNAL);
    }

    @Test
    public void emptyPull() throws CheckedApiException {
        Truth.assertThat((Iterable)this.subscriber.pull()).isEmpty();
    }

    @Test
    public void pullEmptiesForNext() throws CheckedApiException {
        SequencedMessage message1 = SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)10L), (long)10L);
        SequencedMessage message2 = SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)11L), (long)10L);
        this.messageConsumer.accept((ImmutableList<SequencedMessage>)ImmutableList.of((Object)message1, (Object)message2));
        Truth.assertThat((Iterable)this.subscriber.pull()).containsExactly(new Object[]{message1, message2});
        Truth.assertThat((Iterable)this.subscriber.pull()).isEmpty();
    }

    @Test
    public void multipleBatchesAggregatedReturnsTokens() throws CheckedApiException {
        SequencedMessage message1 = SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)10L), (long)10L);
        SequencedMessage message2 = SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)11L), (long)20L);
        SequencedMessage message3 = SequencedMessage.of((Message)Message.builder().build(), (Timestamp)Timestamps.EPOCH, (Offset)Offset.of((long)12L), (long)30L);
        Truth8.assertThat((Optional)this.subscriber.nextOffset()).isEmpty();
        this.messageConsumer.accept((ImmutableList<SequencedMessage>)ImmutableList.of((Object)message1, (Object)message2));
        this.messageConsumer.accept((ImmutableList<SequencedMessage>)ImmutableList.of((Object)message3));
        Truth.assertThat((Iterable)this.subscriber.pull()).containsExactly(new Object[]{message1, message2, message3});
        Truth8.assertThat((Optional)this.subscriber.nextOffset()).hasValue((Object)Offset.of((long)13L));
        Truth.assertThat((Iterable)this.subscriber.pull()).isEmpty();
        FlowControlRequest flowControlRequest = FlowControlRequest.newBuilder().setAllowedMessages(3L).setAllowedBytes(60L).build();
        ((Subscriber)Mockito.verify((Object)this.underlying)).allowFlow(flowControlRequest);
    }

    @Test
    public void closeStops() throws Exception {
        Mockito.when((Object)this.underlying.stopAsync()).thenReturn((Object)this.underlying);
        this.subscriber.close();
        ((Subscriber)Mockito.verify((Object)this.underlying)).stopAsync();
        ((Subscriber)Mockito.verify((Object)this.underlying)).awaitTerminated();
    }
}

