/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.Monitor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class CloseableMonitorTest {
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    boolean state = false;

    @Test
    public void enter() {
        Truth.assertThat((Boolean)this.monitor.monitor.isOccupied()).isFalse();
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Truth.assertThat((Boolean)this.monitor.monitor.isOccupied()).isTrue();
        }
        Truth.assertThat((Boolean)this.monitor.monitor.isOccupied()).isFalse();
    }

    @Test
    public void enterWhenUninterruptibly() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(() -> {
            try (CloseableMonitor.Hold h = this.monitor.enter();){
                this.state = true;
            }
        });
        try (CloseableMonitor.Hold h = this.monitor.enterWhenUninterruptibly(new Monitor.Guard(this.monitor.monitor){

            public boolean isSatisfied() {
                Truth.assertThat((Boolean)((CloseableMonitorTest)CloseableMonitorTest.this).monitor.monitor.isOccupied()).isTrue();
                return CloseableMonitorTest.this.state;
            }
        });){
            Truth.assertThat((Boolean)this.monitor.monitor.isOccupied()).isTrue();
            Truth.assertThat((Boolean)this.state).isTrue();
        }
    }
}

