/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CursorClientImpl;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.CommitCursorResponse;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsRequest;
import com.google.cloud.pubsublite.proto.ListPartitionCursorsResponse;
import com.google.cloud.pubsublite.proto.PartitionCursor;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.stub.CursorServiceStub;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class CursorClientImplTest {
    private static final CloudRegion REGION = CloudRegion.of((String)"us-east1");
    @Mock
    CursorServiceStub stub;
    @Mock
    UnaryCallable<CommitCursorRequest, CommitCursorResponse> commitCallable;
    @Mock
    UnaryCallable<ListPartitionCursorsRequest, ListPartitionCursorsResponse> listCallable;
    private CursorClientImpl client;

    private static SubscriptionPath path() {
        return ((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setName(SubscriptionName.of((String)"a")).setProject(ProjectNumber.of((long)4L))).setLocation(CloudZone.of((CloudRegion)REGION, (char)'a'))).build();
    }

    private static Partition partition() {
        return Partition.of((long)83L);
    }

    private static ListPartitionCursorsRequest listRequest() {
        return ListPartitionCursorsRequest.newBuilder().setParent(CursorClientImplTest.path().toString()).build();
    }

    private static PartitionCursor partitionCursorOf(Partition partition, Offset offset) {
        return PartitionCursor.newBuilder().setPartition(partition.value()).setCursor(Cursor.newBuilder().setOffset(offset.value())).build();
    }

    private static ListPartitionCursorsResponse listResponse() throws CheckedApiException {
        return ListPartitionCursorsResponse.newBuilder().addPartitionCursors(CursorClientImplTest.partitionCursorOf(Partition.of((long)1L), Offset.of((long)111L))).addPartitionCursors(CursorClientImplTest.partitionCursorOf(Partition.of((long)2L), Offset.of((long)222L))).build();
    }

    private static Map<Partition, Offset> listMap() throws CheckedApiException {
        return ImmutableMap.of((Object)Partition.of((long)1L), (Object)Offset.of((long)111L), (Object)Partition.of((long)2L), (Object)Offset.of((long)222L));
    }

    private static Offset commitOffset() {
        return Offset.of((long)222L);
    }

    private static CommitCursorRequest commitRequest() {
        return CommitCursorRequest.newBuilder().setSubscription(CursorClientImplTest.path().toString()).setPartition(CursorClientImplTest.partition().value()).setCursor(Cursor.newBuilder().setOffset(CursorClientImplTest.commitOffset().value())).build();
    }

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.stub.commitCursorCallable()).thenReturn(this.commitCallable);
        Mockito.when((Object)this.stub.listPartitionCursorsCallable()).thenReturn(this.listCallable);
        this.client = new CursorClientImpl(REGION, CursorServiceClient.create((CursorServiceStub)this.stub));
    }

    @After
    public void tearDown() {
        this.client.shutdownNow();
        ((CursorServiceStub)Mockito.verify((Object)this.stub)).shutdownNow();
    }

    @Test
    public void region_isConstructedRegion() {
        Truth.assertThat((Object)this.client.region()).isEqualTo((Object)REGION);
    }

    @Test
    public void listPartitionCursors_Ok() throws Exception {
        Mockito.when((Object)this.listCallable.futureCall((Object)CursorClientImplTest.listRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)CursorClientImplTest.listResponse()));
        Truth.assertThat((Map)((Map)this.client.listPartitionCursors(CursorClientImplTest.path()).get())).isEqualTo(CursorClientImplTest.listMap());
    }

    @Test
    public void listPartitionCursors_Error() {
        Mockito.when((Object)this.listCallable.futureCall((Object)CursorClientImplTest.listRequest())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION).underlying));
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.listPartitionCursors(CursorClientImplTest.path()), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void commitCursor_Ok() throws Exception {
        Mockito.when((Object)this.commitCallable.futureCall((Object)CursorClientImplTest.commitRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)CommitCursorResponse.getDefaultInstance()));
        Void unusedResponse = (Void)this.client.commitCursor(CursorClientImplTest.path(), CursorClientImplTest.partition(), CursorClientImplTest.commitOffset()).get();
    }

    @Test
    public void commitCursor_Error() {
        Mockito.when((Object)this.commitCallable.futureCall((Object)CursorClientImplTest.commitRequest())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION).underlying));
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.commitCursor(CursorClientImplTest.path(), CursorClientImplTest.partition(), CursorClientImplTest.commitOffset()), StatusCode.Code.FAILED_PRECONDITION);
    }
}

