/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.DefaultRoutingPolicy;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.protobuf.ByteString;
import cz.o2.proxima.beam.io.pubsub.com.google.gson.Gson;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultRoutingPolicyTest {
    private static final int NUM_PARTITIONS = 29;
    private static final RoutingPolicy policy = new DefaultRoutingPolicy(29L);

    private static Map<ByteString, Partition> loadTestCases() throws Exception {
        Gson gson = new Gson();
        String json = new String(Files.readAllBytes(Paths.get(DefaultRoutingPolicyTest.class.getResource("/routing_tests.json").toURI())));
        Map map = (Map)gson.fromJson(json, Map.class);
        ImmutableMap.Builder output = ImmutableMap.builder();
        for (String key : map.keySet()) {
            output.put((Object)ByteString.copyFromUtf8((String)key), (Object)Partition.of((long)((int)((Double)map.get(key)).doubleValue())));
        }
        return output.build();
    }

    @Test
    public void routingPerformedCorrectly() throws Exception {
        Map<ByteString, Partition> map = DefaultRoutingPolicyTest.loadTestCases();
        ImmutableMap.Builder results = ImmutableMap.builder();
        for (ByteString key : map.keySet()) {
            results.put((Object)key, (Object)policy.route(key));
        }
        Truth.assertThat((Map)results.build()).containsExactlyEntriesIn(map);
    }
}

