/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.internal.SerialExecutor;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class SerialExecutorTest {
    private final SerialExecutor executor = new SerialExecutor(SystemExecutors.getFuturesExecutor());

    @Test
    public void serializesTasks() throws Exception {
        int numTasks = 100;
        ArrayList receivedSequences = new ArrayList();
        int i = 0;
        while (i < 100) {
            int sequence = i++;
            this.executor.execute(() -> {
                List list = receivedSequences;
                synchronized (list) {
                    receivedSequences.add(sequence);
                }
            });
        }
        this.executor.waitUntilInactive();
        for (i = 0; i < receivedSequences.size(); ++i) {
            Truth.assertThat((Integer)((Integer)receivedSequences.get(i))).isEqualTo((Object)i);
        }
    }

    @Test
    public void closeDiscardsTasks() throws Exception {
        ArrayList receivedSequences = new ArrayList();
        int i = 0;
        while (i < 10) {
            int sequence = i++;
            this.executor.execute(() -> {
                List list = receivedSequences;
                synchronized (list) {
                    receivedSequences.add(sequence);
                }
                this.executor.close();
            });
        }
        this.executor.waitUntilInactive();
        Truth.assertThat(receivedSequences).containsExactly(new Object[]{0});
    }
}

