/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.TopicStatsClientImpl;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorRequest;
import com.google.cloud.pubsublite.proto.ComputeHeadCursorResponse;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsRequest;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.cloud.pubsublite.proto.ComputeTimeCursorRequest;
import com.google.cloud.pubsublite.proto.ComputeTimeCursorResponse;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.TimeTarget;
import com.google.cloud.pubsublite.v1.TopicStatsServiceClient;
import com.google.cloud.pubsublite.v1.stub.TopicStatsServiceStub;
import com.google.protobuf.Timestamp;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth8;
import java.io.IOException;
import java.util.Optional;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class TopicStatsClientImplTest {
    private static final CloudRegion REGION = CloudRegion.of((String)"us-east1");
    @Mock
    TopicStatsServiceStub stub;
    @Mock
    UnaryCallable<ComputeMessageStatsRequest, ComputeMessageStatsResponse> computeStatsCallable;
    @Mock
    UnaryCallable<ComputeHeadCursorRequest, ComputeHeadCursorResponse> computeHeadCursorCallable;
    @Mock
    UnaryCallable<ComputeTimeCursorRequest, ComputeTimeCursorResponse> computeTimeCursorCallable;
    private TopicStatsClientImpl client;

    private static TopicPath path() {
        return ((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setName(TopicName.of((String)"a")).setProject(ProjectNumber.of((long)4L))).setLocation(CloudZone.of((CloudRegion)REGION, (char)'a'))).build();
    }

    private static Partition partition() {
        return Partition.of((long)0L);
    }

    private static Offset start() {
        return Offset.of((long)1L);
    }

    private static Offset end() {
        return Offset.of((long)2L);
    }

    private static Timestamp timestamp() {
        return Timestamp.newBuilder().setSeconds(1L).setNanos(2).build();
    }

    private static Cursor cursor() {
        return Cursor.newBuilder().setOffset(45L).build();
    }

    private static ComputeMessageStatsRequest messageStatsRequest() {
        return ComputeMessageStatsRequest.newBuilder().setTopic(TopicStatsClientImplTest.path().toString()).setPartition(TopicStatsClientImplTest.partition().value()).setStartCursor(Cursor.newBuilder().setOffset(TopicStatsClientImplTest.start().value()).build()).setEndCursor(Cursor.newBuilder().setOffset(TopicStatsClientImplTest.end().value()).build()).build();
    }

    private static ComputeMessageStatsResponse messageStatsResponse() {
        return ComputeMessageStatsResponse.newBuilder().setMessageBytes(1L).setMessageCount(2L).build();
    }

    private static ComputeHeadCursorRequest headCursorRequest() {
        return ComputeHeadCursorRequest.newBuilder().setTopic(TopicStatsClientImplTest.path().toString()).setPartition(TopicStatsClientImplTest.partition().value()).build();
    }

    private static ComputeHeadCursorResponse headCursorResponse() {
        return ComputeHeadCursorResponse.newBuilder().setHeadCursor(TopicStatsClientImplTest.cursor()).build();
    }

    private static ComputeTimeCursorRequest publishTimeCursorRequest() {
        return ComputeTimeCursorRequest.newBuilder().setTopic(TopicStatsClientImplTest.path().toString()).setPartition(TopicStatsClientImplTest.partition().value()).setTarget(TimeTarget.newBuilder().setPublishTime(TopicStatsClientImplTest.timestamp())).build();
    }

    private static ComputeTimeCursorRequest eventTimeCursorRequest() {
        return ComputeTimeCursorRequest.newBuilder().setTopic(TopicStatsClientImplTest.path().toString()).setPartition(TopicStatsClientImplTest.partition().value()).setTarget(TimeTarget.newBuilder().setEventTime(TopicStatsClientImplTest.timestamp())).build();
    }

    private static ComputeTimeCursorResponse unsetTimeCursorResponse() {
        return ComputeTimeCursorResponse.getDefaultInstance();
    }

    private static ComputeTimeCursorResponse timeCursorResponse() {
        return ComputeTimeCursorResponse.newBuilder().setCursor(TopicStatsClientImplTest.cursor()).build();
    }

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.stub.computeMessageStatsCallable()).thenReturn(this.computeStatsCallable);
        Mockito.when((Object)this.stub.computeHeadCursorCallable()).thenReturn(this.computeHeadCursorCallable);
        Mockito.when((Object)this.stub.computeTimeCursorCallable()).thenReturn(this.computeTimeCursorCallable);
        this.client = new TopicStatsClientImpl(REGION, TopicStatsServiceClient.create((TopicStatsServiceStub)this.stub));
    }

    @After
    public void tearDown() throws Exception {
        this.client.shutdownNow();
        ((TopicStatsServiceStub)Mockito.verify((Object)this.stub)).shutdownNow();
    }

    @Test
    public void region_isConstructedRegion() {
        Truth.assertThat((Object)this.client.region()).isEqualTo((Object)REGION);
    }

    @Test
    public void computeMessageStats_Ok() throws Exception {
        Mockito.when((Object)this.computeStatsCallable.futureCall((Object)TopicStatsClientImplTest.messageStatsRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicStatsClientImplTest.messageStatsResponse()));
        Truth.assertThat((Object)this.client.computeMessageStats(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.start(), TopicStatsClientImplTest.end()).get()).isEqualTo((Object)TopicStatsClientImplTest.messageStatsResponse());
    }

    @Test
    public void computeMessageStats_Error() {
        Mockito.when((Object)this.computeStatsCallable.futureCall((Object)TopicStatsClientImplTest.messageStatsRequest())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION).underlying));
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.computeMessageStats(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.start(), TopicStatsClientImplTest.end()), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void computeHeadCursor_Ok() throws Exception {
        Mockito.when((Object)this.computeHeadCursorCallable.futureCall((Object)TopicStatsClientImplTest.headCursorRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicStatsClientImplTest.headCursorResponse()));
        Truth.assertThat((Object)this.client.computeHeadCursor(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition()).get()).isEqualTo((Object)TopicStatsClientImplTest.cursor());
    }

    @Test
    public void computeHeadCursor_Error() {
        Mockito.when((Object)this.computeHeadCursorCallable.futureCall((Object)TopicStatsClientImplTest.headCursorRequest())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.FAILED_PRECONDITION).underlying));
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.computeHeadCursor(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition()), StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void computeCursorForPublishTime_OkPresent() throws Exception {
        Mockito.when((Object)this.computeTimeCursorCallable.futureCall((Object)TopicStatsClientImplTest.publishTimeCursorRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicStatsClientImplTest.timeCursorResponse()));
        Truth8.assertThat((Optional)((Optional)this.client.computeCursorForPublishTime(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.timestamp()).get())).isEqualTo(Optional.of(TopicStatsClientImplTest.cursor()));
    }

    @Test
    public void computeCursorForPublishTime_OkUnset() throws Exception {
        Mockito.when((Object)this.computeTimeCursorCallable.futureCall((Object)TopicStatsClientImplTest.publishTimeCursorRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicStatsClientImplTest.unsetTimeCursorResponse()));
        Truth8.assertThat((Optional)((Optional)this.client.computeCursorForPublishTime(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.timestamp()).get())).isEqualTo(Optional.empty());
    }

    @Test
    public void computeCursorForPublishTime_Error() throws Exception {
        Mockito.when((Object)this.computeTimeCursorCallable.futureCall((Object)TopicStatsClientImplTest.publishTimeCursorRequest())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.UNAVAILABLE).underlying));
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.computeCursorForPublishTime(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.timestamp()), StatusCode.Code.UNAVAILABLE);
    }

    @Test
    public void computeCursorForEventTime_OkPresent() throws Exception {
        Mockito.when((Object)this.computeTimeCursorCallable.futureCall((Object)TopicStatsClientImplTest.eventTimeCursorRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicStatsClientImplTest.timeCursorResponse()));
        Truth8.assertThat((Optional)((Optional)this.client.computeCursorForEventTime(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.timestamp()).get())).isEqualTo(Optional.of(TopicStatsClientImplTest.cursor()));
    }

    @Test
    public void computeCursorForEventTime_OkUnset() throws Exception {
        Mockito.when((Object)this.computeTimeCursorCallable.futureCall((Object)TopicStatsClientImplTest.eventTimeCursorRequest())).thenReturn((Object)ApiFutures.immediateFuture((Object)TopicStatsClientImplTest.unsetTimeCursorResponse()));
        Truth8.assertThat((Optional)((Optional)this.client.computeCursorForEventTime(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.timestamp()).get())).isEqualTo(Optional.empty());
    }

    @Test
    public void computeCursorForEventTime_Error() throws Exception {
        Mockito.when((Object)this.computeTimeCursorCallable.futureCall((Object)TopicStatsClientImplTest.eventTimeCursorRequest())).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)new CheckedApiException((StatusCode.Code)StatusCode.Code.ABORTED).underlying));
        ApiExceptionMatcher.assertFutureThrowsCode(this.client.computeCursorForEventTime(TopicStatsClientImplTest.path(), TopicStatsClientImplTest.partition(), TopicStatsClientImplTest.timestamp()), StatusCode.Code.ABORTED);
    }
}

