/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.testing;

import com.google.api.core.ApiService;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import java.util.concurrent.Future;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RetryingConnectionHelpers {
    public static Future<Void> whenFailed(ApiService service) {
        ApiService.Listener listener = (ApiService.Listener)Mockito.mock(ApiService.Listener.class);
        SettableApiFuture future = SettableApiFuture.create();
        ((ApiService.Listener)Mockito.doAnswer(args -> {
            future.set(null);
            return null;
        }).when((Object)listener)).failed((ApiService.State)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
        service.addListener(listener, SystemExecutors.getFuturesExecutor());
        return future;
    }

    public static Future<Void> whenTerminated(ApiService service) {
        ApiService.Listener listener = (ApiService.Listener)Mockito.mock(ApiService.Listener.class);
        SettableApiFuture future = SettableApiFuture.create();
        ((ApiService.Listener)Mockito.doAnswer(args -> {
            future.set(null);
            return null;
        }).when((Object)listener)).failed((ApiService.State)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any());
        ((ApiService.Listener)Mockito.doAnswer(args -> {
            future.set(null);
            return null;
        }).when((Object)listener)).terminated((ApiService.State)ArgumentMatchers.any());
        service.addListener(listener, SystemExecutors.getFuturesExecutor());
        return future;
    }
}

