/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.testing.RetryingConnectionHelpers;
import com.google.cloud.pubsublite.internal.wire.Assigner;
import com.google.cloud.pubsublite.internal.wire.AssignerImpl;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerFactory;
import com.google.cloud.pubsublite.internal.wire.PartitionAssignmentReceiver;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.proto.PartitionAssignment;
import com.google.cloud.pubsublite.proto.PartitionAssignmentRequest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Future;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class AssignerImplTest {
    private static final PartitionAssignment ASSIGNMENT = PartitionAssignment.newBuilder().addPartitions(1L).addPartitions(7L).build();
    @Mock
    private StreamFactory<PartitionAssignmentRequest, PartitionAssignment> unusedStreamFactory;
    @Mock
    private ConnectedAssigner connectedAssigner;
    @Mock
    private ConnectedAssignerFactory assignerFactory;
    @Mock
    private PartitionAssignmentReceiver receiver;
    private Assigner assigner;
    private ResponseObserver<PartitionAssignment> leakedResponseObserver;

    private static PartitionAssignmentRequest initialRequest() {
        return PartitionAssignmentRequest.newBuilder().setInitial(InitialPartitionAssignmentRequest.newBuilder().setSubscription(((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(ProjectNumber.of((long)12345L))).setLocation(CloudZone.of((CloudRegion)CloudRegion.of((String)"us-east1"), (char)'a'))).setName(SubscriptionName.of((String)"some_subscription")).build().toString())).build();
    }

    private Set<Partition> partitions() {
        HashSet<Partition> partitions = new HashSet<Partition>();
        Iterator iterator = ASSIGNMENT.getPartitionsList().iterator();
        while (iterator.hasNext()) {
            long partition = (Long)iterator.next();
            partitions.add(Partition.of((long)partition));
        }
        return partitions;
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((ConnectedAssignerFactory)Mockito.doAnswer(args -> {
            this.leakedResponseObserver = (ResponseObserver)args.getArgument(1);
            return this.connectedAssigner;
        }).when((Object)this.assignerFactory)).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)AssignerImplTest.initialRequest()));
        this.assigner = new AssignerImpl(this.unusedStreamFactory, this.assignerFactory, AssignerImplTest.initialRequest().getInitial(), this.receiver);
        this.assigner.startAsync().awaitRunning();
        ((ConnectedAssignerFactory)Mockito.verify((Object)this.assignerFactory)).New((StreamFactory)ArgumentMatchers.any(), (ResponseObserver)ArgumentMatchers.any(), ArgumentMatchers.eq((Object)AssignerImplTest.initialRequest()));
    }

    @Test
    public void construct_CallsFactoryNew() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.assignerFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.connectedAssigner});
    }

    @Test
    public void delivery_CallsReceiver() {
        this.leakedResponseObserver.onResponse((Object)ASSIGNMENT);
        ((PartitionAssignmentReceiver)Mockito.verify((Object)this.receiver)).handleAssignment(this.partitions());
    }

    @Test
    public void responseObserverFailure_Fails() throws Exception {
        Future<Void> failed = RetryingConnectionHelpers.whenFailed((ApiService)this.assigner);
        this.leakedResponseObserver.onError((Throwable)new CheckedApiException(StatusCode.Code.INVALID_ARGUMENT));
        failed.get();
        ApiExceptionMatcher.assertThrowableMatches(this.assigner.failureCause(), StatusCode.Code.INVALID_ARGUMENT);
    }
}

