/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.BatchPublisherImpl;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.InitialPublishRequest;
import com.google.cloud.pubsublite.proto.InitialPublishResponse;
import com.google.cloud.pubsublite.proto.MessagePublishRequest;
import com.google.cloud.pubsublite.proto.MessagePublishResponse;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.PublishRequest;
import com.google.cloud.pubsublite.proto.PublishResponse;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BatchPublisherImplTest {
    private static final BatchPublisherImpl.Factory FACTORY = new BatchPublisherImpl.Factory();
    @Mock
    private StreamFactories.PublishStreamFactory streamFactory;
    @Mock
    private ClientStream<PublishRequest> mockRequestStream;
    @Mock
    private ResponseObserver<Offset> mockOutputStream;
    private Optional<ResponseObserver<PublishResponse>> leakedResponseStream = Optional.empty();

    private static PublishRequest initialRequest() {
        return PublishRequest.newBuilder().setInitialRequest(InitialPublishRequest.newBuilder().setTopic(((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setProject(ProjectNumber.of((long)1864654L))).setName(TopicName.of((String)"some_topic")).setLocation(CloudZone.of((CloudRegion)CloudRegion.of((String)"us-east1"), (char)'a'))).build().toString()).setPartition(1024L).build()).build();
    }

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        ((StreamFactories.PublishStreamFactory)Mockito.doAnswer(args -> {
            Preconditions.checkArgument((!this.leakedResponseStream.isPresent() ? 1 : 0) != 0);
            ResponseObserver ResponseObserver2 = (ResponseObserver)args.getArgument(0);
            this.leakedResponseStream = Optional.of(ResponseObserver2);
            return this.mockRequestStream;
        }).when((Object)this.streamFactory)).New((ResponseObserver)ArgumentMatchers.any());
    }

    @After
    public void tearDown() {
        if (this.leakedResponseStream.isPresent()) {
            this.leakedResponseStream.get().onComplete();
        }
    }

    @Test
    public void construct_SendsInitialThenResponse() {
        ((ClientStream)Mockito.doAnswer(args -> {
            Preconditions.checkArgument((boolean)this.leakedResponseStream.isPresent());
            this.leakedResponseStream.get().onResponse((Object)PublishResponse.newBuilder().setInitialResponse(InitialPublishResponse.getDefaultInstance()).build());
            return null;
        }).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.initialRequest());
        BatchPublisherImpl publisher = FACTORY.New((StreamFactory)this.streamFactory, this.mockOutputStream, BatchPublisherImplTest.initialRequest());
        Throwable throwable = null;
        if (publisher != null) {
            if (throwable != null) {
                try {
                    publisher.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                publisher.close();
            }
        }
    }

    @Test
    public void construct_SendsInitialThenError() {
        ((ClientStream)Mockito.doAnswer(args -> {
            Preconditions.checkArgument((boolean)this.leakedResponseStream.isPresent());
            this.leakedResponseStream.get().onError((Throwable)new CheckedApiException(StatusCode.Code.INTERNAL));
            this.leakedResponseStream = Optional.empty();
            return null;
        }).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.initialRequest());
        try (BatchPublisherImpl publisher = FACTORY.New((StreamFactory)this.streamFactory, this.mockOutputStream, BatchPublisherImplTest.initialRequest());){
            ((ResponseObserver)Mockito.verify(this.mockOutputStream)).onError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(StatusCode.Code.INTERNAL)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockOutputStream});
        }
    }

    @Test
    public void construct_SendsMessagePublishResponseError() {
        ((ClientStream)Mockito.doAnswer((Answer)new OffsetAnswer(Offset.of((long)10L))).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.initialRequest());
        try (BatchPublisherImpl publisher = FACTORY.New((StreamFactory)this.streamFactory, this.mockOutputStream, BatchPublisherImplTest.initialRequest());){
            ((ResponseObserver)Mockito.verify(this.mockOutputStream)).onError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(StatusCode.Code.FAILED_PRECONDITION)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockOutputStream});
        }
        this.leakedResponseStream = Optional.empty();
    }

    private BatchPublisherImpl initialize() {
        ((ClientStream)Mockito.doAnswer(args -> {
            Preconditions.checkArgument((boolean)this.leakedResponseStream.isPresent());
            this.leakedResponseStream.get().onResponse((Object)PublishResponse.newBuilder().setInitialResponse(InitialPublishResponse.getDefaultInstance()).build());
            return null;
        }).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.initialRequest());
        return FACTORY.New((StreamFactory)this.streamFactory, this.mockOutputStream, BatchPublisherImplTest.initialRequest());
    }

    @Test
    public void responseAfterClose_Dropped() throws Exception {
        BatchPublisherImpl publisher = this.initialize();
        publisher.close();
        ((ClientStream)Mockito.verify(this.mockRequestStream)).closeSend();
        publisher.publish((Collection)ImmutableList.of((Object)PubSubMessage.getDefaultInstance()));
        ((ResponseObserver)Mockito.verify(this.mockOutputStream, (VerificationMode)Mockito.never())).onResponse(ArgumentMatchers.any());
    }

    @Test
    public void duplicateInitial_Abort() {
        BatchPublisherImpl unusedPublisher = this.initialize();
        PublishResponse.Builder builder = PublishResponse.newBuilder();
        builder.getInitialResponseBuilder();
        this.leakedResponseStream.get().onResponse((Object)builder.build());
        ((ResponseObserver)Mockito.verify(this.mockOutputStream)).onError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(StatusCode.Code.FAILED_PRECONDITION)));
        this.leakedResponseStream = Optional.empty();
    }

    private static PublishRequest messagePublishRequest(PubSubMessage ... messages) {
        return PublishRequest.newBuilder().setMessagePublishRequest(MessagePublishRequest.newBuilder().addAllMessages(Arrays.asList(messages))).build();
    }

    @Test
    public void offsetResponseInOrder_Ok() {
        BatchPublisherImpl publisher = this.initialize();
        ((ClientStream)Mockito.doAnswer((Answer)new OffsetAnswer(Offset.of((long)10L))).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.getDefaultInstance()));
        ((ClientStream)Mockito.doAnswer((Answer)new OffsetAnswer(Offset.of((long)20L))).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"abc")).build()));
        publisher.publish((Collection)ImmutableList.of((Object)PubSubMessage.getDefaultInstance()));
        publisher.publish((Collection)ImmutableList.of((Object)PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"abc")).build()));
        InOrder requests = Mockito.inOrder((Object[])new Object[]{this.mockRequestStream});
        ((ClientStream)requests.verify(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.getDefaultInstance()));
        ((ClientStream)requests.verify(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"abc")).build()));
        InOrder outputs = Mockito.inOrder((Object[])new Object[]{this.mockOutputStream});
        ((ResponseObserver)outputs.verify(this.mockOutputStream)).onResponse((Object)Offset.of((long)10L));
        ((ResponseObserver)outputs.verify(this.mockOutputStream)).onResponse((Object)Offset.of((long)20L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRequestStream});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockOutputStream});
    }

    @Test
    public void offsetResponseOutOfOrder_Exception() {
        BatchPublisherImpl publisher = this.initialize();
        ((ClientStream)Mockito.doAnswer((Answer)new OffsetAnswer(Offset.of((long)10L))).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.getDefaultInstance()));
        ((ClientStream)Mockito.doAnswer((Answer)new OffsetAnswer(Offset.of((long)5L))).when(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"abc")).build()));
        publisher.publish((Collection)ImmutableList.of((Object)PubSubMessage.getDefaultInstance()));
        publisher.publish((Collection)ImmutableList.of((Object)PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"abc")).build()));
        InOrder requests = Mockito.inOrder((Object[])new Object[]{this.mockRequestStream});
        ((ClientStream)requests.verify(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.getDefaultInstance()));
        ((ClientStream)requests.verify(this.mockRequestStream)).send((Object)BatchPublisherImplTest.messagePublishRequest(PubSubMessage.newBuilder().setData(ByteString.copyFromUtf8((String)"abc")).build()));
        ((ClientStream)requests.verify(this.mockRequestStream)).closeSendWithError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher()));
        InOrder outputs = Mockito.inOrder((Object[])new Object[]{this.mockOutputStream});
        ((ResponseObserver)outputs.verify(this.mockOutputStream)).onResponse((Object)Offset.of((long)10L));
        ((ResponseObserver)outputs.verify(this.mockOutputStream)).onError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(StatusCode.Code.FAILED_PRECONDITION)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRequestStream, this.mockOutputStream});
        this.leakedResponseStream = Optional.empty();
    }

    private class OffsetAnswer
    implements Answer<Void> {
        private final Offset offset;

        OffsetAnswer(Offset offset) {
            this.offset = offset;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Preconditions.checkArgument((boolean)BatchPublisherImplTest.this.leakedResponseStream.isPresent());
            ((ResponseObserver)BatchPublisherImplTest.this.leakedResponseStream.get()).onResponse((Object)PublishResponse.newBuilder().setMessageResponse(MessagePublishResponse.newBuilder().setStartCursor(Cursor.newBuilder().setOffset(this.offset.value()))).build());
            ((ClientStream)Mockito.verify((Object)BatchPublisherImplTest.this.mockRequestStream)).send((Object)BatchPublisherImplTest.initialRequest());
            return null;
        }
    }
}

