/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.testing.FakeApiService;
import com.google.cloud.pubsublite.internal.wire.BatchingCommitter;
import com.google.cloud.pubsublite.internal.wire.Committer;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BatchingCommitterTest {
    @Spy
    FakeCommitter underlying;
    @Mock
    AlarmFactory alarmFactory;
    private BatchingCommitter committer;
    private Runnable flushAlarm;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.alarmFactory.newAlarm((Runnable)ArgumentMatchers.any())).thenAnswer(args -> {
            this.flushAlarm = (Runnable)args.getArgument(0);
            return SettableApiFuture.create();
        });
        this.committer = new BatchingCommitter((Committer)this.underlying, this.alarmFactory);
        UncheckedApiPreconditions.checkState((this.flushAlarm != null ? 1 : 0) != 0);
        this.committer.startAsync().awaitRunning();
    }

    @Test
    public void batchesRequests() throws Exception {
        ApiFuture f1 = this.committer.commitOffset(Offset.of((long)1L));
        ApiFuture f2 = this.committer.commitOffset(Offset.of((long)2L));
        ApiFuture f3 = this.committer.commitOffset(Offset.of((long)3L));
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)0)))).commitOffset((Offset)ArgumentMatchers.any());
        Truth.assertThat((Boolean)f1.isDone()).isFalse();
        Truth.assertThat((Boolean)f2.isDone()).isFalse();
        Truth.assertThat((Boolean)f3.isDone()).isFalse();
        SettableApiFuture underlyingFuture3 = SettableApiFuture.create();
        Mockito.when((Object)this.underlying.commitOffset(Offset.of((long)3L))).thenReturn((Object)underlyingFuture3);
        this.flushAlarm.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)1)))).commitOffset(Offset.of((long)3L));
        Truth.assertThat((Boolean)f1.isDone()).isFalse();
        Truth.assertThat((Boolean)f2.isDone()).isFalse();
        Truth.assertThat((Boolean)f3.isDone()).isFalse();
        ApiFuture f4 = this.committer.commitOffset(Offset.of((long)4L));
        SettableApiFuture underlyingFuture4 = SettableApiFuture.create();
        Mockito.when((Object)this.underlying.commitOffset(Offset.of((long)4L))).thenReturn((Object)underlyingFuture4);
        this.flushAlarm.run();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)1)))).commitOffset(Offset.of((long)4L));
        Truth.assertThat((Boolean)f4.isDone()).isFalse();
        underlyingFuture3.set(null);
        f1.get();
        f2.get();
        f3.get();
        Truth.assertThat((Boolean)f4.isDone()).isFalse();
        underlyingFuture4.setException((Throwable)new Exception("Some error"));
        Assert.assertThrows(Exception.class, () -> f4.get());
    }

    @Test
    public void waitUntilEmptyFlushes() throws Exception {
        ApiFuture f1 = this.committer.commitOffset(Offset.of((long)1L));
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)0)))).commitOffset((Offset)ArgumentMatchers.any());
        Mockito.when((Object)this.underlying.commitOffset(Offset.of((long)1L))).thenReturn((Object)ApiFutures.immediateFuture(null));
        this.committer.waitUntilEmpty();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying)))).waitUntilEmpty();
        f1.get();
    }

    @Test
    public void shutdownFlushes() throws Exception {
        ApiFuture f1 = this.committer.commitOffset(Offset.of((long)1L));
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying), (VerificationMode)Mockito.times((int)0)))).commitOffset((Offset)ArgumentMatchers.any());
        Mockito.when((Object)this.underlying.commitOffset(Offset.of((long)1L))).thenReturn((Object)ApiFutures.immediateFuture(null));
        this.committer.stopAsync().awaitTerminated();
        ((FakeCommitter)((Object)Mockito.verify((Object)((Object)this.underlying)))).commitOffset(Offset.of((long)1L));
        f1.get();
    }

    static abstract class FakeCommitter
    extends FakeApiService
    implements Committer {
        FakeCommitter() {
        }
    }
}

