/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.CommitState;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth8;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CommitStateTest {
    private final CommitState state = new CommitState();

    @Test
    public void multipleSentCompletedInOrder() throws CheckedApiException {
        ApiFuture future1 = this.state.addCommit(Offset.of((long)10L));
        ApiFuture future2 = this.state.addCommit(Offset.of((long)1L));
        ApiFuture future3 = this.state.addCommit(Offset.of((long)87L));
        Truth.assertThat((Boolean)future1.isDone()).isFalse();
        Truth.assertThat((Boolean)future2.isDone()).isFalse();
        Truth.assertThat((Boolean)future3.isDone()).isFalse();
        this.state.complete(1L);
        Truth.assertThat((Boolean)future1.isDone()).isTrue();
        Truth.assertThat((Boolean)future2.isDone()).isFalse();
        Truth.assertThat((Boolean)future3.isDone()).isFalse();
        this.state.complete(2L);
        Truth.assertThat((Boolean)future2.isDone()).isTrue();
        Truth.assertThat((Boolean)future3.isDone()).isTrue();
    }

    @Test
    public void completeMoreThanAddedError() {
        ApiFuture future = this.state.addCommit(Offset.of((long)10L));
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        CheckedApiException e = (CheckedApiException)Assert.assertThrows(CheckedApiException.class, () -> this.state.complete(2L));
        Truth.assertThat((Comparable)e.code()).isEqualTo((Object)StatusCode.Code.FAILED_PRECONDITION);
    }

    @Test
    public void reinitializeCompletesAllAfterSingleCompletion() throws CheckedApiException {
        ApiFuture future1 = this.state.addCommit(Offset.of((long)10L));
        ApiFuture future2 = this.state.addCommit(Offset.of((long)99L));
        Truth.assertThat((Boolean)future1.isDone()).isFalse();
        Truth.assertThat((Boolean)future2.isDone()).isFalse();
        Truth8.assertThat((Optional)this.state.reinitializeAndReturnToSend()).hasValue((Object)Offset.of((long)99L));
        Truth.assertThat((Boolean)future1.isDone()).isFalse();
        Truth.assertThat((Boolean)future2.isDone()).isFalse();
        this.state.complete(1L);
        Truth.assertThat((Boolean)future1.isDone()).isTrue();
        Truth.assertThat((Boolean)future2.isDone()).isTrue();
    }

    @Test
    public void reinitializeFailsAllAfterExcessCompletion() {
        ApiFuture future1 = this.state.addCommit(Offset.of((long)10L));
        ApiFuture future2 = this.state.addCommit(Offset.of((long)99L));
        Truth.assertThat((Boolean)future1.isDone()).isFalse();
        Truth.assertThat((Boolean)future2.isDone()).isFalse();
        Truth8.assertThat((Optional)this.state.reinitializeAndReturnToSend()).hasValue((Object)Offset.of((long)99L));
        Truth.assertThat((Boolean)future1.isDone()).isFalse();
        Truth.assertThat((Boolean)future2.isDone()).isFalse();
        CheckedApiException e = (CheckedApiException)Assert.assertThrows(CheckedApiException.class, () -> this.state.complete(2L));
        Truth.assertThat((Comparable)e.code()).isEqualTo((Object)StatusCode.Code.FAILED_PRECONDITION);
    }
}

