/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.ProjectNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.ApiExceptionMatcher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerImpl;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.InitialPartitionAssignmentRequest;
import com.google.cloud.pubsublite.proto.PartitionAssignment;
import com.google.cloud.pubsublite.proto.PartitionAssignmentAck;
import com.google.cloud.pubsublite.proto.PartitionAssignmentRequest;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class ConnectedAssignerImplTest {
    private static final ConnectedAssignerImpl.Factory FACTORY = new ConnectedAssignerImpl.Factory();
    @Mock
    private StreamFactory<PartitionAssignmentRequest, PartitionAssignment> streamFactory;
    @Mock
    private ClientStream<PartitionAssignmentRequest> mockRequestStream;
    @Mock
    private ResponseObserver<PartitionAssignment> mockOutputStream;
    private Optional<ResponseObserver<PartitionAssignment>> leakedResponseStream = Optional.empty();
    private ConnectedAssigner assigner;

    private static PartitionAssignmentRequest initialRequest() {
        return PartitionAssignmentRequest.newBuilder().setInitial(InitialPartitionAssignmentRequest.newBuilder().setSubscription(((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setProject(ProjectNumber.of((long)12345L))).setLocation(CloudZone.of((CloudRegion)CloudRegion.of((String)"us-east1"), (char)'a'))).setName(SubscriptionName.of((String)"some_subscription")).build().toString())).build();
    }

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        ((StreamFactory)Mockito.doAnswer(args -> {
            Preconditions.checkArgument((!this.leakedResponseStream.isPresent() ? 1 : 0) != 0);
            ResponseObserver responseObserver = (ResponseObserver)args.getArgument(0);
            this.leakedResponseStream = Optional.of(responseObserver);
            return this.mockRequestStream;
        }).when(this.streamFactory)).New((ResponseObserver)ArgumentMatchers.any());
    }

    @After
    public void tearDown() {
        this.leakedResponseStream.ifPresent(ResponseObserver::onComplete);
    }

    private Answer<Void> AnswerWith(PartitionAssignment response) {
        return invocation -> {
            Preconditions.checkArgument((boolean)this.leakedResponseStream.isPresent());
            this.leakedResponseStream.get().onResponse((Object)response);
            return null;
        };
    }

    private Answer<Void> AnswerWith(PartitionAssignment.Builder response) {
        return this.AnswerWith(response.build());
    }

    private Answer<Void> AnswerWith(StatusCode.Code error) {
        return invocation -> {
            Preconditions.checkArgument((boolean)this.leakedResponseStream.isPresent());
            this.leakedResponseStream.get().onError((Throwable)new CheckedApiException((StatusCode.Code)error).underlying);
            this.leakedResponseStream = Optional.empty();
            ((ClientStream)Mockito.verify(this.mockRequestStream)).closeSendWithError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(error)));
            ((ResponseObserver)Mockito.verify(this.mockOutputStream)).onError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(error)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockOutputStream});
            return null;
        };
    }

    @Test
    public void construct_SendsInitialThenResponse() throws Exception {
        ((ClientStream)Mockito.doAnswer(this.AnswerWith(PartitionAssignment.newBuilder().addPartitions(7L))).when(this.mockRequestStream)).send((Object)ConnectedAssignerImplTest.initialRequest());
        ConnectedAssigner assigner = FACTORY.New(this.streamFactory, this.mockOutputStream, ConnectedAssignerImplTest.initialRequest());
        Throwable throwable = null;
        if (assigner != null) {
            if (throwable != null) {
                try {
                    assigner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                assigner.close();
            }
        }
    }

    @Test
    public void construct_SendsInitialThenError() throws Exception {
        ((ClientStream)Mockito.doAnswer(this.AnswerWith(StatusCode.Code.INTERNAL)).when(this.mockRequestStream)).send((Object)ConnectedAssignerImplTest.initialRequest());
        ConnectedAssigner assigner = FACTORY.New(this.streamFactory, this.mockOutputStream, ConnectedAssignerImplTest.initialRequest());
        Throwable throwable = null;
        if (assigner != null) {
            if (throwable != null) {
                try {
                    assigner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                assigner.close();
            }
        }
    }

    @Test
    public void construct_noInitialResponse() throws Exception {
        this.assigner = FACTORY.New(this.streamFactory, this.mockOutputStream, ConnectedAssignerImplTest.initialRequest());
        ((ClientStream)Mockito.verify(this.mockRequestStream)).send((Object)ConnectedAssignerImplTest.initialRequest());
    }

    private void initialize() {
        ((ClientStream)Mockito.doAnswer(this.AnswerWith(PartitionAssignment.newBuilder().addPartitions(1L))).when(this.mockRequestStream)).send((Object)ConnectedAssignerImplTest.initialRequest());
        this.assigner = FACTORY.New(this.streamFactory, this.mockOutputStream, ConnectedAssignerImplTest.initialRequest());
        ((ClientStream)Mockito.verify(this.mockRequestStream)).send((Object)ConnectedAssignerImplTest.initialRequest());
        Mockito.reset((Object[])new ClientStream[]{this.mockRequestStream});
        Mockito.reset((Object[])new ResponseObserver[]{this.mockOutputStream});
    }

    @Test
    public void ackAfterClose_Dropped() throws Exception {
        this.initialize();
        this.assigner.close();
        ((ClientStream)Mockito.verify(this.mockRequestStream)).closeSend();
        this.assigner.ack();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRequestStream});
    }

    @Test
    public void ackRequestProxied() {
        this.initialize();
        PartitionAssignmentRequest request = PartitionAssignmentRequest.newBuilder().setAck(PartitionAssignmentAck.getDefaultInstance()).build();
        this.assigner.ack();
        ((ClientStream)Mockito.verify(this.mockRequestStream)).send((Object)request);
    }

    @Test
    public void assignmentResponseBeforeAckAborts() {
        this.initialize();
        PartitionAssignment response = PartitionAssignment.newBuilder().addPartitions(1L).build();
        this.leakedResponseStream.get().onResponse((Object)response);
        ((ResponseObserver)Mockito.verify(this.mockOutputStream)).onError((Throwable)ArgumentMatchers.argThat((ArgumentMatcher)new ApiExceptionMatcher(StatusCode.Code.FAILED_PRECONDITION)));
        this.leakedResponseStream = Optional.empty();
    }

    @Test
    public void assignmentResponseProxied() {
        this.initialize();
        PartitionAssignmentRequest request = PartitionAssignmentRequest.newBuilder().setAck(PartitionAssignmentAck.getDefaultInstance()).build();
        this.assigner.ack();
        ((ClientStream)Mockito.verify(this.mockRequestStream)).send((Object)request);
        PartitionAssignment response = PartitionAssignment.newBuilder().addPartitions(1L).build();
        this.leakedResponseStream.get().onResponse((Object)response);
        ((ResponseObserver)Mockito.verify(this.mockOutputStream)).onResponse((Object)response);
    }
}

